/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.core.ActionCommand;
import com.ibm.lpex.core.AddCommand;
import com.ibm.lpex.core.BlockCommand;
import com.ibm.lpex.core.CalcCommand;
import com.ibm.lpex.core.ClassLoaderList;
import com.ibm.lpex.core.Command;
import com.ibm.lpex.core.CommandList;
import com.ibm.lpex.core.CompareCommand;
import com.ibm.lpex.core.DeleteCommand;
import com.ibm.lpex.core.DeleteTextCommand;
import com.ibm.lpex.core.DocumentPosition;
import com.ibm.lpex.core.Element;
import com.ibm.lpex.core.ExpandAllCommand;
import com.ibm.lpex.core.FindTextCommand;
import com.ibm.lpex.core.GetCommand;
import com.ibm.lpex.core.HelpCommand;
import com.ibm.lpex.core.InputCommand;
import com.ibm.lpex.core.InsertCommand;
import com.ibm.lpex.core.InsertShowCommand;
import com.ibm.lpex.core.InsertTextCommand;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.LoadCommand;
import com.ibm.lpex.core.LocateCommand;
import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexDocumentLocationRunnable;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.Parameter;
import com.ibm.lpex.core.Parameters;
import com.ibm.lpex.core.ParseCommand;
import com.ibm.lpex.core.PrintCommand;
import com.ibm.lpex.core.ProcessPrefixCommand;
import com.ibm.lpex.core.ProfileCommand;
import com.ibm.lpex.core.QueryCommand;
import com.ibm.lpex.core.ReplaceTextCommand;
import com.ibm.lpex.core.ResequenceCommand;
import com.ibm.lpex.core.ResetCommand;
import com.ibm.lpex.core.SaveAsHtmlCommand;
import com.ibm.lpex.core.SaveCommand;
import com.ibm.lpex.core.ScreenShowCommand;
import com.ibm.lpex.core.SetCommand;
import com.ibm.lpex.core.SortCommand;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.TrimCommand;
import com.ibm.lpex.core.UndoCommand;
import com.ibm.lpex.core.UpdateProfileCommand;
import com.ibm.lpex.core.View;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;

final class CommandHandler {
    private View _view;
    private CommandList _commandList;
    private static String _status;
    private static final Object _statusLockObject;
    private static final int COMMAND_INVALID = 0;
    private static final int COMMAND_ACTION = 1;
    private static final int COMMAND_ADD = 2;
    private static final int COMMAND_BLOCK = 3;
    private static final int COMMAND_CALC = 4;
    private static final int COMMAND_COMPARE = 5;
    private static final int COMMAND_DELETE = 6;
    private static final int COMMAND_DELETE_TEXT = 7;
    private static final int COMMAND_EXPAND_ALL = 8;
    private static final int COMMAND_FIND_TEXT = 9;
    private static final int COMMAND_GET = 10;
    private static final int COMMAND_INPUT = 11;
    private static final int COMMAND_INSERT = 12;
    private static final int COMMAND_INSERT_SHOW = 13;
    private static final int COMMAND_INSERT_TEXT = 14;
    private static final int COMMAND_LOAD = 15;
    private static final int COMMAND_LOCATE = 16;
    private static final int COMMAND_PARSE = 17;
    private static final int COMMAND_PRINT = 18;
    private static final int COMMAND_PROCESS_PREFIX = 19;
    private static final int COMMAND_PROFILE = 20;
    private static final int COMMAND_QUERY = 21;
    private static final int COMMAND_REPLACE_TEXT = 22;
    private static final int COMMAND_RESEQUENCE = 23;
    private static final int COMMAND_RESET = 24;
    private static final int COMMAND_SAVE = 25;
    private static final int COMMAND_SAVE_AS_HTML = 26;
    private static final int COMMAND_SCREEN_SHOW = 27;
    private static final int COMMAND_SET = 28;
    private static final int COMMAND_SORT = 29;
    private static final int COMMAND_TRIM = 30;
    private static final int COMMAND_UNDO = 31;
    private static final int COMMAND_UPDATE_PROFILE = 32;
    private static final int COMMAND_HELP = 33;
    private static final int COMMAND_NLS_SIM = 34;
    private static final TableNode[] _commands;

    static {
        _statusLockObject = new Object();
        _commands = new TableNode[]{new TableNode("action", 1), new TableNode("add", 2), new TableNode("block", 3), new TableNode("calc", 4), new TableNode("compare", 5), new TableNode("delete", 6), new TableNode("deleteText", 7), new TableNode("expandAll", 8), new TableNode("findText", 9), new TableNode("get", 10), new TableNode("help", 33), new TableNode("input", 11), new TableNode("insert", 12), new TableNode("insertShow", 13), new TableNode("insertText", 14), new TableNode("load", 15), new TableNode("locate", 16), new TableNode("nlsSim", 34), new TableNode("parse", 17), new TableNode("print", 18), new TableNode("processPrefix", 19), new TableNode("profile", 20), new TableNode("query", 21), new TableNode("replaceText", 22), new TableNode("resequence", 23), new TableNode("reset", 24), new TableNode("save", 25), new TableNode("saveAsHtml", 26), new TableNode("screenShow", 27), new TableNode("set", 28), new TableNode("sort", 29), new TableNode("trim", 30), new TableNode("undo", 31), new TableNode("updateProfile", 32)};
        TableNode.sort(_commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setStatus(String status) {
        Object object = _statusLockObject;
        synchronized (object) {
            _status = status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getStatus() {
        Object object = _statusLockObject;
        synchronized (object) {
            return _status;
        }
    }

    CommandHandler(View view) {
        this._view = view;
        this._commandList = new CommandList();
    }

    void updateProfile() {
        this._commandList.clear();
        String userCommands = UpdateProfileCommand.UserCommandsParameter.getParameter().currentValue(this._view);
        if (userCommands != null) {
            LpexStringTokenizer st = new LpexStringTokenizer(userCommands);
            while (st.hasMoreTokens()) {
                String command = st.nextToken();
                if (st.hasMoreTokens()) {
                    this.defineCommand(command, st.nextToken());
                    continue;
                }
                this._view.setLpexMessageText("command.userCommandsInvalid", command);
            }
        }
    }

    String commands() {
        this._commandList.sort();
        StringBuilder commands = new StringBuilder(256);
        List.Node command = this._commandList.first();
        while (command != null) {
            if (commands.length() != 0) {
                commands.append(' ');
            }
            commands.append(((Command)command).commandString());
            command = command.next();
        }
        return commands.toString();
    }

    String commandClass(String commandString) {
        Command command = this._commandList.find(commandString);
        return command != null ? command.lpexCommand().getClass().getName() : null;
    }

    boolean doCommand(LpexDocumentLocation documentLocation, String commandString) {
        DocumentPosition.Preserve preserve = this._view.documentPosition().preserve();
        Element element = this._view.document().elementList().elementAt(documentLocation.element);
        boolean forceAllVisible = this._view.setForceAllVisible(true);
        this._view.documentPosition().jump(element, documentLocation.position, false);
        boolean success = this.doCommand(commandString);
        LpexDocumentLocation newDocumentLocation = this._view.documentPosition().documentLocation();
        documentLocation.element = newDocumentLocation.element;
        documentLocation.position = newDocumentLocation.position;
        this._view.setForceAllVisible(forceAllVisible);
        preserve.restore();
        this._view.documentPosition().disposePreserve(preserve);
        return success;
    }

    boolean runSubCommand(Callable<Boolean> command) {
        boolean needToSetForce;
        DocumentPosition.Preserve preserve = this._view.documentPosition().preserve();
        boolean bl = needToSetForce = !this._view.forceAllVisible();
        if (needToSetForce) {
            this._view.setForceAllVisible(true);
        }
        try {
            boolean bl2 = command.call();
            return bl2;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        finally {
            if (needToSetForce) {
                this._view.setForceAllVisible(false);
            }
            preserve.restore();
            this._view.documentPosition().disposePreserve(preserve);
        }
    }

    boolean doSubcommand(final LpexDocumentLocation documentLocation, final String commandString) {
        Callable<Boolean> command = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Element element = CommandHandler.this._view.document().elementList().elementAt(documentLocation.element);
                CommandHandler.this._view.documentPosition().jump(element, documentLocation.position, false);
                boolean success = CommandHandler.this.doCommand(commandString);
                LpexDocumentLocation newDocumentLocation = CommandHandler.this._view.documentPosition().documentLocation();
                documentLocation.element = newDocumentLocation.element;
                documentLocation.position = newDocumentLocation.position;
                return success;
            }
        };
        return this.runSubCommand(command);
    }

    int doIterateSubcommand(final LpexDocumentLocation startDocumentLocation, final String firstCommandString, final String commandString, final LpexDocumentLocationRunnable action) {
        final int[] counter = new int[1];
        Callable<Boolean> command = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                Element element = CommandHandler.this._view.document().elementList().elementAt(startDocumentLocation.element);
                CommandHandler.this._view.documentPosition().jump(element, startDocumentLocation.position, false);
                LpexDocumentLocation loc = new LpexDocumentLocation(startDocumentLocation.element, startDocumentLocation.position);
                while (true) {
                    boolean success = CommandHandler.this.doCommand(counter[0] == 0 ? firstCommandString : commandString);
                    loc = CommandHandler.this._view.documentPosition().documentLocation();
                    if (!success || QueryCommand.query("status", CommandHandler.this._view, loc) != null) break;
                    action.setLocation(CommandHandler.this._view, loc);
                    action.run();
                    counter[0] = counter[0] + 1;
                }
                return true;
            }
        };
        this.runSubCommand(command);
        return counter[0];
    }

    boolean doCommand(String commandString) {
        String origCommandString = commandString;
        Command command = this._commandList.find(commandString);
        String aSpace = " ";
        String delimeter = ";";
        try {
            if (command == null) {
                commandString = commandString.replaceAll(delimeter, aSpace + delimeter + aSpace);
                commandString = commandString.replaceAll(delimeter + aSpace + aSpace, delimeter + aSpace);
                command = this._commandList.find(commandString);
                commandClassName = null;
                if (command != null && command.lpexCommand() != null) {
                    commandClassName = command.lpexCommand().getClass().getName();
                }
                if (commandClassName == null || !commandClassName.contains("ISPFCommandSplitter")) {
                    commandString = origCommandString;
                    command = null;
                }
            } else {
                commandClassName = null;
                if (command != null && command.lpexCommand() != null) {
                    commandClassName = command.lpexCommand().getClass().getName();
                }
                if (commandClassName != null && commandClassName.contains("ISPFCommandSplitter")) {
                    commandString = commandString.replaceAll(delimeter, aSpace + delimeter + aSpace);
                    commandString = commandString.replaceAll(delimeter + aSpace + aSpace, delimeter + aSpace);
                    command = this._commandList.find(commandString);
                }
            }
        }
        catch (Exception exc) {
            commandString = origCommandString;
            command = null;
        }
        if (command != null) {
            try {
                return command.lpexCommand().doCommand(this._view.lpexView(), CommandHandler.getParameters(commandString));
            }
            catch (Throwable e) {
                String commandName = command.commandString();
                String errorText = LpexResources.message("exception.command", commandName);
                this._view.screen().setMessageText(errorText);
                LpexLog.log(this._view, errorText, e);
                this.defineCommand(commandName, (LpexCommand)null);
                return true;
            }
        }
        return CommandHandler.doDefaultCommand(this._view, commandString);
    }

    static boolean doDefaultCommand(View view, LpexDocumentLocation documentLocation, String commandString) {
        if (view == null) {
            return CommandHandler.doDefaultCommand(commandString);
        }
        DocumentPosition.Preserve preserve = view.documentPosition().preserve();
        Element element = view.document().elementList().elementAt(documentLocation.element);
        boolean forceAllVisible = false;
        forceAllVisible = view.setForceAllVisible(true);
        view.documentPosition().jump(element, documentLocation.position, false);
        boolean success = CommandHandler.doDefaultCommand(view, commandString);
        LpexDocumentLocation newDocumentLocation = view.documentPosition().documentLocation();
        documentLocation.element = newDocumentLocation.element;
        documentLocation.position = newDocumentLocation.position;
        view.setForceAllVisible(forceAllVisible);
        preserve.restore();
        view.documentPosition().disposePreserve(preserve);
        return success;
    }

    static boolean doDefaultCommand(String commandString) {
        return CommandHandler.doDefaultCommand(null, commandString);
    }

    static boolean doDefaultCommand(View view, String commandString) {
        if (commandString != null && commandString.length() > 0) {
            String command = CommandHandler.getCommand(commandString);
            String parameters = CommandHandler.getParameters(commandString);
            switch (CommandHandler.id(command)) {
                case 1: {
                    return ActionCommand.doCommand(view, parameters);
                }
                case 2: {
                    return AddCommand.doCommand(view, parameters);
                }
                case 3: {
                    return BlockCommand.doCommand(view, parameters);
                }
                case 4: {
                    return CalcCommand.doCommand(view, parameters);
                }
                case 5: {
                    return CompareCommand.doCommand(view, parameters);
                }
                case 6: {
                    return DeleteCommand.doCommand(view, parameters);
                }
                case 7: {
                    return DeleteTextCommand.doCommand(view, parameters);
                }
                case 8: {
                    return ExpandAllCommand.doCommand(view, parameters);
                }
                case 9: {
                    return FindTextCommand.doCommand(view, parameters);
                }
                case 10: {
                    return GetCommand.doCommand(view, parameters);
                }
                case 33: {
                    return HelpCommand.doCommand(view, parameters);
                }
                case 11: {
                    return InputCommand.doCommand(view, parameters);
                }
                case 12: {
                    return InsertCommand.doCommand(view, parameters);
                }
                case 13: {
                    return InsertShowCommand.doCommand(view, parameters);
                }
                case 14: {
                    return InsertTextCommand.doCommand(view, parameters);
                }
                case 15: {
                    return LoadCommand.doCommand(view, parameters);
                }
                case 16: {
                    return LocateCommand.doCommand(view, parameters);
                }
                case 34: {
                    return view.nls().nlsSimulator(parameters);
                }
                case 17: {
                    return ParseCommand.doCommand(view, parameters);
                }
                case 18: {
                    return PrintCommand.doCommand(view, parameters);
                }
                case 19: {
                    return ProcessPrefixCommand.doCommand(view, parameters);
                }
                case 20: {
                    return ProfileCommand.doCommand(view, parameters);
                }
                case 21: {
                    return QueryCommand.doCommand(view, parameters);
                }
                case 22: {
                    return ReplaceTextCommand.doCommand(view, parameters);
                }
                case 23: {
                    return ResequenceCommand.doCommand(view, parameters);
                }
                case 24: {
                    return ResetCommand.doCommand(view, parameters);
                }
                case 25: {
                    return SaveCommand.doCommand(view, parameters);
                }
                case 26: {
                    return SaveAsHtmlCommand.doCommand(view, parameters);
                }
                case 27: {
                    return ScreenShowCommand.doCommand(view, parameters);
                }
                case 28: {
                    return SetCommand.doCommand(view, parameters);
                }
                case 29: {
                    return SortCommand.doCommand(view, parameters);
                }
                case 30: {
                    return TrimCommand.doCommand(view, parameters);
                }
                case 31: {
                    return UndoCommand.doCommand(view, parameters);
                }
                case 32: {
                    return UpdateProfileCommand.doCommand(view, parameters);
                }
            }
            if (CommandHandler.lineNumber(command, parameters)) {
                return LocateCommand.doCommand(view, "emphasis line " + command);
            }
            if (CommandHandler.isShortCommand(command, parameters)) {
                return CommandHandler.doShortCommand(view, command, parameters);
            }
            if (CommandHandler.isQueryCommand(command, parameters)) {
                return QueryCommand.doCommand(view, command);
            }
            if (CommandHandler.isSetCommand(command)) {
                return SetCommand.doCommand(view, command + " " + parameters);
            }
            if (view != null) {
                view.setLpexMessageText("command.invalid", command);
            }
            return false;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    static String getCommand(String commandString) {
        block3: {
            block6: {
                block5: {
                    block4: {
                        command = commandString;
                        while (command.startsWith(" ")) {
                            command = command.substring(1);
                        }
                        if (command.length() <= 0) break block3;
                        c = command.charAt(0);
                        if (!Character.isLetterOrDigit(c)) break block4;
                        i = command.indexOf(32);
                        if (i != -1) {
                            command = command.substring(0, i);
                        }
                        break block3;
                    }
                    if (c != '?') break block5;
                    command = command.substring(0, 1);
                    break block3;
                }
                len = 1;
                if (command.startsWith("/") || command.startsWith("'")) break block6;
                if (!command.startsWith("-/") && !command.startsWith("-'")) ** GOTO lbl23
                len = 2;
                break block6;
lbl-1000:
                // 1 sources

                {
                    ++len;
lbl23:
                    // 2 sources

                    ** while (len < command.length() && !Character.isLetterOrDigit((char)command.charAt((int)len)))
                }
            }
            command = command.substring(0, len);
        }
        return command;
    }

    /*
     * Unable to fully structure code
     */
    private static String getParameters(String commandString) {
        block3: {
            block6: {
                block5: {
                    block4: {
                        block2: {
                            parameters = commandString;
                            while (parameters.startsWith(" ")) {
                                parameters = parameters.substring(1);
                            }
                            if (parameters.length() != 0) break block2;
                            parameters = "";
                            break block3;
                        }
                        if (!Character.isLetterOrDigit(parameters.charAt(0))) break block4;
                        i = parameters.indexOf(32);
                        parameters = i != -1 ? parameters.substring(i + 1) : "";
                        break block3;
                    }
                    if ('?' != parameters.charAt(0)) break block5;
                    parameters = parameters.substring(1);
                    break block3;
                }
                parametersIndex = 1;
                if (parameters.startsWith("/") || parameters.startsWith("'")) break block6;
                if (!parameters.startsWith("-/") && !parameters.startsWith("-'")) ** GOTO lbl24
                parametersIndex = 2;
                break block6;
lbl-1000:
                // 1 sources

                {
                    ++parametersIndex;
lbl24:
                    // 2 sources

                    ** while (parametersIndex < parameters.length() && !Character.isLetterOrDigit((char)parameters.charAt((int)parametersIndex)))
                }
            }
            parameters = parameters.substring(parametersIndex);
        }
        return parameters;
    }

    private static int id(String commandString) {
        TableNode tableNode = TableNode.binarySearch(_commands, commandString.trim());
        return tableNode != null ? tableNode.id() : 0;
    }

    private static boolean lineNumber(String commandString, String parameters) {
        if (parameters.trim().length() == 0) {
            try {
                Integer.parseInt(commandString);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isShortCommand(String commandString, String parameters) {
        if (commandString.equals("/") || commandString.equals("-/") || commandString.equals("'") || commandString.equals("-'") || commandString.equals("?")) {
            return true;
        }
        if (commandString.equals(":")) {
            return CommandHandler.lineNumber(parameters, "");
        }
        return false;
    }

    private static boolean doShortCommand(View view, String commandString, String parameters) {
        if (commandString.equals(":")) {
            return LocateCommand.doCommand(view, "emphasis line " + parameters);
        }
        if (commandString.equals("?")) {
            return view == null ? CommandHandler.doDefaultCommand("help " + parameters) : view.commandHandler().doCommand("help " + parameters);
        }
        String text = LpexStringTokenizer.addQuotes(parameters);
        if (commandString.equals("/")) {
            return view.commandHandler().doCommand("findText " + text);
        }
        if (commandString.equals("-/")) {
            return view.commandHandler().doCommand("findText up " + text);
        }
        if (commandString.equals("'")) {
            return view.commandHandler().doCommand("findText asis " + text);
        }
        if (commandString.equals("-'")) {
            return view.commandHandler().doCommand("findText up asis " + text);
        }
        return false;
    }

    private static boolean isQueryCommand(String commandString, String parameters) {
        return parameters.trim().length() == 0 ? Parameters.getParameter(commandString) != null : false;
    }

    private static boolean isSetCommand(String commandString) {
        Parameter parameter = Parameters.getParameter(commandString);
        return parameter == null ? false : !parameter.isQueryOnly(Parameters.getQualifierString(commandString));
    }

    LpexCommand defineCommand(String commandString, LpexCommand lpexCommand) {
        LpexCommand oldLpexCommand = null;
        Command command = this._commandList.find(commandString);
        if (command != null) {
            oldLpexCommand = command.lpexCommand();
            this._commandList.remove(command);
        }
        if (lpexCommand != null) {
            this._commandList.addAfter(null, new Command(commandString, lpexCommand));
        }
        return oldLpexCommand;
    }

    LpexCommand defineCommand(String commandString, String className) {
        LpexCommand lpexCommand = null;
        if (className != null && className.length() > 0) {
            Class<?> commandClass = null;
            try {
                commandClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (commandClass == null) {
                commandClass = ClassLoaderList.loadClass(className, this._view);
            }
            if (commandClass == null) {
                this._view.setLpexMessageText("class.notFound", className);
                return null;
            }
            if (!LpexCommand.class.isAssignableFrom(commandClass)) {
                this._view.setLpexMessageText("class.invalid", className, "LpexCommand");
                return null;
            }
            try {
                Constructor<?> commandConstructor = commandClass.getConstructor(null);
                lpexCommand = (LpexCommand)commandConstructor.newInstance(null);
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                return null;
            }
            catch (Exception e) {
                this._view.setLpexMessageText("class.invalid", className, "LpexCommand");
                return null;
            }
        }
        return this.defineCommand(commandString, lpexCommand);
    }

    LpexCommand command(String commandString) {
        Command command = this._commandList.find(commandString);
        return command != null ? command.lpexCommand() : null;
    }

    static boolean noParameters(View view, String command) {
        if (view != null) {
            view.setLpexMessageText("command.noParameters", command);
        }
        return false;
    }

    static boolean invalidParameter(View view, String parameter, String command) {
        if (view != null) {
            view.setLpexMessageText("command.invalidParameter", parameter, command);
        }
        return false;
    }

    static boolean incomplete(View view, String command) {
        if (view != null) {
            view.setLpexMessageText("command.incomplete", command);
        }
        return false;
    }

    static boolean invalidQuotedParameter(View view, String parameter, String command) {
        if (view != null) {
            view.setLpexMessageText("command.invalidQuotedParameter", parameter, command);
        }
        return false;
    }

    static boolean integerMissing(View view, String parameter, String command) {
        if (view != null) {
            view.setLpexMessageText("command.integerMissing", parameter, command);
        }
        return false;
    }
}

