/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.core;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.core.ActionUtilities;
import com.ibm.lpex.core.ClassLoaderList;
import com.ibm.lpex.core.CommandLine;
import com.ibm.lpex.core.Document;
import com.ibm.lpex.core.EnterArabicDigitsParameter;
import com.ibm.lpex.core.KeyRecorder;
import com.ibm.lpex.core.List;
import com.ibm.lpex.core.ListNode;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexBaseAction;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.TableNode;
import com.ibm.lpex.core.TextWindow;
import com.ibm.lpex.core.UpdateProfileCommand;
import com.ibm.lpex.core.View;
import com.ibm.lpex.core.VisualEditLineDialogParameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

final class ActionHandler
implements SelectionListener {
    static final String LPEX_POPUP_DEFINITION;
    private static final int KEY_CTRL = 262144;
    private static final int KEY_SHIFT = 131072;
    private static final int KEY_ALT = 65536;
    private static final int KEY_COMMAND = 0x400000;
    static final int MOUSE_BUTTON1 = 524288;
    static final int MOUSE_BUTTON2 = 0x100000;
    static final int MOUSE_BUTTON3 = 0x200000;
    public static final int KEY_MOD_C;
    public static final int KEY_MOD_S;
    public static final int KEY_MOD_A;
    public static final int KEY_MOD_R;
    public static final int KEY_MOD_M;
    private View _view;
    private KeyActionList _textAreaKeyActionList;
    private KeyActionList _prefixAreaKeyActionList;
    private KeyActionList _commandLineKeyActionList;
    private KeyActionList _currentKeyActionList;
    private MouseActionList _textAreaMouseActionList;
    private MouseActionList _prefixAreaMouseActionList;
    private MouseActionList _expandHideAreaMouseActionList;
    private ActionList _actionList;
    private int _availableActionId;
    private Point _currentMousePoint = new Point(0, 0);
    private String _argument;
    private boolean _settingArgument;
    private int _lastKeyActionId = 0;
    private int _userActionId = 0;
    private int _lastUserActionId = 0;
    private Key _currentKey;
    private int _currentKeyModifiers;
    private int _currentKeyContext;
    private static final int MAX_REPEAT = 10000;
    static final int CONTEXT_INVALID = 0;
    static final int CONTEXT_TEXT_AREA = 1;
    static final int CONTEXT_PREFIX_AREA = 2;
    static final int CONTEXT_COMMAND_LINE = 4;
    static final int CONTEXT_EXPAND_HIDE_AREA = 8;
    static final int MOUSE_EVENT_INVALID = 0;
    static final int MOUSE_EVENT_CLICKED = 1;
    static final int MOUSE_EVENT_DRAGGED = 2;
    static final int MOUSE_EVENT_ENTERED = 3;
    static final int MOUSE_EVENT_EXITED = 4;
    static final int MOUSE_EVENT_MOVED = 5;
    static final int MOUSE_EVENT_POPUP = 6;
    static final int MOUSE_EVENT_PRESSED = 7;
    static final int MOUSE_EVENT_RELEASED = 8;
    static final int MOUSE_EVENT_WHEELDOWN = 9;
    static final int MOUSE_EVENT_WHEELUP = 10;
    static final int MOUSE_EVENT_HOVER = 11;
    static final int MOUSE_EVENT_DOUBLECLICKED = 12;
    private static final int VK_UNDEFINED = 0;
    private static final char CHAR_UNDEFINED = '\u0000';
    private static final Key[] _keys;
    static final TableNode[] _mouseEvents;
    private static final String noneKeyActions = "delete.t.p nullAction s-delete.t.p nullAction ";
    private static final String eclipseKeyActions = "a-b.t blockMarkCharacter a-backSpace.t.p.secondary undo a-c.t.p blockCopy a-d.t.p.c blockDelete a-equals.t.p.c visualEditLine a-f7.t.p.c blockShiftLeft a-f8.t.p.c blockShiftRight a-i.t.p.c blockLowerCase a-j.t join a-k.t.p.c blockUpperCase a-l.t.p blockMarkElement a-m.t.p blockMove a-pageDown.t.p.c findBlockEnd a-pageUp.t.p.c findBlockStart a-q.t.p.c findQuickMark a-r.t blockMarkRectangle a-s.t split a-s-h.t hexEditLine a-u.t.p.c blockUnmark a-z.t blockOverlay add.p down backSpace.p prefixBackSpace backSpace.t backSpace c-7.t insertLtrMark c-8.t insertRtlMark c-a.t.p.c blockMarkAllEclipse c-backSpace.t.p.c deleteLine c-c.p nullAction c-c.t copy c-d.t.p duplicateLine c-delete.p prefixTruncate c-delete.t truncate c-down.t.p scrollDown c-end.t.p.c bottom c-enter.t.p.c openLine c-f.t.p.c find c-home.t.p.c top c-insert.t.secondary copy c-j.t.p.c findLastChange c-l.t.p.c locateLine c-left.t prevWord c-m.t.c match c-n.t.p.c findNext c-numpadEnter.t.p.c.secondary openLine c-p.t.p.c print c-pageDown.t.p.c pageRight c-pageUp.t.p.c pageLeft c-q.p nullAction c-q.t setQuickMark c-right.t nextWord c-s-end.t blockMarkBottom c-s-f.t.p.c findAndReplace c-s-h.t.p nullAction c-s-home.t blockMarkTop c-s-l.c locateSequenceLine c-s-left.t blockMarkPrevWord c-s-m.t.c findMatch c-s-n.t.p.c compareNext c-s-p.t.p.c comparePrevious c-s-pageDown.t blockMarkPageRight c-s-pageUp.t blockMarkPageLeft c-s-r.t.p.c compareRefresh c-s-right.t blockMarkNextWord c-s-u.t.p.c.secondary comparePrevious c-s-z.t.p.secondary redo c-s.t.p.c save c-t.t.p.c scrollTop c-u.t.p.c findUp c-up.t.p scrollUp c-v.p nullAction c-v.t paste c-a-a.t.p.c showAll c-x.p nullAction c-x.t cut c-y.t.p redo c-z.t.p undo delete.p prefixDelete delete.t delete down.t.p down end.p prefixEnd end.t end enter.p processPrefix enter.t splitLine escape.t.p commandLine f1.t.p.c help home.p prefixHome home.t home insert.t.p toggleInsert left.p prefixLeft left.t left numpadEnter.p processPrefix numpadEnter.t.secondary splitLine pageDown.t.p.c pageDown pageUp.t.p.c pageUp right.p prefixRight right.t right s-backSpace.p.secondary prefixBackSpace s-backSpace.t.secondary backSpace s-delete.t.secondary cut s-down.t blockMarkDown s-end.t blockMarkEnd s-enter.t newLine s-f10.t.p popupAtCursor s-home.t blockMarkHome s-insert.t.secondary paste s-left.t blockMarkLeft s-numpadEnter.t.secondary newLine s-pageDown.t blockMarkPageDown s-pageUp.t blockMarkPageUp s-right.t blockMarkRight s-tab.p prefixHome s-tab.t prevTabStop s-up.t blockMarkUp tab.p home tab.t insertToTab up.t.p up ";
    private static final String lpexMouseActions;
    private static final String lpexKeyActions = "a-b.t blockMarkCharacter a-backSpace.t.p.secondary undo a-c.t.p blockCopy a-d.t.p.c blockDelete a-equals.t.p.c visualEditLine a-f7.t.p.c blockShiftLeft a-f8.t.p.c blockShiftRight a-i.t.p.c blockLowerCase a-j.t join a-k.t.p.c blockUpperCase a-l.t.p blockMarkElement a-m.t.p blockMove a-pageDown.t.p.c findBlockEnd a-pageUp.t.p.c findBlockStart a-q.t.p.c findQuickMark a-r.t blockMarkRectangle a-s.t split a-s-h.t hexEditLine a-u.t.p.c blockUnmark a-z.t blockOverlay add.p down backSpace.p prefixBackSpace backSpace.t backSpace c-7.t insertLtrMark c-8.t insertRtlMark c-a.t.p.c blockMarkAll c-backSpace.t.p.c deleteLine c-c.p nullAction c-c.t copy c-d.t.p duplicateLine c-delete.p prefixTruncate c-delete.t truncate c-down.t.p scrollDown c-end.t.p.c bottom c-enter.t.p.c openLine c-f.t.p.c find c-home.t.p.c top c-insert.t.secondary copy c-j.t.p.c findLastChange c-l.t.p.c locateLine c-left.t prevWord c-m.t.c match c-n.t.p.c findNext c-numpadEnter.t.p.c.secondary openLine c-p.t.p.c print c-pageDown.t.p.c pageRight c-pageUp.t.p.c pageLeft c-q.p nullAction c-q.t setQuickMark c-right.t nextWord c-s-end.t blockMarkBottom c-s-f.t.p.c findAndReplace c-s-h.t.p nullAction c-s-home.t blockMarkTop c-s-l.c locateSequenceLine c-s-left.t blockMarkPrevWord c-s-m.t.c findMatch c-s-n.t.p.c compareNext c-s-p.t.p.c comparePrevious c-s-pageDown.t blockMarkPageRight c-s-pageUp.t blockMarkPageLeft c-s-r.t.p.c compareRefresh c-s-right.t blockMarkNextWord c-s-u.t.p.c.secondary comparePrevious c-s-z.t.p.secondary redo c-s.t.p.c save c-t.t.p.c scrollTop c-u.t.p.c findUp c-up.t.p scrollUp c-v.p nullAction c-v.t paste c-w.t.p.c showAll c-x.p nullAction c-x.t cut c-y.t.p redo c-z.t.p undo delete.p prefixDelete delete.t delete down.t.p down end.p prefixEnd end.t end enter.p processPrefix enter.t splitLine escape.t.p commandLine f1.t.p.c help home.p prefixHome home.t home insert.t.p toggleInsert left.p prefixLeft left.t left numpadEnter.p processPrefix numpadEnter.t.secondary splitLine pageDown.t.p.c pageDown pageUp.t.p.c pageUp right.p prefixRight right.t right s-backSpace.p.secondary prefixBackSpace s-backSpace.t.secondary backSpace s-delete.t.secondary cut s-down.t blockMarkDown s-end.t blockMarkEnd s-enter.t newLine s-f10.t.p popupAtCursor s-home.t blockMarkHome s-insert.t.secondary paste s-left.t blockMarkLeft s-numpadEnter.t.secondary newLine s-pageDown.t blockMarkPageDown s-pageUp.t blockMarkPageUp s-right.t blockMarkRight s-tab.p prefixHome s-tab.t prevTabStop s-up.t blockMarkUp tab.p home tab.t insertToTab up.t.p up ";
    private static final String eclipseMouseActions;
    private static final String briefKeyActions = "a-a.t blockMarkCharacter a-backSpace.t deleteNextWord a-c.t blockMarkRectangle a-d.t deleteLine a-enter.t.secondary splitLine a-f.t insertFileName a-f5.t.p.c findUp a-f6.t.p.c findAndReplaceUp a-g.t.p.c locateLine a-h.t.p.c help a-i.t.p toggleInsert a-j.t.p.c findQuickMark a-k.t truncate a-m.t.secondary blockMarkCharacter a-numpadEnter.t.secondary splitLine a-o.t.p.c rename a-p.t.p.c print a-r.t.p.c get a-t.t.p.c.secondary findAndReplace a-u.t.p undo a-w.t.p.c save a-y.t.p.c findBlockStart c-b.t.p.c scrollBottom c-backSpace.t deletePrevWord c-c.t.p.c scrollCenter c-d.t.p.c.secondary pageDown c-e.t.p.c.secondary pageUp c-end.t.p.c windowBottom c-f5.t.p.c toggleCaseSensitive c-f6.t.p.c toggleRegularExpression c-home.t.p.c windowTop c-k.t deleteToLineStart c-pageDown.t.p.c bottom c-pageUp.t.p.c top c-s-backSpace.t deleteLine c-u.t.p.c redo f10.t.p.c commandLine f5.t.p.c find f6.t.p.c findAndReplace f7.t.p.c keyRecorderStart f8.t.p.c keyRecorderPlay s-enter.t.secondary splitLine s-f5.t.p.c findNext s-f6.t.p.c findAndReplaceNext s-f7.t.p.c keyRecorderStop s-numpadEnter.t.secondary splitLine ";
    private static final String briefMouseActions = "";
    private static final String emacsKeyActions = "a-0.t appendToActionArgument a-1.t appendToActionArgument a-2.t appendToActionArgument a-3.t appendToActionArgument a-4.t appendToActionArgument a-5.t appendToActionArgument a-6.t appendToActionArgument a-7.t appendToActionArgument a-8.t appendToActionArgument a-9.t appendToActionArgument a-atSign.t setQuickMarkWord a-b.t prevWord a-backSlash.t deleteWhiteSpace a-backSpace.t deletePrevWord a-c.t capitalizeWord a-d.t deleteNextWord a-delete.t deletePrevWord a-f.t nextWord a-f9.t.c print a-greaterThanSign.t bottom a-minus.t appendToActionArgument a-i.t insertTab a-l.t lowerCaseWord a-lessThanSign.t top a-percent.t findAndReplace a-space.t oneSpace a-t.t transposeWords a-u.t upperCaseWord a-v.t.c pageUp a-x.t commandLine a-y.t yankPrevious a-z.t scrollUp backSpace.t backSpace c-0.t appendToActionArgument c-1.t appendToActionArgument c-2.t appendToActionArgument c-3.t appendToActionArgument c-4.t appendToActionArgument c-5.t appendToActionArgument c-6.t appendToActionArgument c-7.t appendToActionArgument c-8.t appendToActionArgument c-9.t appendToActionArgument c-a-0.t appendToActionArgument c-a-1.t appendToActionArgument c-a-2.t appendToActionArgument c-a-3.t appendToActionArgument c-a-4.t appendToActionArgument c-a-5.t appendToActionArgument c-a-6.t appendToActionArgument c-a-7.t appendToActionArgument c-a-8.t appendToActionArgument c-a-9.t appendToActionArgument c-a-minus.t appendToActionArgument c-a-o.t splitAndShift c-a-s.t find c-a.t home c-atSign.t setQuickMark c-b.t left c-c.t nullAction c-d.t delete c-e.t end c-f.t right c-g.t.c nullAction c-minus.t appendToActionArgument c-i.t nullAction c-j.t nullAction c-k.t killLine c-l.t.c scrollCenter c-m-0.t appendToActionArgument c-m-1.t appendToActionArgument c-m-2.t appendToActionArgument c-m-3.t appendToActionArgument c-m-4.t appendToActionArgument c-m-5.t appendToActionArgument c-m-6.t appendToActionArgument c-m-7.t appendToActionArgument c-m-8.t appendToActionArgument c-m-9.t appendToActionArgument c-m-minus.t appendToActionArgument c-m-o.t splitAndShift c-m-s.t find c-n.t down c-o.t split c-p.t up c-q.t nullAction c-r.t.c findUp c-s.c findNext c-s.t find c-space.t setQuickMark c-t.t transposeCharacters c-u.t setActionArgument c-underscore.t.c undo c-v.t.c pageDown c-w.t killRegion c-x,c-l.t lowerCaseRegion c-x,c-o.t deleteBlankLines c-x,c-s.t.c save c-x,c-t.t transposeLines c-x,c-u.t upperCaseRegion c-x,c-w.t.c saveAs c-x,c-x.t findQuickMark c-x,closeBracket.t bottom c-x,closeParenthesis.t keyRecorderStop c-x,e keyRecorderPlay c-x,greaterThanSign.t.c pageRight c-x,h setQuickMarkAll c-x,i.t.c get c-x,lessThanSign.t.c pageLeft c-x,openBracket.t top c-x,openParenthesis.t keyRecorderStart c-x,u.t.c undo c-y.t yank c-z.t scrollDown delete.t backSpace down.t down end.t bottom enter.t splitLine escape,0.t appendToActionArgument escape,1.t appendToActionArgument escape,2.t appendToActionArgument escape,3.t appendToActionArgument escape,4.t appendToActionArgument escape,5.t appendToActionArgument escape,6.t appendToActionArgument escape,7.t appendToActionArgument escape,8.t appendToActionArgument escape,9.t appendToActionArgument escape,a-y.t yankPrevious escape,atSign.t setQuickMarkWord escape,b.t prevWord escape,backSlash.t deleteWhiteSpace escape,backSpace.t deletePrevWord escape,c-o.t splitAndShift escape,c-s.t find escape,c.t capitalizeWord escape,d.t deleteNextWord escape,delete.t deletePrevWord escape,f.t nextWord escape,f9.t.c print escape,greaterThanSign.t bottom escape,minus.t appendToActionArgument escape,l.t lowerCaseWord escape,lessThanSign.t top escape,m-y.t yankPrevious escape,percent.t findAndReplace escape,space.t oneSpace escape,t.t transposeWords escape,u.t upperCaseWord escape,v.t.c pageUp escape,x.t commandLine escape,z.t scrollUp f10.t redo f9.t undo home.t top insert.t toggleInsert left.t left m-0.t appendToActionArgument m-1.t appendToActionArgument m-2.t appendToActionArgument m-3.t appendToActionArgument m-4.t appendToActionArgument m-5.t appendToActionArgument m-6.t appendToActionArgument m-7.t appendToActionArgument m-8.t appendToActionArgument m-9.t appendToActionArgument m-atSign.t setQuickMarkWord m-b.t prevWord m-backSlash.t deleteWhiteSpace m-backSpace.t deletePrevWord m-c.t capitalizeWord m-d.t deleteNextWord m-delete.t deletePrevWord m-f.t nextWord m-greaterThanSign.t bottom m-minus.t appendToActionArgument m-l.t lowerCaseWord m-lessThanSign.t top m-percent.t findAndReplace m-space.t oneSpace m-t.t transposeWords m-u.t upperCaseWord m-v.t.c pageUp m-x.t commandLine m-y.t yankPrevious m-z.t scrollUp numpadEnter.t.secondary splitLine pageDown.t.c pageDown pageUp.t.c pageUp right.t right tab.t indentText up.t up ";
    private static final String emacsMouseActions = "";
    private static final String epmKeyActions = "a-b.t blockMarkRectangle a-e.t.p.c findBlockEnd a-enter.t.secondary splitLine a-f.t.p.c blockFill a-n.t insertFileName a-numpadEnter.t.secondary splitLine a-w.t blockMarkWord a-y.t.p.c findBlockStart a-z.t blockMarkCharacter c-0.t insertRightBrace c-6.t insertNot c-9.t insertLeftBrace c-b.t.p.c findMark c-d.t deleteNextWord c-e.t truncate c-enter.t.secondary splitLine c-f.t.p.c findNext c-f1.t upperCaseWord c-f2.t lowerCaseWord c-f3.t.p.c blockUpperCase c-f4.t.p.c blockLowerCase c-f5.t wordStart c-f6.t wordEnd c-f7.t blockShiftLeft c-f8.t blockShiftRight c-i.t.p commandLine c-k.t.p duplicateLine c-l.t execCommand c-m.t nameMark c-numpadEnter.t.secondary splitLine c-r.t.p.c toggleKeyRecording c-s-backSpace.t deleteLine c-s.t.p.c find c-t.t.p.c keyRecorderPlay c-tab.t insertTab c-u.t.p undo f2.t.p.c save f3.t.p.c rename f9.t.p.c undo s-enter.t.secondary splitLine s-f1.t.p.c pageLeft s-f2.t.p.c pageRight s-f3.t.p.c pageUp s-f4.t.p.c pageDown s-numpadEnter.t.secondary splitLine ";
    private static final String epmMouseActions = "";
    private static final String seuKeyActions = "a-enter.t.p processPrefix a-numpadEnter.t.p processPrefix backSpace.t backSpaceInLine delete.t deleteInLine enter.t openLine f5.t.p.c restorePrefix f7.t.p.c pageUp f8.t.p.c pageDown s-f2.t.p.c find s-f4.t.p.c findNext s-f5.t.p.c findAndReplace s-f7.t.p.c pageLeft s-f8.t.p.c pageRight";
    private static final String seuMouseActions = "";
    private static final String ispfKeyActions = "a-enter.t.secondary newLine a-numpadEnter.t.secondary newLine";
    private static final String ispfMouseActions = "";
    private static final String xeditKeyActions = "f11.t.p.c pageRight f5.t.p.c findNext f6.t.p.c find f7.t.p.c pageUp f8.t.p.c pageDown";
    private static final String xeditMouseActions = "";
    private int _lastMousePressedModifiers;

    static {
        KEY_MOD_C = SWT.MOD1;
        KEY_MOD_S = SWT.MOD2;
        KEY_MOD_A = SWT.MOD3;
        KEY_MOD_R = SWT.MOD4;
        if (!LpexUtilities.isMac()) {
            KEY_MOD_M = 65536;
            LPEX_POPUP_DEFINITION = "3-pressed.1";
        } else {
            KEY_MOD_M = 0x400000;
            LPEX_POPUP_DEFINITION = "c-1-pressed.1";
        }
        _keys = new Key[]{new Key("0", 0, '0', false), new Key("1", 0, '1', false), new Key("2", 0, '2', false), new Key("3", 0, '3', false), new Key("4", 0, '4', false), new Key("5", 0, '5', false), new Key("6", 0, '6', false), new Key("7", 0, '7', false), new Key("8", 0, '8', false), new Key("9", 0, '9', false), new Key("a", 0, 'a', false), new Key("add", 16777259, '+', false), new Key("ampersand", 0, '&', true), new Key("asterisk", 0, '*', true), new Key("atSign", 0, '@', true), new Key("b", 0, 'b', false), new Key("backQuote", 0, '`', true), new Key("backSlash", 0, '\\', false), new Key("backSpace", 8, '\b', false), new Key("c", 0, 'c', false), new Key("cancel", 16777302, '\u0000', false), new Key("capsLock", 16777298, '\u0000', false), new Key("closeBrace", 0, '}', true), new Key("closeBracket", 0, ']', false), new Key("closeParenthesis", 0, ')', true), new Key("colon", 0, ':', true), new Key("comma", 0, ',', false), new Key("d", 0, 'd', false), new Key("decimal", 16777262, '.', false), new Key("delete", 127, '\u007f', false), new Key("divide", 16777263, '/', false), new Key("dollarSign", 0, '$', true), new Key("doubleQuote", 0, '\"', true), new Key("down", 0x1000002, '\u0000', false), new Key("e", 0, 'e', false), new Key("end", 0x1000008, '\u0000', false), new Key("enter", 13, '\r', false), new Key("equals", 0, '=', false), new Key("escape", 27, '\u001b', false), new Key("exclamationMark", 0, '!', true), new Key("f", 0, 'f', false), new Key("f1", 0x100000A, '\u0000', false), new Key("f10", 0x1000013, '\u0000', false), new Key("f11", 0x1000014, '\u0000', false), new Key("f12", 0x1000015, '\u0000', false), new Key("f13", 0x1000016, '\u0000', false), new Key("f14", 0x1000017, '\u0000', false), new Key("f15", 0x1000018, '\u0000', false), new Key("f2", 0x100000B, '\u0000', false), new Key("f3", 0x100000C, '\u0000', false), new Key("f4", 0x100000D, '\u0000', false), new Key("f5", 0x100000E, '\u0000', false), new Key("f6", 0x100000F, '\u0000', false), new Key("f7", 0x1000010, '\u0000', false), new Key("f8", 0x1000011, '\u0000', false), new Key("f9", 0x1000012, '\u0000', false), new Key("g", 0, 'g', false), new Key("greaterThanSign", 0, '>', true), new Key("h", 0, 'h', false), new Key("help", 0x1000051, '\u0000', false), new Key("home", 0x1000007, '\u0000', false), new Key("i", 0, 'i', false), new Key("insert", 0x1000009, '\u0000', false), new Key("j", 0, 'j', false), new Key("k", 0, 'k', false), new Key("karat", 0, '^', true), new Key("l", 0, 'l', false), new Key("left", 0x1000003, '\u0000', false), new Key("lessThanSign", 0, '<', true), new Key("m", 0, 'm', false), new Key("minus", 0, '-', false), new Key("multiply", 16777258, '*', false), new Key("n", 0, 'n', false), new Key("numLock", 16777299, '\u0000', false), new Key("numberSign", 0, '#', true), new Key("numpad0", 0x1000030, '0', false), new Key("numpad1", 0x1000031, '1', false), new Key("numpad2", 16777266, '2', false), new Key("numpad3", 0x1000033, '3', false), new Key("numpad4", 16777268, '4', false), new Key("numpad5", 16777269, '5', false), new Key("numpad6", 16777270, '6', false), new Key("numpad7", 16777271, '7', false), new Key("numpad8", 16777272, '8', false), new Key("numpad9", 16777273, '9', false), new Key("numpadEnter", 0x1000050, '\r', false), new Key("o", 0, 'o', false), new Key("openBrace", 0, '{', true), new Key("openBracket", 0, '[', false), new Key("openParenthesis", 0, '(', true), new Key("p", 0, 'p', false), new Key("pageDown", 0x1000006, '\u0000', false), new Key("pageUp", 0x1000005, '\u0000', false), new Key("pause", 0x1000055, '\u0000', false), new Key("percent", 0, '%', true), new Key("period", 0, '.', false), new Key("plus", 0, '+', true), new Key("printScreen", 16777303, '\u0000', false), new Key("q", 0, 'q', false), new Key("questionMark", 0, '?', true), new Key("quote", 0, '\'', false), new Key("r", 0, 'r', false), new Key("right", 0x1000004, '\u0000', false), new Key("s", 0, 's', false), new Key("scrollLock", 16777300, '\u0000', false), new Key("semicolon", 0, ';', false), new Key("slash", 0, '/', false), new Key("space", 0, ' ', false), new Key("subtract", 16777261, '-', false), new Key("t", 0, 't', false), new Key("tab", 9, '\t', false), new Key("tilde", 0, '~', true), new Key("u", 0, 'u', false), new Key("underscore", 0, '_', true), new Key("up", 0x1000001, '\u0000', false), new Key("v", 0, 'v', false), new Key("verticalBar", 0, '|', true), new Key("w", 0, 'w', false), new Key("x", 0, 'x', false), new Key("y", 0, 'y', false), new Key("z", 0, 'z', false)};
        _mouseEvents = new TableNode[]{new TableNode("clicked", 1), new TableNode("dragged", 2), new TableNode("entered", 3), new TableNode("exited", 4), new TableNode("hover", 11), new TableNode("moved", 5), new TableNode("popup", 6), new TableNode("pressed", 7), new TableNode("released", 8), new TableNode("wheelDown", 9), new TableNode("wheelUp", 10)};
        TableNode.sort(_mouseEvents);
        lpexMouseActions = "1-dragged.t.p.e blockMarkToMouse 1-pressed.1.e expandHideAtMouse 1-pressed.1.t.p cursorToMouse 1-pressed.2.e expandHideAtMouse 1-pressed.2.t.p blockMarkWordAtMouse 1-pressed.3.e expandHideAtMouse a-1-dragged.t.p.e blockMarkToMouse a-1-pressed.1.t.p.e cursorToMouse a-1-pressed.2.t.p.e blockMarkRectangleAtMouse c-1-dragged.t.p.e blockMarkToMouse c-1-pressed.1.t.p.e cursorToMouse c-1-pressed.2.t.p.e blockMarkElementAtMouse c-a-1-pressed.1.t.p.e blockUnmark c-a-s-1-pressed.1.t.p.e blockUnmark c-s-1-pressed.1.t.p.e expandHideAtMouse c-s-2-pressed.1.t.p.e expandHideAtMouse c-s-3-pressed.1.t.p.e expandHideAtMouse c-wheelDown.t.p.e pageDown c-wheelUp.t.p.e pageUp " + LPEX_POPUP_DEFINITION + ".t.p.e popupAtMouse s-1-dragged.t.p.e blockMarkToMouse s-1-pressed.1.t.p.e blockMarkToMouse ";
        eclipseMouseActions = "1-dragged.t.p.e blockMarkToMouse 1-pressed.1.e expandHideAtMouse 1-pressed.1.t.p cursorToMouse 1-pressed.2.e expandHideAtMouse 1-pressed.2.t.p blockMarkWordAtMouse 1-pressed.3.e expandHideAtMouse a-1-dragged.t.p.e blockMarkToMouse a-1-pressed.1.t.p.e cursorToMouse a-1-pressed.2.t.p.e blockMarkRectangleAtMouse c-1-dragged.t.p.e blockMarkToMouse c-1-pressed.1.t.p.e cursorToMouse c-1-pressed.2.t.p.e blockMarkElementAtMouse c-a-1-pressed.1.t.p.e blockUnmark c-a-s-1-pressed.1.t.p.e blockUnmark c-s-1-pressed.1.t.p.e expandHideAtMouse c-s-2-pressed.1.t.p.e expandHideAtMouse c-s-3-pressed.1.t.p.e expandHideAtMouse c-wheelDown.t.p.e pageDown c-wheelUp.t.p.e pageUp " + LPEX_POPUP_DEFINITION + ".t.p.e popupAtMouse s-1-dragged.t.p.e blockMarkToMouse s-1-pressed.1.t.p.e blockMarkToMouse ";
    }

    ActionHandler(View view) {
        this._view = view;
        this._textAreaKeyActionList = new KeyActionList(1);
        this._prefixAreaKeyActionList = new KeyActionList(2);
        this._commandLineKeyActionList = new KeyActionList(4);
        this._currentKeyActionList = null;
        this._textAreaMouseActionList = new MouseActionList(1);
        this._prefixAreaMouseActionList = new MouseActionList(2);
        this._expandHideAreaMouseActionList = new MouseActionList(8);
        this._actionList = new ActionList();
        this._availableActionId = 300;
    }

    void clearActionLists() {
        this._textAreaKeyActionList.clear();
        this._prefixAreaKeyActionList.clear();
        this._commandLineKeyActionList.clear();
        this._textAreaMouseActionList.clear();
        this._prefixAreaMouseActionList.clear();
        this._expandHideAreaMouseActionList.clear();
        this._actionList.clear();
    }

    void updateProfile() {
        UpdateProfileCommand.UserMouseActionsParameter userMouseActionsParameter;
        String userMouseActions;
        UpdateProfileCommand.UserKeyActionsParameter userKeyActionsParameter;
        String userKeyActions;
        this.clearActionLists();
        String baseProfile = this._view.baseProfile();
        if ("none".equalsIgnoreCase(baseProfile)) {
            this.defineKeyActions(noneKeyActions, "none");
        } else {
            if (!"emacs".equalsIgnoreCase(baseProfile) && !"eclipse".equalsIgnoreCase(baseProfile)) {
                this.defineKeyActions(lpexKeyActions, "lpex");
            }
            this.defineMouseActions(lpexMouseActions, "lpex");
            if (baseProfile != null) {
                if (baseProfile.equalsIgnoreCase("brief")) {
                    this.defineKeyActions(briefKeyActions, "brief");
                    this.defineMouseActions("", "brief");
                } else if (baseProfile.equalsIgnoreCase("emacs")) {
                    this.defineKeyActions(emacsKeyActions, "emacs");
                    this.defineMouseActions("", "emacs");
                } else if (baseProfile.equalsIgnoreCase("epm")) {
                    this.defineKeyActions(epmKeyActions, "epm");
                    this.defineMouseActions("", "epm");
                } else if (baseProfile.equalsIgnoreCase("eclipse")) {
                    this.defineKeyActions(eclipseKeyActions, "eclipse");
                    this.defineMouseActions(eclipseMouseActions, "eclipse");
                } else if (baseProfile.equalsIgnoreCase("seu")) {
                    this.defineKeyActions(seuKeyActions, "seu");
                    this.defineMouseActions("", "seu");
                } else if (baseProfile.equalsIgnoreCase("xedit")) {
                    this.defineKeyActions(xeditKeyActions, "xedit");
                    this.defineMouseActions("", "xedit");
                } else if (baseProfile.equalsIgnoreCase("ispf")) {
                    this.defineKeyActions(ispfKeyActions, "ispf");
                    this.defineMouseActions("", "ispf");
                }
            }
        }
        String userActions = UpdateProfileCommand.UserActionsParameter.getParameter().currentValue(this._view);
        if (userActions != null) {
            LpexStringTokenizer st = new LpexStringTokenizer(userActions);
            while (st.hasMoreTokens()) {
                String action = st.nextToken();
                if (st.hasMoreTokens()) {
                    this.defineAction(action, st.nextToken());
                    continue;
                }
                this._view.setLpexMessageText("action.userActionsInvalid", action);
            }
        }
        if ((userKeyActions = (userKeyActionsParameter = UpdateProfileCommand.UserKeyActionsParameter.getParameter()).currentValue(this._view)) != null) {
            this.defineKeyActions(userKeyActions, userKeyActionsParameter.name());
        }
        if ((userMouseActions = (userMouseActionsParameter = UpdateProfileCommand.UserMouseActionsParameter.getParameter()).currentValue(this._view)) != null) {
            this.defineMouseActions(userMouseActions, userMouseActionsParameter.name());
        }
    }

    private void defineKeyActions(String keyActions, String setting) {
        LpexStringTokenizer st = new LpexStringTokenizer(keyActions);
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            if (st.hasMoreTokens()) {
                this.defineKeyAction(key, st.nextToken());
                continue;
            }
            this._view.setLpexMessageText("action.keyActionsInvalid", setting, key);
        }
    }

    boolean defineKeyAction(String keyString, String actionString) {
        int[] modifiersArray;
        if ("null".equalsIgnoreCase(actionString)) {
            actionString = null;
        }
        if ((modifiersArray = ActionUtilities.getKeyModifiersArray(keyString)).length == 0) {
            this._view.setLpexMessageText("action.keyInvalid", keyString);
            return false;
        }
        Key[] keyArray = ActionHandler.getKeyArray(keyString);
        int i = 0;
        while (i < keyArray.length) {
            if (keyArray[i] == null) {
                this._view.setLpexMessageText("action.keyInvalid", keyString);
                return false;
            }
            ++i;
        }
        int context = ActionUtilities.getKeyContext(keyString);
        if (context == 0) {
            this._view.setLpexMessageText("action.keyInvalid", keyString);
            return false;
        }
        boolean secondary = ActionUtilities.getSecondary(keyString);
        if ((context & 1) != 0 && !this._view.vi()) {
            this._textAreaKeyActionList.defineKeyAction(modifiersArray, keyArray, secondary, actionString);
        }
        if ((context & 2) != 0) {
            this._prefixAreaKeyActionList.defineKeyAction(modifiersArray, keyArray, secondary, actionString);
        }
        if ((context & 4) != 0) {
            this._commandLineKeyActionList.defineKeyAction(modifiersArray, keyArray, secondary, actionString);
        }
        return true;
    }

    String keys() {
        String keys = this._textAreaKeyActionList.keys(1500) + " ";
        if (!this._view.prefixProtect()) {
            keys = keys + this._prefixAreaKeyActionList.keys(800) + " ";
        }
        keys = keys + this._commandLineKeyActionList.keys(700);
        return keys.trim();
    }

    String keyActionString(String keyString) {
        int context;
        int[] modifiersArray = ActionUtilities.getKeyModifiersArray(keyString);
        if (modifiersArray.length == 0) {
            return null;
        }
        Key[] keyArray = ActionHandler.getKeyArray(keyString);
        KeyActionList.KeyAction keyAction = this.findKey(modifiersArray, keyArray, context = ActionUtilities.getKeyContext(keyString));
        return keyAction != null ? keyAction.actionString() : null;
    }

    KeyActionList.KeyAction findKey(int modifiers, Key key, int context) {
        KeyActionList.KeyAction keyAction = null;
        if (context == 1) {
            keyAction = this._textAreaKeyActionList.findKey(modifiers, key);
        } else if (context == 2) {
            keyAction = this._prefixAreaKeyActionList.findKey(modifiers, key);
        } else if (context == 4) {
            keyAction = this._commandLineKeyActionList.findKey(modifiers, key);
        }
        return keyAction;
    }

    KeyActionList.KeyAction findKey(int[] modifiersArray, Key[] keyArray, int context) {
        KeyActionList.KeyAction keyAction = null;
        if (context == 1) {
            keyAction = this._textAreaKeyActionList.findKey(modifiersArray, keyArray);
        } else if (context == 2) {
            keyAction = this._prefixAreaKeyActionList.findKey(modifiersArray, keyArray);
        } else if (context == 4) {
            keyAction = this._commandLineKeyActionList.findKey(modifiersArray, keyArray);
        }
        return keyAction;
    }

    static int activeContext(View view) {
        Composite textWindow = view.window() != null ? view.window().textWindow() : null;
        return textWindow == null || textWindow.isFocusControl() ? 1 : 4;
    }

    /*
     * Unable to fully structure code
     */
    void doKeyEvent(Event e) {
        block34: {
            block36: {
                block35: {
                    block33: {
                        v0 = textWindow = this._view.window() != null ? this._view.window().textWindow() : null;
                        if (textWindow == e.widget) {
                            this._currentKeyContext = this._view.inPrefix() != false ? 2 : 1;
                        } else {
                            this._currentKeyContext = 4;
                            if (this._view._traceKeys) {
                                this.traceKeyEvent(e, true, true);
                            }
                        }
                        this._currentKeyModifiers = e.stateMask;
                        this._currentKey = ActionHandler.getKey(e);
                        if (this._view._traceKeys) {
                            this.traceKey();
                        }
                        if (this._currentKeyContext != 1 || !this._view.vi()) break block33;
                        c = e.character;
                        if (c == '\u0000') {
                            switch (e.keyCode) {
                                case 0x1000002: {
                                    c = 'j';
                                    break;
                                }
                                case 0x1000003: {
                                    c = 'h';
                                    break;
                                }
                                case 0x1000006: {
                                    c = '\u0006';
                                    break;
                                }
                                case 0x1000005: {
                                    c = '\u0002';
                                    break;
                                }
                                case 0x1000004: {
                                    c = 'l';
                                    break;
                                }
                                case 0x1000001: {
                                    c = 'k';
                                    break;
                                }
                            }
                        }
                        if (c != '\u0000') {
                            this._view.beginUserAction();
                            this._view.viHandler().processCharacter(c);
                            this._view.endUserActionKey();
                            Document.screenShow();
                        }
                        break block34;
                    }
                    c = e.character;
                    v1 = keyAction = this._currentKeyActionList == null ? this.findKey(this._currentKeyModifiers, this._currentKey, this._currentKeyContext) : this._currentKeyActionList.findKey(this._currentKeyModifiers, this._currentKey);
                    if ((this._currentKey == null || keyAction == null && this._currentKeyActionList == null) && (this._currentKeyActionList != null || keyAction != null || c == '\u0000' || e.widget != textWindow)) break block34;
                    actionId = keyAction != null ? keyAction.actionId() : 0;
                    this._view.beginUserAction(actionId);
                    if (this._currentKeyActionList == null || keyAction != null) break block35;
                    this._view.screen().setMessageText(null);
                    this._currentKeyActionList = null;
                    break block36;
                }
                if (keyAction == null) ** GOTO lbl78
                if (keyAction.keyActionList() != null) {
                    this._currentKeyActionList = keyAction.keyActionList();
                    this._view.screen().setMessageText(keyAction.keyString());
                } else {
                    if (this._currentKeyActionList != null) {
                        this._view.screen().setMessageText(null);
                        this._currentKeyActionList = null;
                    }
                    if (actionId == 0) {
                        this._view.setLpexMessageText("action.invalid", keyAction.actionString());
                    } else {
                        this._lastKeyActionId = actionId;
                        recording = KeyRecorder.keyRecorder().recording();
                        rc = this.doActionIfAvailable(actionId);
                        if (recording == KeyRecorder.keyRecorder().recording()) {
                            KeyRecorder.keyRecorder().recordAction(this._view, actionId, this._argument);
                        }
                        this.setArgument(null);
                        this._view.endUserActionKey();
                        if (rc == 1) {
                            Document.screenShow(this._view);
                        } else if (rc == 2) {
                            Document.screenShow(this._view.document());
                        } else if (rc == 3) {
                            Document.screenShow();
                        }
                        return;
lbl78:
                        // 1 sources

                        if (LpexUtilities.isMac()) {
                            ignore = (this._currentKeyModifiers ^ 0x400000) == 0 || (this._currentKeyModifiers ^ 0x420000) == 0;
                        } else {
                            v2 = ignore = (this._currentKeyModifiers ^ 65536) == 0 || (this._currentKeyModifiers ^ 262144) == 0 || (this._currentKeyModifiers ^ 196608) == 0 || (this._currentKeyModifiers ^ 393216) == 0;
                        }
                        if (!ignore && c < ' ' && c != '\t') {
                            ignore = true;
                        }
                        if (!ignore) {
                            if (this._settingArgument && this.validArgumentCharacter(c)) {
                                this.appendToArgument(c);
                            } else {
                                repeat = this.repeat();
                                if (c <= '9' && c >= '0' && EnterArabicDigitsParameter.getParameter().currentValue(this._view)) {
                                    c = (char)(c + 1584);
                                }
                                i = 0;
                                while (i < repeat) {
                                    this._view.receiveCharacter(c);
                                    KeyRecorder.keyRecorder().recordCharacter(this._view.insertMode(), c);
                                    ++i;
                                }
                                this.setArgument(null);
                                this._view.endUserActionKey();
                                Document.screenShow(this._view.document());
                                return;
                            }
                        }
                    }
                }
            }
            this._view.endUserActionKey();
            Document.screenShow();
        }
    }

    void traceKeyEvent(Event e, boolean down, boolean doit) {
        StringBuilder result = new StringBuilder(64);
        result.append("[char=0x");
        result.append(Integer.toHexString(e.character).toUpperCase());
        if (e.character != '\u0000') {
            result.append(" \"").append(e.character).append('\"');
            switch (e.character) {
                case '\u0000': {
                    result.append(" ('\\0')");
                    break;
                }
                case '\b': {
                    result.append(" ('\\b')");
                    break;
                }
                case '\r': {
                    result.append(" ('\\r')");
                    break;
                }
                case '\u007f': {
                    result.append(" (Del)");
                    break;
                }
                case '\u001b': {
                    result.append(" (Esc)");
                    break;
                }
                case '\n': {
                    result.append(" ('\\n')");
                    break;
                }
                case '\t': {
                    result.append(" ('\\t')");
                    break;
                }
            }
        }
        result.append(", code=0x").append(Integer.toHexString(e.keyCode).toUpperCase());
        if (e.keyCode == 262144) {
            result.append(" (CTRL)");
        } else if (e.keyCode == 65536) {
            result.append(" (ALT)");
        } else if (e.keyCode == 131072) {
            result.append(" (SHIFT)");
        } else if (e.keyCode == 0x400000) {
            result.append(" (COMMAND)");
        }
        result.append(", state=");
        if (e.stateMask == 0) {
            result.append("<none>");
        } else {
            int otherModifiers;
            if ((e.stateMask & 0x40000) != 0) {
                result.append("Ctrl ");
            }
            if ((e.stateMask & 0x10000) != 0) {
                result.append("Alt ");
            }
            if ((e.stateMask & 0x20000) != 0) {
                result.append("Shift ");
            }
            if ((e.stateMask & 0x400000) != 0) {
                result.append("Command ");
            }
            if ((e.stateMask & 0x80000) != 0) {
                result.append("BUTTON1 ");
            }
            if ((otherModifiers = e.stateMask & 0xFFB0FFFF) != 0) {
                result.append("<others>: ");
                result.append(Integer.toHexString(otherModifiers).toUpperCase());
            }
            if (result.charAt(result.length() - 1) == ' ') {
                result.deleteCharAt(result.length() - 1);
            }
        }
        result.append(doit ? "]" : " !doit]");
        this._view._keyTrace = result.toString();
    }

    void traceKey() {
        String currentKeyString = this.currentKeyString();
        if (currentKeyString != null) {
            this._view._keyTrace = currentKeyString + " " + this._view._keyTrace;
        }
        this._view.screen().setMessageTraceText(this._view._keyTrace);
    }

    void traceMouseEvent(MouseEvent e, int eID, String mouseAction) {
        StringBuilder result = new StringBuilder(64);
        if (this._view._mouseTrace != null) {
            if (eID == 11) {
                int i = this._view._mouseTrace.indexOf(" ..hover");
                if (i >= 0) {
                    this._view._mouseTrace = this._view._mouseTrace.substring(0, i);
                }
                result.append(this._view._mouseTrace);
            } else if (eID == 5) {
                int i = this._view._mouseTrace.indexOf(" ..moved");
                if (i >= 0) {
                    this._view._mouseTrace = this._view._mouseTrace.substring(0, i);
                }
                result.append(this._view._mouseTrace);
            }
        }
        switch (eID) {
            case 2: {
                result.append("drag");
                break;
            }
            case 3: {
                result.append("enter");
                break;
            }
            case 4: {
                result.append("exit");
                break;
            }
            case 5: {
                result.append(" ..moved");
                break;
            }
            case 7: {
                result.append("down");
                break;
            }
            case 8: {
                result.append("up");
                break;
            }
            case 11: {
                result.append(" ..hover");
                break;
            }
            case 9: {
                result.append("wheelDown.").append(-e.count);
                break;
            }
            case 10: {
                result.append("wheelUp.").append(e.count);
                break;
            }
            case 12: {
                result.append("dblClick");
                break;
            }
            default: {
                result.append("?????");
            }
        }
        result.append(" [").append(e.x).append(',').append(e.y).append(']');
        if (e.button != 0) {
            result.append(" button=").append(e.button);
        }
        if (mouseAction != null) {
            result.append(' ').append(mouseAction);
        }
        this._view._mouseTrace = result.toString();
        this._view.screen().setMessageTraceText(this._view._mouseTrace);
    }

    private static Key[] getKeyArray(String keyString) {
        keyString = keyString.replace(',', ' ');
        LpexStringTokenizer st = new LpexStringTokenizer(keyString);
        int count = st.countTokens();
        Key[] keyArray = new Key[count];
        int i = 0;
        while (i < count) {
            keyArray[i] = ActionHandler.getKey(st.nextToken(), i == count - 1);
            ++i;
        }
        return keyArray;
    }

    private static Key getKey(String keyString, boolean last) {
        while (keyString.startsWith("a-") || keyString.startsWith("c-") || keyString.startsWith("m-") || keyString.startsWith("s-") || keyString.startsWith("r-") || keyString.startsWith("A-") || keyString.startsWith("C-") || keyString.startsWith("M-") || keyString.startsWith("S-") || keyString.startsWith("R-")) {
            keyString = keyString.substring(2);
        }
        int indexOfDot = keyString.indexOf(46);
        if (indexOfDot >= 0 && last) {
            keyString = keyString.substring(0, indexOfDot);
        }
        return (Key)TableNode.binarySearch(_keys, keyString);
    }

    static Key getKey(Event e) {
        char keyChar = e.character;
        int keyCode = e.keyCode;
        int modifiers = e.stateMask;
        if (keyChar == '\u0000' && (modifiers & 0x40000) != 0 && (modifiers & 0x20000) != 0 && keyCode != 65536) {
            keyChar = '@';
        } else if ((modifiers & 0x40000) != 0 && (modifiers & 0x10000) == 0 && keyChar >= '\u0001' && keyChar <= '\u001f') {
            keyChar = (char)(keyChar + 64);
        }
        if (keyChar >= 'A' && keyChar <= 'Z') {
            keyChar = (char)(keyChar + 32);
        }
        Key bestKey = null;
        int i = 0;
        while (i < _keys.length) {
            Key key = _keys[i];
            if (key.keyCode() == keyCode && key.keyChar() == e.character) {
                return key;
            }
            if (key.keyCode() == 0 && key.keyChar() == keyChar) {
                bestKey = key;
            } else if (bestKey == null && key.keyCode() == 0 && key.keyChar() == keyCode) {
                bestKey = key;
            } else if ((modifiers & 0x40000) == 0 && key.keyCode() != 0 && key.keyCode() == keyCode) {
                bestKey = key;
            }
            ++i;
        }
        return bestKey;
    }

    String keyText(int actionId) {
        KeyActionList.KeyAction keyAction = this._textAreaKeyActionList.findPrimaryKey(actionId);
        if (keyAction != null) {
            return ActionHandler.keyText(keyAction.keyString());
        }
        return null;
    }

    static String keyText(String keyString) {
        Object keyText = "";
        if (keyString != null) {
            Key[] keyArray = ActionHandler.getKeyArray(keyString);
            int[] modifiersArray = ActionUtilities.getKeyModifiersArray(keyString);
            int i = 0;
            while (i < keyArray.length) {
                if (keyArray[i] == null) {
                    return null;
                }
                String keyName = keyArray[i].keyName();
                int modifiers = modifiersArray[i];
                Object text = LpexResources.message("key." + keyName);
                if (text == null) {
                    Key key = (Key)TableNode.binarySearch(_keys, keyName);
                    char keyChar = key.keyChar();
                    if (keyChar > ' ' && keyChar <= '~') {
                        keyName = String.valueOf(keyChar);
                    }
                    text = keyName.toUpperCase();
                }
                if (!LpexUtilities.isMac()) {
                    if ((modifiers & KEY_MOD_S) != 0) {
                        text = LpexResources.message("key.shift") + "+" + (String)text;
                    }
                    if ((modifiers & KEY_MOD_A) != 0) {
                        text = LpexResources.message("key.alt") + "+" + (String)text;
                    }
                    if ((modifiers & KEY_MOD_C) != 0) {
                        text = LpexResources.message("key.ctrl") + "+" + (String)text;
                    }
                    if ((modifiers & KEY_MOD_R) != 0) {
                        text = LpexResources.message("key.windows") + "+" + (String)text;
                    }
                } else {
                    if ((modifiers & KEY_MOD_C) != 0) {
                        text = LpexResources.message("key.command") + "+" + (String)text;
                    }
                    if ((modifiers & KEY_MOD_A) != 0) {
                        text = LpexResources.message("key.option") + "+" + (String)text;
                    }
                    if ((modifiers & KEY_MOD_R) != 0) {
                        text = LpexResources.message("key.control") + "+" + (String)text;
                    }
                    if ((modifiers & KEY_MOD_S) != 0) {
                        text = LpexResources.message("key.shift") + "+" + (String)text;
                    }
                }
                if (i > 0) {
                    keyText = (String)keyText + ",";
                }
                keyText = (String)keyText + (String)text;
                ++i;
            }
        }
        return keyText;
    }

    String keyString(int actionId) {
        KeyActionList.KeyAction keyAction = this._textAreaKeyActionList.findPrimaryKey(actionId);
        return keyAction != null ? keyAction.keyString() : null;
    }

    String currentKeyString() {
        if (this._currentKey == null) {
            return null;
        }
        Object keyString = this._currentKey.keyName();
        if ((this._currentKeyModifiers & KEY_MOD_S) != 0) {
            keyString = "s-" + (String)keyString;
        }
        if ((this._currentKeyModifiers & KEY_MOD_A) != 0) {
            keyString = "a-" + (String)keyString;
        }
        if ((this._currentKeyModifiers & KEY_MOD_C) != 0) {
            keyString = "c-" + (String)keyString;
        }
        if ((this._currentKeyModifiers & KEY_MOD_R) != 0) {
            keyString = "r-" + (String)keyString;
        }
        if ((this._currentKeyContext & 1) != 0) {
            keyString = (String)keyString + ".t";
        }
        if ((this._currentKeyContext & 2) != 0) {
            keyString = (String)keyString + ".p";
        }
        if ((this._currentKeyContext & 4) != 0) {
            keyString = (String)keyString + ".c";
        }
        return keyString;
    }

    private void defineMouseActions(String mouseActions, String setting) {
        LpexStringTokenizer st = new LpexStringTokenizer(mouseActions);
        while (st.hasMoreTokens()) {
            String mouseEvent = st.nextToken();
            if (st.hasMoreTokens()) {
                this.defineMouseAction(mouseEvent, st.nextToken());
                continue;
            }
            this._view.setLpexMessageText("action.mouseActionsInvalid", setting, mouseEvent);
        }
    }

    boolean defineMouseAction(String mouseEvent, String actionString) {
        boolean mouseButtonEvent;
        int modifiers = ActionUtilities.getMouseModifiers(mouseEvent);
        int eventId = ActionHandler.getMouseEventId(mouseEvent);
        int clickCount = ActionUtilities.getMouseClickCount(mouseEvent);
        int context = ActionUtilities.getMouseContext(mouseEvent);
        boolean bl = mouseButtonEvent = eventId == 7 || eventId == 1 || eventId == 8;
        if (eventId == 0 || context == 0 || mouseButtonEvent && clickCount <= 0) {
            this._view.setLpexMessageText("action.mouseEventInvalid", mouseEvent);
            return false;
        }
        if (mouseButtonEvent && (modifiers & 0x380000) == 0) {
            modifiers |= 0x80000;
        }
        if ((context & 1) != 0) {
            this._textAreaMouseActionList.defineMouseAction(modifiers, eventId, clickCount, actionString);
        }
        if ((context & 2) != 0) {
            this._prefixAreaMouseActionList.defineMouseAction(modifiers, eventId, clickCount, actionString);
        }
        if ((context & 8) != 0) {
            this._expandHideAreaMouseActionList.defineMouseAction(modifiers, eventId, clickCount, actionString);
        }
        return true;
    }

    String mouseEvents() {
        String mouseEvents = this._textAreaMouseActionList.mouseEvents() + " " + this._prefixAreaMouseActionList.mouseEvents() + " " + this._expandHideAreaMouseActionList.mouseEvents();
        return mouseEvents.trim();
    }

    String mouseActionString(String mouseEvent) {
        MouseActionList.MouseAction mouseAction;
        int modifiers = ActionUtilities.getMouseModifiers(mouseEvent);
        int eventId = ActionHandler.getMouseEventId(mouseEvent);
        int clickCount = ActionUtilities.getMouseClickCount(mouseEvent);
        int context = ActionUtilities.getMouseContext(mouseEvent);
        if ((eventId == 7 || eventId == 1 || eventId == 8) && (modifiers & 0x380000) == 0) {
            modifiers |= 0x80000;
        }
        return (mouseAction = this.findMouseEvent(modifiers, eventId, clickCount, context)) != null ? mouseAction.actionString() : null;
    }

    MouseActionList.MouseAction findMouseEvent(int modifiers, int eventId, int clickCount, int context) {
        MouseActionList.MouseAction mouseAction = null;
        if (context == 1) {
            mouseAction = this._textAreaMouseActionList.findMouseEvent(modifiers, eventId, clickCount);
        } else if (context == 2) {
            mouseAction = this._prefixAreaMouseActionList.findMouseEvent(modifiers, eventId, clickCount);
        } else if (context == 8) {
            mouseAction = this._expandHideAreaMouseActionList.findMouseEvent(modifiers, eventId, clickCount);
        }
        return mouseAction;
    }

    void doMouseEvent(MouseEvent e, int eID) {
        int modifiers = e.stateMask;
        if (eID != 2) {
            modifiers &= 0xFFC7FFFF;
            if (e.button == 1) {
                modifiers |= 0x80000;
            } else if (e.button == 2) {
                modifiers |= 0x100000;
            } else if (e.button == 3) {
                modifiers |= 0x200000;
            }
        }
        int eventId = eID;
        int clickCount = 0;
        switch (eID) {
            case 1: {
                clickCount = 1;
                break;
            }
            case 2: {
                modifiers = this._lastMousePressedModifiers;
                break;
            }
            case 7: {
                clickCount = 1;
                this._lastMousePressedModifiers = modifiers;
                break;
            }
            case 8: {
                clickCount = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 12: {
                eventId = 7;
                clickCount = 2;
                break;
            }
            default: {
                eventId = 0;
            }
        }
        this._currentMousePoint.x = e.x;
        this._currentMousePoint.y = e.y;
        int x = this._currentMousePoint.x;
        int context = 1;
        if (x > 0 && this._view.screen().prefixAreaWidth() > 0 && this._view.screen().prefixAreaWidth() > x) {
            context = 2;
        }
        if (x > 0 && this._view.screen().expandHideAreaWidth() > 0 && this._view.screen().expandHideAreaWidth() > x) {
            context = 8;
        }
        MouseActionList.MouseAction mouseAction = this.findMouseEvent(modifiers, eventId, clickCount, context);
        if (this._view._traceMouseEvents) {
            this.traceMouseEvent(e, eID, mouseAction != null ? mouseAction.actionString() : null);
        }
        if (mouseAction != null) {
            int actionId = mouseAction.actionId();
            this._view.beginUserAction(actionId);
            if (actionId == 0) {
                this._view.setLpexMessageText("action.invalid", mouseAction.actionString());
            } else {
                this.doActionIfAvailable(actionId);
                this.setArgument(null);
            }
            this._view.endUserAction();
            Document.screenShow();
        }
    }

    private static int getMouseEventId(String mouseEvent) {
        TableNode tableNode;
        while (mouseEvent.startsWith("1-") || mouseEvent.startsWith("2-") || mouseEvent.startsWith("3-") || mouseEvent.startsWith("a-") || mouseEvent.startsWith("c-") || mouseEvent.startsWith("m-") || mouseEvent.startsWith("s-") || mouseEvent.startsWith("r-") || mouseEvent.startsWith("A-") || mouseEvent.startsWith("C-") || mouseEvent.startsWith("M-") || mouseEvent.startsWith("S-") || mouseEvent.startsWith("R-")) {
            mouseEvent = mouseEvent.substring(2);
        }
        int indexOfDot = mouseEvent.indexOf(46);
        if (indexOfDot >= 0) {
            mouseEvent = mouseEvent.substring(0, indexOfDot);
        }
        return (tableNode = TableNode.binarySearch(_mouseEvents, mouseEvent)) != null ? tableNode.id() : 0;
    }

    Point currentMousePoint() {
        return this._currentMousePoint;
    }

    int id(String actionName) {
        if (actionName != null) {
            Action userAction = this._actionList.find(actionName = actionName.trim());
            return userAction != null ? userAction.id() : ActionUtilities.defaultActionId(actionName);
        }
        return 0;
    }

    String actionName(int actionId) {
        Action userAction = this._actionList.find(actionId);
        return userAction != null ? userAction.actionString() : ActionUtilities.defaultActionName(actionId);
    }

    boolean actionAvailable(int actionId) {
        Action userAction = this._actionList.find(actionId);
        return userAction != null ? userAction.lpexAction().available(this._view.lpexView()) : ActionUtilities.defaultActionAvailable(this._view, actionId);
    }

    boolean actionCheckable(int actionId) {
        Action userAction = this._actionList.find(actionId);
        if (userAction == null) {
            return ActionUtilities.defaultActionCheckable(actionId);
        }
        LpexAction lpexAction = userAction.lpexAction();
        return lpexAction instanceof LpexBaseAction && ((LpexBaseAction)lpexAction).checkable();
    }

    boolean actionChecked(int actionId) {
        Action userAction = this._actionList.find(actionId);
        if (userAction == null) {
            return ActionUtilities.defaultActionChecked(this._view, actionId);
        }
        LpexAction lpexAction = userAction.lpexAction();
        return lpexAction instanceof LpexBaseAction ? ((LpexBaseAction)lpexAction).checked(this._view.lpexView()) : false;
    }

    static boolean defaultPrintActionAvailable() {
        return true;
    }

    void doAction(int actionId) {
        Action userAction = this._actionList.find(actionId);
        if (userAction != null) {
            try {
                userAction.lpexAction().doAction(this._view.lpexView());
            }
            catch (Throwable e) {
                String actionName = userAction.actionString();
                String errorText = LpexResources.message("exception.action", actionName);
                this._view.screen().setMessageText(errorText);
                LpexLog.log(this._view, errorText, e);
                this.defineAction(actionName, (LpexAction)null);
            }
        } else {
            ActionUtilities.doDefaultAction(this._view, actionId);
        }
        this._view.screen().setKeepCursorVisible(true);
    }

    int doActionIfAvailable(int actionId) {
        int rc;
        block6: {
            rc = 0;
            Action userAction = this._actionList.find(actionId);
            if (userAction != null) {
                try {
                    LpexAction lpexAction = userAction.lpexAction();
                    if (!lpexAction.available(this._view.lpexView())) break block6;
                    lpexAction.doAction(this._view.lpexView());
                    if (lpexAction instanceof LpexBaseAction) {
                        rc = ((LpexBaseAction)lpexAction).screenShow(this._view.lpexView());
                        break block6;
                    }
                    if (actionId == 94 || actionId == 206 || actionId == 175 || actionId == 136) {
                        rc = 1;
                        break block6;
                    }
                    rc = 3;
                }
                catch (Throwable e) {
                    String actionName = userAction.actionString();
                    String errorText = LpexResources.message("exception.action", actionName);
                    this._view.screen().setMessageText(errorText);
                    LpexLog.log(this._view, errorText, e);
                    this.defineAction(actionName, (LpexAction)null);
                }
            } else {
                rc = ActionUtilities.doDefaultAction(this._view, actionId);
            }
        }
        this._view.screen().setKeepCursorVisible(true);
        return rc;
    }

    void triggerAction(int actionId) {
        this._view.beginUserAction(actionId);
        int rc = this.doActionIfAvailable(actionId);
        this.setArgument(null);
        this._view.endUserAction();
        if (rc == 1) {
            Document.screenShow(this._view);
        } else if (rc == 2) {
            Document.screenShow(this._view.document());
        } else if (rc == 3) {
            Document.screenShow();
        }
    }

    void triggerAction(int actionId, boolean record) {
        String argument = this._argument;
        boolean recording = KeyRecorder.keyRecorder().recording();
        this.triggerAction(actionId);
        if (record && recording == KeyRecorder.keyRecorder().recording()) {
            KeyRecorder.keyRecorder().recordAction(this._view, actionId, argument);
        }
    }

    void doDefaultActionHexEditLine() {
        if (this._view.window() != null && this._view.documentPosition().element() != null) {
            CommandLine commandLine = (CommandLine)this._view.window().commandLine();
            commandLine.setForceVisible(true);
            commandLine.setMode(6);
            this._view.window().commandLineRequestFocus();
        }
    }

    void doDefaultActionVisualEditLine() {
        if (this._view.window() != null && this._view.documentPosition().element() != null && (this._view.document()._sourceHebrew || this._view.document()._sourceArabic)) {
            if (VisualEditLineDialogParameter.getParameter().currentValue(this._view)) {
                CommandLine commandLine = (CommandLine)this._view.window().commandLine();
                commandLine.setForceVisible(true);
                commandLine.setMode(7);
                this._view.window().commandLineRequestFocus();
            } else {
                this._view.window().getVisualElement().display();
            }
        }
    }

    void doDefaultActionPopupAtCursor() {
        Menu menu;
        if (this._view.window() != null && (menu = ((TextWindow)this._view.window().textWindow()).getPopupMenu()) != null) {
            Point cursor = this._view.window().textWindow().toDisplay(new Point(this._view.screen().cursorX(), this._view.screen().cursorY()));
            menu.setLocation(cursor.x, cursor.y);
            menu.setVisible(true);
        }
    }

    void doDefaultActionPopupAtMouse() {
        Menu menu;
        if (this._view.window() != null && (menu = ((TextWindow)this._view.window().textWindow()).getPopupMenu()) != null) {
            Point mouse = this._view.window().getDisplay().getCursorLocation();
            menu.setLocation(mouse.x, mouse.y);
            menu.setVisible(true);
        }
    }

    void doDefaultActionPreferences() {
        if (this._view.window() != null) {
            boolean success = false;
            try {
                success = Utilities.doDefaultActionPreferences(this._view.lpexView());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!success) {
                this._view.setLpexMessageText("action.notAvailable", "preferences");
            }
        }
    }

    void setDocumentPositionToMouse(boolean click) {
        Point point = this.currentMousePoint();
        this._view.documentPosition().setPosition(point.x, point.y, click);
    }

    boolean mouseInTopExpandHideHeader() {
        Point point = this.currentMousePoint();
        return this._view.screen().inTopExpandHideHeader(point.x, point.y);
    }

    LpexAction defineAction(String actionString, LpexAction lpexAction) {
        if (actionString == null) {
            throw new IllegalArgumentException("actionName == null");
        }
        LpexAction oldLpexAction = null;
        Action action = this._actionList.find(actionString);
        if (action != null) {
            oldLpexAction = action.lpexAction();
            this._textAreaKeyActionList.actionRemoved(action.id());
            this._prefixAreaKeyActionList.actionRemoved(action.id());
            this._commandLineKeyActionList.actionRemoved(action.id());
            this._textAreaMouseActionList.actionRemoved(action.id());
            this._prefixAreaMouseActionList.actionRemoved(action.id());
            this._expandHideAreaMouseActionList.actionRemoved(action.id());
            this._actionList.remove(action);
        }
        if (lpexAction != null) {
            int actionId = ActionUtilities.defaultActionId(actionString);
            if (actionId == 0) {
                actionId = this._availableActionId++;
            }
            action = new Action(actionId, actionString, lpexAction);
            this._actionList.addAfter(null, action);
        }
        return oldLpexAction;
    }

    LpexAction defineAction(String actionString, String className) {
        if (actionString == null) {
            throw new IllegalArgumentException("actionName == null");
        }
        LpexAction lpexAction = null;
        if (className != null && className.length() > 0) {
            Class<?> actionClass = null;
            try {
                actionClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (actionClass == null) {
                actionClass = ClassLoaderList.loadClass(className, this._view);
            }
            if (actionClass == null) {
                this._view.setLpexMessageText("class.notFound", className);
                return null;
            }
            if (!LpexAction.class.isAssignableFrom(actionClass)) {
                this._view.setLpexMessageText("class.invalid", className, "LpexAction");
                return null;
            }
            try {
                Constructor<?> actionConstructor = actionClass.getConstructor(null);
                lpexAction = (LpexAction)actionConstructor.newInstance(null);
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                return null;
            }
            catch (Exception e) {
                this._view.setLpexMessageText("class.invalid", className, "LpexAction");
                return null;
            }
        }
        return this.defineAction(actionString, lpexAction);
    }

    LpexAction action(String actionString) {
        Action action = this._actionList.find(actionString);
        return action != null ? action.lpexAction() : null;
    }

    String actions() {
        this._actionList.sort();
        StringBuilder actions = new StringBuilder(320);
        Action action = (Action)this._actionList.first();
        while (action != null) {
            if (actions.length() != 0) {
                actions.append(' ');
            }
            actions.append(action.actionString());
            action = (Action)action.next();
        }
        return actions.toString();
    }

    String actionClass(String actionString) {
        Action action = this._actionList.find(actionString);
        return action != null ? action.lpexAction().getClass().getName() : null;
    }

    boolean populatePopupMenu(Menu popupMenu, String menuDefinition) {
        return this.populateSubmenu(popupMenu, new LpexStringTokenizer(menuDefinition));
    }

    boolean populateSubmenu(Menu menu, LpexStringTokenizer st) {
        boolean prevSeparator = true;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("MARK-")) continue;
            if (token.equalsIgnoreCase("endSubmenu")) {
                return true;
            }
            if (token.equalsIgnoreCase("beginSubmenu")) {
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    Menu submenu = new Menu(menu);
                    MenuItem submenuLabel = new MenuItem(menu, 64);
                    this.setMenuItemResources(submenuLabel, token, -1);
                    submenuLabel.setMenu(submenu);
                    if (token.equalsIgnoreCase("popup.compareMenu")) {
                        menu.setDefaultItem(submenuLabel);
                    }
                    if (!this.populateSubmenu(submenu, st)) {
                        return false;
                    }
                }
                prevSeparator = false;
                continue;
            }
            if (token.equalsIgnoreCase("separator")) {
                if (prevSeparator) continue;
                new MenuItem(menu, 2);
                prevSeparator = true;
                continue;
            }
            if (!st.hasMoreTokens()) continue;
            String actionName = st.nextToken();
            int actionId = this.id(actionName);
            if (actionId == 0) {
                this._view.setLpexMessageText("action.invalid", actionName);
                return false;
            }
            boolean checkable = this.actionCheckable(actionId);
            MenuItem menuItem = new MenuItem(menu, checkable ? 32 : 0);
            this.setMenuItemResources(menuItem, token, actionId);
            menuItem.setData((Object)actionName);
            menuItem.addSelectionListener((SelectionListener)this);
            menuItem.setEnabled(this.actionAvailable(actionId));
            if (checkable) {
                menuItem.setSelection(this.actionChecked(actionId));
            }
            Object contextHelpId = null;
            LpexAction lpexAction = this.action(actionName);
            if (lpexAction != null && lpexAction instanceof LpexBaseAction) {
                contextHelpId = ((LpexBaseAction)lpexAction).getHelpId(this._view.lpexView());
            }
            if (contextHelpId == null) {
                contextHelpId = "com.ibm.lpex." + token.replace('.', '_') + "_context";
            }
            LpexUtilities.setHelp(menuItem, contextHelpId);
            prevSeparator = false;
        }
        return true;
    }

    private void setMenuItemResources(MenuItem menuItem, String token, int actionId) {
        Object primaryKey;
        Object label;
        if (LpexStringTokenizer.isValidQuotedString(token)) {
            label = LpexStringTokenizer.removeQuotes(token);
        } else {
            label = LpexResources.message(token);
            if (label == null) {
                label = token;
            }
        }
        if (actionId != -1 && actionId != 146 && (primaryKey = this.keyText(actionId)) != null) {
            int ampIndex = ((String)primaryKey).indexOf(38);
            if (ampIndex >= 0) {
                primaryKey = ((String)primaryKey).substring(0, ampIndex) + "&" + ((String)primaryKey).substring(ampIndex);
            }
            label = (String)label + "\t" + (String)primaryKey;
        }
        menuItem.setText((String)label);
    }

    public void widgetSelected(SelectionEvent e) {
        String action = (String)e.widget.getData();
        int actionId = this.id(action);
        if (actionId != 0) {
            this.triggerAction(actionId);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    String argument() {
        return this._argument;
    }

    void setArgument(String argument) {
        if (this._userActionId != 186 && this._userActionId != 30) {
            this._argument = argument;
            this._settingArgument = false;
        }
    }

    void doDefaultActionAppendToActionArgument() {
        if (this._currentKey != null && this._currentKey.keyChar() != '\u0000') {
            this.appendToArgument(this._currentKey.keyChar());
        }
    }

    void doDefaultActionSetActionArgument() {
        if (this._argument == null || this._argument.length() == 0) {
            this._argument = "";
            this._settingArgument = true;
        } else {
            int i = 0;
            while (i < this._argument.length()) {
                if (this._argument.charAt(i) != '*') {
                    this._settingArgument = false;
                    break;
                }
                ++i;
            }
        }
        if (this._settingArgument) {
            this._argument = String.valueOf(this._argument) + "*";
        }
    }

    private void appendToArgument(char c) {
        if (this._argument == null) {
            this._argument = "";
        }
        this._argument = String.valueOf(this._argument) + c;
    }

    private boolean validArgumentCharacter(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        if (c == '-') {
            if (this._argument == null || this._argument.length() == 0) {
                return true;
            }
            int i = 0;
            while (i < this._argument.length()) {
                if (this._argument.charAt(i) != '*') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    int repeat() {
        int repeat = 1;
        if (this._argument != null && this._argument.length() > 0) {
            int i = 0;
            while (i < this._argument.length() && this._argument.charAt(i) == '*') {
                if (repeat < 10000) {
                    repeat *= 4;
                }
                ++i;
            }
            if (i < this._argument.length()) {
                repeat = 0;
                boolean negative = false;
                if (this._argument.charAt(i) == '-') {
                    negative = true;
                    ++i;
                }
                while (i < this._argument.length()) {
                    char c = this._argument.charAt(i);
                    if (c >= '0' && c <= '9') {
                        if (repeat < 10000) {
                            repeat = repeat * 10 + (c - 48);
                        }
                    } else if (c == '-') {
                        negative = true;
                    }
                    ++i;
                }
                if (negative) {
                    repeat = repeat == 0 ? -1 : -repeat;
                }
            }
        }
        return repeat;
    }

    int lastKeyActionId() {
        return this._lastKeyActionId;
    }

    int userActionId() {
        return this._userActionId;
    }

    int lastUserActionId() {
        return this._lastUserActionId;
    }

    void setUserActionId(int actionId) {
        this._lastUserActionId = this._userActionId;
        this._userActionId = actionId;
    }

    static final class Action
    extends ListNode {
        private int _id;
        private String _actionString;
        private LpexAction _lpexAction;

        Action(int id, String actionString, LpexAction lpexAction) {
            this._id = id;
            this._actionString = actionString;
            this._lpexAction = lpexAction;
        }

        int id() {
            return this._id;
        }

        String actionString() {
            return this._actionString;
        }

        LpexAction lpexAction() {
            return this._lpexAction;
        }
    }

    static final class ActionList
    extends List {
        ActionList() {
        }

        Action find(int id) {
            List.Node current = this.first();
            while (current != null) {
                if (((Action)current).id() == id) {
                    return (Action)current;
                }
                current = current.next();
            }
            return null;
        }

        Action find(String actionString) {
            List.Node current = this.first();
            while (current != null) {
                if (((Action)current).actionString().equalsIgnoreCase(actionString)) {
                    return (Action)current;
                }
                current = current.next();
            }
            return null;
        }

        void sort() {
            boolean swap;
            do {
                swap = false;
                Action action = (Action)this.first();
                while (action != null) {
                    Action next = (Action)action.next();
                    if (next != null && action.actionString().compareTo(next.actionString()) > 0) {
                        this.remove(action);
                        this.addAfter(next, action);
                        action = next;
                        swap = true;
                    }
                    action = (Action)action.next();
                }
            } while (swap);
        }
    }

    private static final class Key
    extends TableNode {
        private int _keyCode;
        private char _keyChar;
        private boolean _ignoreShift;

        Key(String keyName, int keyCode, char keyChar, boolean ignoreShift) {
            super(keyName, keyCode);
            this._keyCode = keyCode;
            this._keyChar = keyChar;
            this._ignoreShift = ignoreShift;
        }

        String keyName() {
            return this.string();
        }

        int keyCode() {
            return this._keyCode;
        }

        char keyChar() {
            return this._keyChar;
        }

        boolean ignoreShift() {
            return this._ignoreShift;
        }

        public String toString() {
            return "Key {name=" + this.keyName() + "}";
        }
    }

    final class KeyActionList
    extends List {
        int _context;
        KeyAction _prefixKeyAction;

        KeyActionList(int context) {
            this._context = context;
        }

        private void defineKeyAction(int modifiers, Key key, boolean secondary, String actionString) {
            KeyAction keyAction = this.findKey(modifiers, key);
            if (keyAction != null) {
                String oldActionString = keyAction.actionString();
                this.remove(keyAction);
                if (oldActionString != null && this.findPrimaryKey(oldActionString) == null) {
                    keyAction = (KeyAction)this.first();
                    while (keyAction != null) {
                        if (keyAction.actionString() != null && keyAction.actionString().equalsIgnoreCase(oldActionString)) {
                            keyAction.setSecondary(false);
                            break;
                        }
                        keyAction = (KeyAction)keyAction.next();
                    }
                }
            }
            if (actionString != null && actionString.length() > 0) {
                if (!secondary && (keyAction = this.findPrimaryKey(actionString)) != null) {
                    keyAction.setSecondary(true);
                }
                keyAction = new KeyAction(modifiers, key, secondary, actionString);
                this.addBefore(null, keyAction);
            }
        }

        void defineKeyAction(int[] modifiersArray, Key[] keyArray, boolean secondary, String actionString) {
            this.defineKeyAction(0, modifiersArray, keyArray, secondary, actionString);
        }

        private void defineKeyAction(int level, int[] modifiersArray, Key[] keyArray, boolean secondary, String actionString) {
            if (level == keyArray.length - 1) {
                this.defineKeyAction(modifiersArray[level], keyArray[level], secondary, actionString);
            } else {
                KeyAction keyAction = this.findKey(modifiersArray[level], keyArray[level]);
                KeyActionList keyActionList = null;
                if (keyAction != null) {
                    this.remove(keyAction);
                    keyActionList = keyAction.keyActionList();
                }
                if (keyActionList == null) {
                    keyActionList = new KeyActionList(this._context);
                }
                keyActionList.defineKeyAction(level + 1, modifiersArray, keyArray, secondary, actionString);
                if (keyActionList.first() != null) {
                    keyAction = new KeyAction(modifiersArray[level], keyArray[level], keyActionList);
                    this.addBefore(null, keyAction);
                    keyActionList._prefixKeyAction = keyAction;
                }
            }
        }

        KeyAction findKey(int modifiers, Key key) {
            if (key != null) {
                KeyAction keyAction = (KeyAction)this.first();
                while (keyAction != null && !keyAction.keyEquals(modifiers, key)) {
                    keyAction = (KeyAction)keyAction.next();
                }
                if (keyAction != null) {
                    this.remove(keyAction);
                    this.addAfter(null, keyAction);
                }
                return keyAction;
            }
            return null;
        }

        KeyAction findKey(int[] modifiersArray, Key[] keyArray) {
            return this.findKey(0, modifiersArray, keyArray);
        }

        private KeyAction findKey(int level, int[] modifiersArray, Key[] keyArray) {
            KeyAction keyAction = this.findKey(modifiersArray[level], keyArray[level]);
            if (level == keyArray.length - 1) {
                return keyAction;
            }
            if (keyAction != null && keyAction.keyActionList() != null) {
                return keyAction.keyActionList().findKey(level + 1, modifiersArray, keyArray);
            }
            return null;
        }

        KeyAction findPrimaryKey(int actionId) {
            KeyAction keyAction = (KeyAction)this.first();
            while (keyAction != null) {
                if (keyAction.keyActionList() != null) {
                    KeyAction primaryKeyAction = keyAction.keyActionList().findPrimaryKey(actionId);
                    if (primaryKeyAction != null) {
                        return primaryKeyAction;
                    }
                } else if (keyAction.primaryKey(actionId)) {
                    return keyAction;
                }
                keyAction = (KeyAction)keyAction.next();
            }
            return null;
        }

        KeyAction findPrimaryKey(String actionString) {
            KeyAction keyAction;
            int actionId = ActionUtilities.defaultActionId(actionString);
            if (actionId != 0) {
                keyAction = this.findPrimaryKey(actionId);
            } else {
                keyAction = (KeyAction)this.first();
                while (keyAction != null && !keyAction.primaryKey(actionString)) {
                    keyAction = (KeyAction)keyAction.next();
                }
            }
            return keyAction;
        }

        void actionRemoved(int actionId) {
            if (actionId >= 300) {
                KeyAction keyAction = (KeyAction)this.first();
                while (keyAction != null) {
                    if (keyAction.actionId() == actionId) {
                        keyAction.resetActionId();
                    }
                    keyAction = (KeyAction)keyAction.next();
                }
            }
        }

        void sort() {
            boolean swap;
            do {
                swap = false;
                KeyAction keyAction = (KeyAction)this.first();
                while (keyAction != null) {
                    KeyAction next = (KeyAction)keyAction.next();
                    if (next != null && keyAction.keyString().compareTo(next.keyString()) > 0) {
                        this.remove(keyAction);
                        this.addAfter(next, keyAction);
                        keyAction = next;
                        swap = true;
                    }
                    keyAction = (KeyAction)keyAction.next();
                }
            } while (swap);
        }

        String keys(int estimatedLength) {
            this.sort();
            StringBuilder keys = new StringBuilder(estimatedLength);
            KeyAction keyAction = (KeyAction)this.first();
            while (keyAction != null) {
                if (keys.length() != 0) {
                    keys.append(' ');
                }
                if (keyAction.keyActionList() != null) {
                    keys.append(keyAction.keyActionList().keys(600));
                } else {
                    keys.append(keyAction.keyString());
                }
                keyAction = (KeyAction)keyAction.next();
            }
            return keys.toString();
        }

        final class KeyAction
        extends ListNode {
            private int _modifiers;
            private Key _key;
            private boolean _secondary;
            private String _actionString;
            private int _actionId;
            private KeyActionList _keyActionList;

            KeyAction(int modifiers, Key key, boolean secondary, String actionString) {
                if (key.ignoreShift()) {
                    modifiers &= 0xFFFDFFFF;
                }
                this._modifiers = modifiers;
                this._key = key;
                this._secondary = secondary;
                this._actionString = actionString;
                this._actionId = 0;
            }

            KeyAction(int modifiers, Key key, KeyActionList keyActionList2) {
                if (key.ignoreShift()) {
                    modifiers &= 0xFFFDFFFF;
                }
                this._modifiers = modifiers;
                this._key = key;
                this._keyActionList = keyActionList2;
                this._actionId = 0;
            }

            int actionId() {
                if (this._actionId == 0) {
                    this._actionId = ActionHandler.this.id(this._actionString);
                }
                return this._actionId;
            }

            int modifiers() {
                return this._modifiers;
            }

            Key key() {
                return this._key;
            }

            String actionString() {
                return this._actionString;
            }

            String keyString() {
                StringBuilder keyString = new StringBuilder(32);
                if ((this._modifiers & KEY_MOD_R) != 0) {
                    keyString.append("r-");
                }
                if ((this._modifiers & KEY_MOD_C) != 0) {
                    keyString.append("c-");
                }
                if ((this._modifiers & KEY_MOD_A) != 0) {
                    keyString.append("a-");
                }
                if ((this._modifiers & KEY_MOD_S) != 0) {
                    keyString.append("s-");
                }
                keyString.append(this._key.keyName());
                if (this._keyActionList == null) {
                    if ((KeyActionList.this._context & 1) != 0) {
                        keyString.append(".t");
                    }
                    if ((KeyActionList.this._context & 2) != 0) {
                        keyString.append(".p");
                    }
                    if ((KeyActionList.this._context & 4) != 0) {
                        keyString.append(".c");
                    }
                    if (this._secondary) {
                        keyString.append(".secondary");
                    }
                }
                Object prefixKeyString = "";
                KeyAction prefixKeyAction = this.prefixKeyAction();
                while (prefixKeyAction != null) {
                    prefixKeyString = prefixKeyAction.keyString() + "," + (String)prefixKeyString;
                    prefixKeyAction = prefixKeyAction.prefixKeyAction();
                }
                return (String)prefixKeyString + keyString.toString();
            }

            boolean secondary() {
                return this._secondary;
            }

            void setSecondary(boolean secondary) {
                this._secondary = secondary;
            }

            boolean keyEquals(int modifiers, Key key) {
                if (key.ignoreShift()) {
                    modifiers &= 0xFFFDFFFF;
                }
                return this._modifiers == modifiers && this._key == key;
            }

            boolean primaryKey(int actionId) {
                return !this._secondary && actionId == this.actionId();
            }

            boolean primaryKey(String actionString) {
                return !this._secondary && actionString.equalsIgnoreCase(this._actionString);
            }

            void resetActionId() {
                this._actionId = 0;
            }

            KeyActionList keyActionList() {
                return this._keyActionList;
            }

            KeyAction prefixKeyAction() {
                return KeyActionList.this._prefixKeyAction;
            }
        }
    }

    final class MouseActionList
    extends List {
        int _context;

        MouseActionList(int context) {
            this._context = context;
        }

        void defineMouseAction(int modifiers, int eventId, int clickCount, String actionString) {
            MouseAction mouseAction = this.findMouseEvent(modifiers, eventId, clickCount);
            if (mouseAction != null) {
                this.remove(mouseAction);
            }
            if (actionString != null && actionString.length() > 0) {
                mouseAction = new MouseAction(modifiers, eventId, clickCount, actionString);
                this.addBefore(null, mouseAction);
            }
        }

        MouseAction findMouseEvent(int modifiers, int eventId, int clickCount) {
            MouseAction mouseAction = (MouseAction)this.first();
            while (mouseAction != null && !mouseAction.mouseEventEquals(modifiers, eventId, clickCount)) {
                mouseAction = (MouseAction)mouseAction.next();
            }
            if (mouseAction != null) {
                this.remove(mouseAction);
                this.addAfter(null, mouseAction);
            }
            return mouseAction;
        }

        void actionRemoved(int actionId) {
            if (actionId >= 300) {
                MouseAction mouseAction = (MouseAction)this.first();
                while (mouseAction != null) {
                    if (mouseAction.actionId() == actionId) {
                        mouseAction.resetActionId();
                    }
                    mouseAction = (MouseAction)mouseAction.next();
                }
            }
        }

        void sort() {
            boolean swap;
            do {
                swap = false;
                MouseAction mouseAction = (MouseAction)this.first();
                while (mouseAction != null) {
                    MouseAction next = (MouseAction)mouseAction.next();
                    if (next != null && mouseAction.event().compareTo(next.event()) > 0) {
                        this.remove(mouseAction);
                        this.addAfter(next, mouseAction);
                        mouseAction = next;
                        swap = true;
                    }
                    mouseAction = (MouseAction)mouseAction.next();
                }
            } while (swap);
        }

        String mouseEvents() {
            this.sort();
            StringBuilder mouseEvents = new StringBuilder(464);
            MouseAction mouseAction = (MouseAction)this.first();
            while (mouseAction != null) {
                if (mouseEvents.length() != 0) {
                    mouseEvents.append(' ');
                }
                mouseEvents.append(mouseAction.event());
                mouseAction = (MouseAction)mouseAction.next();
            }
            return mouseEvents.toString();
        }

        final class MouseAction
        extends ListNode {
            private int _modifiers;
            private int _eventId;
            private int _clickCount;
            private String _actionString;
            private int _actionId;

            MouseAction(int modifiers, int eventId, int clickCount, String actionString) {
                this._modifiers = modifiers;
                this._eventId = eventId;
                this._clickCount = clickCount;
                if (this._eventId == 6) {
                    this._modifiers = 0;
                    this._clickCount = 0;
                }
                this._actionString = actionString;
                this._actionId = 0;
            }

            int actionId() {
                if (this._actionId == 0) {
                    this._actionId = ActionHandler.this.id(this._actionString);
                }
                return this._actionId;
            }

            int modifiers() {
                return this._modifiers;
            }

            int eventId() {
                return this._eventId;
            }

            int clickCount() {
                return this._clickCount;
            }

            String actionString() {
                return this._actionString;
            }

            String event() {
                TableNode tableNode;
                StringBuilder event = new StringBuilder(28);
                if ((this._modifiers & KEY_MOD_R) != 0) {
                    event.append("r-");
                }
                if ((this._modifiers & KEY_MOD_C) != 0) {
                    event.append("c-");
                }
                if ((this._modifiers & KEY_MOD_A) != 0) {
                    event.append("a-");
                }
                if ((this._modifiers & KEY_MOD_S) != 0) {
                    event.append("s-");
                }
                if ((this._modifiers & 0x80000) != 0) {
                    event.append("1-");
                }
                if ((this._modifiers & 0x100000) != 0) {
                    event.append("2-");
                }
                if ((this._modifiers & 0x200000) != 0) {
                    event.append("3-");
                }
                event.append((tableNode = TableNode.sequentialSearch(_mouseEvents, this._eventId)) != null ? tableNode.string() : "???");
                if (this._clickCount > 0) {
                    event.append('.').append(this._clickCount);
                }
                if ((MouseActionList.this._context & 1) != 0) {
                    event.append(".t");
                }
                if ((MouseActionList.this._context & 2) != 0) {
                    event.append(".p");
                }
                if ((MouseActionList.this._context & 8) != 0) {
                    event.append(".e");
                }
                return event.toString();
            }

            boolean mouseEventEquals(int modifiers, int eventId, int clickCount) {
                if (eventId == 6 && this._eventId == 6) {
                    return true;
                }
                return this._modifiers == modifiers && this._eventId == eventId && this._clickCount == clickCount;
            }

            void resetActionId() {
                this._actionId = 0;
            }
        }
    }
}

