/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.cc1;

import com.ibm.lpex.cc1.LpexCalcParserConstants;
import com.ibm.lpex.cc1.LpexCalcParserTokenManager;
import com.ibm.lpex.cc1.ParseException;
import com.ibm.lpex.cc1.SimpleCharStream;
import com.ibm.lpex.cc1.Token;
import com.ibm.lpex.cc1.TokenMgrError;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.NumberFormat;
import java.util.Stack;
import java.util.Vector;

public class LpexCalcParser
implements LpexCalcParserConstants {
    private Stack<Double> _stack = new Stack();
    private NumberFormat _numberFormat = NumberFormat.getNumberInstance();
    private static final int FUNCTION_COS = 1;
    private static final int FUNCTION_MAX = 2;
    private static final int FUNCTION_MIN = 3;
    private static final int FUNCTION_RANDOM = 4;
    private static final int FUNCTION_SIN = 5;
    private static final int FUNCTION_SQRT = 6;
    private static final int FUNCTION_TAN = 7;
    private static final FunctionNode[] _functions = new FunctionNode[]{new FunctionNode("cos", 1, 1), new FunctionNode("max", 2, -1), new FunctionNode("min", 3, -1), new FunctionNode("random", 4, 0), new FunctionNode("root", 6, 1), new FunctionNode("sin", 5, 1), new FunctionNode("sqrt", 6, 1), new FunctionNode("tan", 7, 1)};
    public LpexCalcParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[1];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector<int[]> jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    static {
        LpexCalcParser.jj_la1_0();
    }

    public static boolean doCalcCommand(LpexView lpexView, String calculation) {
        boolean rc = false;
        Object message = null;
        if (calculation == null) {
            calculation = "";
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (StringReader stringReader = new StringReader(calculation + "\n");){
            LpexCalcParser parser = new LpexCalcParser(stringReader);
            try {
                switch (parser.calculation()) {
                    case -1: 
                    case 0: {
                        break;
                    }
                    case 1: {
                        message = calculation + " = " + parser.getResult(lpexView);
                    }
                }
                rc = true;
            }
            catch (TokenMgrError x) {
                int pos = parser.token_source.getStream().getEndColumn();
                message = parser.getError(pos, calculation);
            }
            catch (FunctionArgumentsException x) {
                message = LpexResources.message("command.invalidFunction", x.function() + "()", "calc");
            }
            catch (FunctionException x) {
                message = LpexResources.message("command.invalidParameter", x.function() + "()", "calc");
            }
            catch (ParseException x) {
                int pos = parser.token_source.getStream().getEndColumn();
                message = parser.getError(pos, calculation);
            }
            parser.token_source.getStream().Done();
            parser._stack.removeAllElements();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (message != null && lpexView != null) {
            lpexView.doCommand("set messageText " + (String)message);
        }
        return rc;
    }

    private String getError(int lastPosition, String calculation) {
        if (lastPosition == 0) {
            return LpexResources.message("command.invalidParameter", String.valueOf(calculation.charAt(0)), "calc");
        }
        int trimmedLength = calculation.length();
        int i = trimmedLength - 1;
        while (i >= 0 && calculation.charAt(i) == ' ') {
            --trimmedLength;
            --i;
        }
        if (lastPosition > trimmedLength) {
            return LpexResources.message("command.incomplete", "calc");
        }
        return LpexResources.message("command.invalidParameter", calculation.substring(lastPosition - 1).trim(), "calc");
    }

    private String getResult(LpexView lpexView) {
        StringBuilder result = new StringBuilder();
        double d = this.pop();
        if (lpexView != null && lpexView.queryOn("userParameter.calc.formatResult")) {
            result.append(this._numberFormat.format(d));
        } else {
            result.append(d);
        }
        long l = (long)d;
        if (d == (double)l) {
            result.append(" [0x");
            int i = (int)l;
            if (l == (long)i) {
                String intHex = Integer.toHexString(i).toUpperCase();
                if (intHex.length() == 1) {
                    result.append('0');
                }
                result.append(intHex);
            } else {
                result.append(Long.toHexString(l).toUpperCase());
            }
            result.append("]");
        }
        return result.toString();
    }

    private void push(double x) {
        this._stack.push(x);
    }

    private double pop() {
        return this._stack.pop();
    }

    static int verifyFunction(String function, int parmsCount) throws FunctionException {
        FunctionNode functionNode = FunctionNode.search(_functions, function.toLowerCase());
        if (functionNode == null) {
            throw new FunctionException(function);
        }
        if (functionNode._parmsCount != -1 && functionNode._parmsCount != parmsCount) {
            throw new FunctionArgumentsException(function);
        }
        return functionNode._id;
    }

    public final int calculation() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 20: 
            case 23: 
            case 25: {
                this.logical();
                this.jj_consume_token(4);
                return 1;
            }
            case 4: {
                this.jj_consume_token(4);
                return 0;
            }
            case 0: {
                this.jj_consume_token(0);
                return -1;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void logical() throws ParseException {
        this.sum();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11: 
                case 12: 
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block13;
                }
            }
            Token x = switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 11 -> this.jj_consume_token(11);
                case 12 -> this.jj_consume_token(12);
                case 13 -> this.jj_consume_token(13);
                default -> {
                    this.jj_la1[2] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            };
            this.sum();
            long a = (long)this.pop();
            long b = (long)this.pop();
            switch (x.kind) {
                case 11: {
                    this.push(a & b);
                    break;
                }
                case 12: {
                    this.push(a | b);
                    break;
                }
                case 13: {
                    this.push(a ^ b);
                }
            }
        }
    }

    public final void sum() throws ParseException {
        this.term();
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block7;
                }
            }
            Token x = switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5 -> this.jj_consume_token(5);
                case 6 -> this.jj_consume_token(6);
                default -> {
                    this.jj_la1[4] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            };
            this.term();
            double a = this.pop();
            double b = this.pop();
            if (x.kind == 5) {
                this.push(b + a);
                continue;
            }
            this.push(b - a);
        }
    }

    public final void term() throws ParseException {
        this.power();
        block13: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block13;
                }
            }
            Token x = switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 7 -> this.jj_consume_token(7);
                case 8 -> this.jj_consume_token(8);
                case 10 -> this.jj_consume_token(10);
                default -> {
                    this.jj_la1[6] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            };
            this.power();
            double a = this.pop();
            double b = this.pop();
            switch (x.kind) {
                case 7: {
                    this.push(b * a);
                    break;
                }
                case 8: {
                    this.push(b / a);
                    break;
                }
                case 10: {
                    this.push(b % a);
                }
            }
        }
    }

    public final void power() throws ParseException {
        this.unary();
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            this.jj_consume_token(9);
            this.power();
            double a = this.pop();
            double b = this.pop();
            this.push(Math.pow(b, a));
        }
    }

    public final void unary() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                this.element();
                long l = (long)this.pop();
                this.push(l ^ 0xFFFFFFFFFFFFFFFFL);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                this.element();
                double d = this.pop();
                this.push(-d);
                break;
            }
            case 5: 
            case 15: 
            case 20: 
            case 23: 
            case 25: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: {
                        this.jj_consume_token(5);
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                    }
                }
                this.element();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void element() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                try {
                    Number n = this._numberFormat.parse(this.token.image);
                    this.push(n.doubleValue());
                }
                catch (java.text.ParseException x) {
                    this._stack.push(Double.NaN);
                }
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                Object hex = this.token.image.toLowerCase();
                if (((String)hex).startsWith("x'")) {
                    hex = "0x" + ((String)hex).substring(2, ((String)hex).length() - 1);
                } else if (((String)hex).startsWith("x")) {
                    hex = "0" + (String)hex;
                }
                try {
                    this.push(Long.decode((String)hex).doubleValue());
                }
                catch (NumberFormatException x) {
                    this._stack.push(Double.NaN);
                }
                break;
            }
            case 23: {
                this.function();
                break;
            }
            case 25: {
                this.jj_consume_token(25);
                this.logical();
                this.jj_consume_token(26);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void function() throws ParseException {
        int parmsCount = 0;
        this.jj_consume_token(23);
        String functionName = this.token.image;
        this.jj_consume_token(25);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 14: 
            case 15: 
            case 20: 
            case 23: 
            case 25: {
                this.logical();
                ++parmsCount;
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 27: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(27);
                    this.logical();
                    ++parmsCount;
                }
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        switch (LpexCalcParser.verifyFunction(functionName, parmsCount)) {
            case 4: {
                this.push(Math.random());
                break;
            }
            case 5: {
                this.push(Math.sin(this.pop()));
                break;
            }
            case 1: {
                this.push(Math.cos(this.pop()));
                break;
            }
            case 7: {
                this.push(Math.tan(this.pop()));
                break;
            }
            case 6: {
                this.push(Math.sqrt(this.pop()));
                break;
            }
            case 3: {
                double result = -1.7976931348623157E308;
                if (parmsCount > 0) {
                    result = this.pop();
                    int i = 0;
                    while (i < parmsCount - 1) {
                        result = Math.min(result, this.pop());
                        ++i;
                    }
                }
                this.push(result);
                break;
            }
            case 2: {
                double result = Double.MAX_VALUE;
                if (parmsCount > 0) {
                    result = this.pop();
                    int i = 0;
                    while (i < parmsCount - 1) {
                        result = Math.max(result, this.pop());
                        ++i;
                    }
                }
                this.push(result);
            }
        }
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            return true;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    private final boolean jj_3_1() {
        return this.jj_scan_token(9);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{43040881, 14336, 14336, 96, 96, 1408, 1408, 32, 43040864, 43024384, 0x8000000, 43040864};
    }

    public LpexCalcParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new LpexCalcParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public LpexCalcParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new LpexCalcParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public LpexCalcParser(LpexCalcParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    public void ReInit(LpexCalcParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.jj_2_rtns.length) {
            this.jj_2_rtns[i] = new JJCalls();
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[28];
        int i = 0;
        while (i < 28) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 12) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 28) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 1) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static final class FunctionArgumentsException
    extends FunctionException {
        private static final long serialVersionUID = -1302643514617043176L;

        FunctionArgumentsException(String function) {
            super(function);
        }
    }

    static class FunctionException
    extends ParseException {
        private static final long serialVersionUID = -105570956663576967L;
        private String _function;

        FunctionException(String function) {
            this._function = function;
        }

        String function() {
            return this._function;
        }
    }

    static final class FunctionNode {
        String _functionName;
        int _id;
        int _parmsCount;

        FunctionNode(String functionName, int id, int parmsCount) {
            this._functionName = functionName;
            this._id = id;
            this._parmsCount = parmsCount;
        }

        static FunctionNode search(FunctionNode[] table, String functionName) {
            int i = 0;
            while (i < table.length) {
                if (table[i]._functionName.equals(functionName)) {
                    return table[i];
                }
                ++i;
            }
            return null;
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private static final long serialVersionUID = -5934146677348573155L;

        private LookaheadSuccess() {
        }
    }
}

