/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.WhitespaceCharacterMapping;
import com.ibm.lpex.alef.preferences.WhitespaceCharacterUtil;
import com.ibm.lpex.core.LpexResources;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WhitespaceCharacterMappingDialog
extends TitleAreaDialog {
    private Combo whitespaceCombo;
    private Text whitespaceHexText;
    private Text substituteText;
    private Text substituteHexText;
    private Character originalChar = null;
    private Character substituteChar = null;
    private List<WhitespaceCharacterMapping> unexpectedMappingList = null;
    protected static final int TEXT_FIELD_WIDTH = 100;
    private int currentStatus;
    private String currentMsg;
    private boolean inEditDialog;
    private static final String OK_MSG = LpexResources.message("preferences.whitespace.dialog.description");
    private ModifyListener whitesapceComboModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Character c = WhitespaceCharacterUtil.getWhitespaceCharacterByName(WhitespaceCharacterMappingDialog.this.whitespaceCombo.getText());
            if (c != null) {
                WhitespaceCharacterMappingDialog.this.originalChar = c;
                WhitespaceCharacterMappingDialog.this.whitespaceHexText.setText(WhitespaceCharacterUtil.getCharHexValue(c.charValue()));
                WhitespaceCharacterMappingDialog.this.validatePageInput();
                WhitespaceCharacterMappingDialog.this.updateStatus();
            }
        }
    };

    public WhitespaceCharacterMappingDialog(Shell parent) {
        super(parent);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.inEditDialog) {
            this.validatePageInput();
            this.updateStatus();
            this.inEditDialog = false;
        } else {
            this.updateOKButton(false);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Utilities.setHelp((Control)parent, "whitespace_mapping_dialog");
        int nColumns = 2;
        this.initializeDialogUnits((Control)parent);
        this.setTitle(LpexResources.message("preferences.whitespace.dialog.title"));
        this.setMessage(OK_MSG, 1);
        this.getShell().setText(LpexResources.message("preferences.whitespace.dialog.shell_title"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label1 = new Label(composite, 0);
        label1.setText(LpexResources.message("preferences.mappingtable.whitespace"));
        label1.setFont(parent.getFont());
        this.whitespaceCombo = new Combo(composite, 4);
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.whitespaceCombo.setLayoutData((Object)data);
        this.whitespaceCombo.setFont(parent.getFont());
        this.whitespaceCombo.setItems(WhitespaceCharacterUtil.getWhitespaceCharacterNames());
        Label label2 = new Label(composite, 0);
        label2.setText(LpexResources.message("preferences.mappingtable.whitespaceHex"));
        label2.setFont(parent.getFont());
        this.whitespaceHexText = new Text(composite, 2048);
        GridData data2 = new GridData(768);
        data2.widthHint = 100;
        this.whitespaceHexText.setLayoutData((Object)data2);
        this.whitespaceHexText.setFont(parent.getFont());
        Label label3 = new Label(composite, 0);
        label3.setText(LpexResources.message("preferences.mappingtable.substituteChar"));
        label3.setFont(parent.getFont());
        this.substituteText = new Text(composite, 2048);
        GridData data3 = new GridData(768);
        data3.widthHint = 100;
        this.substituteText.setLayoutData((Object)data3);
        this.substituteText.setTextLimit(1);
        this.substituteText.setFont(parent.getFont());
        Label label4 = new Label(composite, 0);
        label4.setText(LpexResources.message("preferences.mappingtable.substituteHex"));
        label4.setFont(parent.getFont());
        this.substituteHexText = new Text(composite, 2048);
        GridData data4 = new GridData(768);
        data4.widthHint = 100;
        this.substituteHexText.setLayoutData((Object)data4);
        this.substituteHexText.setFont(parent.getFont());
        this.setupDialogFieldListener();
        this.initFields();
        return composite;
    }

    public void initFields() {
        if (this.originalChar != null) {
            this.whitespaceCombo.removeModifyListener(this.whitesapceComboModifyListener);
            this.whitespaceCombo.setText(WhitespaceCharacterUtil.getWhitespaceName(this.originalChar.charValue()));
            this.whitespaceHexText.setText(WhitespaceCharacterUtil.getCharHexValue(this.originalChar.charValue()));
            this.whitespaceCombo.addModifyListener(this.whitesapceComboModifyListener);
        }
        if (this.substituteChar != null) {
            this.substituteText.setText(String.valueOf(this.substituteChar));
            this.substituteHexText.setText(WhitespaceCharacterUtil.getCharHexValue(this.substituteChar.charValue()));
        }
    }

    public void init(WhitespaceCharacterMapping mapping) {
        this.originalChar = Character.valueOf(mapping.getOriginal());
        this.substituteChar = Character.valueOf(mapping.getSubstitute());
    }

    public void setupDialogFieldListener() {
        this.whitespaceCombo.addModifyListener(this.whitesapceComboModifyListener);
        this.whitespaceHexText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                WhitespaceCharacterMappingDialog.this.validatePageInput();
                WhitespaceCharacterMappingDialog.this.whitespaceCombo.removeModifyListener(WhitespaceCharacterMappingDialog.this.whitesapceComboModifyListener);
                String charName = WhitespaceCharacterUtil.getWhitespaceName(WhitespaceCharacterMappingDialog.this.originalChar.charValue());
                if (charName != null) {
                    WhitespaceCharacterMappingDialog.this.whitespaceCombo.setText(charName);
                }
                WhitespaceCharacterMappingDialog.this.whitespaceCombo.addModifyListener(WhitespaceCharacterMappingDialog.this.whitesapceComboModifyListener);
                WhitespaceCharacterMappingDialog.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.substituteText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String s = WhitespaceCharacterMappingDialog.this.substituteText.getText();
                if (s.length() == 1) {
                    WhitespaceCharacterMappingDialog.this.substituteChar = Character.valueOf(WhitespaceCharacterMappingDialog.this.substituteText.getText().charAt(0));
                    WhitespaceCharacterMappingDialog.this.substituteHexText.setText(WhitespaceCharacterUtil.getCharHexValue(WhitespaceCharacterMappingDialog.this.substituteChar.charValue()));
                }
                WhitespaceCharacterMappingDialog.this.validatePageInput();
                WhitespaceCharacterMappingDialog.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.substituteHexText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                WhitespaceCharacterMappingDialog.this.validatePageInput();
                WhitespaceCharacterMappingDialog.this.substituteText.setText(String.valueOf(WhitespaceCharacterMappingDialog.this.substituteChar));
                WhitespaceCharacterMappingDialog.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void validatePageInput() {
        int value;
        this.currentStatus = 0;
        String hexValue = this.whitespaceHexText.getText().trim().toUpperCase();
        if (hexValue.startsWith("0X")) {
            hexValue = hexValue.substring(2).trim();
        }
        try {
            value = Integer.parseInt(hexValue, 16);
            this.originalChar = Character.valueOf((char)value);
            String charName = WhitespaceCharacterUtil.getWhitespaceName(this.originalChar.charValue());
            if (charName == null) {
                this.currentStatus = 4;
                this.currentMsg = LpexResources.message("preferences.whitespace.dialog.whitespace.hex.unknown");
            } else {
                for (WhitespaceCharacterMapping mapping : this.unexpectedMappingList) {
                    if (mapping.getOriginal() != this.originalChar.charValue()) continue;
                    this.currentStatus = 4;
                    this.currentMsg = LpexResources.message("preferences.whitespace.dialog.whitespace_exists");
                }
            }
        }
        catch (Exception exception) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.whitespace.dialog.whitespace.hex.error");
        }
        if (this.substituteText.getText().length() < 1) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.whitespace.dialog.display.empty");
        }
        if ((hexValue = this.substituteHexText.getText().trim().toUpperCase()).startsWith("0X")) {
            hexValue = hexValue.substring(2).trim();
        }
        try {
            value = Integer.parseInt(hexValue, 16);
            this.substituteChar = Character.valueOf((char)value);
        }
        catch (Exception exception) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.whitespace.dialog.display.hex.error");
        }
    }

    protected void updateStatus() {
        switch (this.currentStatus) {
            case 0: {
                this.setMessage(OK_MSG, 1);
                this.updateOKButton(true);
                break;
            }
            case 4: {
                this.setMessage(this.currentMsg, 3);
                this.updateOKButton(false);
                break;
            }
            default: {
                this.setMessage(OK_MSG, 1);
                this.updateOKButton(true);
            }
        }
    }

    public WhitespaceCharacterMapping getWhitespaceCharacterMapping() {
        return new WhitespaceCharacterMapping(this.originalChar.charValue(), this.substituteChar.charValue());
    }

    private void updateOKButton(boolean enable) {
        Button ok_button = this.getButton(0);
        if (ok_button != null && !ok_button.isDisposed()) {
            ok_button.setEnabled(enable);
        }
    }

    public void setUnexpectedMappingList(List<WhitespaceCharacterMapping> unexpectedMappingList) {
        this.unexpectedMappingList = unexpectedMappingList;
    }

    protected void setInEditDialog(boolean inEditDialog) {
        this.inEditDialog = true;
    }
}

