/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexTableItem;
import com.ibm.lpex.alef.preferences.TablePreferencePage;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class UserKeyActionsPreferencePage
extends TablePreferencePage {
    private static final String[] _valueTableNames = new String[]{LpexResources.message("preferences.userKeyActionsTableKey"), LpexResources.message("preferences.userKeyActionsTableAction")};
    private static final String[] _valueNames = new String[]{LpexResources.message("preferences.userKeyActionsKey"), LpexResources.message("preferences.userKeyActionsAction")};
    private static final int[] _valueWeights = new int[]{50, 50};

    public UserKeyActionsPreferencePage() {
        super(true, true);
    }

    @Override
    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "userKeyActions_page");
        return super.createContents(parent);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setValue2Options();
        }
    }

    @Override
    protected String[] getValueTableNames() {
        return _valueTableNames;
    }

    @Override
    protected String[] getValueNames() {
        return _valueNames;
    }

    @Override
    protected int[] getValueWeights() {
        return _valueWeights;
    }

    @Override
    protected String[] getValue2Options() {
        String editorActions = LpexView.globalQuery("defaultActions");
        String userActions = LpexView.globalQuery("current.updateProfile.userActions");
        boolean anyUserActions = userActions != null;
        StringBuilder actions = new StringBuilder(editorActions.length() + (anyUserActions ? userActions.length() : 0));
        actions.append(editorActions);
        if (anyUserActions) {
            LpexStringTokenizer st = new LpexStringTokenizer(userActions);
            while (st.hasMoreTokens()) {
                actions.append(' ').append(st.nextToken());
                if (!st.hasMoreTokens()) continue;
                st.nextToken();
            }
        }
        Object[] actionsList = actions.toString().split(" ");
        if (anyUserActions) {
            Arrays.sort(actionsList);
        }
        return actionsList;
    }

    @Override
    protected void value1Modified() {
        super.value1Modified();
        String newKeyDefinition = this.value1TextField().getText();
        String newKeyText = LpexView.keyText(newKeyDefinition.trim());
        if (newKeyText == null) {
            this.value1Info().setText("");
        } else {
            this.value1Info().setText(newKeyText);
            int selection = this.value1TextField().getSelection().x;
            int count1 = 1;
            int i = 0;
            while (i < selection) {
                if (newKeyDefinition.charAt(i) == ',') {
                    ++count1;
                }
                ++i;
            }
            int count2 = 0;
            int i2 = 0;
            while (i2 < newKeyText.length()) {
                if (newKeyText.charAt(i2) == ',') {
                    ++count2;
                }
                if (count1 <= count2) break;
                ++i2;
            }
            this.value1Info().setSelection(i2);
            this.value1Info().showSelection();
        }
    }

    @Override
    protected Vector<LpexTableItem> initialize() {
        return this.updateSettings(LpexView.globalQuery("current.updateProfile.userKeyActions"));
    }

    @Override
    protected Vector<LpexTableItem> initializeDefaults() {
        return this.updateSettings(LpexView.globalQuery("install.updateProfile.userKeyActions"));
    }

    private Vector<LpexTableItem> updateSettings(String userKeyActions) {
        Vector<LpexTableItem> items = new Vector<LpexTableItem>();
        if (userKeyActions != null) {
            StringTokenizer st = new StringTokenizer(userKeyActions);
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                items.addElement(new LpexTableItem(key, st.nextToken()));
            }
        }
        return items;
    }

    public boolean performOk() {
        Vector<LpexTableItem> items = this.getItems();
        StringBuilder newUserKeyActions = new StringBuilder();
        int i = 0;
        while (i < items.size()) {
            LpexTableItem pi = items.elementAt(i);
            if (newUserKeyActions.length() != 0) {
                newUserKeyActions.append(' ');
            }
            newUserKeyActions.append(pi.value1());
            newUserKeyActions.append(' ');
            newUserKeyActions.append(pi.value2());
            ++i;
        }
        if (LpexFieldEditorPreferencePage.updateDefaultValue("updateProfile.userKeyActions", newUserKeyActions.toString())) {
            LpexView.doGlobalCommand("updateProfile all");
        }
        return true;
    }
}

