/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexStringFieldEditor;
import com.ibm.lpex.alef.preferences.TabIncrementFieldEditor;
import com.ibm.lpex.alef.preferences.TabStopsFieldEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class TabsPreferencePage
extends LpexFieldEditorPreferencePage {
    private String _initialTabs;
    private String _initialExpandTabs;
    private LpexStringFieldEditor _tabStopsTextField;
    private LpexStringFieldEditor _tabIncrementTextField;
    private LpexBooleanFieldEditor _expandTabsCheckBox;

    public TabsPreferencePage() {
        super(LpexResources.message("preferences.tabsTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "tabs_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this._tabStopsTextField = new TabStopsFieldEditor(parent, "preferences.tabsTabStops");
        this._tabIncrementTextField = new TabIncrementFieldEditor(parent, "preferences.tabsTabIncrement");
        new Label(parent, 0);
        new Label(parent, 0);
        this._expandTabsCheckBox = new LpexBooleanFieldEditor(parent, "preferences.tabsExpandTabs");
        this.addField((FieldEditor)this._tabStopsTextField);
        this.addField((FieldEditor)this._tabIncrementTextField);
        this.addField((FieldEditor)this._expandTabsCheckBox);
        this._initialTabs = TabsPreferencePage.getDefaultValue("tabs");
        this._initialExpandTabs = TabsPreferencePage.getDefaultValue("expandTabs");
        this.updateSettings(this._initialTabs, this._initialExpandTabs);
    }

    public boolean performOk() {
        boolean update = TabsPreferencePage.updateDefaultValue("tabs", this.tabs());
        if (update |= TabsPreferencePage.updateDefaultValue("expandTabs", this._expandTabsCheckBox.getOnOffValue())) {
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        String tabs = LpexView.globalQuery("install.tabs");
        String expandTabs = LpexView.globalQuery("install.expandTabs");
        this.updateSettings(tabs, expandTabs);
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialTabs, this._initialExpandTabs);
    }

    private void updateSettings(String tabs, String expandTabs) {
        String tabStops = "";
        String tabIncrement = "";
        if (tabs != null) {
            int indexOfEvery = tabs.indexOf("every");
            if (indexOfEvery != -1) {
                tabIncrement = tabs.substring(indexOfEvery + 5).trim();
                tabStops = tabs.substring(0, indexOfEvery).trim();
            } else {
                tabStops = tabs.trim();
            }
        }
        this._tabStopsTextField.setStringValue(tabStops);
        this._tabIncrementTextField.setStringValue(tabIncrement);
        this._expandTabsCheckBox.setSelected("on".equals(expandTabs));
    }

    private String tabs() {
        String tabIncrement;
        Object tabStops = this._tabStopsTextField.getStringValue().trim();
        if (((String)tabStops).length() == 0) {
            tabStops = "1";
        }
        if ((tabIncrement = this._tabIncrementTextField.getStringValue().trim()).length() > 0) {
            tabStops = (String)tabStops + " every " + tabIncrement;
        }
        return tabStops;
    }
}

