/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexTableItem;
import com.ibm.lpex.alef.preferences.TablePreferencePage;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ParsersPreferencePage
extends TablePreferencePage {
    private static final String[] _valueTableNames = new String[]{LpexResources.message("preferences.parsersTableName"), LpexResources.message("preferences.parsersTableClassName")};
    private static final String[] _valueNames = new String[]{LpexResources.message("preferences.parsersName"), LpexResources.message("preferences.parsersClassName")};
    private static final int[] _valueWeights = new int[]{30, 70};
    private static String _lastParserSelected;
    private String _value1errorMsg;
    private String _value2errorMsg;

    @Override
    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "parsers_page");
        return super.createContents(parent);
    }

    public static void setLastParserSelected(String parser) {
        _lastParserSelected = parser;
    }

    static String getLastParserSelected() {
        if (_lastParserSelected == null) {
            LpexView lpexView;
            IEditorPart editor;
            IWorkbenchPage page;
            IWorkbenchWindow window = null;
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                window = workbench != null ? workbench.getActiveWorkbenchWindow() : null;
            }
            catch (Throwable workbench) {
                // empty catch block
            }
            if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) instanceof LpexAbstractTextEditor && (lpexView = ((LpexAbstractTextEditor)editor).getLpexView()) != null) {
                _lastParserSelected = lpexView.query("parser");
            }
        }
        return _lastParserSelected;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.selectItem(ParsersPreferencePage.getLastParserSelected());
        }
    }

    public void dispose() {
        ParsersPreferencePage.setLastParserSelected(null);
    }

    @Override
    protected String[] getValueTableNames() {
        return _valueTableNames;
    }

    @Override
    protected String[] getValueNames() {
        return _valueNames;
    }

    @Override
    protected int[] getValueWeights() {
        return _valueWeights;
    }

    @Override
    protected Vector<LpexTableItem> initialize() {
        Vector<LpexTableItem> items = new Vector<LpexTableItem>();
        StringTokenizer st = new StringTokenizer(LpexView.globalQuery("current.updateProfile.parsers"));
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            String className = LpexView.globalQuery("current.updateProfile.parserClass." + name);
            if (className == null || className.length() <= 0) continue;
            items.addElement(new LpexTableItem(name, className));
        }
        return items;
    }

    @Override
    protected Vector<LpexTableItem> initializeDefaults() {
        Vector<LpexTableItem> items = new Vector<LpexTableItem>();
        StringTokenizer st = new StringTokenizer(LpexView.globalQuery("install.updateProfile.parsers"));
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            String className = LpexView.globalQuery("install.updateProfile.parserClass." + name);
            if (className == null || className.length() <= 0) continue;
            items.addElement(new LpexTableItem(name, className));
        }
        return items;
    }

    @Override
    protected void tableSelectionModified(String newValue1, String newValue2) {
        ParsersPreferencePage.setLastParserSelected(newValue1);
    }

    public boolean performOk() {
        boolean parserChanged = false;
        Vector<LpexTableItem> items = this.getItems();
        Vector<String> names = new Vector<String>();
        StringTokenizer st = new StringTokenizer(LpexView.globalQuery("current.updateProfile.parsers"));
        while (st.hasMoreTokens()) {
            names.addElement(st.nextToken());
        }
        int i = 0;
        while (i < names.size()) {
            String name = (String)names.elementAt(i);
            boolean found = false;
            int j = 0;
            while (j < items.size()) {
                String currentName = items.elementAt(j).value1();
                if (name.equals(currentName)) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                String installSetting = LpexView.globalQuery("install.updateProfile.parserClass." + name);
                if (installSetting == null) {
                    LpexView.doGlobalCommand("set default.updateProfile.parserClass." + name + " install");
                } else {
                    LpexView.doGlobalCommand("set default.updateProfile.parserClass." + name);
                }
                parserChanged = true;
            }
            ++i;
        }
        i = 0;
        while (i < items.size()) {
            LpexTableItem pi = items.elementAt(i);
            String name = pi.value1();
            String className = pi.value2();
            if (LpexFieldEditorPreferencePage.updateDefaultValue("updateProfile.parserClass." + name, className)) {
                parserChanged = true;
            }
            ++i;
        }
        if (parserChanged) {
            LpexView.doGlobalCommand("updateProfile all");
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    @Override
    protected void doSetPressed(String name, String className) {
        if (name.length() != 0 && "install".equals(className)) {
            className = LpexView.globalQuery("install.updateProfile.parserClass." + name);
        }
        super.doSetPressed(name, className);
    }

    @Override
    protected void value1Modified() {
        String name = this.value1TextField().getText().trim();
        this._value1errorMsg = null;
        if (name.indexOf(32) >= 0) {
            this._value1errorMsg = LpexResources.message("preferences.incorrectValue", name);
        }
        String errorMsg = this._value1errorMsg != null ? this._value1errorMsg : this._value2errorMsg;
        this.setErrorMessage(errorMsg);
        this.setValid(errorMsg == null);
        super.value1Modified();
    }

    @Override
    protected void value2Modified() {
        this._value2errorMsg = LpexFieldEditorPreferencePage.validateClassName(this.getValue2());
        String errorMsg = this._value2errorMsg != null ? this._value2errorMsg : this._value1errorMsg;
        this.setErrorMessage(errorMsg);
        this.setValid(errorMsg == null);
    }
}

