/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.core.LpexResources;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

final class LpexListEditor
extends FieldEditor {
    private List _list;
    private int _itemCount;

    protected LpexListEditor(Composite parent, String labelKey, String[] values) {
        this.init("", LpexResources.message(labelKey));
        this._itemCount = values.length;
        this.createControl(parent);
        int i = 0;
        while (i < values.length) {
            this._list.add(values[i]);
            ++i;
        }
    }

    void setSelectedIndex(int index) {
        this._list.setSelection(index);
        this._list.showSelection();
    }

    int getSelectedIndex() {
        return this._list.getSelectionIndex();
    }

    void clearSelection() {
        this._list.deselectAll();
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this._list.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this._list = this.getListControl(parent);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.heightHint = this._list.getItemHeight() * Math.min(this._itemCount, 15);
        gd.horizontalSpan = numColumns;
        this._list.setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public List getListControl(Composite parent) {
        if (this._list == null) {
            this._list = new List(parent, 2564);
            this._list.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    LpexListEditor.this._list = null;
                }
            });
        } else {
            this.checkParent((Control)this._list, parent);
        }
        return this._list;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setFocus() {
        if (this._list != null) {
            this._list.setFocus();
        }
    }

    public void setEnabled(boolean enabled) {
        if (this._list != null) {
            this._list.setEnabled(enabled);
            this.getLabelControl().setEnabled(enabled);
        }
    }
}

