/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.HostCharacterMapping;
import com.ibm.lpex.alef.preferences.HostCharacterUtil;
import com.ibm.lpex.core.LpexResources;
import java.util.List;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HostCharacterMappingDialog
extends TitleAreaDialog {
    private Combo codePageCombo;
    private Text codePointFromText;
    private Text codePointToText;
    private Text codePointSingleText;
    private Button singleTypeButton;
    private Button rangeTypeButton;
    private Composite codePointRangeComp;
    private Composite codePointSingleComp;
    private Composite codePointParentComp;
    private String codePage;
    private int singleCodePoint = -1;
    private int codePointFrom = -1;
    private int codePointTo = -1;
    StackLayout stackLayout;
    private boolean isSingleType;
    private boolean inEditDialog;
    private Text substituteText;
    private Label fromLabel;
    private Label toLabel;
    private Text substituteHexText;
    private Character substituteChar = null;
    private List<HostCharacterMapping> unexpectedMappingList = null;
    protected static final int TEXT_FIELD_WIDTH = 100;
    private int currentStatus;
    private String currentMsg;
    private static final String OK_MSG = LpexResources.message("preferences.host.char.dialog.description");
    private ModifyListener codePageComboModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String page = HostCharacterMappingDialog.this.codePageCombo.getText();
            if (page != null) {
                HostCharacterMappingDialog.this.codePage = page;
                HostCharacterMappingDialog.this.validatePageInput();
                HostCharacterMappingDialog.this.updateStatus();
            }
        }
    };

    public HostCharacterMappingDialog(Shell parent) {
        super(parent);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        if (this.inEditDialog) {
            this.validatePageInput();
            this.updateStatus();
            this.inEditDialog = false;
        } else {
            this.updateOKButton(false);
        }
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.stackLayout = new StackLayout();
        Utilities.setHelp((Control)parent, "hostChar_mapping_dialog");
        int nColumns = 2;
        this.initializeDialogUnits((Control)parent);
        this.setTitle(LpexResources.message("preferences.host.char.dialog.title"));
        this.setMessage(OK_MSG, 1);
        this.getShell().setText(LpexResources.message("preferences.host.char.dialog.shell_title"));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label label1 = new Label(composite, 0);
        label1.setText(LpexResources.message("preferences.mappingtable.hostCodePage"));
        label1.setFont(parent.getFont());
        this.codePageCombo = new Combo(composite, 4);
        GridData data = new GridData(768);
        data.widthHint = 100;
        this.codePageCombo.setLayoutData((Object)data);
        this.codePageCombo.setFont(parent.getFont());
        this.codePageCombo.setItems(HostCharacterUtil.getCodePageNames());
        Label label4 = new Label(composite, 0);
        label4.setText(LpexResources.message("preferences.mappingtable.hostCodePointType"));
        label4.setFont(parent.getFont());
        Composite composite1 = new Composite(composite, 0);
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        composite1.setLayout((Layout)layout1);
        GridData data1 = new GridData(768);
        data1.widthHint = 100;
        data1.horizontalSpan = 1;
        composite1.setLayoutData((Object)data1);
        this.singleTypeButton = new Button(composite1, 16);
        this.singleTypeButton.setText(LpexResources.message("preferences.host.char.codePoint.single"));
        this.singleTypeButton.pack();
        this.rangeTypeButton = new Button(composite1, 16);
        this.rangeTypeButton.setText(LpexResources.message("preferences.host.char.codePoint.range"));
        this.rangeTypeButton.pack();
        Label label2 = new Label(composite, 0);
        label2.setText(LpexResources.message("preferences.mappingtable.hostCodePoint"));
        label2.setFont(parent.getFont());
        this.codePointParentComp = new Composite(composite, 0);
        this.codePointParentComp.setLayout((Layout)this.stackLayout);
        this.stackLayout.marginWidth = 0;
        this.codePointRangeComp = new Composite(this.codePointParentComp, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 5;
        this.codePointRangeComp.setLayout((Layout)layout2);
        GridData data222 = new GridData(768);
        data222.widthHint = 100;
        data222.horizontalSpan = 0;
        this.codePointRangeComp.setLayoutData((Object)data222);
        this.fromLabel = new Label(this.codePointRangeComp, 0);
        this.fromLabel.setText(LpexResources.message("preferences.host.char.codePoint.from"));
        this.fromLabel.setFont(parent.getFont());
        this.codePointFromText = new Text(this.codePointRangeComp, 2048);
        GridData data24 = new GridData(768);
        data24.widthHint = 100;
        this.codePointFromText.setLayoutData((Object)data24);
        this.codePointFromText.setFont(parent.getFont());
        this.toLabel = new Label(this.codePointRangeComp, 0);
        this.toLabel.setText(LpexResources.message("preferences.host.char.codePoint.to"));
        this.toLabel.setFont(parent.getFont());
        this.codePointToText = new Text(this.codePointRangeComp, 2048);
        GridData data241 = new GridData(768);
        data241.widthHint = 100;
        this.codePointToText.setLayoutData((Object)data24);
        this.codePointToText.setFont(parent.getFont());
        Label label7 = new Label(this.codePointRangeComp, 0);
        label7.setText(LpexResources.message("preferences.host.char.value.type"));
        label7.setFont(parent.getFont());
        this.codePointSingleComp = new Composite(this.codePointParentComp, 0);
        this.codePointSingleComp.setLayout((Layout)layout);
        this.codePointSingleText = new Text(this.codePointSingleComp, 2048);
        this.codePointSingleText.setLayoutData((Object)data);
        this.codePointSingleText.setFont(parent.getFont());
        Label label6 = new Label(this.codePointSingleComp, 0);
        label6.setText(LpexResources.message("preferences.host.char.value.type"));
        label6.setFont(parent.getFont());
        Label label3 = new Label(composite, 0);
        label3.setText(LpexResources.message("preferences.mappingtable.substituteChar"));
        label3.setFont(parent.getFont());
        this.substituteText = new Text(composite, 2048);
        GridData data3 = new GridData(768);
        data3.widthHint = 100;
        this.substituteText.setLayoutData((Object)data3);
        this.substituteText.setTextLimit(1);
        this.substituteText.setFont(parent.getFont());
        Label label5 = new Label(composite, 0);
        label5.setText(LpexResources.message("preferences.mappingtable.substituteHex"));
        label5.setFont(parent.getFont());
        this.substituteHexText = new Text(composite, 2048);
        GridData data4 = new GridData(768);
        data4.widthHint = 100;
        this.substituteHexText.setLayoutData((Object)data4);
        this.substituteHexText.setFont(parent.getFont());
        this.setupDialogFieldListener();
        this.singleTypeButton.setSelection(true);
        this.rangeTypeButton.setSelection(false);
        this.stackLayout.topControl = this.codePointSingleComp;
        this.codePointParentComp.layout();
        this.initFields();
        return composite;
    }

    public void initFields() {
        if (this.codePage != null) {
            this.codePageCombo.removeModifyListener(this.codePageComboModifyListener);
            this.codePageCombo.setText(this.codePage);
            this.codePageCombo.addModifyListener(this.codePageComboModifyListener);
        }
        if (this.isSingleType) {
            this.singleTypeButton.setSelection(true);
            this.rangeTypeButton.setSelection(false);
            this.stackLayout.topControl = this.codePointSingleComp;
            this.codePointParentComp.layout();
        } else {
            this.rangeTypeButton.setSelection(true);
            this.singleTypeButton.setSelection(false);
            this.stackLayout.topControl = this.codePointRangeComp;
            this.codePointParentComp.layout();
        }
        if (this.singleCodePoint != -1) {
            this.codePointSingleText.setText(HostCharacterUtil.getHexString(String.valueOf(this.singleCodePoint)));
        }
        if (this.codePointFrom != -1) {
            this.codePointFromText.setText(HostCharacterUtil.getHexString(String.valueOf(this.codePointFrom)));
        }
        if (this.codePointTo != -1) {
            this.codePointToText.setText(HostCharacterUtil.getHexString(String.valueOf(this.codePointTo)));
        }
        if (this.substituteChar != null) {
            this.substituteText.setText(String.valueOf(this.substituteChar));
            this.substituteHexText.setText(HostCharacterUtil.getCharHexValue(this.substituteChar.charValue()));
        }
    }

    public void init(HostCharacterMapping mapping) {
        if (mapping.isSingleType()) {
            this.singleCodePoint = mapping.getSingleCodePoint();
            this.isSingleType = true;
        } else {
            this.codePointFrom = mapping.getCodePointFrom();
            this.codePointTo = mapping.getCodePointTo();
            this.isSingleType = false;
        }
        this.codePage = mapping.getCodePage();
        this.substituteChar = Character.valueOf(mapping.getSubstitute());
        this.updateOKButton(false);
    }

    public void setupDialogFieldListener() {
        this.codePageCombo.addModifyListener(this.codePageComboModifyListener);
        this.codePointSingleText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String value;
                String s = HostCharacterMappingDialog.this.codePointSingleText.getText();
                HostCharacterMappingDialog.this.isSingleType = true;
                if (s.trim().length() != 0 && (value = HostCharacterMappingDialog.this.getDecimalValue(s)) != null) {
                    HostCharacterMappingDialog.this.singleCodePoint = Integer.parseInt(value);
                }
                HostCharacterMappingDialog.this.validatePageInput();
                HostCharacterMappingDialog.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.codePointFromText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String value;
                HostCharacterMappingDialog.this.isSingleType = false;
                String s = HostCharacterMappingDialog.this.codePointFromText.getText();
                if (s.trim().length() != 0 && (value = HostCharacterMappingDialog.this.getDecimalValue(s)) != null) {
                    HostCharacterMappingDialog.this.codePointFrom = Integer.parseInt(HostCharacterMappingDialog.this.getDecimalValue(value));
                }
                HostCharacterMappingDialog.this.validatePageInput();
                HostCharacterMappingDialog.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.codePointToText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String value;
                HostCharacterMappingDialog.this.isSingleType = false;
                String s = HostCharacterMappingDialog.this.codePointToText.getText();
                if (s.trim().length() != 0 && (value = HostCharacterMappingDialog.this.getDecimalValue(s)) != null) {
                    HostCharacterMappingDialog.this.codePointTo = Integer.parseInt(HostCharacterMappingDialog.this.getDecimalValue(value));
                }
                HostCharacterMappingDialog.this.validatePageInput();
                HostCharacterMappingDialog.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.substituteText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String s = HostCharacterMappingDialog.this.substituteText.getText();
                if (s.length() == 1) {
                    HostCharacterMappingDialog.this.substituteChar = Character.valueOf(HostCharacterMappingDialog.this.substituteText.getText().charAt(0));
                    HostCharacterMappingDialog.this.substituteHexText.setText(HostCharacterUtil.getCharHexValue(HostCharacterMappingDialog.this.substituteChar.charValue()));
                }
                HostCharacterMappingDialog.this.validatePageInput();
                HostCharacterMappingDialog.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.substituteHexText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                String hexValue = HostCharacterMappingDialog.this.substituteHexText.getText().trim().toUpperCase();
                if (hexValue.toUpperCase().startsWith("0X")) {
                    hexValue = hexValue.substring(2).trim();
                }
                try {
                    int value = Integer.parseInt(hexValue, 16);
                    HostCharacterMappingDialog.this.substituteChar = Character.valueOf((char)value);
                }
                catch (Exception exception) {
                    HostCharacterMappingDialog.this.currentStatus = 4;
                    HostCharacterMappingDialog.this.currentMsg = LpexResources.message("preferences.host.char.dialog.display.hex.error");
                }
                HostCharacterMappingDialog.this.substituteText.setText(String.valueOf(HostCharacterMappingDialog.this.substituteChar));
                HostCharacterMappingDialog.this.validatePageInput();
                HostCharacterMappingDialog.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.singleTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                HostCharacterMappingDialog.this.isSingleType = true;
                if (HostCharacterMappingDialog.this.singleCodePoint == -1 && HostCharacterMappingDialog.this.codePointFrom != -1) {
                    HostCharacterMappingDialog.this.singleCodePoint = HostCharacterMappingDialog.this.codePointFrom;
                    HostCharacterMappingDialog.this.codePointSingleText.setText(HostCharacterUtil.getHexString(String.valueOf(HostCharacterMappingDialog.this.singleCodePoint)));
                }
                HostCharacterMappingDialog.this.stackLayout.topControl = HostCharacterMappingDialog.this.codePointSingleComp;
                HostCharacterMappingDialog.this.codePointParentComp.layout();
                HostCharacterMappingDialog.this.validatePageInput();
                HostCharacterMappingDialog.this.updateStatus();
            }
        });
        this.rangeTypeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                HostCharacterMappingDialog.this.isSingleType = false;
                if (HostCharacterMappingDialog.this.codePointFrom == -1 && HostCharacterMappingDialog.this.singleCodePoint != -1) {
                    HostCharacterMappingDialog.this.codePointFrom = HostCharacterMappingDialog.this.singleCodePoint;
                    HostCharacterMappingDialog.this.codePointFromText.setText(HostCharacterUtil.getHexString(String.valueOf(HostCharacterMappingDialog.this.codePointFrom)));
                }
                HostCharacterMappingDialog.this.stackLayout.topControl = HostCharacterMappingDialog.this.codePointRangeComp;
                HostCharacterMappingDialog.this.codePointParentComp.layout();
                HostCharacterMappingDialog.this.validatePageInput();
                HostCharacterMappingDialog.this.updateStatus();
            }
        });
    }

    private void validatePageInput() {
        HostCharacterMapping currentMapping;
        String value;
        this.currentStatus = 0;
        if (this.substituteText.getText().length() < 1) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.host.char.dialog.display.empty");
        }
        if (!(this.isSingleType || this.codePointTo != -1 && this.codePointFrom != -1)) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.host.char.dialog.code.point.range.Incomplete");
        }
        if (!this.isSingleType) {
            value = this.codePointFromText.getText();
            if (value != null && (value = this.getDecimalValue(value)) == null) {
                this.currentStatus = 4;
                this.currentMsg = LpexResources.message("preferences.host.char.dialog.code.point.incorrect");
            }
            if ((value = this.codePointToText.getText()) != null && (value = this.getDecimalValue(value)) == null) {
                this.currentStatus = 4;
                this.currentMsg = LpexResources.message("preferences.host.char.dialog.code.point.incorrect");
            }
            if (this.codePointFrom != -1 && this.codePointTo != -1 && this.codePointTo <= this.codePointFrom) {
                this.currentStatus = 4;
                this.currentMsg = LpexResources.message("preferences.host.char.dialog.code.point.range.unreasonable");
            }
        }
        if (this.isSingleType && (value = this.getDecimalValue(this.codePointSingleText.getText())) == null) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.host.char.dialog.code.point.incorrect");
        }
        if ((currentMapping = this.getHostCharacterMapping()) != null && HostCharacterUtil.isMappingExisted(currentMapping, this.unexpectedMappingList)) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.host.char.dialog.host_char_exists");
        }
        if (this.codePageCombo.getText() == null || this.codePageCombo.getText().trim().isEmpty()) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.host.char.dialog.codepage.empty");
        }
    }

    private String getDecimalValue(String hexString) {
        if (hexString == null) {
            return null;
        }
        String hexValue = hexString.trim().toUpperCase();
        int value = 0;
        try {
            if (hexValue.toUpperCase().startsWith("0X")) {
                hexValue = hexValue.substring(2).trim();
                value = Integer.parseInt(hexValue, 16);
            } else {
                value = Integer.parseInt(hexValue);
            }
            return String.valueOf(value);
        }
        catch (Exception exception) {
            this.currentStatus = 4;
            this.currentMsg = LpexResources.message("preferences.host.char.dialog.code.point.incorrect");
            return null;
        }
    }

    protected void updateStatus() {
        switch (this.currentStatus) {
            case 0: {
                this.setMessage(OK_MSG, 1);
                this.updateOKButton(true);
                break;
            }
            case 4: {
                this.setMessage(this.currentMsg, 3);
                this.updateOKButton(false);
                break;
            }
            default: {
                this.setMessage(OK_MSG, 1);
                this.updateOKButton(true);
            }
        }
    }

    public HostCharacterMapping getHostCharacterMapping() {
        if (this.isSingleType) {
            if (this.codePage != null && this.singleCodePoint != -1 && this.substituteChar != null) {
                return new HostCharacterMapping(this.codePage, this.singleCodePoint, this.substituteChar.charValue());
            }
        } else if (this.codePage != null && this.codePointFrom != -1 && this.codePointTo != -1 && this.substituteChar != null) {
            return new HostCharacterMapping(this.codePage, this.codePointFrom, this.codePointTo, this.substituteChar.charValue());
        }
        return null;
    }

    private void updateOKButton(boolean enable) {
        Button ok_button = this.getButton(0);
        if (ok_button != null && !ok_button.isDisposed()) {
            ok_button.setEnabled(enable);
        }
    }

    public void setUnexpectedMappingList(List<HostCharacterMapping> unexpectedMappingList) {
        this.unexpectedMappingList = unexpectedMappingList;
    }

    protected void setInEditDialog(boolean inEditDialog) {
        this.inEditDialog = true;
    }
}

