/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexIntegerFieldEditor;
import com.ibm.lpex.alef.preferences.LpexStringFieldEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class FindTextPreferencePage
extends LpexFieldEditorPreferencePage {
    private String _initialAsis;
    private String _initialWholeWord;
    private String _initialRegularExpression;
    private String _initialWrap;
    private String _initialEmphasis;
    private String _initialMark;
    private String _initialBlock;
    private String _initialColumns;
    private String _initialStartColumn;
    private String _initialEndColumn;
    private String _initialFindText;
    private String _initialReplaceText;
    private String _initialIncremental;
    private LpexBooleanFieldEditor _asisCheckBox;
    private LpexBooleanFieldEditor _wholeWordCheckBox;
    private LpexBooleanFieldEditor _regularExpressionCheckBox;
    private LpexBooleanFieldEditor _wrapCheckBox;
    private LpexBooleanFieldEditor _emphasisCheckBox;
    private LpexBooleanFieldEditor _markCheckBox;
    private LpexBooleanFieldEditor _blockCheckBox;
    private LpexBooleanFieldEditor _columnsCheckBox;
    private LpexIntegerFieldEditor _startColumnField;
    private LpexIntegerFieldEditor _endColumnField;
    private LpexStringFieldEditor _findTextField;
    private LpexStringFieldEditor _replaceTextField;
    private LpexBooleanFieldEditor _incrementalCheckBox;

    public FindTextPreferencePage() {
        super(LpexResources.message("preferences.findTextTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "findText_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        this._initialAsis = FindTextPreferencePage.getDefaultValue("findText.asis");
        this._initialWholeWord = FindTextPreferencePage.getDefaultValue("findText.wholeWord");
        this._initialRegularExpression = FindTextPreferencePage.getDefaultValue("findText.regularExpression");
        this._initialWrap = FindTextPreferencePage.getDefaultValue("findText.wrap");
        this._initialEmphasis = FindTextPreferencePage.getDefaultValue("findText.emphasis");
        this._initialMark = FindTextPreferencePage.getDefaultValue("findText.mark");
        this._initialBlock = FindTextPreferencePage.getDefaultValue("findText.block");
        this._initialColumns = FindTextPreferencePage.getDefaultValue("findText.columns");
        this._initialStartColumn = FindTextPreferencePage.getDefaultValue("findText.startColumn");
        this._initialEndColumn = FindTextPreferencePage.getDefaultValue("findText.endColumn");
        this._initialFindText = FindTextPreferencePage.getDefaultValue("findText.findText");
        this._initialReplaceText = FindTextPreferencePage.getDefaultValue("findText.replaceText");
        this._initialIncremental = FindTextPreferencePage.getDefaultValue("findText.incremental");
        Composite parent = this.getFieldEditorParent();
        this._asisCheckBox = new LpexBooleanFieldEditor(parent, "preferences.findTextAsis");
        this._wholeWordCheckBox = new LpexBooleanFieldEditor(parent, "preferences.findTextWholeWord");
        this._regularExpressionCheckBox = new LpexBooleanFieldEditor(parent, "preferences.findTextRegularExpression");
        this._wrapCheckBox = new LpexBooleanFieldEditor(parent, "preferences.findTextWrap");
        this._emphasisCheckBox = new LpexBooleanFieldEditor(parent, "preferences.findTextEmphasis");
        this._markCheckBox = new LpexBooleanFieldEditor(parent, "preferences.findTextMark");
        this._blockCheckBox = new LpexBooleanFieldEditor(parent, "preferences.findTextBlock");
        new Label(parent, 0);
        new Label(parent, 0);
        this._columnsCheckBox = new LpexBooleanFieldEditor(parent, "preferences.findTextColumns");
        this._startColumnField = new LpexIntegerFieldEditor(parent, "preferences.findTextStartColumn");
        this._endColumnField = new LpexIntegerFieldEditor(parent, "preferences.findTextEndColumn");
        new Label(parent, 0);
        new Label(parent, 0);
        this._findTextField = new LpexStringFieldEditor(parent, "preferences.findTextFindText");
        this._replaceTextField = new LpexStringFieldEditor(parent, "preferences.findTextReplaceText");
        new Label(parent, 0);
        new Label(parent, 0);
        this._incrementalCheckBox = new LpexBooleanFieldEditor(parent, "pref.findIncremental");
        this.addField((FieldEditor)this._asisCheckBox);
        this.addField((FieldEditor)this._wholeWordCheckBox);
        this.addField((FieldEditor)this._regularExpressionCheckBox);
        this.addField((FieldEditor)this._wrapCheckBox);
        this.addField((FieldEditor)this._emphasisCheckBox);
        this.addField((FieldEditor)this._markCheckBox);
        this.addField((FieldEditor)this._blockCheckBox);
        this.addField((FieldEditor)this._columnsCheckBox);
        this.addField((FieldEditor)this._startColumnField);
        this.addField((FieldEditor)this._endColumnField);
        this.addField((FieldEditor)this._findTextField);
        this.addField((FieldEditor)this._replaceTextField);
        this.addField((FieldEditor)this._incrementalCheckBox);
        this.performReset();
        this.enableStartEndColumns();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this._columnsCheckBox) {
            this.enableStartEndColumns();
        }
        super.propertyChange(event);
    }

    private void enableStartEndColumns() {
        boolean columns = this._columnsCheckBox.getBooleanValue();
        if (this._startColumnField != null) {
            this._startColumnField.setEnabled(columns);
        }
        if (this._endColumnField != null) {
            this._endColumnField.setEnabled(columns);
        }
    }

    public boolean performOk() {
        FindTextPreferencePage.updateDefaultValue("findText.asis", this._asisCheckBox.getOnOffValue());
        FindTextPreferencePage.updateDefaultValue("findText.block", this._blockCheckBox.getOnOffValue());
        FindTextPreferencePage.updateDefaultValue("findText.columns", this._columnsCheckBox.getOnOffValue());
        FindTextPreferencePage.updateDefaultValue("findText.emphasis", this._emphasisCheckBox.getOnOffValue());
        FindTextPreferencePage.updateDefaultValue("findText.endColumn", this._endColumnField.getStringValue());
        String newText = this._findTextField.getStringValue();
        if (newText.length() != 0) {
            newText = LpexStringTokenizer.addQuotes(newText);
        }
        FindTextPreferencePage.updateDefaultValue("findText.findText", newText);
        FindTextPreferencePage.updateDefaultValue("findText.mark", this._markCheckBox.getOnOffValue());
        FindTextPreferencePage.updateDefaultValue("findText.wholeWord", this._wholeWordCheckBox.getOnOffValue());
        FindTextPreferencePage.updateDefaultValue("findText.regularExpression", this._regularExpressionCheckBox.getOnOffValue());
        newText = this._replaceTextField.getStringValue();
        if (newText.length() != 0) {
            newText = LpexStringTokenizer.addQuotes(newText);
        }
        FindTextPreferencePage.updateDefaultValue("findText.replaceText", newText);
        FindTextPreferencePage.updateDefaultValue("findText.startColumn", this._startColumnField.getStringValue());
        FindTextPreferencePage.updateDefaultValue("findText.wrap", this._wrapCheckBox.getOnOffValue());
        FindTextPreferencePage.updateDefaultValue("findText.incremental", this._incrementalCheckBox.getOnOffValue());
        return true;
    }

    protected void performDefaults() {
        this.updateSettings(LpexView.globalQuery("install.findText.asis"), LpexView.globalQuery("install.findText.block"), LpexView.globalQuery("install.findText.columns"), LpexView.globalQuery("install.findText.emphasis"), LpexView.globalQuery("install.findText.endColumn"), LpexView.globalQuery("install.findText.findText"), LpexView.globalQuery("install.findText.mark"), LpexView.globalQuery("install.findText.wholeWord"), LpexView.globalQuery("install.findText.regularExpression"), LpexView.globalQuery("install.findText.replaceText"), LpexView.globalQuery("install.findText.startColumn"), LpexView.globalQuery("install.findText.wrap"), LpexView.globalQuery("install.findText.incremental"));
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this.updateSettings(this._initialAsis, this._initialBlock, this._initialColumns, this._initialEmphasis, this._initialEndColumn, this._initialFindText, this._initialMark, this._initialWholeWord, this._initialRegularExpression, this._initialReplaceText, this._initialStartColumn, this._initialWrap, this._initialIncremental);
    }

    private void updateSettings(String asis, String block, String columns, String emphasis, String endColumn, String findText, String mark, String wholeWord, String regularExpression, String replaceText, String startColumn, String wrap, String incremental) {
        this._asisCheckBox.setSelected("on".equals(asis));
        this._blockCheckBox.setSelected("on".equals(block));
        this._columnsCheckBox.setSelected("on".equals(columns));
        this._emphasisCheckBox.setSelected("on".equals(emphasis));
        this._endColumnField.setStringValue(endColumn);
        this._findTextField.setStringValue(findText != null ? LpexStringTokenizer.removeQuotes(findText) : "");
        this._markCheckBox.setSelected("on".equals(mark));
        this._wholeWordCheckBox.setSelected("on".equals(wholeWord));
        this._regularExpressionCheckBox.setSelected("on".equals(regularExpression));
        this._replaceTextField.setStringValue(replaceText != null ? LpexStringTokenizer.removeQuotes(replaceText) : "");
        this._startColumnField.setStringValue(startColumn);
        this._wrapCheckBox.setSelected("on".equals(wrap));
        this._incrementalCheckBox.setSelected("on".equals(incremental));
    }
}

