/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.preferences;

import com.ibm.lpex.alef.Utilities;
import com.ibm.lpex.alef.preferences.LpexBooleanFieldEditor;
import com.ibm.lpex.alef.preferences.LpexCompactComboEditor;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.LpexIntegerFieldEditor;
import com.ibm.lpex.alef.preferences.LpexRadioGroupFieldEditor;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public final class ControlsPreferencePage
extends LpexFieldEditorPreferencePage {
    private boolean _initialStatusLine;
    private boolean _initialFormatLine;
    private boolean _initialMessageLine;
    private boolean _initialCommandLine;
    private boolean _initialCommandLineOnTop;
    private boolean _initialPrefixArea;
    private boolean _initialExpandHide;
    private boolean _initialHighlightCurrentLine;
    private boolean _initialVisualEditLine;
    private String _initialCursorWidth;
    private String _initialCursorBlinkTime;
    private boolean _initialSplitWindow;
    private String _initialSplitWindowOrientation;
    private LpexBooleanFieldEditor _statusLineCheckBox;
    private LpexBooleanFieldEditor _formatLineCheckBox;
    private LpexBooleanFieldEditor _messageLineCheckBox;
    private LpexBooleanFieldEditor _commandLineCheckBox;
    private LpexCompactComboEditor _commandLineOnTopCombo;
    private LpexBooleanFieldEditor _prefixAreaCheckBox;
    private LpexBooleanFieldEditor _expandHideCheckBox;
    private LpexBooleanFieldEditor _highlightCurrentLineCheckBox;
    private LpexBooleanFieldEditor _visualEditLineCheckBox;
    private LpexIntegerFieldEditor _cursorWidthField;
    private LpexIntegerFieldEditor _cursorBlinkTimeField;
    private LpexBooleanFieldEditor _splitWindowCheckBox;
    private LpexRadioGroupFieldEditor _splitWindowOrientationRadioGroup;
    private String[] _commandLineLocationValues = new String[]{LpexResources.message("preferences.controlsCommandLineLocationTop"), LpexResources.message("preferences.controlsCommandLineLocationBottom")};

    public ControlsPreferencePage() {
        super(LpexResources.message("preferences.controlsTitle"), 1);
    }

    protected Control createContents(Composite parent) {
        Utilities.setHelp((Control)parent, "controls_page");
        return super.createContents(parent);
    }

    protected void createFieldEditors() {
        this._initialStatusLine = this.defaultSetting("statusLine");
        this._initialFormatLine = this.defaultSetting("formatLine");
        this._initialMessageLine = this.defaultSetting("messageLine");
        this._initialCommandLine = this.defaultSetting("commandLine");
        this._initialCommandLineOnTop = this.defaultSetting("commandLineOnTop");
        this._initialPrefixArea = this.defaultSetting("prefixArea");
        this._initialExpandHide = this.defaultSetting("expandHide");
        this._initialHighlightCurrentLine = this.defaultSetting("highlightCurrentLine");
        this._initialVisualEditLine = this.defaultSetting("visualEditLineDialog");
        this._initialCursorWidth = ControlsPreferencePage.getDefaultValue("cursor.width");
        this._initialCursorBlinkTime = ControlsPreferencePage.getDefaultValue("cursor.blinkTime");
        this._initialSplitWindow = this.defaultSetting("splitWindow");
        this._initialSplitWindowOrientation = ControlsPreferencePage.getDefaultValue("splitWindow.orientation");
        Composite parent = this.getFieldEditorParent();
        this._statusLineCheckBox = new LpexBooleanFieldEditor(parent, "preferences.controlsStatusLine", this._initialStatusLine);
        this._formatLineCheckBox = new LpexBooleanFieldEditor(parent, "preferences.controlsFormatLine", this._initialFormatLine);
        this._messageLineCheckBox = new LpexBooleanFieldEditor(parent, "preferences.controlsMessageLine", this._initialMessageLine);
        this._commandLineCheckBox = new LpexBooleanFieldEditor(parent, "preferences.controlsCommandLine", this._initialCommandLine);
        this._prefixAreaCheckBox = new LpexBooleanFieldEditor(parent, "preferences.controlsPrefixArea", this._initialPrefixArea);
        this._expandHideCheckBox = new LpexBooleanFieldEditor(parent, "preferences.controlsExpandHide", this._initialExpandHide);
        new Label(parent, 0);
        this._highlightCurrentLineCheckBox = new LpexBooleanFieldEditor(parent, "preferences.controlsCurrentLine", this._initialHighlightCurrentLine);
        this._visualEditLineCheckBox = new LpexBooleanFieldEditor(parent, "pref.controlsVisualEditLine", this._initialVisualEditLine);
        new Label(parent, 0);
        new Label(parent, 0);
        this._cursorWidthField = new LpexIntegerFieldEditor(parent, "preferences.controlsCursorWidth", 1, 20);
        this._cursorWidthField.setStringValue(this._initialCursorWidth);
        this._cursorBlinkTimeField = new LpexIntegerFieldEditor(parent, "preferences.controlsCursorBlinkTime", 200, 1200, 0, 0);
        this._cursorBlinkTimeField.setStringValue(this._initialCursorBlinkTime);
        this._commandLineOnTopCombo = new LpexCompactComboEditor("preferences.controlsCommandLineLocation", parent, this._commandLineLocationValues);
        this._commandLineOnTopCombo.setStringValue(this._initialCommandLineOnTop ? this._commandLineLocationValues[0] : this._commandLineLocationValues[1]);
        new Label(parent, 0);
        this._splitWindowCheckBox = new LpexBooleanFieldEditor(parent, "preferences.controlsSplit", this._initialSplitWindow);
        this._splitWindowOrientationRadioGroup = new LpexRadioGroupFieldEditor(null, 1, new String[][]{{"preferences.controlsVertical", "vertical"}, {"preferences.controlsHorizontal", "horizontal"}}, parent, false, this._initialSplitWindowOrientation, 20);
        this.enableWindowOrientation();
        this.addField((FieldEditor)this._statusLineCheckBox);
        this.addField((FieldEditor)this._formatLineCheckBox);
        this.addField((FieldEditor)this._messageLineCheckBox);
        this.addField((FieldEditor)this._commandLineCheckBox);
        this.addField((FieldEditor)this._prefixAreaCheckBox);
        this.addField((FieldEditor)this._expandHideCheckBox);
        this.addField(this._commandLineOnTopCombo);
        this.addField((FieldEditor)this._highlightCurrentLineCheckBox);
        this.addField((FieldEditor)this._visualEditLineCheckBox);
        this.addField((FieldEditor)this._cursorWidthField);
        this.addField((FieldEditor)this._cursorBlinkTimeField);
        this.addField((FieldEditor)this._splitWindowCheckBox);
        this.addField(this._splitWindowOrientationRadioGroup);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this._splitWindowCheckBox) {
            this.enableWindowOrientation();
        }
        super.propertyChange(event);
    }

    private void enableWindowOrientation() {
        if (this._splitWindowOrientationRadioGroup != null) {
            this._splitWindowOrientationRadioGroup.setEnabled(this._splitWindowCheckBox.getBooleanValue());
        }
    }

    public boolean performOk() {
        boolean doScreenShow = this.updateLpex(this._statusLineCheckBox, "statusLine") | this.updateLpex(this._formatLineCheckBox, "formatLine") | this.updateLpex(this._messageLineCheckBox, "messageLine") | this.updateLpex(this._commandLineCheckBox, "commandLine") | this.updateLpex(this._prefixAreaCheckBox, "prefixArea") | this.updateLpex(this._expandHideCheckBox, "expandHide") | this.updateLpex(this._commandLineOnTopCombo, "commandLineOnTop", this._commandLineLocationValues[0]) | this.updateLpex(this._highlightCurrentLineCheckBox, "highlightCurrentLine") | this.updateLpex(this._cursorWidthField, "cursor.width");
        this.updateLpex(this._visualEditLineCheckBox, "visualEditLineDialog");
        this.updateLpex(this._cursorBlinkTimeField, "cursor.blinkTime");
        this.updateLpex(this._splitWindowCheckBox, "splitWindow");
        this.updateLpex(this._splitWindowOrientationRadioGroup, "splitWindow.orientation");
        if (doScreenShow) {
            LpexView.doGlobalCommand("screenShow");
        }
        return true;
    }

    protected void performDefaults() {
        this._statusLineCheckBox.setSelected(this.installSetting("statusLine"));
        this._formatLineCheckBox.setSelected(this.installSetting("formatLine"));
        this._messageLineCheckBox.setSelected(this.installSetting("messageLine"));
        this._commandLineCheckBox.setSelected(this.installSetting("commandLine"));
        this._prefixAreaCheckBox.setSelected(this.installSetting("prefixArea"));
        this._expandHideCheckBox.setSelected(this.installSetting("expandHide"));
        this._commandLineOnTopCombo.setStringValue(this.installSetting("commandLineOnTop") ? this._commandLineLocationValues[0] : this._commandLineLocationValues[1]);
        this._highlightCurrentLineCheckBox.setSelected(this.installSetting("highlightCurrentLine"));
        this._visualEditLineCheckBox.setSelected(this.installSetting("visualEditLineDialog"));
        this._cursorWidthField.setStringValue(LpexView.globalQuery("install.cursor.width"));
        this._cursorBlinkTimeField.setStringValue(LpexView.globalQuery("install.cursor.blinkTime"));
        this._splitWindowCheckBox.setSelected(this.installSetting("splitWindow"));
        this._splitWindowOrientationRadioGroup.setValue(LpexView.globalQuery("install.splitWindow.orientation"));
        super.performDefaults();
    }

    @Override
    protected void performReset() {
        this._statusLineCheckBox.setSelected(this._initialStatusLine);
        this._formatLineCheckBox.setSelected(this._initialFormatLine);
        this._messageLineCheckBox.setSelected(this._initialMessageLine);
        this._commandLineCheckBox.setSelected(this._initialCommandLine);
        this._prefixAreaCheckBox.setSelected(this._initialPrefixArea);
        this._commandLineOnTopCombo.setStringValue(this._initialCommandLineOnTop ? this._commandLineLocationValues[0] : this._commandLineLocationValues[1]);
        this._expandHideCheckBox.setSelected(this._initialExpandHide);
        this._highlightCurrentLineCheckBox.setSelected(this._initialHighlightCurrentLine);
        this._visualEditLineCheckBox.setSelected(this._initialVisualEditLine);
        this._cursorWidthField.setStringValue(this._initialCursorWidth);
        this._cursorBlinkTimeField.setStringValue(this._initialCursorBlinkTime);
        this._splitWindowCheckBox.setSelected(this._initialSplitWindow);
        this._splitWindowOrientationRadioGroup.setValue(this._initialSplitWindowOrientation);
    }

    private boolean defaultSetting(String parameter) {
        return "on".equals(ControlsPreferencePage.getDefaultValue(parameter));
    }

    private boolean installSetting(String parameter) {
        return "on".equals(LpexView.globalQuery("install." + parameter));
    }

    private boolean updateLpex(LpexBooleanFieldEditor checkBox, String parameter) {
        return checkBox != null ? ControlsPreferencePage.updateDefaultValue(parameter, checkBox.getBooleanValue() ? "on" : "off") : false;
    }

    private boolean updateLpex(LpexCompactComboEditor combo, String parameter, String trueValue) {
        return combo != null ? ControlsPreferencePage.updateDefaultValue(parameter, combo.getStringValue().equalsIgnoreCase(trueValue) ? "on" : "off") : false;
    }

    private boolean updateLpex(LpexRadioGroupFieldEditor radioGroup, String parameter) {
        return radioGroup != null ? ControlsPreferencePage.updateDefaultValue(parameter, radioGroup.getValue()) : false;
    }

    private boolean updateLpex(LpexIntegerFieldEditor integerField, String parameter) {
        return integerField != null ? ControlsPreferencePage.updateDefaultValue(parameter, integerField.getStringValue()) : false;
    }
}

