/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.contentassist;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.alef.contentassist.AdditionalInfoController;
import com.ibm.lpex.alef.contentassist.CompletionProposalPopup;
import com.ibm.lpex.alef.contentassist.ContextInformationPopup;
import com.ibm.lpex.alef.contentassist.ICompletionProposal;
import com.ibm.lpex.alef.contentassist.IContentAssistListener;
import com.ibm.lpex.alef.contentassist.IContentAssistProcessor;
import com.ibm.lpex.alef.contentassist.IContentAssistant;
import com.ibm.lpex.alef.contentassist.IContextInformation;
import com.ibm.lpex.alef.contentassist.IContextInformationPresenter;
import com.ibm.lpex.alef.contentassist.IContextInformationValidator;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexKeyListener;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class ContentAssistant
implements IContentAssistant,
IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    static final boolean IS_MAC = "carbon".equals(SWT.getPlatform());
    public static final String STORE_SIZE_X = "size.x";
    public static final String STORE_SIZE_Y = "size.y";
    static final int CONTEXT_SELECTOR = 0;
    static final int PROPOSAL_SELECTOR = 1;
    static final int CONTEXT_INFO_POPUP = 2;
    public static final int LAYOUT_PROPOSAL_SELECTOR = 0;
    public static final int LAYOUT_CONTEXT_SELECTOR = 1;
    public static final int LAYOUT_CONTEXT_INFO_POPUP = 2;
    public static final int WIDGET_PRIORITY = 20;
    private static final int DEFAULT_AUTO_ACTIVATION_DELAY = 500;
    private IInformationControlCreator fInformationControlCreator;
    private int fAutoActivationDelay = 500;
    private boolean fIsAutoActivated;
    private boolean fIsAutoInserting;
    private int fProposalPopupOrientation = 10;
    private int fContextInfoPopupOrientation = 20;
    private Map<String, IContentAssistProcessor> fProcessors;
    private String fPartitioning = "__dftl_partitioning";
    private Color fContextInfoPopupBackground;
    private Color fContextInfoPopupForeground;
    private Color fContextSelectorBackground;
    private Color fContextSelectorForeground;
    private Color fProposalSelectorBackground;
    private Color fProposalSelectorForeground;
    private LpexTextViewer fViewer;
    private String fLastErrorMessage;
    private Closer fCloser;
    private LayoutManager fLayoutManager;
    private AutoAssistListener fAutoAssistListener;
    private InternalListener fInternalListener;
    private CompletionProposalPopup fProposalPopup;
    private ContextInformationPopup fContextInfoPopup;
    private boolean fKeyListenerHooked;
    private IContentAssistListener[] fListeners = new IContentAssistListener[4];

    private static char getCharPressed(Event e) {
        char c = e.character;
        if (c == '\u0000' && (e.stateMask & 0x40000) != 0 && (e.stateMask & 0x20000) != 0 && e.keyCode != 65536) {
            c = '@';
        } else if ((e.stateMask & 0x40000) != 0 && (e.stateMask & 0x10000) == 0 && c >= '\u0001' && c <= '\u001f') {
            c = (char)(c + 64);
        }
        boolean ignore = IS_MAC ? (e.stateMask ^ 0x400000) == 0 || (e.stateMask ^ 0x420000) == 0 : (e.stateMask ^ 0x10000) == 0 || (e.stateMask ^ 0x40000) == 0 || (e.stateMask ^ 0x30000) == 0 || (e.stateMask ^ 0x60000) == 0;
        return ignore ? (char)'\u0000' : c;
    }

    public void setDocumentPartitioning(String partitioning) {
        Assert.isNotNull((Object)partitioning);
        this.fPartitioning = partitioning;
    }

    public String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void setContentAssistProcessor(IContentAssistProcessor processor, String contentType) {
        Assert.isNotNull((Object)contentType);
        if (this.fProcessors == null) {
            this.fProcessors = new HashMap<String, IContentAssistProcessor>();
        }
        if (processor == null) {
            this.fProcessors.remove(contentType);
        } else {
            this.fProcessors.put(contentType, processor);
        }
    }

    @Override
    public IContentAssistProcessor getContentAssistProcessor(String contentType) {
        return this.fProcessors == null ? null : this.fProcessors.get(contentType);
    }

    public void enableAutoActivation(boolean enabled) {
        this.fIsAutoActivated = enabled;
        this.manageAutoActivation(this.fIsAutoActivated);
    }

    public void enableAutoInsert(boolean enabled) {
        this.fIsAutoInserting = enabled;
    }

    boolean isAutoInserting() {
        return this.fIsAutoInserting;
    }

    private void manageAutoActivation(boolean start) {
        if (start) {
            if (this.fViewer != null && this.fAutoAssistListener == null) {
                this.fAutoAssistListener = new AutoAssistListener();
                LpexView lpexView = this.fViewer.getLpexView();
                if (lpexView != null) {
                    LpexView[] views = lpexView.getLpexViews();
                    int i = 0;
                    while (i < views.length) {
                        views[i].addLpexKeyListener(this.fAutoAssistListener);
                        ++i;
                    }
                }
            }
        } else if (this.fAutoAssistListener != null) {
            LpexView lpexView = this.fViewer.getLpexView();
            if (lpexView != null) {
                LpexView[] views = lpexView.getLpexViews();
                int i = 0;
                while (i < views.length) {
                    views[i].removeLpexKeyListener(this.fAutoAssistListener);
                    ++i;
                }
            }
            this.fAutoAssistListener = null;
        }
    }

    public void newLpexView(LpexView lpexView) {
        if (this.fAutoAssistListener != null) {
            lpexView.addLpexKeyListener(this.fAutoAssistListener);
        }
    }

    public void disposeLpexView(LpexView lpexView) {
        if (this.fAutoAssistListener != null) {
            lpexView.removeLpexKeyListener(this.fAutoAssistListener);
        }
    }

    public void setAutoActivationDelay(int delay) {
        this.fAutoActivationDelay = Math.max(0, delay);
    }

    public void setProposalPopupOrientation(int orientation) {
        this.fProposalPopupOrientation = orientation;
    }

    public void setContextInformationPopupOrientation(int orientation) {
        this.fContextInfoPopupOrientation = orientation;
    }

    public void setContextInformationPopupBackground(Color background) {
        this.fContextInfoPopupBackground = background;
    }

    Color getContextInformationPopupBackground() {
        return this.fContextInfoPopupBackground;
    }

    public void setContextInformationPopupForeground(Color foreground) {
        this.fContextInfoPopupForeground = foreground;
    }

    Color getContextInformationPopupForeground() {
        return this.fContextInfoPopupForeground;
    }

    public void setProposalSelectorBackground(Color background) {
        this.fProposalSelectorBackground = background;
    }

    Color getProposalSelectorBackground() {
        return this.fProposalSelectorBackground;
    }

    public void setProposalSelectorForeground(Color foreground) {
        this.fProposalSelectorForeground = foreground;
    }

    Color getProposalSelectorForeground() {
        return this.fProposalSelectorForeground;
    }

    public void setContextSelectorBackground(Color background) {
        this.fContextSelectorBackground = background;
    }

    Color getContextSelectorBackground() {
        return this.fContextSelectorBackground;
    }

    public void setContextSelectorForeground(Color foreground) {
        this.fContextSelectorForeground = foreground;
    }

    Color getContextSelectorForeground() {
        return this.fContextSelectorForeground;
    }

    public void setInformationControlCreator(IInformationControlCreator creator) {
        this.fInformationControlCreator = creator;
    }

    @Override
    public void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.fViewer = (LpexTextViewer)textViewer;
        this.fLayoutManager = new LayoutManager();
        this.fInternalListener = new InternalListener();
        AdditionalInfoController controller = null;
        if (this.fInformationControlCreator != null) {
            controller = new AdditionalInfoController(this.fInformationControlCreator, Math.round((float)this.fAutoActivationDelay * 1.5f));
        }
        this.fContextInfoPopup = new ContextInformationPopup(this, this.fViewer);
        this.fProposalPopup = new CompletionProposalPopup(this, this.fViewer, controller);
        this.manageAutoActivation(this.fIsAutoActivated);
    }

    @Override
    public void uninstall() {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.hide();
        }
        if (this.fContextInfoPopup != null) {
            this.fContextInfoPopup.hide();
        }
        this.manageAutoActivation(false);
        this.fViewer = null;
    }

    void addToLayout(Object popup, Shell shell, int type, int visibleOffset) {
        this.fLayoutManager.add(popup, shell, type, visibleOffset);
    }

    void layout(int type, int visibleOffset) {
        this.fLayoutManager.layout(type, visibleOffset);
    }

    void popupFocusLost(FocusEvent e) {
        this.fCloser.focusLost(e);
    }

    int getSelectionOffset() {
        return this.fViewer.getSelectedRange().x;
    }

    private boolean acquireWidgetToken(int type) {
        switch (type) {
            case 0: 
            case 1: {
                LpexTextViewer owner = this.fViewer;
                return owner.requestWidgetToken(this);
            }
        }
        return true;
    }

    boolean addContentAssistListener(IContentAssistListener listener, int type) {
        if (this.acquireWidgetToken(type)) {
            this.fListeners[type] = listener;
            if (this.getNumberOfListeners() == 1) {
                this.fCloser = new Closer();
                this.fCloser.install();
                this.installKeyListener();
            }
            return true;
        }
        return false;
    }

    private void installKeyListener() {
        LpexView text;
        if (!this.fKeyListenerHooked && (text = this.fViewer.getLpexView()) != null) {
            text.addLpexKeyListener(this.fInternalListener);
            this.fKeyListenerHooked = true;
        }
    }

    private void releaseWidgetToken(int type) {
        if (this.fListeners[0] == null && this.fListeners[1] == null) {
            LpexTextViewer owner = null;
            owner = this.fViewer;
            if (owner != null) {
                owner.releaseWidgetToken(this);
            }
        }
    }

    void removeContentAssistListener(IContentAssistListener listener, int type) {
        this.fListeners[type] = null;
        if (this.getNumberOfListeners() == 0) {
            if (this.fCloser != null) {
                this.fCloser.uninstall();
                this.fCloser = null;
            }
            this.uninstallKeyListener();
        }
        this.releaseWidgetToken(type);
    }

    private void uninstallKeyListener() {
        LpexView text;
        if (this.fKeyListenerHooked && (text = this.fViewer.getLpexView()) != null) {
            text.removeLpexKeyListener(this.fInternalListener);
            this.fKeyListenerHooked = false;
        }
    }

    private int getNumberOfListeners() {
        int count = 0;
        int i = 0;
        while (i <= 2) {
            if (this.fListeners[i] != null) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    @Override
    public String showPossibleCompletions() {
        return this.showProposals(false);
    }

    public String showProposals(boolean autoActivated) {
        return this.fProposalPopup.showProposals(autoActivated);
    }

    protected void contextInformationClosed() {
    }

    @Override
    public String showContextInformation() {
        return this.fContextInfoPopup != null ? this.fContextInfoPopup.showContextProposals(false) : null;
    }

    void showContextInformation(IContextInformation contextInformation, int position) {
        this.fContextInfoPopup.showContextInformation(contextInformation, position);
    }

    String getErrorMessage() {
        return this.fLastErrorMessage;
    }

    private IContentAssistProcessor getProcessor(ITextViewer textViewer, int position) {
        LpexDocumentLocation loc;
        LpexView lpexView;
        LpexParser parser;
        IContentAssistProcessor processor = null;
        if (textViewer instanceof LpexTextViewer && (parser = (lpexView = ((LpexTextViewer)textViewer).getLpexView()).parser()) != null && parser instanceof LpexCommonParser && (processor = this.getContentAssistProcessor(((LpexCommonParser)parser).getLanguage(loc = lpexView.documentLocation()))) == null) {
            processor = this.getContentAssistProcessor(((LpexCommonParser)parser).getLanguage());
        }
        if (processor == null) {
            processor = this.getContentAssistProcessor("__dftl_partition_content_type");
        }
        return processor;
    }

    ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int position) {
        this.fLastErrorMessage = null;
        ICompletionProposal[] result = null;
        IContentAssistProcessor p = this.getProcessor(viewer, position);
        if (p != null) {
            result = p.computeCompletionProposals(viewer, position);
            this.fLastErrorMessage = p.getErrorMessage();
        }
        return result;
    }

    IContextInformation[] computeContextInformation(ITextViewer viewer, int position) {
        this.fLastErrorMessage = null;
        IContextInformation[] result = null;
        IContentAssistProcessor p = this.getProcessor(viewer, position);
        if (p != null) {
            result = p.computeContextInformation(viewer, position);
            this.fLastErrorMessage = p.getErrorMessage();
        }
        return result;
    }

    IContextInformationValidator getContextInformationValidator(ITextViewer textViewer, int position) {
        IContentAssistProcessor p = this.getProcessor(textViewer, position);
        return p != null ? p.getContextInformationValidator() : null;
    }

    IContextInformationPresenter getContextInformationPresenter(ITextViewer textViewer, int position) {
        IContextInformationValidator validator = this.getContextInformationValidator(textViewer, position);
        if (validator instanceof IContextInformationPresenter) {
            return (IContextInformationPresenter)((Object)validator);
        }
        return null;
    }

    private char[] getCompletionProposalAutoActivationCharacters(ITextViewer textViewer, int position) {
        IContentAssistProcessor p = this.getProcessor(textViewer, position);
        return p != null ? p.getCompletionProposalAutoActivationCharacters() : null;
    }

    private char[] getContextInformationAutoActivationCharacters(ITextViewer textViewer, int position) {
        IContentAssistProcessor p = this.getProcessor(textViewer, position);
        return p != null ? p.getContextInformationAutoActivationCharacters() : null;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        return false;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        if (priority > 20) {
            this.hide();
            return true;
        }
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.setFocus();
            return this.fProposalPopup.hasFocus();
        }
        return false;
    }

    protected void hide() {
        if (this.fProposalPopup != null) {
            this.fProposalPopup.hide();
        }
        if (this.fContextInfoPopup != null) {
            this.fContextInfoPopup.hide();
        }
    }

    public boolean hasProposalPopupFocus() {
        return this.fProposalPopup.hasFocus();
    }

    class AutoAssistListener
    implements LpexKeyListener,
    Runnable {
        private Thread fThread;
        private boolean fIsReset;
        private Object fMutex = new Object();
        private int fShowStyle;
        private static final int SHOW_PROPOSALS = 1;
        private static final int SHOW_CONTEXT_INFO = 2;

        protected AutoAssistListener() {
        }

        protected void start(int showStyle) {
            this.fShowStyle = showStyle;
            this.fThread = new Thread((Runnable)this, "AutoAssist Delay");
            this.fThread.start();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reset(int showStyle) {
            Object object = this.fMutex;
            synchronized (object) {
                this.fShowStyle = showStyle;
                this.fIsReset = true;
                this.fMutex.notifyAll();
            }
        }

        protected void stop() {
            if (this.fThread != null) {
                this.fThread.interrupt();
            }
        }

        private boolean contains(char[] characters, char character) {
            if (characters != null) {
                int i = 0;
                while (i < characters.length) {
                    if (character == characters[i]) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        @Override
        public void keyPressed(Event e) {
            int showStyle;
            char charPressed = ContentAssistant.getCharPressed(e);
            int pos = ContentAssistant.this.fViewer.getSelectedRange().x;
            char[] activation = ContentAssistant.this.getCompletionProposalAutoActivationCharacters(ContentAssistant.this.fViewer, pos);
            if (this.contains(activation, charPressed) && !ContentAssistant.this.fProposalPopup.isActive()) {
                showStyle = 1;
            } else {
                activation = ContentAssistant.this.getContextInformationAutoActivationCharacters(ContentAssistant.this.fViewer, pos);
                if (this.contains(activation, charPressed) && !ContentAssistant.this.fContextInfoPopup.isActive()) {
                    showStyle = 2;
                } else {
                    if (this.fThread != null && this.fThread.isAlive()) {
                        this.stop();
                    }
                    return;
                }
            }
            if (this.fThread != null && this.fThread.isAlive()) {
                this.reset(showStyle);
            } else {
                this.start(showStyle);
            }
        }

        protected void showAssist(final int showStyle) {
            LpexWindow control = ContentAssistant.this.fViewer.getLpexWindow();
            Display d = control.getDisplay();
            if (d != null) {
                try {
                    d.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (showStyle == 1) {
                                ContentAssistant.this.showProposals(true);
                            } else if (showStyle == 2 && ((AutoAssistListener)AutoAssistListener.this).ContentAssistant.this.fContextInfoPopup != null) {
                                ((AutoAssistListener)AutoAssistListener.this).ContentAssistant.this.fContextInfoPopup.showContextProposals(true);
                            }
                        }
                    });
                }
                catch (SWTError sWTError) {
                    // empty catch block
                }
            }
        }
    }

    class Closer
    implements ControlListener,
    MouseListener,
    FocusListener,
    DisposeListener,
    IViewportListener {
        Closer() {
        }

        protected void install() {
            if (ContentAssistant.this.fViewer != null) {
                LpexWindow w = ContentAssistant.this.fViewer.getLpexWindow();
                if (LpexUtilities.okToUse((Widget)w)) {
                    w.getShell().addControlListener((ControlListener)this);
                    w.textWindow().addMouseListener((MouseListener)this);
                    w.textWindow().addFocusListener((FocusListener)this);
                    w.addDisposeListener(this);
                }
                ContentAssistant.this.fViewer.addViewportListener(this);
            }
        }

        protected void uninstall() {
            if (ContentAssistant.this.fViewer != null) {
                LpexWindow w = ContentAssistant.this.fViewer.getLpexWindow();
                if (LpexUtilities.okToUse((Widget)w)) {
                    Composite textWindow;
                    Shell shell = w.getShell();
                    if (LpexUtilities.okToUse((Widget)shell)) {
                        shell.removeControlListener((ControlListener)this);
                    }
                    if (LpexUtilities.okToUse((Widget)(textWindow = w.textWindow()))) {
                        textWindow.removeMouseListener((MouseListener)this);
                        textWindow.removeFocusListener((FocusListener)this);
                    }
                    w.removeDisposeListener(this);
                }
                ContentAssistant.this.fViewer.removeViewportListener(this);
            }
        }

        public void controlResized(ControlEvent e) {
            this.hide();
        }

        public void controlMoved(ControlEvent e) {
            this.hide();
        }

        public void mouseDown(MouseEvent e) {
            this.hide();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.hide();
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Display d;
            LpexWindow control = null;
            if (ContentAssistant.this.fViewer != null) {
                control = ContentAssistant.this.fViewer.getLpexWindow();
            }
            if (control != null && LpexUtilities.okToUse(control) && (d = control.getDisplay()) != null) {
                d.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (!(((Closer)Closer.this).ContentAssistant.this.fProposalPopup.hasFocus() || ((Closer)Closer.this).ContentAssistant.this.fContextInfoPopup != null && ((Closer)Closer.this).ContentAssistant.this.fContextInfoPopup.hasFocus())) {
                                Closer.this.hide();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            this.hide();
        }

        public void viewportChanged(int topIndex) {
            this.hide();
        }

        protected void hide() {
            ContentAssistant.this.fProposalPopup.hide();
            ContentAssistant.this.fContextInfoPopup.hide();
        }
    }

    class InternalListener
    implements LpexKeyListener {
        InternalListener() {
        }

        @Override
        public void keyPressed(Event e) {
            IContentAssistListener[] listeners = (IContentAssistListener[])ContentAssistant.this.fListeners.clone();
            int i = 0;
            while (i < listeners.length) {
                if (listeners[i] != null && (!listeners[i].keyPressed(e) || !e.doit)) break;
                ++i;
            }
        }
    }

    class LayoutManager
    implements Listener {
        int fContextType = 1;
        Shell[] fShells = new Shell[3];
        Object[] fPopups = new Object[3];

        LayoutManager() {
        }

        protected void add(Object popup, Shell shell, int type, int offset) {
            Assert.isNotNull((Object)popup);
            Assert.isTrue((shell != null && !shell.isDisposed() ? 1 : 0) != 0);
            this.checkType(type);
            if (this.fShells[type] != shell) {
                if (this.fShells[type] != null) {
                    this.fShells[type].removeListener(12, (Listener)this);
                }
                shell.addListener(12, (Listener)this);
                this.fShells[type] = shell;
            }
            this.fPopups[type] = popup;
            if (type == 1 || type == 2) {
                this.fContextType = type;
            }
            this.layout(type, offset);
            this.adjustListeners(type);
        }

        protected void checkType(int type) {
            Assert.isTrue((type == 0 || type == 1 || type == 2 ? 1 : 0) != 0);
        }

        public void handleEvent(Event event) {
            Widget source = event.widget;
            source.removeListener(12, (Listener)this);
            int type = this.getShellType(source);
            this.checkType(type);
            this.fShells[type] = null;
            switch (type) {
                case 0: {
                    if (this.fContextType != 1 || !LpexUtilities.okToUse((Widget)this.fShells[1])) break;
                    ContentAssistant.this.addContentAssistListener((IContentAssistListener)this.fPopups[1], 0);
                    break;
                }
                case 1: {
                    if (LpexUtilities.okToUse((Widget)this.fShells[0])) {
                        if (ContentAssistant.this.fProposalPopupOrientation == 12) {
                            this.layout(0, ContentAssistant.this.getSelectionOffset());
                        }
                        ContentAssistant.this.addContentAssistListener((IContentAssistListener)this.fPopups[0], 1);
                    }
                    this.fContextType = 2;
                    break;
                }
                case 2: {
                    if (LpexUtilities.okToUse((Widget)this.fShells[0]) && ContentAssistant.this.fContextInfoPopupOrientation == 21) {
                        this.layout(0, ContentAssistant.this.getSelectionOffset());
                    }
                    this.fContextType = 1;
                    break;
                }
            }
        }

        protected int getShellType(Widget shell) {
            int i = 0;
            while (i < this.fShells.length) {
                if (this.fShells[i] == shell) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected void layout(int type, int offset) {
            switch (type) {
                case 0: {
                    this.layoutProposalSelector(offset);
                    break;
                }
                case 1: {
                    this.layoutContextSelector(offset);
                    break;
                }
                case 2: {
                    this.layoutContextInfoPopup(offset);
                    break;
                }
            }
        }

        protected void layoutProposalSelector(int offset) {
            if (this.fContextType == 2 && ContentAssistant.this.fContextInfoPopupOrientation == 21 && LpexUtilities.okToUse((Widget)this.fShells[2])) {
                Shell shell = this.fShells[0];
                Shell parent = this.fShells[2];
                shell.setLocation(this.getStackedLocation(shell, parent));
            } else if (this.fContextType != 1 || !LpexUtilities.okToUse((Widget)this.fShells[1])) {
                Shell shell = this.fShells[0];
                shell.setLocation(this.getBelowLocation(shell, offset));
            } else {
                switch (ContentAssistant.this.fProposalPopupOrientation) {
                    case 11: {
                        this.fShells[1].dispose();
                        Shell shell = this.fShells[0];
                        shell.setLocation(this.getBelowLocation(shell, offset));
                        break;
                    }
                    case 10: {
                        Shell shell = this.fShells[0];
                        shell.setLocation(this.getBelowLocation(shell, offset));
                        break;
                    }
                    case 12: {
                        Shell shell = this.fShells[0];
                        Shell parent = this.fShells[1];
                        shell.setLocation(this.getStackedLocation(shell, parent));
                        break;
                    }
                }
            }
        }

        protected void layoutContextSelector(int offset) {
            Shell shell = this.fShells[1];
            shell.setLocation(this.getBelowLocation(shell, offset));
            if (LpexUtilities.okToUse((Widget)this.fShells[0])) {
                switch (ContentAssistant.this.fProposalPopupOrientation) {
                    case 11: {
                        this.fShells[0].dispose();
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 12: {
                        shell = this.fShells[0];
                        Shell parent = this.fShells[1];
                        shell.setLocation(this.getStackedLocation(shell, parent));
                        break;
                    }
                }
            }
        }

        protected void layoutContextInfoPopup(int offset) {
            switch (ContentAssistant.this.fContextInfoPopupOrientation) {
                case 20: {
                    Shell shell = this.fShells[2];
                    shell.setLocation(this.getAboveLocation(shell, offset));
                    break;
                }
                case 21: {
                    Shell parent = this.fShells[2];
                    parent.setLocation(this.getBelowLocation(parent, offset));
                    if (!LpexUtilities.okToUse((Widget)this.fShells[0])) break;
                    Shell shell = this.fShells[0];
                    shell.setLocation(this.getStackedLocation(shell, parent));
                    break;
                }
            }
        }

        protected void shiftLeftLocation(Point location, Rectangle shellBounds, Rectangle displayBounds) {
            if (location.x + shellBounds.width > displayBounds.width) {
                location.x = displayBounds.width - shellBounds.width;
            }
        }

        protected void shiftDownLocation(Point location, Rectangle shellBounds, Rectangle displayBounds) {
            if (location.y < displayBounds.y) {
                location.y = displayBounds.y;
            }
        }

        protected void shiftUpLocation(Point location, Rectangle shellBounds, Rectangle displayBounds) {
            if (location.y + shellBounds.height > displayBounds.height) {
                location.y = displayBounds.height - shellBounds.height;
            }
        }

        protected Point getAboveLocation(Shell shell, int offset) {
            LpexView lpexView = ContentAssistant.this.fViewer.getLpexView();
            Point location = new Point(lpexView.queryInt("pixelPosition"), (lpexView.queryInt("cursorRow") - 1) * lpexView.queryInt("rowHeight"));
            location = ContentAssistant.this.fViewer.getLpexWindow().textWindow().toDisplay(location);
            Rectangle shellBounds = shell.getBounds();
            Rectangle displayBounds = shell.getDisplay().getClientArea();
            location.y -= shellBounds.height;
            this.shiftLeftLocation(location, shellBounds, displayBounds);
            this.shiftDownLocation(location, shellBounds, displayBounds);
            return location;
        }

        protected Point getBelowLocation(Shell shell, int offset) {
            LpexView lpexView = ContentAssistant.this.fViewer.getLpexView();
            int rowHeight = lpexView.queryInt("rowHeight");
            Point location = new Point(lpexView.queryInt("pixelPosition"), (lpexView.queryInt("cursorRow") - 1) * rowHeight);
            location = ContentAssistant.this.fViewer.getLpexWindow().textWindow().toDisplay(location);
            location.y += rowHeight;
            Rectangle shellBounds = shell.getBounds();
            Rectangle displayBounds = shell.getDisplay().getClientArea();
            this.shiftLeftLocation(location, shellBounds, displayBounds);
            this.shiftUpLocation(location, shellBounds, displayBounds);
            return location;
        }

        protected Point getStackedLocation(Shell shell, Shell parent) {
            Point p = parent.getLocation();
            Point size = parent.getSize();
            p.x += size.x / 4;
            p.y += size.y;
            p = parent.toDisplay(p);
            Rectangle shellBounds = shell.getBounds();
            Rectangle displayBounds = shell.getDisplay().getClientArea();
            this.shiftLeftLocation(p, shellBounds, displayBounds);
            this.shiftUpLocation(p, shellBounds, displayBounds);
            return p;
        }

        protected void adjustListeners(int type) {
            switch (type) {
                case 0: {
                    if (this.fContextType != 1 || !LpexUtilities.okToUse((Widget)this.fShells[1])) break;
                    ContentAssistant.this.removeContentAssistListener((IContentAssistListener)this.fPopups[1], 0);
                    break;
                }
                case 1: {
                    if (!LpexUtilities.okToUse((Widget)this.fShells[0])) break;
                    ContentAssistant.this.removeContentAssistListener((IContentAssistListener)this.fPopups[0], 1);
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
    }
}

