/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef.contentassist;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.alef.contentassist.AdditionalInfoController;
import com.ibm.lpex.alef.contentassist.ContentAssistant;
import com.ibm.lpex.alef.contentassist.ICompletionProposal;
import com.ibm.lpex.alef.contentassist.ICompletionProposalExtension;
import com.ibm.lpex.alef.contentassist.IContentAssistListener;
import com.ibm.lpex.alef.contentassist.IContextInformation;
import com.ibm.lpex.alef.contentassist.PopupCloser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import java.util.ArrayList;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class CompletionProposalPopup
implements IContentAssistListener {
    private LpexTextViewer fViewer;
    private ContentAssistant fContentAssistant;
    private AdditionalInfoController fAdditionalInfoController;
    private PopupCloser fPopupCloser = new PopupCloser();
    private Shell fProposalShell;
    private Table fProposalTable;
    private long fInvocationCounter;
    private ICompletionProposal[] fFilteredProposals;
    private ICompletionProposal[] fComputedProposals;
    private int fInvocationOffset;
    private LpexDocumentLocation fInvocationLocation;
    private int fFilterOffset;
    private LpexDocumentLocation fFilterLocation = new LpexDocumentLocation(1, 1);

    public CompletionProposalPopup(ContentAssistant contentAssistant, ITextViewer viewer, AdditionalInfoController infoController) {
        this.fContentAssistant = contentAssistant;
        this.fViewer = (LpexTextViewer)viewer;
        this.fAdditionalInfoController = infoController;
    }

    public String showProposals(final boolean autoActivated) {
        LpexView lpexView = this.fViewer.getLpexView();
        lpexView.doDefaultCommand("undo check");
        if (lpexView.query("includedClasses").length() != 0 || lpexView.query("excludedClasses").length() != 0) {
            lpexView.doCommand("set includedClasses");
            lpexView.doCommand("set excludedClasses");
            lpexView.doDefaultCommand("screenShow view");
        }
        lpexView.triggerAction(146);
        final LpexWindow lpexWindow = this.fViewer.getLpexWindow();
        BusyIndicator.showWhile((Display)lpexWindow.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                int count;
                CompletionProposalPopup.this.fInvocationOffset = CompletionProposalPopup.this.fViewer.getSelectedRange().x;
                CompletionProposalPopup.this.fInvocationLocation = CompletionProposalPopup.this.fViewer.getLpexView().documentLocation();
                CompletionProposalPopup.this.fComputedProposals = CompletionProposalPopup.this.computeProposals(CompletionProposalPopup.this.fInvocationOffset);
                int n = count = CompletionProposalPopup.this.fComputedProposals == null ? 0 : CompletionProposalPopup.this.fComputedProposals.length;
                if (count == 0) {
                    if (!autoActivated) {
                        lpexWindow.getDisplay().beep();
                    }
                } else if (count == 1 && !autoActivated && CompletionProposalPopup.this.fContentAssistant.isAutoInserting()) {
                    CompletionProposalPopup.this.insertProposal(CompletionProposalPopup.this.fComputedProposals[0], '\u0000', CompletionProposalPopup.this.fInvocationOffset);
                } else {
                    CompletionProposalPopup.this.createProposalSelector();
                    CompletionProposalPopup.this.setProposals(CompletionProposalPopup.this.fComputedProposals);
                    CompletionProposalPopup.this.displayProposals();
                }
            }
        });
        return this.getErrorMessage();
    }

    private ICompletionProposal[] computeProposals(int offset) {
        return this.fContentAssistant.computeCompletionProposals(this.fViewer, offset);
    }

    private String getErrorMessage() {
        return this.fContentAssistant.getErrorMessage();
    }

    private void createProposalSelector() {
        if (LpexUtilities.okToUse((Widget)this.fProposalShell)) {
            return;
        }
        this.fProposalShell = new Shell(this.fViewer.getLpexWindow().getShell(), 16392);
        this.fProposalTable = new Table((Composite)this.fProposalShell, 768);
        int height = this.fProposalTable.getItemHeight() * 10;
        this.fProposalShell.setSize(302, height + 2);
        this.fProposalTable.setSize(300, height);
        this.fProposalTable.setLocation(1, 1);
        Display display = this.fViewer.getLpexWindow().getDisplay();
        this.fProposalShell.setBackground(display.getSystemColor(2));
        Color c = this.fContentAssistant.getProposalSelectorBackground();
        if (c == null) {
            c = display.getSystemColor(29);
        }
        this.fProposalTable.setBackground(c);
        c = this.fContentAssistant.getProposalSelectorForeground();
        if (c == null) {
            c = display.getSystemColor(28);
        }
        this.fProposalTable.setForeground(c);
        this.fProposalTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CompletionProposalPopup.this.selectProposal();
            }
        });
        this.fPopupCloser.install(this.fContentAssistant, this.fProposalTable);
        this.fProposalTable.setHeaderVisible(false);
        this.fContentAssistant.addToLayout(this, this.fProposalShell, 0, this.fContentAssistant.getSelectionOffset());
    }

    private ICompletionProposal getSelectedProposal() {
        int i = this.fProposalTable.getSelectionIndex();
        if (i < 0 || i >= this.fFilteredProposals.length) {
            return null;
        }
        return this.fFilteredProposals[i];
    }

    private void selectProposal() {
        ICompletionProposal p = this.getSelectedProposal();
        this.hide();
        if (p != null) {
            this.insertProposal(p, '\u0000', this.fViewer.getSelectedRange().x);
        }
    }

    private void insertProposal(ICompletionProposal p, char trigger, int offset) {
        IContextInformation info;
        if (p instanceof ICompletionProposalExtension) {
            ICompletionProposalExtension e = (ICompletionProposalExtension)((Object)p);
            e.apply(this.fViewer, trigger, offset);
        } else {
            p.apply(this.fViewer);
        }
        LpexView lpexView = this.fViewer.getLpexView();
        if (lpexView.queryOn("current.parseAfterEveryKey")) {
            lpexView.doCommand("parse");
            lpexView.doCommand("screenShow view");
        }
        if ((info = p.getContextInformation()) != null) {
            int position;
            if (p instanceof ICompletionProposalExtension) {
                ICompletionProposalExtension e = (ICompletionProposalExtension)((Object)p);
                position = e.getContextInformationPosition();
            } else {
                Point selection = this.fViewer.getSelectedRange();
                position = selection.x + selection.y;
            }
            this.fContentAssistant.showContextInformation(info, position);
        }
    }

    public void setFocus() {
        if (LpexUtilities.okToUse((Widget)this.fProposalShell)) {
            this.fProposalShell.setFocus();
        }
    }

    public boolean hasFocus() {
        return LpexUtilities.okToUse((Widget)this.fProposalShell) ? this.fProposalShell.isFocusControl() || this.fProposalTable.isFocusControl() : false;
    }

    public void hide() {
        if (LpexUtilities.okToUse((Widget)this.fProposalShell)) {
            this.fContentAssistant.removeContentAssistListener(this, 1);
            this.fPopupCloser.uninstall();
            this.fProposalShell.setVisible(false);
            this.fProposalShell.dispose();
            this.fProposalShell = null;
        }
        this.fFilteredProposals = null;
    }

    public boolean isActive() {
        return this.fProposalShell != null && !this.fProposalShell.isDisposed();
    }

    private void setProposals(ICompletionProposal[] proposals) {
        if (LpexUtilities.okToUse((Widget)this.fProposalTable)) {
            this.fFilteredProposals = proposals;
            this.fProposalTable.setRedraw(false);
            this.fProposalTable.removeAll();
            int i = 0;
            while (i < proposals.length) {
                ICompletionProposal p = proposals[i];
                TableItem item = new TableItem(this.fProposalTable, 0);
                if (p.getImage() != null) {
                    item.setImage(p.getImage());
                }
                item.setText(p.getDisplayString());
                item.setData((Object)p);
                ++i;
            }
            Point currentLocation = this.fProposalShell.getLocation();
            Point newLocation = this.getLocation();
            if (newLocation.x < currentLocation.x && newLocation.y == currentLocation.y || newLocation.y < currentLocation.y) {
                this.fProposalShell.setLocation(newLocation);
            }
            this.selectProposal(0);
            this.fProposalTable.setRedraw(true);
        }
    }

    private Point getLocation() {
        LpexView lpexView = this.fViewer.getLpexView();
        Point p = new Point(lpexView.queryInt("pixelPosition"), lpexView.queryInt("cursorRow") * lpexView.queryInt("rowHeight"));
        return this.fViewer.getLpexWindow().textWindow().toDisplay(p);
    }

    private void displayProposals() {
        if (this.fContentAssistant.addContentAssistListener(this, 1)) {
            this.fProposalShell.setVisible(true);
            if (this.fAdditionalInfoController != null) {
                this.fAdditionalInfoController.install((Control)this.fProposalTable);
                this.fAdditionalInfoController.handleTableSelectionChanged();
            }
        }
    }

    @Override
    public boolean keyPressed(Event e) {
        ICompletionProposalExtension t;
        char[] triggers;
        if (!LpexUtilities.okToUse((Widget)this.fProposalShell)) {
            return true;
        }
        char key = e.character;
        if (key == '\u0000') {
            int newSelection = this.fProposalTable.getSelectionIndex();
            int visibleRows = this.fProposalTable.getSize().y / this.fProposalTable.getItemHeight() - 1;
            switch (e.keyCode) {
                case 0x1000003: 
                case 0x1000004: {
                    this.filterProposal();
                    return true;
                }
                case 0x1000001: {
                    newSelection -= newSelection > 0 ? 1 : 0;
                    break;
                }
                case 0x1000002: {
                    newSelection += newSelection < this.fProposalTable.getItemCount() - 1 ? 1 : 0;
                    break;
                }
                case 0x1000006: {
                    if ((newSelection += visibleRows) < this.fProposalTable.getItemCount()) break;
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 0x1000005: {
                    if ((newSelection -= visibleRows) >= 0) break;
                    newSelection = 0;
                    break;
                }
                case 0x1000007: {
                    newSelection = 0;
                    break;
                }
                case 0x1000008: {
                    newSelection = this.fProposalTable.getItemCount() - 1;
                    break;
                }
                case 131072: 
                case 262144: {
                    return true;
                }
                default: {
                    this.hide();
                    return true;
                }
            }
            this.selectProposal(newSelection);
            e.doit = false;
            return false;
        }
        if (key == '\u001b') {
            this.hide();
            e.doit = false;
            return true;
        }
        if (key == '\r') {
            this.selectProposal();
            e.doit = false;
            return true;
        }
        if (key == '\t') {
            this.fProposalShell.setFocus();
            e.doit = false;
            return false;
        }
        ICompletionProposal p = this.getSelectedProposal();
        if (p instanceof ICompletionProposalExtension && this.contains(triggers = (t = (ICompletionProposalExtension)((Object)p)).getTriggerCharacters(), key)) {
            this.hide();
            this.insertProposal(p, key, this.fViewer.getSelectedRange().x);
            e.doit = false;
            return true;
        }
        this.filterProposal();
        return true;
    }

    private void selectProposal(int index) {
        this.fProposalTable.setSelection(index);
        this.fProposalTable.showSelection();
        if (this.fAdditionalInfoController != null) {
            this.fAdditionalInfoController.handleTableSelectionChanged();
        }
    }

    private boolean contains(char[] characters, char c) {
        if (characters == null) {
            return false;
        }
        int i = 0;
        while (i < characters.length) {
            if (c == characters[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void filterProposal() {
        ++this.fInvocationCounter;
        this.fViewer.getLpexWindow().getDisplay().asyncExec(new Runnable(){
            long fCounter;
            {
                this.fCounter = CompletionProposalPopup.this.fInvocationCounter;
            }

            @Override
            public void run() {
                if (this.fCounter != CompletionProposalPopup.this.fInvocationCounter) {
                    return;
                }
                int offset = CompletionProposalPopup.this.fViewer.getSelectedRange().x;
                ICompletionProposal[] proposals = offset == -1 ? null : CompletionProposalPopup.this.computeFilteredProposals(offset);
                CompletionProposalPopup.this.fFilterOffset = offset;
                CompletionProposalPopup.this.fFilterLocation = CompletionProposalPopup.this.fViewer.getLpexView().documentLocation();
                if (proposals != null && proposals.length > 0) {
                    CompletionProposalPopup.this.setProposals(proposals);
                } else {
                    CompletionProposalPopup.this.hide();
                }
            }
        });
    }

    private ICompletionProposal[] computeFilteredProposals(int offset) {
        LpexDocumentLocation location = this.fViewer.getLpexView().documentLocation();
        if (offset == this.fInvocationOffset && location.element == this.fInvocationLocation.element && location.position == this.fInvocationLocation.position) {
            return this.fComputedProposals;
        }
        if (offset < this.fInvocationOffset) {
            this.fInvocationOffset = offset;
            this.fInvocationLocation = location;
            this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
            return this.fComputedProposals;
        }
        ICompletionProposal[] proposals = this.fComputedProposals;
        if (offset > this.fFilterOffset || location.element > this.fFilterLocation.element || location.position > this.fFilterLocation.position) {
            proposals = this.fFilteredProposals;
        }
        if (proposals == null) {
            return null;
        }
        int length = proposals.length;
        ArrayList<ICompletionProposalExtension> filtered = new ArrayList<ICompletionProposalExtension>(length);
        int i = 0;
        while (i < length) {
            if (proposals[i] instanceof ICompletionProposalExtension) {
                ICompletionProposalExtension p = (ICompletionProposalExtension)((Object)proposals[i]);
                if (p.isValidFor(this.fViewer, location)) {
                    filtered.add(p);
                }
            } else {
                this.fInvocationOffset = offset;
                this.fInvocationLocation = location;
                this.fComputedProposals = this.computeProposals(this.fInvocationOffset);
                return this.fComputedProposals;
            }
            ++i;
        }
        ICompletionProposal[] p = new ICompletionProposal[filtered.size()];
        filtered.toArray(p);
        return p;
    }
}

