/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexPreferenceNode;
import com.ibm.lpex.alef.LpexSourceViewer;
import com.ibm.lpex.alef.LpexViewPreferenceNode;
import com.ibm.lpex.alef.preferences.LpexFieldEditorPreferencePage;
import com.ibm.lpex.alef.preferences.ParsersPreferencePage;
import com.ibm.lpex.alef.preferences.SequenceNumbersPreferencePage;
import com.ibm.lpex.alef.preferences.SourceEncodingPreferencePage;
import com.ibm.lpex.alef.preferences.ViewBasePreferencePage;
import com.ibm.lpex.alef.preferences.ViewParserPreferencePage;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public final class Utilities {
    private static PreferenceManager _preferenceManager;
    private static LpexViewPreferenceNode _baseViewNode;

    private Utilities() {
    }

    public static boolean doDefaultActionPreferences(LpexView lpexView) {
        if (lpexView.window() != null) {
            Shell shell = lpexView.window().getShell();
            Utilities.createPreferenceManager();
            Utilities.updatePreferencePage(lpexView);
            PreferenceDialog dialog = new PreferenceDialog(shell, _preferenceManager);
            dialog.open();
            return true;
        }
        return false;
    }

    private static void createPreferenceManager() {
        if (_preferenceManager == null) {
            _preferenceManager = new PreferenceManager(' ');
            LpexPreferenceNode basePreferenceNode = new LpexPreferenceNode(LpexResources.message("preferences.rootTitle"), "com.ibm.lpex.alef.preferences.LpexBasePreferencePage");
            _preferenceManager.addToRoot((IPreferenceNode)basePreferenceNode);
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.appearanceTitle"), "com.ibm.lpex.alef.preferences.AppearancePreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.blockTitle"), "com.ibm.lpex.alef.preferences.BlockPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.compareTitle"), "com.ibm.lpex.alef.preferences.ComparePreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.controlsTitle"), "com.ibm.lpex.alef.preferences.ControlsPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.findTextTitle"), "com.ibm.lpex.alef.preferences.FindTextPreferencePage"));
            LpexPreferenceNode parsersPreferenceNode = new LpexPreferenceNode(LpexResources.message("preferences.parsersTitle"), "com.ibm.lpex.alef.preferences.ParsersPreferencePage");
            basePreferenceNode.add((IPreferenceNode)parsersPreferenceNode);
            parsersPreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.parserAssociationsTitle"), "com.ibm.lpex.alef.preferences.ParserAssociationsPreferencePage"));
            parsersPreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.parsers.settingsTitle"), "com.ibm.lpex.alef.preferences.ParserStylesPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.printTitle"), "com.ibm.lpex.alef.preferences.PrintPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.saveTitle"), "com.ibm.lpex.alef.preferences.SavePreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.tabsTitle"), "com.ibm.lpex.alef.preferences.TabsPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.userActionsTitle"), "com.ibm.lpex.alef.preferences.UserActionsPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.userCommandsTitle"), "com.ibm.lpex.alef.preferences.UserCommandsPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.userKeyActionsTitle"), "com.ibm.lpex.alef.preferences.UserKeyActionsPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.userMouseActionsTitle"), "com.ibm.lpex.alef.preferences.UserMouseActionsPreferencePage"));
            basePreferenceNode.add((IPreferenceNode)new LpexPreferenceNode(LpexResources.message("preferences.userProfileTitle"), "com.ibm.lpex.alef.preferences.UserProfilePreferencePage"));
        }
    }

    static IPreferencePage createViewPreferencePage(LpexView lpexView, int nodeType) {
        LpexFieldEditorPreferencePage newPage = null;
        switch (nodeType) {
            case 0: {
                newPage = new ViewBasePreferencePage(lpexView);
                newPage.setTitle(Utilities.getViewName(lpexView));
                break;
            }
            case 1: {
                newPage = new ViewParserPreferencePage(lpexView);
                break;
            }
            case 2: {
                newPage = new SequenceNumbersPreferencePage(lpexView);
                break;
            }
            case 3: {
                newPage = new SourceEncodingPreferencePage(lpexView);
                break;
            }
        }
        return newPage;
    }

    private static void updatePreferencePage(LpexView lpexView) {
        IPreferenceNode baseLpexNode = _preferenceManager.find("com.ibm.lpex.alef.preferences.LpexBasePreferencePage");
        if (baseLpexNode == null) {
            return;
        }
        if (_baseViewNode != null && _baseViewNode.lpexView() != lpexView) {
            LpexViewPreferenceNode.remove(baseLpexNode, (IPreferenceNode)_baseViewNode);
            _baseViewNode = null;
        }
        if (_baseViewNode == null) {
            LpexViewPreferenceNode baseViewNode = new LpexViewPreferenceNode(lpexView, 0);
            baseLpexNode.add((IPreferenceNode)baseViewNode);
            _baseViewNode = baseViewNode;
            baseViewNode.add((IPreferenceNode)new LpexViewPreferenceNode(lpexView, 1));
            baseViewNode.add((IPreferenceNode)new LpexViewPreferenceNode(lpexView, 2));
            baseViewNode.add((IPreferenceNode)new LpexViewPreferenceNode(lpexView, 3));
        }
        ParsersPreferencePage.setLastParserSelected(lpexView.query("parser"));
    }

    static String getViewName(LpexView lpexView) {
        Object name = lpexView.query("sourceName");
        if (name == null && (name = lpexView.query("name")) == null) {
            name = LpexResources.message("untitledDocument", lpexView.query("documentId"));
        }
        if (lpexView.queryInt("documentViews") != 1) {
            name = (String)name + ": " + lpexView.query("viewId");
        }
        return name;
    }

    static String getViewName(LpexSourceViewer lpexSourceViewer) {
        LpexView firstLpexView;
        String name = null;
        if (lpexSourceViewer != null && (firstLpexView = lpexSourceViewer.getFirstLpexView()) != null) {
            name = firstLpexView.query("name");
        }
        return name;
    }

    public static void setHelp(Control c, String helpId) {
        LpexUtilities.setHelp(c, "com.ibm.lpex." + helpId);
    }
}

