/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

class LpexTextViewerHoverManager
extends AbstractHoverInformationControlManager
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    public static final int WIDGET_PRIORITY = 0;
    private LpexTextViewer fTextViewer;
    private Thread fThread;
    private ITextListener fStopper;
    private Object fMutex = new Object();
    private volatile ITextHover fTextHover;
    private boolean fProcessMouseHoverEvent = true;
    private MouseMoveListener fMouseMoveListener;
    private IViewportListener fViewportListener;
    private boolean _canceling;
    private LpexWindow _window;

    public LpexTextViewerHoverManager(LpexTextViewer textViewer, LpexWindow window, IInformationControlCreator creator) {
        super(creator);
        this.fTextViewer = textViewer;
        this.fStopper = new ITextListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void textChanged(TextEvent event) {
                Object object = LpexTextViewerHoverManager.this.fMutex;
                synchronized (object) {
                    if (LpexTextViewerHoverManager.this.fThread != null) {
                        LpexTextViewerHoverManager.this.fThread.interrupt();
                        LpexTextViewerHoverManager.this.fThread = null;
                    }
                }
            }
        };
        this.fViewportListener = new IViewportListener(){

            public void viewportChanged(int verticalOffset) {
                LpexTextViewerHoverManager.this.fProcessMouseHoverEvent = false;
            }
        };
        this.fTextViewer.addViewportListener(this.fViewportListener);
        this.fMouseMoveListener = new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                LpexTextViewerHoverManager.this.fProcessMouseHoverEvent = true;
            }
        };
        this._window = window;
        this._window.textWindow().addMouseMoveListener(this.fMouseMoveListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeInformation() {
        if (!this.fProcessMouseHoverEvent) {
            this.setInformation(null, null);
            return;
        }
        Point location = this.getHoverEventLocation();
        int offset = this.computeOffsetAtLocation(location.x, location.y);
        if (offset == -1) {
            this.setInformation(null, null);
            return;
        }
        final ITextHover hover = this.fTextViewer.getTextHover(offset, this.getHoverEventStateMask());
        if (hover == null) {
            this.setInformation(null, null);
            return;
        }
        final IRegion region = hover.getHoverRegion((ITextViewer)this.fTextViewer, offset);
        if (region == null) {
            this.setInformation(null, null);
            return;
        }
        final Rectangle area = this.computeArea(region);
        if (area == null || area.isEmpty()) {
            this.setInformation(null, null);
            return;
        }
        if (this.fThread != null) {
            this.setInformation(null, null);
            return;
        }
        this.fThread = new Thread("Text Viewer Hover Presenter"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block27: {
                    boolean hasFinished = false;
                    try {
                        try {
                            if (LpexTextViewerHoverManager.this.fThread != null) {
                                Object information;
                                try {
                                    information = hover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)hover).getHoverInfo2((ITextViewer)LpexTextViewerHoverManager.this.fTextViewer, region) : hover.getHoverInfo((ITextViewer)LpexTextViewerHoverManager.this.fTextViewer, region);
                                }
                                catch (ArrayIndexOutOfBoundsException x) {
                                    information = null;
                                }
                                if (hover instanceof ITextHoverExtension) {
                                    LpexTextViewerHoverManager.this.setCustomInformationControlCreator(((ITextHoverExtension)hover).getHoverControlCreator());
                                } else {
                                    LpexTextViewerHoverManager.this.setCustomInformationControlCreator(null);
                                }
                                LpexTextViewerHoverManager.this.setInformation(information, area);
                                if (information != null) {
                                    LpexTextViewerHoverManager.this.fTextHover = hover;
                                }
                            } else {
                                LpexTextViewerHoverManager.this.setInformation(null, null);
                            }
                            hasFinished = true;
                        }
                        catch (RuntimeException ex) {
                            String PLUGIN_ID = "org.eclipse.jface.text";
                            ILog log = Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID));
                            log.log((IStatus)new Status(4, PLUGIN_ID, 0, "Unexpected runtime error while computing a text hover", (Throwable)ex));
                            Object object = LpexTextViewerHoverManager.this.fMutex;
                            synchronized (object) {
                                if (LpexTextViewerHoverManager.this.fTextViewer != null) {
                                    LpexTextViewerHoverManager.this.fTextViewer.removeTextListener(LpexTextViewerHoverManager.this.fStopper);
                                }
                                LpexTextViewerHoverManager.this.fThread = null;
                                if (!hasFinished) {
                                    LpexTextViewerHoverManager.this.setInformation(null, null);
                                }
                                break block27;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = LpexTextViewerHoverManager.this.fMutex;
                        synchronized (object) {
                            if (LpexTextViewerHoverManager.this.fTextViewer != null) {
                                LpexTextViewerHoverManager.this.fTextViewer.removeTextListener(LpexTextViewerHoverManager.this.fStopper);
                            }
                            LpexTextViewerHoverManager.this.fThread = null;
                            if (!hasFinished) {
                                LpexTextViewerHoverManager.this.setInformation(null, null);
                            }
                        }
                        throw throwable;
                    }
                    Object object = LpexTextViewerHoverManager.this.fMutex;
                    synchronized (object) {
                        if (LpexTextViewerHoverManager.this.fTextViewer != null) {
                            LpexTextViewerHoverManager.this.fTextViewer.removeTextListener(LpexTextViewerHoverManager.this.fStopper);
                        }
                        LpexTextViewerHoverManager.this.fThread = null;
                        if (!hasFinished) {
                            LpexTextViewerHoverManager.this.setInformation(null, null);
                        }
                    }
                }
            }
        };
        this.fThread.setDaemon(true);
        this.fThread.setPriority(1);
        Object object = this.fMutex;
        synchronized (object) {
            this.fTextViewer.addTextListener(this.fStopper);
            this.fThread.start();
        }
    }

    protected void presentInformation() {
        if (this.fTextViewer == null) {
            return;
        }
        Composite textWidget = this._window.textWindow();
        if (textWidget != null && !textWidget.isDisposed()) {
            Display display = textWidget.getDisplay();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LpexTextViewerHoverManager.this.doPresentInformation();
                }
            });
        }
    }

    protected void doPresentInformation() {
        super.presentInformation();
    }

    private int computeOffsetAtLocation(int x, int y) {
        LpexDocumentLocation loc;
        IDocument document = this.fTextViewer.getVisibleDocument();
        if (document == null) {
            return -1;
        }
        int top = 0;
        if (y < top) {
            return -1;
        }
        LpexView lpexView = this._window.getLpexView();
        int row = (y - top) / lpexView.queryInt("rowHeight") + 1;
        if (row > lpexView.queryInt("rows")) {
            return -1;
        }
        int element = lpexView.elementOfRow(row);
        if (element == 0 || lpexView.show(element)) {
            return -1;
        }
        int prefixWidth = lpexView.queryInt("prefixAreaWidth") + lpexView.queryInt("expandHideAreaWidth");
        if (x < prefixWidth) {
            return -1;
        }
        if ((x += lpexView.queryInt("scroll") - prefixWidth) >= lpexView.queryInt("textWidth", loc = new LpexDocumentLocation(element, 1))) {
            return -1;
        }
        int lookup = lpexView.queryInt("pixelPosition", loc);
        String text = lpexView.elementText(element);
        if (text == null) {
            return -1;
        }
        int high = text.length();
        int guessPosition = 1;
        int guessPixelDelta = Math.abs(lookup - x);
        int i = 2;
        while (i <= high) {
            loc.position = i;
            lookup = lpexView.queryInt("pixelPosition", loc);
            int pixelDelta = Math.abs(lookup - x);
            if (pixelDelta < guessPixelDelta) {
                guessPosition = i;
                guessPixelDelta = pixelDelta;
            }
            ++i;
        }
        loc.position = guessPosition;
        return this.fTextViewer.getDocumentAdapter().getDocOffset(loc);
    }

    protected void showInformationControl(Rectangle subjectArea) {
        if (this.fTextViewer != null && this.fTextViewer.requestWidgetToken(this, 0)) {
            super.showInformationControl(subjectArea);
        }
    }

    protected void hideInformationControl() {
        try {
            this.fTextHover = null;
            super.hideInformationControl();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        this.fTextHover = null;
        super.hideInformationControl();
        return true;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        if (priority > 0) {
            this.fTextHover = null;
            super.hideInformationControl();
            return true;
        }
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        if (this.getInternalAccessor().getInformationControlReplacer() == null) {
            return false;
        }
        IInformationControl iControl = this.getInternalAccessor().getCurrentInformationControl();
        if (this.getInternalAccessor().canReplace(iControl)) {
            if (this.canceledReplacingDelay()) {
                this.fTextViewer.releaseWidgetToken(this);
                this.getInternalAccessor().replaceInformationControl(true);
            }
            return true;
        }
        return iControl instanceof IInformationControlExtension5;
    }

    private boolean canceledReplacingDelay() {
        this._canceling = true;
        IInformationControl control = this.fInformationControl;
        this.fInformationControl = null;
        super.hideInformationControl();
        this.fInformationControl = control;
        this._canceling = false;
        return true;
    }

    protected boolean canClearDataOnHide() {
        if (this._canceling) {
            return false;
        }
        return super.canClearDataOnHide();
    }

    protected ITextHover getCurrentTextHover() {
        return this.fTextHover;
    }

    public void dispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeViewportListener(this.fViewportListener);
            this.fViewportListener = null;
            Composite st = this._window.textWindow();
            if (st != null && !st.isDisposed()) {
                st.removeMouseMoveListener(this.fMouseMoveListener);
            }
            this.fMouseMoveListener = null;
        }
        super.dispose();
    }

    public Point getHoverEventLocation() {
        return super.getHoverEventLocation();
    }

    private Rectangle computeArea(IRegion region) {
        IRegion widgetRegion = this.modelRange2WidgetRange(region);
        int start = widgetRegion.getOffset();
        int end = widgetRegion.getOffset() + widgetRegion.getLength();
        if (end == start) {
            end = start + 1;
        }
        LpexView lpexView = this._window.getLpexView();
        int rows = lpexView.queryInt("rows");
        int rowHeight = lpexView.queryInt("rowHeight");
        int prefixWidth = lpexView.queryInt("prefixAreaWidth") + lpexView.queryInt("expandHideAreaWidth");
        int xAdjust = prefixWidth - lpexView.queryInt("scroll");
        int upperLeftx = 0;
        int upperLefty = 0;
        int lowerRightx = 0;
        int lowerRighty = 0;
        int offset = start;
        while (offset < end) {
            int x = -1;
            int y = -1;
            LpexDocumentLocation loc = this.fTextViewer.getLpexDocumentLocation(offset);
            int row = 1;
            while (row <= rows) {
                if (lpexView.elementOfRow(row) == loc.element) {
                    y = (row - 1) * rowHeight;
                    x = lpexView.queryInt("pixelPosition", loc) + xAdjust;
                    break;
                }
                ++row;
            }
            if (offset == start) {
                upperLeftx = lowerRightx = x;
                upperLefty = lowerRighty = y;
            } else if (x != -1 || y != -1) {
                if (upperLeftx > x) {
                    upperLeftx = x;
                }
                if (upperLefty > y) {
                    upperLefty = y;
                }
                if (lowerRightx < x) {
                    lowerRightx = x;
                }
                if (lowerRighty < y) {
                    lowerRighty = y;
                }
            }
            ++offset;
        }
        int width = (lowerRightx += this.fTextViewer.getAverageCharWidth(this._window)) - upperLeftx;
        int height = (lowerRighty += rowHeight) - upperLefty;
        return new Rectangle(upperLeftx, upperLefty, width, height);
    }

    private IRegion modelRange2WidgetRange(IRegion region) {
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fTextViewer;
            return extension.modelRange2WidgetRange(region);
        }
        IRegion visibleRegion = this.fTextViewer.getVisibleRegion();
        int start = region.getOffset() - visibleRegion.getOffset();
        int end = start + region.getLength();
        if (end > visibleRegion.getLength()) {
            end = visibleRegion.getLength();
        }
        return new Region(start, end - start);
    }
}

