/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.DocumentAdapter;
import com.ibm.lpex.alef.LPEXMultiWindow;
import com.ibm.lpex.alef.LPEXView;
import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.alef.LpexHyperlinkManager;
import com.ibm.lpex.alef.LpexStickyHoverManager;
import com.ibm.lpex.alef.LpexTextSelection;
import com.ibm.lpex.alef.LpexTextViewerHoverManager;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexParser;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexViewListener;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.StyledTextContentLpexViewWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IAutoIndentStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentInformationMapping;
import org.eclipse.jface.text.IDocumentInformationMappingExtension2;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IEventConsumer;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextOperationTargetExtension;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension6;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.HyperlinkManager;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.projection.ChildDocument;
import org.eclipse.jface.text.projection.ChildDocumentManager;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;

public class LpexTextViewer
extends Viewer
implements ITextViewer,
ITextViewerExtension,
ITextViewerExtension4,
ITextViewerExtension6,
ITextViewerExtension8,
IEditingSupportRegistry,
ITextOperationTarget,
ITextOperationTargetExtension,
IWidgetTokenOwner,
IWidgetTokenOwnerExtension {
    public static final boolean TRACE_ERRORS = false;
    protected static final int SCROLLER = 1;
    protected static final int MOUSE = 2;
    protected static final int MOUSE_END = 3;
    protected static final int KEY = 4;
    protected static final int RESIZE = 5;
    protected static final int INTERNAL = 6;
    private IDocument fDocument;
    private IDocument fVisibleDocument;
    private DocumentAdapter fDocumentAdapter;
    private ISlaveDocumentManager fSlaveDocumentManager;
    private ViewportManager fViewportManager;
    private int fTextHeight = -1;
    private int fTopInset = 0;
    private VisibleDocumentListener fVisibleDocumentListener = new VisibleDocumentListener();
    private List<LpexTextViewerHoverManager> fTextHoverManager;
    private IWidgetTokenKeeper fWidgetTokenKeeper;
    private IRewriteTarget fRewriteTarget;
    private List<ISelectionChangedListener> fPostSelectionChangedListeners;
    private Set<IEditingSupport> fEditorHelpers = new HashSet<IEditingSupport>();
    protected Map<TextHoverKey, ITextHover> fTextHovers;
    protected int fLastTopPixel;
    protected List<ITextInputListener> fTextInputListeners;
    protected IInformationControlCreator fHoverControlCreator;
    protected IDocumentInformationMapping fInformationMapping;
    protected String fPartitioning;
    protected IHyperlinkDetector[] fHyperlinkDetectors;
    protected IHyperlinkPresenter fHyperlinkPresenter;
    protected LpexHyperlinkManager fHyperlinkManager;
    protected int fHyperlinkStateMask;
    private LPEXMultiWindow _lpexMultiWindow;
    private LpexWindow _lpexWindow;
    private LpexView _lpexView;
    private LpexWindow _activeWindow;
    private boolean _latestBlockInView;
    private int _latestCursorElement = 0;
    private int _latestCursorPosition = 0;
    private int _latestBlockTopElement;
    private int _latestBlockTopPosition;
    private int _latestBlockBottomElement;
    private int _latestBlockBottomPosition;
    static final String POPUP_VERTICAL_SPLIT = "popup.verticalSplit verticalSplit";
    static final String POPUP_HORIZONTAL_SPLIT = "popup.horizontalSplit horizontalSplit";
    ClassLoader _classLoader;
    private IEditorInput _editorInput;
    private String _readonly;
    IAnnotationModel _annotationModel;
    private boolean _documentChanging;
    StyledTextContentLpexViewWrapper stclw;

    protected LpexTextViewer() {
    }

    public LpexTextViewer(Composite parent, int styles) {
        this.createControl(parent, styles);
    }

    public LpexAbstractTextEditor getTextEditor() {
        return null;
    }

    protected DocumentAdapter createDocumentAdapter() {
        return new DocumentAdapter(this);
    }

    DocumentAdapter getDocumentAdapter() {
        return this.fDocumentAdapter;
    }

    protected void createControl(Composite parent, int styles) {
        this._lpexMultiWindow = new LPEXMultiWindow(parent, 0, this.getTextEditor());
        this._lpexView = new LPEXView(false);
        this._lpexView.addThemeChangeListener();
        this._lpexWindow = this._lpexMultiWindow.newWindow(this._lpexView, styles);
        this._lpexMultiWindow.addActiveWindowListener(lpexWindow -> this.activeWindowChanged(lpexWindow));
        this._lpexMultiWindow.addDisposeListener(e -> this.handleDispose());
        this.fTopInset = -this._lpexMultiWindow.computeTrim((int)0, (int)0, (int)0, (int)0).y - this._lpexWindow.computeTrim((int)0, (int)0, (int)0, (int)0).y;
        LpexView.setClassLoader(this._classLoader);
        this.initPrimaryLpexWindow(this._lpexWindow);
        this.initLpexView(this._lpexView);
    }

    public LpexView splitView(LpexView lpexView) {
        String element;
        LPEXView newLpexView = null;
        try {
            newLpexView = new LPEXView(lpexView, false);
        }
        catch (LpexView.ViewInstantiationException e) {
            return null;
        }
        LpexWindow newLpexWindow = this._lpexMultiWindow.newWindow(newLpexView, 2112);
        if (newLpexWindow == null) {
            newLpexView.dispose();
            return null;
        }
        this.initLpexView(newLpexView);
        this.initSecondaryLpexWindow(newLpexWindow);
        newLpexView.doDefaultCommand("updateProfile");
        String newParser = newLpexView.query("parser");
        if (newParser != null && newParser.equals(lpexView.query("parser"))) {
            newLpexView.doCommand("set includedClasses " + lpexView.query("includedClasses"));
            newLpexView.doCommand("set excludedClasses " + lpexView.query("excludedClasses"));
        }
        if ((element = lpexView.query("element")) != null) {
            newLpexView.doCommand("locate element " + element);
            newLpexView.doCommand("set cursorRow " + lpexView.query("cursorRow"));
            newLpexView.doCommand("set position " + lpexView.query("position"));
        }
        newLpexWindow.setFocus();
        return newLpexView;
    }

    void initLpexView(LpexView lpexView) {
        lpexView.addLpexViewListener(new LpexViewAdapter(){

            @Override
            public void updateProfile(LpexView view) {
                LpexTextViewer.this.handleUpdateProfile(view);
            }

            @Override
            public void shown(LpexView view) {
                LpexTextViewer.this.handleLpexViewShown(view);
            }

            @Override
            public void disposed(LpexView view) {
                LpexTextViewer.this.handleLpexViewDisposed(view);
            }
        });
        try {
            this.initializeLpexView(lpexView);
        }
        catch (Throwable e) {
            LpexLog.log(e);
        }
    }

    void handleLpexViewShown(LpexView lpexView) {
        if (lpexView != this.getActiveLpexView()) {
            return;
        }
        LpexDocumentLocation loc = lpexView.documentLocation();
        boolean selectionChanged = this._latestCursorElement != loc.element || this._latestCursorPosition != loc.position;
        boolean blockInView = lpexView.queryOn("block.inView");
        if (!selectionChanged) {
            boolean bl = selectionChanged = this._latestBlockInView != blockInView || blockInView && (this._latestBlockTopElement != lpexView.queryInt("block.topElement") || this._latestBlockTopPosition != lpexView.queryInt("block.topPosition") || this._latestBlockBottomElement != lpexView.queryInt("block.bottomElement") || this._latestBlockBottomPosition != lpexView.queryInt("block.bottomPosition"));
        }
        if (selectionChanged) {
            this._latestCursorElement = loc.element;
            this._latestCursorPosition = loc.position;
            this._latestBlockInView = blockInView;
            if (blockInView) {
                this._latestBlockTopElement = lpexView.queryInt("block.topElement");
                this._latestBlockTopPosition = lpexView.queryInt("block.topPosition");
                this._latestBlockBottomElement = lpexView.queryInt("block.bottomElement");
                this._latestBlockBottomPosition = lpexView.queryInt("block.bottomPosition");
            } else {
                this._latestBlockTopElement = 0;
            }
            Point p = this.getSelectedRange();
            this.selectionChanged(p.x, p.y);
        }
    }

    void handleLpexViewDisposed(LpexView lpexView) {
        if (this._lpexView == lpexView) {
            this._lpexView = null;
        }
    }

    void initPrimaryLpexWindow(LpexWindow lpexWindow) {
        this.addCommandLineHelpListener(lpexWindow);
    }

    void initSecondaryLpexWindow(LpexWindow lpexWindow) {
        this.addCommandLineHelpListener(lpexWindow);
        if (this.fHyperlinkManager != null) {
            this.fHyperlinkManager.install(lpexWindow);
        }
        this.installHoverControlManager(lpexWindow);
    }

    private void addCommandLineHelpListener(LpexWindow lpexWindow) {
        lpexWindow.commandLine().addHelpListener(e -> this.displayCommandLineHelp(null));
    }

    void displayCommandLineHelp(LpexView lpexView) {
        String help;
        Widget widget;
        if (lpexView == null) {
            lpexView = this.getLpexView();
        }
        if (lpexView != null && (widget = LpexUtilities.commandLineFocusWidget(lpexView)) != null && (help = (String)widget.getData("ID")) != null) {
            try {
                PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.lpex." + help);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Control getControl() {
        return this._lpexMultiWindow;
    }

    public void activatePlugins() {
        this.ensureHoverControlManagerInstalled();
        this.ensureHyperlinkManagerInstalled();
    }

    private void ensureHoverControlManagerInstalled() {
        if (this.fTextHovers != null && !this.fTextHovers.isEmpty() && this.fHoverControlCreator != null && this.fTextHoverManager == null) {
            this.fTextHoverManager = new ArrayList<LpexTextViewerHoverManager>();
            this.installHoverControlManager(this.getLpexWindow());
        }
    }

    private void installHoverControlManager(LpexWindow lpexWindow) {
        LpexTextViewerHoverManager textHoverManager = new LpexTextViewerHoverManager(this, lpexWindow, this.fHoverControlCreator);
        this.fTextHoverManager.add(textHoverManager);
        textHoverManager.install((Control)lpexWindow.textWindow());
        textHoverManager.getInternalAccessor().setInformationControlReplacer((InformationControlReplacer)new LpexStickyHoverManager(this, textHoverManager));
    }

    public void resetPlugins() {
    }

    protected void handleDispose() {
        this.setDocument(null);
        this.removeViewPortUpdate();
        if (this.fTextInputListeners != null) {
            this.fTextInputListeners.clear();
            this.fTextInputListeners = null;
        }
        if (this.fPostSelectionChangedListeners != null) {
            this.fPostSelectionChangedListeners.clear();
            this.fPostSelectionChangedListeners = null;
        }
        if (this.fTextHovers != null) {
            this.fTextHovers.clear();
            this.fTextHovers = null;
        }
        if (this.fTextHoverManager != null) {
            for (LpexTextViewerHoverManager textHoverManager : this.fTextHoverManager) {
                textHoverManager.dispose();
            }
            this.fTextHoverManager = null;
        }
        if (this.fVisibleDocumentListener != null) {
            if (this.fVisibleDocument != null) {
                this.fVisibleDocument.removeDocumentListener((IDocumentListener)this.fVisibleDocumentListener);
            }
            this.fVisibleDocumentListener = null;
        }
        if (this.fDocumentAdapter != null) {
            this.fDocumentAdapter.setEclipseDocument(null);
            this.fDocumentAdapter.setLpexView(null);
            this.fDocumentAdapter = null;
        }
        if (this.fSlaveDocumentManager != null) {
            if (this.fVisibleDocument != null) {
                this.fSlaveDocumentManager.freeSlaveDocument(this.fVisibleDocument);
            }
            this.fSlaveDocumentManager = null;
        }
        if (this.fHyperlinkManager != null) {
            this.fHyperlinkManager.uninstall();
            this.fHyperlinkManager = null;
        }
        this.fHyperlinkDetectors = null;
        this.fVisibleDocument = null;
        this.fDocument = null;
        if (this._lpexView != null) {
            this._lpexView.dispose();
        }
        this._lpexView = null;
        this._lpexWindow = null;
        this._activeWindow = null;
        this._lpexMultiWindow = null;
    }

    public StyledText getTextWidget() {
        if (this.stclw == null) {
            this.stclw = new StyledTextContentLpexViewWrapper(this);
        }
        return this.stclw.styledText();
    }

    public void setAutoIndentStrategy(IAutoIndentStrategy strategy, String contentType) {
    }

    protected final void setAutoEditStrategies(IAutoEditStrategy[] strategies, String contentType) {
    }

    public void prependAutoEditStrategy(IAutoEditStrategy strategy, String contentType) {
    }

    public void removeAutoEditStrategy(IAutoEditStrategy strategy, String contentType) {
    }

    public void setEventConsumer(IEventConsumer consumer) {
    }

    public void setIndentPrefixes(String[] indentPrefixes, String contentType) {
    }

    public int getTopInset() {
        return this.fTopInset;
    }

    public boolean isEditable() {
        return this._lpexView != null && !this._lpexView.queryOn("readonly");
    }

    public void setEditable(boolean editable) {
        if (!editable) {
            this._readonly = "on";
            if (this._lpexView != null) {
                this._lpexView.doCommand("set readonly " + this._readonly);
            }
        } else {
            this._readonly = null;
        }
    }

    public void setDefaultPrefixes(String[] defaultPrefixes, String contentType) {
    }

    public void setUndoManager(IUndoManager undoManager) {
    }

    public IUndoManager getUndoManager() {
        return null;
    }

    public void setTextHover(ITextHover hover, String contentType) {
        this.setTextHover(hover, contentType, 255);
    }

    public void setTextHover(ITextHover hover, String contentType, int stateMask) {
        TextHoverKey key = new TextHoverKey(contentType, stateMask);
        if (hover != null) {
            if (this.fTextHovers == null) {
                this.fTextHovers = new HashMap<TextHoverKey, ITextHover>();
            }
            this.fTextHovers.put(key, hover);
        } else if (this.fTextHovers != null) {
            this.fTextHovers.remove(key);
        }
        this.ensureHoverControlManagerInstalled();
    }

    public void removeTextHovers(String contentType) {
        if (this.fTextHovers == null) {
            return;
        }
        for (TextHoverKey key : new HashSet<TextHoverKey>(this.fTextHovers.keySet())) {
            if (!key.fContentType.equals(contentType)) continue;
            this.fTextHovers.remove(key);
        }
    }

    protected ITextHover getTextHover(int offset) {
        return this.getTextHover(offset, 255);
    }

    protected ITextHover getTextHover(int offset, int stateMask) {
        LpexParser parser;
        if (this.fTextHovers == null) {
            return null;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        Object textHover = null;
        try {
            String type = TextUtilities.getContentType((IDocument)document, (String)this.getDocumentPartitioning(), (int)offset, (boolean)true);
            textHover = this.getTextHoverForContentType(type, stateMask);
        }
        catch (BadLocationException type) {
            // empty catch block
        }
        if (textHover == null && this._lpexView != null && (parser = this._lpexView.parser()) != null && parser instanceof LpexCommonParser) {
            String type;
            LpexDocumentLocation loc = this.getLpexDocumentLocation(offset);
            String subType = ((LpexCommonParser)parser).getLanguage(loc);
            if (subType != null) {
                textHover = this.getTextHoverForContentType(subType, stateMask);
            }
            if (textHover == null && (type = ((LpexCommonParser)parser).getLanguage()) != null && !type.equals(subType)) {
                textHover = this.getTextHoverForContentType(type, stateMask);
            }
        }
        return (ITextHover)textHover;
    }

    private Object getTextHoverForContentType(String type, int stateMask) {
        TextHoverKey key = new TextHoverKey(type, stateMask);
        ITextHover textHover = this.fTextHovers.get(key);
        if (textHover == null) {
            key.setStateMask(255);
            textHover = this.fTextHovers.get(key);
        }
        return textHover;
    }

    protected AbstractInformationControlManager getTextHoveringController() {
        if (this.fTextHoverManager != null && this.fTextHoverManager.size() > 0) {
            return (AbstractInformationControlManager)this.fTextHoverManager.get(0);
        }
        return null;
    }

    public void setHoverControlCreator(IInformationControlCreator creator) {
        this.fHoverControlCreator = creator;
    }

    public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
        if (this._lpexView != null) {
            if (this.fWidgetTokenKeeper != null) {
                if (this.fWidgetTokenKeeper == requester) {
                    return true;
                }
                if (this.fWidgetTokenKeeper.requestWidgetToken((IWidgetTokenOwner)this)) {
                    this.fWidgetTokenKeeper = requester;
                    return true;
                }
            } else {
                this.fWidgetTokenKeeper = requester;
                return true;
            }
        }
        return false;
    }

    public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
        if (this._lpexView != null) {
            if (this.fWidgetTokenKeeper != null) {
                if (this.fWidgetTokenKeeper == requester) {
                    return true;
                }
                boolean accepted = false;
                if (this.fWidgetTokenKeeper instanceof IWidgetTokenKeeperExtension) {
                    IWidgetTokenKeeperExtension extension = (IWidgetTokenKeeperExtension)this.fWidgetTokenKeeper;
                    accepted = extension.requestWidgetToken((IWidgetTokenOwner)this, priority);
                } else {
                    accepted = this.fWidgetTokenKeeper.requestWidgetToken((IWidgetTokenOwner)this);
                }
                if (accepted) {
                    this.fWidgetTokenKeeper = requester;
                    return true;
                }
            } else {
                this.fWidgetTokenKeeper = requester;
                return true;
            }
        }
        return false;
    }

    public void releaseWidgetToken(IWidgetTokenKeeper tokenKeeper) {
        if (this.fWidgetTokenKeeper == tokenKeeper) {
            this.fWidgetTokenKeeper = null;
        }
    }

    public Point getSelectedRange() {
        LpexView lpexView = this.getActiveLpexView();
        if (lpexView != null && this.fDocumentAdapter != null) {
            LpexDocumentLocation loc = lpexView.documentLocation();
            if (loc.element > 0) {
                int end;
                int start;
                if (lpexView.queryOn("block.inView")) {
                    int linesBeforeStart = lpexView.linesBeforeStart();
                    loc.element = lpexView.queryInt("block.topElement") - linesBeforeStart;
                    loc.position = lpexView.queryInt("block.topPosition");
                    start = this.fDocumentAdapter.getDocOffset(loc);
                    loc.element = lpexView.queryInt("block.bottomElement") - linesBeforeStart;
                    loc.position = lpexView.queryInt("block.bottomPosition");
                    if (!"stream".equals(lpexView.query("block.type"))) {
                        ++loc.position;
                    }
                    end = this.fDocumentAdapter.getDocOffset(loc);
                } else {
                    end = start = this.fDocumentAdapter.getDocOffset(loc);
                }
                if (start != -1 && end != -1) {
                    return new Point(start, end - start);
                }
            }
        }
        return new Point(-1, -1);
    }

    public void setSelectedRange(int selectionOffset, int selectionLength) {
        LpexView lpexView = this.getActiveLpexView();
        if (lpexView == null || this.fDocumentAdapter == null) {
            return;
        }
        IRegion widgetSelection = this.modelRange2ClosestWidgetRange((IRegion)new Region(selectionOffset, selectionLength));
        if (widgetSelection == null) {
            return;
        }
        int[] selectionRange = new int[]{widgetSelection.getOffset(), widgetSelection.getLength()};
        this.validateSelectionRange(selectionRange);
        if (selectionRange[0] < 0) {
            return;
        }
        LpexDocumentLocation startLocation = this.getLpexDocumentLocation(selectionRange[0]);
        if (selectionRange[1] == 0) {
            lpexView.doCommand("block clear");
            lpexView.jump(startLocation);
            lpexView.doCommand("screenShow view");
        } else {
            LpexDocumentLocation endLocation = this.getLpexDocumentLocation(selectionRange[0] + selectionRange[1]);
            lpexView.doCommand("block clear");
            lpexView.doCommand(startLocation, "block set");
            if (!"stream".equals(lpexView.query("current.block.defaultType"))) {
                --endLocation.position;
            }
            lpexView.jump(endLocation);
            lpexView.doCommand("block set");
            lpexView.doCommand("screenShow");
        }
        this.selectionChanged(selectionRange[0], selectionRange[1]);
    }

    public int getCurrentOffset() {
        LpexView lpexView = this.getActiveLpexView();
        if (lpexView != null && this.fDocumentAdapter != null) {
            LpexDocumentLocation loc = lpexView.documentLocation();
            if (loc.element > 0) {
                return this.fDocumentAdapter.getDocOffset(loc);
            }
        }
        return -1;
    }

    protected void validateSelectionRange(int[] selectionRange) {
        int delta;
        IDocument document = this.getVisibleDocument();
        if (document == null) {
            selectionRange[0] = -1;
            selectionRange[1] = -1;
            return;
        }
        int documentLength = document.getLength();
        int offset = selectionRange[0];
        int length = selectionRange[1];
        if (length < 0) {
            length = -length;
            offset -= length;
        }
        if (offset < 0) {
            offset = 0;
        }
        if (offset > documentLength) {
            offset = documentLength;
        }
        if ((delta = offset + length - documentLength) > 0) {
            length -= delta;
        }
        try {
            int end;
            int lineNumber = document.getLineOfOffset(offset);
            IRegion lineInformation = document.getLineInformation(lineNumber);
            int lineEnd = lineInformation.getOffset() + lineInformation.getLength();
            delta = offset - lineEnd;
            if (delta > 0) {
                offset = lineEnd;
                length += delta;
                String delimiter = document.getLineDelimiter(lineNumber);
                if (delimiter != null) {
                    int delimiterLength = delimiter.length();
                    offset += delimiterLength;
                    length -= delimiterLength;
                }
            }
            if ((delta = (end = offset + length) - (lineEnd = (lineInformation = document.getLineInformationOfOffset(end)).getOffset() + lineInformation.getLength())) > 0) {
                length -= delta;
            }
        }
        catch (BadLocationException x) {
            selectionRange[0] = -1;
            selectionRange[1] = -1;
            return;
        }
        if (selectionRange[1] < 0) {
            selectionRange[0] = offset + length;
            selectionRange[1] = -length;
        } else {
            selectionRange[0] = offset;
            selectionRange[1] = length;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        if (selection instanceof ITextSelection) {
            ITextSelection s = (ITextSelection)selection;
            this.setSelectedRange(s.getOffset(), s.getLength());
            if (reveal) {
                this.revealRange(s.getOffset(), s.getLength());
            }
        }
    }

    public ISelection getSelection() {
        Point p = null;
        try {
            p = this.getSelectedRange();
        }
        catch (Exception e) {
            if (!this._documentChanging) {
                LpexLog.log(e);
            }
            return LpexTextSelection.emptySelection();
        }
        if (p.x == -1 || p.y == -1) {
            return LpexTextSelection.emptySelection();
        }
        return new LpexTextSelection(this.getActiveLpexView(), this.getDocument(), p.x, p.y);
    }

    public ISelectionProvider getSelectionProvider() {
        return this;
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fPostSelectionChangedListeners == null) {
            this.fPostSelectionChangedListeners = new ArrayList<ISelectionChangedListener>();
        }
        if (!this.fPostSelectionChangedListeners.contains(listener)) {
            this.fPostSelectionChangedListeners.add(listener);
        }
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fPostSelectionChangedListeners != null) {
            this.fPostSelectionChangedListeners.remove(listener);
            if (this.fPostSelectionChangedListeners.size() == 0) {
                this.fPostSelectionChangedListeners = null;
            }
        }
    }

    protected void selectionChanged(int offset, int len) {
        this.fireSelectionChanged(offset, len);
    }

    protected void fireSelectionChanged(int offset, int len) {
        LpexTextSelection selection = new LpexTextSelection(this._lpexView, this.getDocument(), this._getVisibleRegionOffset() + offset, len);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection);
        this.fireSelectionChanged(event);
    }

    public void addTextListener(ITextListener listener) {
    }

    public void removeTextListener(ITextListener listener) {
    }

    public void addTextInputListener(ITextInputListener listener) {
        if (listener != null) {
            if (this.fTextInputListeners == null) {
                this.fTextInputListeners = new ArrayList<ITextInputListener>();
            }
            if (!this.fTextInputListeners.contains(listener)) {
                this.fTextInputListeners.add(listener);
            }
        }
    }

    public void removeTextInputListener(ITextInputListener listener) {
        if (listener != null && this.fTextInputListeners != null) {
            this.fTextInputListeners.remove(listener);
            if (this.fTextInputListeners.size() == 0) {
                this.fTextInputListeners = null;
            }
        }
    }

    protected void fireInputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        List<ITextInputListener> listener = this.fTextInputListeners;
        if (listener != null) {
            int i = 0;
            while (i < listener.size()) {
                ITextInputListener l = listener.get(i);
                l.inputDocumentAboutToBeChanged(oldInput, newInput);
                ++i;
            }
        }
    }

    protected void fireInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        List<ITextInputListener> listener = this.fTextInputListeners;
        if (listener != null) {
            int i = 0;
            while (i < listener.size()) {
                ITextInputListener l = listener.get(i);
                l.inputDocumentChanged(oldInput, newInput);
                ++i;
            }
        }
    }

    public Object getInput() {
        return this.getDocument();
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public void setInput(Object input) {
        IDocument document = null;
        if (input instanceof IDocument) {
            document = (IDocument)input;
        }
        this.setDocument(document);
    }

    public void setDocument(IDocument document) {
        this.fireInputDocumentAboutToBeChanged(this.fDocument, document);
        this._documentChanging = true;
        IDocument oldDocument = this.fDocument;
        this.fDocument = document;
        this.setVisibleDocument(this.fDocument);
        this.resetPlugins();
        this.inputChanged(this.fDocument, oldDocument);
        this._documentChanging = false;
        this.fireInputDocumentChanged(oldDocument, this.fDocument);
    }

    public void setDocument(IDocument document, int modelRangeOffset, int modelRangeLength) {
        this.fireInputDocumentAboutToBeChanged(this.fDocument, document);
        IDocument oldDocument = this.fDocument;
        this.fDocument = document;
        try {
            IDocument slaveDocument = this.createSlaveDocument(document);
            this.updateSlaveDocument(slaveDocument, modelRangeOffset, modelRangeLength);
            this.setVisibleDocument(slaveDocument);
        }
        catch (BadLocationException x) {
            throw new IllegalArgumentException(JFaceTextMessages.getString("TextViewer.error.invalid_visible_region_1"));
        }
        this.resetPlugins();
        this.inputChanged(this.fDocument, oldDocument);
        this.fireInputDocumentChanged(oldDocument, this.fDocument);
    }

    protected IDocument createSlaveDocument(IDocument document) {
        ISlaveDocumentManager manager = this.getSlaveDocumentManager();
        if (manager.isSlaveDocument(document)) {
            return document;
        }
        return manager.createSlaveDocument(document);
    }

    @Deprecated
    private boolean updateVisibleDocument(IDocument visibleDocument, int visibleRegionOffset, int visibleRegionLength) throws BadLocationException {
        if (visibleDocument instanceof ChildDocument) {
            ChildDocument childDocument = (ChildDocument)visibleDocument;
            IDocument document = childDocument.getParentDocument();
            int line = document.getLineOfOffset(visibleRegionOffset);
            int offset = document.getLineOffset(line);
            int length = visibleRegionOffset - offset + visibleRegionLength;
            Position parentRange = childDocument.getParentDocumentRange();
            if (offset != parentRange.getOffset() || length != parentRange.getLength()) {
                childDocument.setParentDocumentRange(offset, length);
                return true;
            }
        }
        return false;
    }

    protected boolean updateSlaveDocument(IDocument slaveDocument, int modelRangeOffset, int modelRangeLength) throws BadLocationException {
        return this.updateVisibleDocument(slaveDocument, modelRangeOffset, modelRangeLength);
    }

    private void initializeViewportUpdate() {
        this.fViewportManager = new ViewportManager();
        this.fViewportManager.addViewport(this.getActiveLpexWindow());
        this.fLastTopPixel = -1;
    }

    private void removeViewPortUpdate() {
        this.fViewportManager.removeViewport(this.getActiveLpexWindow());
        if (this.fViewportManager.isEmpty()) {
            this.fViewportManager = null;
        }
    }

    public void addViewportListener(IViewportListener listener) {
        Viewport viewport;
        if (this.fViewportManager == null) {
            this.initializeViewportUpdate();
        }
        if ((viewport = this.fViewportManager.addViewport(this.getActiveLpexWindow())) != null) {
            viewport.addViewportListener(listener);
        }
    }

    public void removeViewportListener(IViewportListener listener) {
        Viewport viewport;
        if (this.fViewportManager != null && (viewport = this.fViewportManager.getViewport(this.getActiveLpexWindow())) != null) {
            viewport.removeViewportListener(listener);
        }
    }

    protected void updateViewportListeners(int origin) {
        int topPixel = this.getTopPixel();
        if (topPixel >= 0 && topPixel != this.fLastTopPixel) {
            Viewport viewport;
            if (this.fViewportManager != null && (viewport = this.fViewportManager.getViewport(this.getActiveLpexWindow())) != null) {
                viewport.updateToViewportListeners(topPixel);
            }
            this.fLastTopPixel = topPixel;
        }
    }

    public int getTopPixel() {
        int linePixel;
        int lineHeight;
        int topIndex = this.getTopIndex();
        int verticalScrollOffset = topIndex * (lineHeight = this.getLineHeight()) - (linePixel = this.getLinePixel(topIndex));
        verticalScrollOffset = verticalScrollOffset < 0 ? 0 : verticalScrollOffset;
        return verticalScrollOffset < 0 ? 0 : verticalScrollOffset;
    }

    int getLinePixel(int lineIndex) {
        int lineCount = this.getLineCount();
        int lineIndex2 = lineCount < lineIndex ? lineCount : lineIndex;
        lineIndex2 = lineIndex > 0 ? lineIndex : 0;
        int lineHeight = this.getLineHeight();
        int topMargin = this.getTopMargin();
        int topIndex = this.getTopIndex();
        int linePixel = ((lineIndex2 - topIndex) * lineHeight + topMargin) / 2;
        return linePixel < 0 ? 0 : linePixel;
    }

    public int getLineCount() {
        IDocument doc = this.getDocument();
        return doc == null ? 0 : doc.getNumberOfLines();
    }

    public int getLineHeight() {
        if (this.fTextHeight == -1) {
            GC g = new GC((Drawable)this._lpexWindow);
            g.setFont(this._lpexWindow.getFont());
            FontMetrics fontMetrics = g.getFontMetrics();
            if (fontMetrics != null) {
                int baseline = fontMetrics.getAscent() + fontMetrics.getLeading();
                this.fTextHeight = baseline + fontMetrics.getDescent();
            } else {
                this.fTextHeight = 0;
            }
            g.dispose();
        }
        return this.fTextHeight;
    }

    public int getLineIndex(int pixel) {
        int topPixel = this.getTopPixel();
        int topMargin = this.getTopMargin();
        int lineHeight = this.getLineHeight();
        int lineIndex = (pixel - topMargin + topPixel) / lineHeight;
        int lineCount = this.getLineCount();
        lineIndex = lineCount < lineIndex ? lineCount : lineIndex;
        lineIndex = lineIndex > 0 ? lineIndex : 0;
        return lineIndex;
    }

    public int getTopMargin() {
        return 2;
    }

    public int getTopIndex() {
        int element;
        if (this._lpexView != null && (element = this._lpexView.elementOfRow(1)) != 0) {
            int top = this._lpexView.lineOfElement(element) - 1;
            return this.widgetLine2ModelLine(top);
        }
        return 0;
    }

    public void setTopIndex(int index) {
        if (this._lpexView != null && index >= 0) {
            int widgetLine = this.modelLine2WidgetLine(index);
            if (widgetLine == -1) {
                widgetLine = this.getClosestWidgetLineForModelLine(index);
            }
            if (widgetLine > -1) {
                this._lpexView.doCommand("locate line " + (widgetLine + 1 + this._lpexView.linesBeforeStart()));
                this._lpexView.triggerAction(184);
                this.updateViewportListeners(6);
            }
        }
    }

    @Deprecated
    protected int getVisibleLinesInViewport() {
        return this._lpexView != null ? this._lpexView.queryInt("rows") : -1;
    }

    public int getBottomIndex() {
        if (this._lpexView != null) {
            int element = this._lpexView.elementOfRow(this._lpexView.queryInt("rows"));
            if (element != 0) {
                return this._lpexView.lineOfElement(element) - 1;
            }
            if (this._lpexView.elementOfRow(1) != 0) {
                return this._lpexView.queryInt("lines") - (this._lpexView.linesBeforeStart() + this._lpexView.linesAfterEnd()) - 1;
            }
        }
        return -1;
    }

    public int getTopIndexStartOffset() {
        int top = this.getTopIndex();
        try {
            top = this.getVisibleDocument().getLineOffset(top);
            return this.widgetOffset2ModelOffset(top);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int getBottomIndexEndOffset() {
        IRegion coverage;
        int bottomEndOffset;
        block3: {
            try {
                IRegion line = this.getDocument().getLineInformation(this.getBottomIndex());
                bottomEndOffset = line.getOffset() + line.getLength() - 1;
                coverage = this.getModelCoverage();
                if (coverage != null) break block3;
                return -1;
            }
            catch (BadLocationException ex) {
                return this.getDocument().getLength() - 1;
            }
        }
        int coverageEndOffset = coverage.getOffset() + coverage.getLength() - 1;
        return Math.min(coverageEndOffset, bottomEndOffset);
    }

    public void revealRange(int start, int len) {
        LpexView lpexView = this.getActiveLpexView();
        if (lpexView == null || this.fDocumentAdapter == null) {
            return;
        }
        LpexDocumentLocation begin = this.getLpexDocumentLocation(start);
        this.ensureVisible(lpexView, begin.element);
        if (len > lpexView.elementText(begin.element).length()) {
            LpexDocumentLocation end = this.getLpexDocumentLocation(start + len);
            this.ensureVisible(lpexView, end.element);
        }
    }

    void ensureVisible(LpexView lpexView, int element) {
        LpexDocumentLocation loc = new LpexDocumentLocation(element, 1);
        if (!lpexView.queryOn("visible", loc)) {
            while (--loc.element >= 1) {
                if (!lpexView.queryOn("visible", loc)) continue;
                lpexView.doCommand(loc, "set expanded on");
                return;
            }
            lpexView.doCommand("set topExpanded on");
        }
    }

    protected final int getAverageCharWidth(LpexWindow lpexWindow) {
        GC gc = new GC((Drawable)lpexWindow.textWindow());
        gc.setFont(lpexWindow.getLpexView().getFont());
        int increment = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        return increment;
    }

    public void refresh() {
        this.setDocument(this.getDocument());
    }

    protected ISlaveDocumentManager getSlaveDocumentManager() {
        if (this.fSlaveDocumentManager == null) {
            this.fSlaveDocumentManager = this.createSlaveDocumentManager();
        }
        return this.fSlaveDocumentManager;
    }

    protected ISlaveDocumentManager createSlaveDocumentManager() {
        return new ChildDocumentManager();
    }

    public final void invalidateTextPresentation() {
    }

    public final void invalidateTextPresentation(int offset, int length) {
    }

    private void initializeWidgetContents() {
        if (this._lpexView != null && this.fVisibleDocument != null) {
            if (this.fDocumentAdapter == null) {
                this.fDocumentAdapter = this.createDocumentAdapter();
            }
            this.fDocumentAdapter.setEclipseDocument(this.fVisibleDocument);
            if (this._editorInput != null) {
                this.setFileName();
            }
            this.fDocumentAdapter.setLpexView(this._lpexView);
            this.fDocumentAdapter.lpexSetText();
            try {
                this.widgetContentsSet(this._lpexView);
            }
            catch (Throwable e2) {
                LpexLog.log(e2);
            }
            this._lpexView.doDefaultCommand("updateProfile");
            this._lpexView.doDefaultCommand("screenShow document");
            this.addHelpListener(e -> this.performHelp(null));
        }
    }

    void performHelp(LpexView lpexView) {
    }

    void widgetContentsSet(LpexView lpexView) {
    }

    protected void freeSlaveDocument(IDocument slave) {
        ISlaveDocumentManager manager = this.getSlaveDocumentManager();
        if (manager != null && manager.isSlaveDocument(slave)) {
            manager.freeSlaveDocument(slave);
        }
    }

    protected void setVisibleDocument(IDocument document) {
        if (this.fVisibleDocument == document && this.fVisibleDocument instanceof ChildDocument) {
            return;
        }
        if (this.fVisibleDocument != null) {
            if (this.fVisibleDocumentListener != null) {
                this.fVisibleDocument.removeDocumentListener((IDocumentListener)this.fVisibleDocumentListener);
            }
            if (this.fVisibleDocument != document) {
                this.freeSlaveDocument(this.fVisibleDocument);
            }
        }
        this.fVisibleDocument = document;
        this.initializeDocumentInformationMapping(this.fVisibleDocument);
        this.initializeWidgetContents();
        if (this.fVisibleDocument != null && this.fVisibleDocumentListener != null) {
            this.fVisibleDocument.addDocumentListener((IDocumentListener)this.fVisibleDocumentListener);
        }
    }

    protected void handleVisibleDocumentAboutToBeChanged(DocumentEvent event) {
    }

    protected void handleVisibleDocumentChanged(DocumentEvent event) {
    }

    protected void initializeDocumentInformationMapping(IDocument visibleDocument) {
        ISlaveDocumentManager manager = this.getSlaveDocumentManager();
        this.fInformationMapping = manager.createMasterSlaveMapping(visibleDocument);
    }

    public IDocument getVisibleDocument() {
        return this.fVisibleDocument;
    }

    protected int _getVisibleRegionOffset() {
        return 0;
    }

    public IRegion getVisibleRegion() {
        IDocument document = this.getVisibleDocument();
        if (document instanceof ChildDocument) {
            Position p = ((ChildDocument)document).getParentDocumentRange();
            return new Region(p.getOffset(), p.getLength());
        }
        return new Region(0, document == null ? 0 : document.getLength());
    }

    public void setVisibleRegion(int start, int len) {
    }

    public void resetVisibleRegion() {
    }

    public boolean overlapsWithVisibleRegion(int start, int length) {
        return true;
    }

    public void setTextDoubleClickStrategy(ITextDoubleClickStrategy strategy, String contentType) {
    }

    protected Object selectContentTypePlugin(int offset, Map<?, ?> plugins) {
        LpexParser parser;
        Object plugin = null;
        try {
            plugin = this.selectContentTypePlugin(TextUtilities.getContentType((IDocument)this.getDocument(), (String)this.getDocumentPartitioning(), (int)offset, (boolean)true), plugins);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (plugin == null && this._lpexView != null && (parser = this._lpexView.parser()) != null && parser instanceof LpexCommonParser) {
            String language;
            LpexDocumentLocation loc = this.getLpexDocumentLocation(offset);
            String subLanguage = ((LpexCommonParser)parser).getLanguage(loc);
            if (subLanguage != null) {
                plugin = this.selectContentTypePlugin(subLanguage, plugins);
            }
            if (plugin == null && (language = ((LpexCommonParser)parser).getLanguage()) != null && !language.equals(subLanguage)) {
                plugin = this.selectContentTypePlugin(language, plugins);
            }
        }
        return plugin;
    }

    private Object selectContentTypePlugin(String type, Map<?, ?> plugins) {
        return plugins == null ? null : plugins.get(type);
    }

    public boolean canDoOperation(int operation) {
        LpexView lpexView = this.getLpexView();
        return lpexView != null ? lpexView.actionAvailable(operation) : false;
    }

    public void doOperation(int operation) {
        LpexView lpexView = this.getLpexView();
        if (lpexView != null) {
            lpexView.triggerAction(operation);
        }
    }

    public void enableOperation(int operation, boolean enable) {
    }

    public void setTextColor(Color color) {
    }

    public void setTextColor(Color color, int start, int length, boolean controlRedraw) {
    }

    protected IRegion _internalGetVisibleRegion() {
        return null;
    }

    public void changeTextPresentation(TextPresentation presentation, boolean controlRedraw) {
    }

    public IFindReplaceTarget getFindReplaceTarget() {
        return null;
    }

    public ITextOperationTarget getTextOperationTarget() {
        return this;
    }

    public void appendVerifyKeyListener(VerifyKeyListener listener) {
    }

    public void prependVerifyKeyListener(VerifyKeyListener listener) {
    }

    public void removeVerifyKeyListener(VerifyKeyListener listener) {
    }

    public int getMark() {
        return -1;
    }

    public void setMark(int offset) {
    }

    public final void setRedraw(boolean redraw) {
    }

    protected final void setRedraw(boolean redraw, int topIndex) {
    }

    protected final boolean redraws() {
        return true;
    }

    public IRewriteTarget getRewriteTarget() {
        if (this.fRewriteTarget == null) {
            this.fRewriteTarget = new RewriteTarget();
        }
        return this.fRewriteTarget;
    }

    public ITextHover getCurrentTextHover() {
        if (this.fTextHoverManager != null) {
            for (LpexTextViewerHoverManager textHoverManager : this.fTextHoverManager) {
                ITextHover hover = textHoverManager.getCurrentTextHover();
                if (hover == null) continue;
                return hover;
            }
        }
        return null;
    }

    public Point getHoverEventLocation() {
        if (this.fTextHoverManager != null) {
            for (LpexTextViewerHoverManager textHoverManager : this.fTextHoverManager) {
                Point p = textHoverManager.getHoverEventLocation();
                if (p == null) continue;
                return p;
            }
        }
        return null;
    }

    public int modelLine2WidgetLine(int modelLine) {
        if (this.fInformationMapping == null) {
            return modelLine;
        }
        try {
            return this.fInformationMapping.toImageLine(modelLine);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int modelOffset2WidgetOffset(int modelOffset) {
        if (this.fInformationMapping == null) {
            return modelOffset;
        }
        try {
            return this.fInformationMapping.toImageOffset(modelOffset);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public IRegion modelRange2WidgetRange(IRegion modelRange) {
        if (this.fInformationMapping == null) {
            return modelRange;
        }
        try {
            Region reversed;
            IRegion result;
            if (modelRange.getLength() < 0 && (result = this.fInformationMapping.toImageRegion((IRegion)(reversed = new Region(modelRange.getOffset() + modelRange.getLength(), -modelRange.getLength())))) != null) {
                return new Region(result.getOffset() + result.getLength(), -result.getLength());
            }
            return this.fInformationMapping.toImageRegion(modelRange);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected IRegion modelRange2ClosestWidgetRange(IRegion modelRange) {
        if (!(this.fInformationMapping instanceof IDocumentInformationMappingExtension2)) {
            return this.modelRange2WidgetRange(modelRange);
        }
        try {
            Region reversed;
            IRegion result;
            if (modelRange.getLength() < 0 && (result = ((IDocumentInformationMappingExtension2)this.fInformationMapping).toClosestImageRegion((IRegion)(reversed = new Region(modelRange.getOffset() + modelRange.getLength(), -modelRange.getLength())))) != null) {
                return new Region(result.getOffset() + result.getLength(), -result.getLength());
            }
            return ((IDocumentInformationMappingExtension2)this.fInformationMapping).toClosestImageRegion(modelRange);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int widgetlLine2ModelLine(int widgetLine) {
        return this.widgetLine2ModelLine(widgetLine);
    }

    public int widgetLine2ModelLine(int widgetLine) {
        if (this.fInformationMapping == null) {
            return widgetLine;
        }
        try {
            return this.fInformationMapping.toOriginLine(widgetLine);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public int widgetOffset2ModelOffset(int widgetOffset) {
        if (this.fInformationMapping == null) {
            return widgetOffset;
        }
        try {
            return this.fInformationMapping.toOriginOffset(widgetOffset);
        }
        catch (BadLocationException x) {
            if (widgetOffset == this.getVisibleDocument().getLength()) {
                IRegion coverage = this.fInformationMapping.getCoverage();
                return coverage.getOffset() + coverage.getLength();
            }
            return -1;
        }
    }

    public IRegion widgetRange2ModelRange(IRegion widgetRange) {
        if (this.fInformationMapping == null) {
            return widgetRange;
        }
        try {
            if (widgetRange.getLength() < 0) {
                Region reveresed = new Region(widgetRange.getOffset() + widgetRange.getLength(), -widgetRange.getLength());
                IRegion result = this.fInformationMapping.toOriginRegion((IRegion)reveresed);
                return new Region(result.getOffset() + result.getLength(), -result.getLength());
            }
            return this.fInformationMapping.toOriginRegion(widgetRange);
        }
        catch (BadLocationException x) {
            int modelEndOffset;
            int modelOffset = this.widgetOffset2ModelOffset(widgetRange.getOffset());
            if (modelOffset > -1 && (modelEndOffset = this.widgetOffset2ModelOffset(widgetRange.getOffset() + widgetRange.getLength())) > -1) {
                return new Region(modelOffset, modelEndOffset - modelOffset);
            }
            return null;
        }
    }

    public IRegion getModelCoverage() {
        if (this.fInformationMapping == null) {
            IDocument document = this.getDocument();
            return document == null ? null : new Region(0, document.getLength());
        }
        return this.fInformationMapping.getCoverage();
    }

    protected int getClosestWidgetLineForModelLine(int modelLine) {
        if (this.fInformationMapping == null) {
            return modelLine;
        }
        try {
            return this.fInformationMapping.toClosestImageLine(modelLine);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    protected IRegion modelRange2WidgetRange(Position modelPosition) {
        return this.modelRange2WidgetRange((IRegion)new Region(modelPosition.getOffset(), modelPosition.getLength()));
    }

    protected Point widgetSelection2ModelSelection(Point widgetSelection) {
        Region region = new Region(widgetSelection.x, widgetSelection.y);
        return (region = this.widgetRange2ModelRange((IRegion)region)) == null ? null : new Point(region.getOffset(), region.getLength());
    }

    protected Point modelSelection2WidgetSelection(Point modelSelection) {
        if (this.fInformationMapping == null) {
            return modelSelection;
        }
        try {
            Region region = new Region(modelSelection.x, modelSelection.y);
            region = this.fInformationMapping.toImageRegion((IRegion)region);
            if (region != null) {
                return new Point(region.getOffset(), region.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public int widgetLineOfWidgetOffset(int widgetOffset) {
        IDocument document = this.getVisibleDocument();
        if (document != null) {
            try {
                return document.getLineOfOffset(widgetOffset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return -1;
    }

    public boolean moveFocusToWidgetToken() {
        if (this.fWidgetTokenKeeper instanceof IWidgetTokenKeeperExtension) {
            IWidgetTokenKeeperExtension extension = (IWidgetTokenKeeperExtension)this.fWidgetTokenKeeper;
            return extension.setFocus((IWidgetTokenOwner)this);
        }
        return false;
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fPartitioning = partitioning;
    }

    protected String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    public void addTextPresentationListener(ITextPresentationListener listener) {
        if (this.stclw == null) {
            this.stclw = new StyledTextContentLpexViewWrapper(this);
        }
        this.stclw.addTextPresentationListener(listener);
    }

    public void removeTextPresentationListener(ITextPresentationListener listener) {
        if (this.stclw != null) {
            this.stclw.removeTextPresentationListener(listener);
        }
    }

    public void register(IEditingSupport helper) {
        Assert.isLegal((helper != null ? 1 : 0) != 0);
        this.fEditorHelpers.add(helper);
    }

    public void unregister(IEditingSupport helper) {
        this.fEditorHelpers.remove(helper);
    }

    public IEditingSupport[] getRegisteredSupports() {
        return this.fEditorHelpers.toArray(new IEditingSupport[this.fEditorHelpers.size()]);
    }

    public void setHyperlinkDetectors(IHyperlinkDetector[] hyperlinkDetectors, int eventStateMask) {
        if (this.fHyperlinkDetectors != null) {
            int i = 0;
            while (i < this.fHyperlinkDetectors.length) {
                if (this.fHyperlinkDetectors[i] instanceof IHyperlinkDetectorExtension) {
                    ((IHyperlinkDetectorExtension)this.fHyperlinkDetectors[i]).dispose();
                }
                ++i;
            }
        }
        boolean enable = hyperlinkDetectors != null && hyperlinkDetectors.length > 0;
        this.fHyperlinkStateMask = eventStateMask;
        this.fHyperlinkDetectors = null;
        if (hyperlinkDetectors != null) {
            this.fHyperlinkDetectors = new IHyperlinkDetector[hyperlinkDetectors.length];
            System.arraycopy(hyperlinkDetectors, 0, this.fHyperlinkDetectors, 0, hyperlinkDetectors.length);
        }
        if (enable) {
            if (this.fHyperlinkManager != null) {
                this.fHyperlinkManager.setHyperlinkDetectors(this.fHyperlinkDetectors);
                this.fHyperlinkManager.setHyperlinkStateMask(this.fHyperlinkStateMask);
            }
            this.ensureHyperlinkManagerInstalled();
        } else {
            if (this.fHyperlinkManager != null) {
                this.fHyperlinkManager.uninstall();
            }
            this.fHyperlinkManager = null;
        }
    }

    public void setHyperlinkPresenter(IHyperlinkPresenter hyperlinkPresenter) throws IllegalStateException {
        if (this.fHyperlinkManager != null) {
            throw new IllegalStateException();
        }
        this.fHyperlinkPresenter = hyperlinkPresenter;
        this.ensureHyperlinkManagerInstalled();
    }

    private void ensureHyperlinkManagerInstalled() {
        if (this.fHyperlinkDetectors != null && this.fHyperlinkDetectors.length > 0 && this.fHyperlinkPresenter != null && this.fHyperlinkManager == null) {
            this.fHyperlinkManager = new LpexHyperlinkManager(HyperlinkManager.FIRST);
            this.fHyperlinkManager.install(this, this.fHyperlinkPresenter, this.fHyperlinkDetectors, this.fHyperlinkStateMask);
        }
    }

    protected void initializeLpexView(LpexView lpexView) {
    }

    private void handleUpdateProfile(LpexView lpexView) {
        if (this._readonly != null) {
            lpexView.doCommand("set readonly " + this._readonly);
        }
        try {
            this.updateProfile(lpexView);
        }
        catch (Throwable e) {
            LpexLog.log(e);
        }
        if (lpexView.queryOn("current.multipleViews")) {
            StringBuilder viewPopup = new StringBuilder(1440);
            viewPopup.append("set popup ").append(lpexView.query("current.popup")).append(" beginSubmenu popup.viewMenu popup.openNewView openNewView");
            if (lpexView.queryOn("current.splitWindow") || this._lpexMultiWindow.getWindows().length > 1) {
                viewPopup.append(" popup.nextView nextView popup.prevView prevView separator ").append("horizontal".equals(lpexView.query("current.splitWindow.orientation")) ? POPUP_VERTICAL_SPLIT : POPUP_HORIZONTAL_SPLIT);
                if (lpexView != this.getFirstLpexView()) {
                    viewPopup.append(" separator popup.closeView closeView");
                }
            }
            viewPopup.append(" endSubmenu");
            lpexView.doDefaultCommand(viewPopup.toString());
        }
    }

    protected void updateProfile(LpexView lpexView) {
    }

    protected void setEditorInput(IEditorInput editorInput) {
        this._editorInput = editorInput;
        this.setFileName();
    }

    public LpexMultiWindow getLpexMultiWindow() {
        return this._lpexMultiWindow;
    }

    public LpexWindow getLpexWindow() {
        return this._lpexMultiWindow != null ? this._lpexMultiWindow.getWindow() : null;
    }

    public LpexWindow getFirstLpexWindow() {
        return this._lpexWindow;
    }

    public LpexWindow getActiveLpexWindow() {
        return this._activeWindow != null ? this._activeWindow : this._lpexWindow;
    }

    public LpexView getLpexView() {
        LpexWindow lpexWindow = this._lpexMultiWindow != null ? this._lpexMultiWindow.getWindow() : null;
        return lpexWindow != null ? lpexWindow.getLpexView() : null;
    }

    public LpexView getFirstLpexView() {
        return this._lpexView;
    }

    public LpexView getActiveLpexView() {
        return this._activeWindow != null && !this._activeWindow.isDisposed() ? this._activeWindow.getLpexView() : this._lpexView;
    }

    private void setFileName() {
        if (this._lpexView == null) {
            return;
        }
        String name = null;
        if (this._editorInput != null) {
            if (this._editorInput instanceof IFileEditorInput) {
                IPath location = ((IFileEditorInput)this._editorInput).getFile().getLocation();
                if (location != null) {
                    name = location.toOSString();
                }
            } else if (this._editorInput instanceof IStorageEditorInput) {
                int dotIndex;
                int spaceIndex;
                try {
                    IStorage storage = ((IStorageEditorInput)this._editorInput).getStorage();
                    IPath fullPath = storage.getFullPath();
                    name = fullPath != null ? fullPath.toOSString() : storage.getName();
                }
                catch (CoreException storage) {
                    // empty catch block
                }
                if (name != null && "org.eclipse.team.internal.ui.history.FileRevisionEditorInput".equals(this._editorInput.getClass().getName()) && (spaceIndex = name.lastIndexOf(32)) >= 0 && (dotIndex = name.lastIndexOf(46, spaceIndex)) >= 0) {
                    name = name.substring(0, spaceIndex);
                }
            }
            if (name == null && this._editorInput instanceof IURIEditorInput) {
                URI uri = ((IURIEditorInput)this._editorInput).getURI();
                if ("file".equals(uri.getScheme())) {
                    name = new Path(uri.getSchemeSpecificPart()).toOSString();
                } else {
                    try {
                        IFileStore store = EFS.getStore((URI)uri);
                        if (store != null) {
                            name = store.getName();
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
            if (name == null) {
                name = this._editorInput.getName();
            }
        }
        this._lpexView.doCommand("set name " + (name != null ? name : ""));
    }

    public LpexDocumentLocation getLpexDocumentLocation(int offset) {
        return this.fDocumentAdapter != null ? this.fDocumentAdapter.getLpexDocumentLocation(offset) : new LpexDocumentLocation(0, 0);
    }

    public int getDocOffset(LpexDocumentLocation documentLocation) {
        return this.fDocumentAdapter != null ? this.fDocumentAdapter.getDocOffset(documentLocation) : -1;
    }

    void activeWindowChanged(LpexWindow lpexWindow) {
        this._activeWindow = lpexWindow;
    }

    public void setHoverEnrichMode(ITextViewerExtension8.EnrichMode mode) {
        if (this.fTextHoverManager == null) {
            return;
        }
        for (LpexTextViewerHoverManager textHoverManager : this.fTextHoverManager) {
            textHoverManager.getInternalAccessor().setHoverEnrichMode(mode);
        }
    }

    public void print(StyledTextPrintOptions options) {
    }

    private static final class JFaceTextMessages {
        private static ResourceBundle _bundle;

        private JFaceTextMessages() {
        }

        public static String getString(String key) {
            try {
                if (_bundle == null) {
                    _bundle = ResourceBundle.getBundle("org.eclipse.jface.text.JFaceTextMessages");
                }
                if (_bundle != null) {
                    return _bundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return "!" + key + "!";
        }
    }

    class RewriteTarget
    implements IRewriteTarget {
        RewriteTarget() {
        }

        public void beginCompoundChange() {
            if (LpexTextViewer.this.fDocumentAdapter != null) {
                LpexTextViewer.this.fDocumentAdapter.startLpexChanges();
            }
        }

        public void endCompoundChange() {
            if (LpexTextViewer.this.fDocumentAdapter != null) {
                LpexTextViewer.this.fDocumentAdapter.endLpexChanges();
            }
        }

        public IDocument getDocument() {
            return LpexTextViewer.this.getDocument();
        }

        public void setRedraw(boolean redraw) {
            LpexTextViewer.this.setRedraw(redraw);
        }
    }

    protected static class TextHoverKey {
        private String fContentType;
        private int fStateMask;

        protected TextHoverKey(String contentType, int stateMask) {
            Assert.isNotNull((Object)contentType);
            this.fContentType = contentType;
            this.fStateMask = stateMask;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TextHoverKey textHoverKey = (TextHoverKey)obj;
            return textHoverKey.fContentType.equals(this.fContentType) && textHoverKey.fStateMask == this.fStateMask;
        }

        public int hashCode() {
            return this.fStateMask << 16 | this.fContentType.hashCode();
        }

        private void setStateMask(int stateMask) {
            this.fStateMask = stateMask;
        }
    }

    private class Viewport {
        private LpexWindow lpexWindow;
        private ScrollBar verticalBar;
        private ViewportGuard viewportGuard;
        private Set<IViewportListener> viewPortListeners;

        Viewport(LpexWindow initLpexWindow) {
            this.lpexWindow = initLpexWindow;
            this.verticalBar = this.lpexWindow == null ? null : this.lpexWindow.getVerticalBar();
            this.viewportGuard = new ViewportGuard(this);
            this.viewPortListeners = ConcurrentHashMap.newKeySet();
            this.connect();
        }

        void connect() {
            if (this.lpexWindow != null && this.viewportGuard != null) {
                this.lpexWindow.addKeyListener(this.viewportGuard);
                this.lpexWindow.addMouseListener((MouseListener)this.viewportGuard);
                this.lpexWindow.addControlListener(this.viewportGuard);
                if (this.lpexWindow.getLpexView() != null) {
                    this.lpexWindow.getLpexView().addLpexViewListener(this.viewportGuard);
                }
            }
            if (this.verticalBar != null && this.viewportGuard != null) {
                this.verticalBar.addSelectionListener((SelectionListener)this.viewportGuard);
            }
        }

        void disconnect() {
            if (this.lpexWindow != null && this.viewportGuard != null) {
                this.lpexWindow.removeKeyListener(this.viewportGuard);
                this.lpexWindow.removeMouseListener((MouseListener)this.viewportGuard);
                this.lpexWindow.removeControlListener(this.viewportGuard);
                if (this.lpexWindow.getLpexView() != null) {
                    this.lpexWindow.getLpexView().removeLpexViewListener(this.viewportGuard);
                }
            }
            if (this.verticalBar != null && this.viewportGuard != null) {
                this.verticalBar.removeSelectionListener((SelectionListener)this.viewportGuard);
            }
        }

        public void addViewportListener(IViewportListener listener) {
            if (this.viewPortListeners == null || listener == null) {
                return;
            }
            this.viewPortListeners.add(listener);
        }

        public void removeViewportListener(IViewportListener listener) {
            if (this.viewPortListeners == null || listener == null) {
                return;
            }
            this.viewPortListeners.remove(listener);
        }

        public void updateToViewportListeners(int px) {
            if (this.viewPortListeners == null) {
                return;
            }
            this.viewPortListeners.forEach(viewportListener -> viewportListener.viewportChanged(px));
        }

        public void clear() {
            if (this.viewPortListeners == null) {
                return;
            }
            this.viewPortListeners.clear();
        }

        public void delete() {
            this.disconnect();
            this.clear();
            this.viewPortListeners = null;
            if (this.viewportGuard != null) {
                this.viewportGuard.delete();
                this.viewportGuard = null;
            }
            this.verticalBar = null;
            this.lpexWindow = null;
        }

        private class ViewportGuard
        extends MouseAdapter
        implements ControlListener,
        KeyListener,
        MouseMoveListener,
        SelectionListener,
        LpexViewListener {
            private Viewport parent;

            ViewportGuard(Viewport initViewport) {
                this.parent = initViewport;
            }

            public void delete() {
                this.parent = null;
            }

            public void controlResized(ControlEvent e) {
                LpexTextViewer.this.updateViewportListeners(5);
            }

            public void controlMoved(ControlEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                LpexTextViewer.this.updateViewportListeners(4);
            }

            public void keyPressed(KeyEvent e) {
                LpexTextViewer.this.updateViewportListeners(4);
            }

            public void mouseUp(MouseEvent e) {
                if (this.parent != null && this.parent.lpexWindow != null) {
                    this.parent.lpexWindow.textWindow().removeMouseMoveListener((MouseMoveListener)this);
                }
                LpexTextViewer.this.updateViewportListeners(3);
            }

            public void mouseDown(MouseEvent e) {
                if (this.parent != null && this.parent.lpexWindow != null) {
                    this.parent.lpexWindow.textWindow().addMouseMoveListener((MouseMoveListener)this);
                }
            }

            public void mouseMove(MouseEvent e) {
                LpexTextViewer.this.updateViewportListeners(2);
            }

            public void widgetSelected(SelectionEvent e) {
                LpexTextViewer.this.updateViewportListeners(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void showing(LpexView lpexView) {
            }

            @Override
            public void shown(LpexView lpexView) {
                LpexTextViewer.this.updateViewportListeners(1);
            }

            @Override
            public boolean saving(LpexView lpexView) {
                return false;
            }

            @Override
            public void saved(LpexView lpexView) {
            }

            @Override
            public boolean renaming(LpexView lpexView) {
                return false;
            }

            @Override
            public void renamed(LpexView lpexView) {
            }

            @Override
            public void readonly(LpexView lpexView) {
            }

            @Override
            public void updateProfile(LpexView lpexView) {
            }

            @Override
            public void disposed(LpexView lpexView) {
            }
        }
    }

    private class ViewportManager {
        Map<LpexWindow, Viewport> viewportMap;

        ViewportManager() {
            int initSize = LpexTextViewer.this._lpexMultiWindow == null ? 1 : LpexTextViewer.this._lpexMultiWindow.getMaxWindows();
            this.viewportMap = new ConcurrentHashMap<LpexWindow, Viewport>(initSize);
        }

        Viewport addViewport(LpexWindow lpexWindow) {
            if (lpexWindow == null) {
                return null;
            }
            Viewport viewport = this.getViewport(lpexWindow);
            if (viewport == null) {
                viewport = new Viewport(lpexWindow);
                this.viewportMap.put(lpexWindow, viewport);
            }
            return viewport;
        }

        Viewport getViewport(LpexWindow lpexWindow) {
            if (lpexWindow == null) {
                return null;
            }
            Viewport viewport = this.viewportMap.get((Object)lpexWindow);
            return viewport;
        }

        void removeViewport(LpexWindow lpexWindow) {
            if (lpexWindow == null) {
                return;
            }
            Viewport viewport = this.viewportMap.remove((Object)lpexWindow);
            if (viewport != null) {
                viewport.delete();
            }
        }

        boolean isEmpty() {
            return this.viewportMap == null || this.viewportMap.isEmpty();
        }
    }

    class VisibleDocumentListener
    implements IDocumentListener {
        VisibleDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
            LpexTextViewer.this.handleVisibleDocumentAboutToBeChanged(e);
        }

        public void documentChanged(DocumentEvent e) {
            LpexTextViewer.this.handleVisibleDocumentChanged(e);
        }
    }
}

