/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.DefaultEncodingSupport;
import com.ibm.lpex.alef.LpexAbstractDecoratedTextEditor;
import com.ibm.lpex.alef.LpexSourceViewerConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.IEncodingSupport;

public class LpexTextEditor
extends LpexAbstractDecoratedTextEditor {
    public static final String EDITOR_CONTEXT_MENU_ID = "#LpexTextEditorContext";
    public static final String RULER_CONTEXT_MENU_ID = "#LpexTextRulerContext";
    private DefaultEncodingSupport fEncodingSupport;

    public LpexTextEditor() {
        if (this.getSourceViewerConfiguration() == null) {
            this.setSourceViewerConfiguration((SourceViewerConfiguration)new LpexSourceViewerConfiguration(this.getPreferenceStore()));
        }
    }

    @Override
    protected void initializeEditor() {
        this.setEditorContextMenuId(EDITOR_CONTEXT_MENU_ID);
        this.setRulerContextMenuId(RULER_CONTEXT_MENU_ID);
        this.setHelpContextId("com.ibm.lpex.text_editor");
        this.setPreferenceStore(EditorsUI.getPreferenceStore());
    }

    @Override
    public void dispose() {
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.dispose();
            this.fEncodingSupport = null;
        }
        super.dispose();
    }

    protected void installEncodingSupport() {
        this.fEncodingSupport = new DefaultEncodingSupport();
        this.fEncodingSupport.initialize(this);
    }

    @Override
    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    protected void createActions() {
        this.installEncodingSupport();
        super.createActions();
    }

    @Override
    protected String getStatusHeader(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusHeader(status)) != null) {
            return message;
        }
        return super.getStatusHeader(status);
    }

    @Override
    protected String getStatusBanner(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusBanner(status)) != null) {
            return message;
        }
        return super.getStatusBanner(status);
    }

    @Override
    protected String getStatusMessage(IStatus status) {
        String message;
        if (this.fEncodingSupport != null && (message = this.fEncodingSupport.getStatusMessage(status)) != null) {
            return message;
        }
        return super.getStatusMessage(status);
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IEncodingSupport.class.equals((Object)adapter)) {
            return this.fEncodingSupport;
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected void updatePropertyDependentActions() {
        super.updatePropertyDependentActions();
        if (this.fEncodingSupport != null) {
            this.fEncodingSupport.reset();
        }
    }
}

