/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.alef.LpexTextViewerHoverManager;
import org.eclipse.jface.internal.text.InformationControlReplacer;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class LpexStickyHoverManager
extends InformationControlReplacer
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    private static final int WIDGET_PRIORITY = -5;
    private final LpexTextViewer fTextViewer;
    private AbstractHoverInformationControlManager _hoverMgr;

    public LpexStickyHoverManager(LpexTextViewer textViewer, AbstractHoverInformationControlManager hoverMgr) {
        super((IInformationControlCreator)new AbstractReusableInformationControlCreator(){

            public IInformationControl doCreateInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, true);
            }
        });
        this.fTextViewer = textViewer;
        this.setCloser(new Closer());
        this.install((Control)this.fTextViewer.getFirstLpexWindow().textWindow());
        this._hoverMgr = hoverMgr;
    }

    protected void showInformationControl(Rectangle subjectArea) {
        if (this.fTextViewer != null && this.fTextViewer.requestWidgetToken(this, -5)) {
            super.showInformationControl(subjectArea);
        }
    }

    public void hideInformationControl() {
        try {
            super.hideInformationControl();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        this.hideInformationControl();
        return true;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        if (this.getCurrentInformationControl2() != null) {
            if (this.getCurrentInformationControl2().isFocusControl()) {
                return false;
            }
            if (priority > -5) {
                this.hideInformationControl();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean setFocus(IWidgetTokenOwner owner) {
        IInformationControl iControl = this.getCurrentInformationControl2();
        if (iControl instanceof IInformationControlExtension5) {
            IInformationControlExtension5 iControl5 = (IInformationControlExtension5)iControl;
            if (iControl5.isVisible()) {
                iControl.setFocus();
                return iControl.isFocusControl();
            }
            return false;
        }
        iControl.setFocus();
        return iControl.isFocusControl();
    }

    public void replaceInformationControl(IInformationControlCreator informationPresenterControlCreator, Rectangle contentBounds, Object information, Rectangle subjectArea, boolean takeFocus) {
        if (this._hoverMgr instanceof LpexTextViewerHoverManager) {
            this.fTextViewer.releaseWidgetToken((LpexTextViewerHoverManager)this._hoverMgr);
        }
        super.replaceInformationControl(informationPresenterControlCreator, contentBounds, information, subjectArea, takeFocus);
    }

    class Closer
    implements AbstractInformationControlManager.IInformationControlCloser,
    ControlListener,
    MouseListener,
    IViewportListener,
    KeyListener,
    FocusListener,
    Listener {
        private Control fSubjectControl;
        private boolean fIsActive = false;
        private Display fDisplay;

        Closer() {
        }

        public void setSubjectControl(Control control) {
            this.fSubjectControl = control;
        }

        public void setInformationControl(IInformationControl control) {
        }

        public void start(Rectangle informationArea) {
            if (this.fIsActive) {
                return;
            }
            this.fIsActive = true;
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.addControlListener((ControlListener)this);
                this.fSubjectControl.addMouseListener((MouseListener)this);
                this.fSubjectControl.addKeyListener((KeyListener)this);
            }
            LpexStickyHoverManager.this.fTextViewer.addViewportListener(this);
            IInformationControl fInformationControlToClose = LpexStickyHoverManager.this.getCurrentInformationControl2();
            if (fInformationControlToClose != null) {
                fInformationControlToClose.addFocusListener((FocusListener)this);
            }
            this.fDisplay = this.fSubjectControl.getDisplay();
            if (!this.fDisplay.isDisposed()) {
                this.fDisplay.addFilter(5, (Listener)this);
                this.fDisplay.addFilter(16, (Listener)this);
            }
        }

        public void stop() {
            IInformationControl fInformationControlToClose;
            if (!this.fIsActive) {
                return;
            }
            this.fIsActive = false;
            LpexStickyHoverManager.this.fTextViewer.removeViewportListener(this);
            if (this.fSubjectControl != null && !this.fSubjectControl.isDisposed()) {
                this.fSubjectControl.removeControlListener((ControlListener)this);
                this.fSubjectControl.removeMouseListener((MouseListener)this);
                this.fSubjectControl.removeKeyListener((KeyListener)this);
            }
            if ((fInformationControlToClose = LpexStickyHoverManager.this.getCurrentInformationControl2()) != null) {
                fInformationControlToClose.removeFocusListener((FocusListener)this);
            }
            if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                this.fDisplay.removeFilter(5, (Listener)this);
                this.fDisplay.removeFilter(16, (Listener)this);
            }
            this.fDisplay = null;
        }

        public void controlResized(ControlEvent e) {
            LpexStickyHoverManager.this.hideInformationControl();
        }

        public void controlMoved(ControlEvent e) {
            LpexStickyHoverManager.this.hideInformationControl();
        }

        public void mouseDown(MouseEvent e) {
            LpexStickyHoverManager.this.hideInformationControl();
        }

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDoubleClick(MouseEvent e) {
            LpexStickyHoverManager.this.hideInformationControl();
        }

        public void viewportChanged(int topIndex) {
            LpexStickyHoverManager.this.hideInformationControl();
        }

        public void keyPressed(KeyEvent e) {
            LpexStickyHoverManager.this.hideInformationControl();
        }

        public void keyReleased(KeyEvent e) {
        }

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            Display d = this.fSubjectControl.getDisplay();
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LpexStickyHoverManager.this.hideInformationControl();
                }
            });
        }

        public void handleEvent(Event event) {
            IInformationControl iControl;
            if (event.type == 5) {
                if (!(event.widget instanceof Control) || event.widget.isDisposed()) {
                    return;
                }
                IInformationControl infoControl = LpexStickyHoverManager.this.getCurrentInformationControl2();
                if (infoControl != null && !infoControl.isFocusControl() && infoControl instanceof IInformationControlExtension3) {
                    IInformationControlExtension3 iControl3 = (IInformationControlExtension3)infoControl;
                    Rectangle controlBounds = iControl3.getBounds();
                    if (controlBounds != null) {
                        Point mouseLoc = event.display.map((Control)event.widget, null, event.x, event.y);
                        int margin = LpexStickyHoverManager.this.getKeepUpMargin();
                        Geometry.expand((Rectangle)controlBounds, (int)margin, (int)margin, (int)margin, (int)margin);
                        if (!controlBounds.contains(mouseLoc)) {
                            LpexStickyHoverManager.this.hideInformationControl();
                        }
                    }
                } else if (this.fDisplay != null && !this.fDisplay.isDisposed()) {
                    this.fDisplay.removeFilter(5, (Listener)this);
                }
            } else if (event.type == 16 && (iControl = LpexStickyHoverManager.this.getCurrentInformationControl2()) != null && !iControl.isFocusControl()) {
                LpexStickyHoverManager.this.hideInformationControl();
            }
        }
    }
}

