/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IOverviewRulerExtension;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LpexOverviewRuler
implements IOverviewRuler,
IOverviewRulerExtension {
    private static final boolean IS_MAC = Util.isMac();
    private static final int INSET = 2;
    private static final int ANNOTATION_HEIGHT = 4;
    private static boolean ANNOTATION_HEIGHT_SCALABLE = true;
    private IAnnotationModel fModel;
    private LpexTextViewer fTextViewer;
    private Canvas fCanvas;
    private Canvas fHeader;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private int fWidth;
    private Cursor fHitDetectionCursor;
    private Cursor fLastCursor;
    private int fLastMouseButtonActivityLine = -1;
    private int fAnnotationHeight = -1;
    private IAnnotationAccess fAnnotationAccess;
    private HeaderPainter fHeaderPainter;
    private Set<Object> fConfiguredAnnotationTypes = new HashSet<Object>();
    private Set<Object> fConfiguredHeaderAnnotationTypes = new HashSet<Object>();
    private Map<Object, Color> fAnnotationTypes2Colors = new ConcurrentHashMap<Object, Color>();
    private ISharedTextColors fSharedTextColors;
    private List<Object> fAnnotationsSortedByLayer = new ArrayList<Object>();
    private List<Integer> fLayersSortedByLayer = new ArrayList<Integer>();
    private Map<Object, Object> fAllowedAnnotationTypes = new ConcurrentHashMap<Object, Object>();
    private Map<Object, Object> fAllowedHeaderAnnotationTypes = new ConcurrentHashMap<Object, Object>();
    private List<Annotation> fCachedAnnotations = new ArrayList<Annotation>();
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LpexOverviewRuler.this.fRunnableLock;
            synchronized (object) {
                LpexOverviewRuler.this.fIsRunnablePosted = false;
            }
            LpexOverviewRuler.this.redraw();
            LpexOverviewRuler.this.updateHeader();
        }
    };
    private boolean fIsTemporaryAnnotationDiscolored;
    private boolean fUseSaturatedColors = false;

    public LpexOverviewRuler(IAnnotationAccess annotationAccess, int width, ISharedTextColors sharedColors) {
        this(annotationAccess, width, sharedColors, false);
    }

    public LpexOverviewRuler(IAnnotationAccess annotationAccess, int width, ISharedTextColors sharedColors, boolean discolorTemporaryAnnotation) {
        this.fAnnotationAccess = annotationAccess;
        this.fWidth = width;
        this.fSharedTextColors = sharedColors;
        this.fIsTemporaryAnnotationDiscolored = discolorTemporaryAnnotation;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fWidth;
    }

    public void setModel(IAnnotationModel model) {
        if (model != this.fModel || model != null) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.fModel = model;
            this.fInternalListener.listenToText();
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.update();
        }
    }

    public Control createControl(Composite parent, ITextViewer textViewer) {
        this.fTextViewer = (LpexTextViewer)textViewer;
        this.fHitDetectionCursor = new Cursor((Device)parent.getDisplay(), 21);
        this.fHeader = new Canvas(parent, 0);
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            this.fHeader.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    LpexOverviewRuler.this.updateHeaderToolTipText();
                }
            });
        }
        this.fCanvas = new Canvas(parent, 262144);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (LpexOverviewRuler.this.fTextViewer != null) {
                    LpexOverviewRuler.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                LpexOverviewRuler.this.handleDispose();
                LpexOverviewRuler.this.fTextViewer = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                LpexOverviewRuler.this.handleMouseDown(event);
            }
        });
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                LpexOverviewRuler.this.handleMouseMove(event);
            }
        });
        this.fInternalListener.listenToText();
        return this.fCanvas;
    }

    private void handleDispose() {
        this.fInternalListener.dontListenToText();
        this.fTextViewer = null;
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        if (this.fHitDetectionCursor != null) {
            this.fHitDetectionCursor.dispose();
            this.fHitDetectionCursor = null;
        }
        this.fConfiguredAnnotationTypes.clear();
        this.fAllowedAnnotationTypes.clear();
        this.fConfiguredHeaderAnnotationTypes.clear();
        this.fAllowedHeaderAnnotationTypes.clear();
        this.fAnnotationTypes2Colors.clear();
        this.fAnnotationsSortedByLayer.clear();
        this.fLayersSortedByLayer.clear();
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        try {
            gc.setBackground(this.fCanvas.getBackground());
            gc.fillRectangle(0, 0, size.x, size.y);
            this.cacheAnnotations();
            this.doPaint(gc);
        }
        finally {
            gc.dispose();
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    private void doPaint(GC gc) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        int hh = 4;
        IDocument document = this.fTextViewer.getDocument();
        WidgetInfos infos = null;
        for (Object annotationType : this.fAnnotationsSortedByLayer) {
            if (this.skip(annotationType)) continue;
            int[] style = new int[]{4, 2};
            int t = 0;
            while (t < style.length) {
                boolean areColorsComputed = false;
                Color fill = null;
                Color stroke = null;
                FilterIterator e = new FilterIterator(annotationType, style[t], this.fCachedAnnotations.iterator());
                while (e.hasNext()) {
                    Annotation a = (Annotation)e.next();
                    Position p = this.fModel.getPosition(a);
                    if (p == null) continue;
                    int annotationOffset = p.getOffset();
                    int annotationLength = p.getLength();
                    IRegion widgetRegion = null;
                    widgetRegion = this.fTextViewer.modelRange2WidgetRange((IRegion)new Region(annotationOffset, annotationLength));
                    if (widgetRegion == null) continue;
                    if (infos == null) {
                        infos = new WidgetInfos(this.fTextViewer, this.fCanvas);
                        r.x = 2;
                        r.width = infos.bounds.width - 4;
                    }
                    try {
                        int startOffset = widgetRegion.getOffset();
                        int startLine = document.getLineOfOffset(startOffset);
                        int yy = this.computeY(startLine, infos);
                        if (ANNOTATION_HEIGHT_SCALABLE) {
                            int numberOfLines = document.getNumberOfLines(annotationOffset, annotationLength);
                            IRegion lastLine = document.getLineInformationOfOffset(annotationOffset + annotationLength);
                            if (lastLine.getOffset() == annotationOffset + annotationLength) {
                                --numberOfLines;
                            }
                            if (numberOfLines > 1) {
                                int yy2 = this.computeY(startLine + numberOfLines - 1, infos);
                                hh = Math.max(yy2 - yy, 4);
                            } else {
                                hh = 4;
                            }
                        }
                        this.fAnnotationHeight = hh;
                        if (!areColorsComputed) {
                            stroke = this.getStrokeColor(annotationType, style[t] == 2);
                            fill = this.fUseSaturatedColors ? stroke : this.getFillColor(annotationType, style[t] == 2);
                            areColorsComputed = true;
                        }
                        if (fill != null) {
                            gc.setBackground(fill);
                            gc.fillRectangle(2, yy, infos.bounds.width - 4, hh);
                        }
                        if (stroke == null) continue;
                        gc.setForeground(stroke);
                        r.y = yy;
                        if (yy + hh == infos.bounds.height) {
                            --r.y;
                        }
                        r.height = hh;
                        gc.setLineWidth(0);
                        gc.drawRectangle(r);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
                ++t;
            }
        }
    }

    private void cacheAnnotations() {
        this.fCachedAnnotations.clear();
        if (this.fModel != null) {
            Iterator iter = this.fModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation annotation = (Annotation)iter.next();
                if (annotation.isMarkedDeleted() || this.skip(annotation.getType())) continue;
                this.fCachedAnnotations.add(annotation);
            }
        }
    }

    private int computeY(int startLine, WidgetInfos infos) {
        LpexView lpexView = this.fTextViewer.getFirstLpexView();
        int maxLines = lpexView.queryInt("lines") - lpexView.linesBeforeStart() - lpexView.linesAfterEnd();
        Point size = this.fCanvas.getSize();
        int writable = maxLines * lpexView.queryInt("rowHeight");
        if (size.y > writable) {
            size.y = Math.max(writable - this.fHeader.getSize().y, 0);
        }
        return Math.min(startLine * size.y / maxLines, size.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            d.asyncExec(this.fRunnable);
        }
    }

    private void redraw() {
        if (this.fTextViewer == null || this.fModel == null) {
            return;
        }
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            if (IS_MAC) {
                this.fCanvas.redraw();
                this.fCanvas.update();
            } else {
                GC gc = new GC((Drawable)this.fCanvas);
                this.doubleBufferPaint(gc);
                gc.dispose();
            }
        }
    }

    private int[] toLineNumbers(int y_coordinate, boolean annotationRect) {
        int rulerLength = this.fCanvas.getSize().y;
        LpexView lpexView = this.fTextViewer.getFirstLpexView();
        int maxLines = lpexView.queryInt("lines") - lpexView.linesBeforeStart() - lpexView.linesAfterEnd();
        int writable = maxLines * lpexView.queryInt("rowHeight");
        if (rulerLength > writable) {
            rulerLength = Math.max(writable - this.fHeader.getSize().y, 0);
        }
        if (y_coordinate >= writable || y_coordinate >= rulerLength) {
            return new int[]{-1, -1};
        }
        int[] lines = new int[2];
        int pixel0 = Math.max(y_coordinate - 1, 0);
        int pixel1 = Math.min(rulerLength, y_coordinate + 1);
        rulerLength = Math.max(rulerLength, 1);
        lines[0] = pixel0 * maxLines / rulerLength;
        lines[1] = pixel1 * maxLines / rulerLength;
        return lines;
    }

    private Position getAnnotationPosition(int[] lineNumbers) {
        if (lineNumbers[0] == -1) {
            return null;
        }
        Position found = null;
        try {
            IDocument d = this.fTextViewer.getDocument();
            IRegion line = d.getLineInformation(lineNumbers[0]);
            int start = line.getOffset();
            line = d.getLineInformation(lineNumbers[lineNumbers.length - 1]);
            int end = line.getOffset() + line.getLength();
            int i = this.fAnnotationsSortedByLayer.size() - 1;
            while (i >= 0) {
                Object annotationType = this.fAnnotationsSortedByLayer.get(i);
                FilterIterator e = new FilterIterator(annotationType, 6);
                while (e.hasNext() && found == null) {
                    Position p;
                    Annotation a = (Annotation)e.next();
                    if (a.isMarkedDeleted() || this.skip(a.getType()) || (p = this.fModel.getPosition(a)) == null) continue;
                    int posOffset = p.getOffset();
                    int posEnd = posOffset + p.getLength();
                    IRegion region = d.getLineInformationOfOffset(posEnd);
                    if (posEnd > posOffset && region.getOffset() == posEnd) {
                        region = d.getLineInformationOfOffset(--posEnd);
                    }
                    if (posOffset > end || posEnd < start) continue;
                    found = p;
                }
                --i;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return found;
    }

    private int findBestMatchingLineNumber(int[] lineNumbers) {
        Position pos;
        block4: {
            if (lineNumbers == null || lineNumbers.length < 1) {
                return -1;
            }
            try {
                pos = this.getAnnotationPosition(lineNumbers);
                if (pos != null) break block4;
                return -1;
            }
            catch (BadLocationException e) {
                return -1;
            }
        }
        return this.fTextViewer.getDocument().getLineOfOffset(pos.getOffset());
    }

    private void handleMouseDown(MouseEvent event) {
        if (this.fTextViewer != null) {
            LpexWindow activeWindow;
            Position p;
            int[] lines = this.toLineNumbers(event.y, true);
            if (lines[0] == -1) {
                lines = this.toLineNumbers(event.y, false);
            }
            if ((p = this.getAnnotationPosition(lines)) == null && event.button == 1) {
                try {
                    p = new Position(this.fTextViewer.getDocument().getLineInformation(lines[0]).getOffset(), 0);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (p != null) {
                this.fTextViewer.revealRange(p.getOffset(), p.getLength());
                this.fTextViewer.setSelectedRange(p.getOffset(), p.getLength());
            }
            if ((activeWindow = this.fTextViewer.getActiveLpexWindow()) != null && !activeWindow.isDisposed()) {
                activeWindow.setFocus();
            }
        }
        this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(event.y);
    }

    private void handleMouseMove(MouseEvent event) {
        if (this.fTextViewer != null) {
            Cursor cursor;
            int[] lines = this.toLineNumbers(event.y, true);
            Position p = this.getAnnotationPosition(lines);
            Cursor cursor2 = cursor = p != null ? this.fHitDetectionCursor : null;
            if (cursor != this.fLastCursor) {
                this.fCanvas.setCursor(cursor);
                this.fLastCursor = cursor;
            }
        }
    }

    public void addAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.add(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    public void removeAnnotationType(Object annotationType) {
        this.fConfiguredAnnotationTypes.remove(annotationType);
        this.fAllowedAnnotationTypes.clear();
    }

    public void setAnnotationTypeLayer(Object annotationType, int layer) {
        int j = this.fAnnotationsSortedByLayer.indexOf(annotationType);
        if (j != -1) {
            this.fAnnotationsSortedByLayer.remove(j);
            this.fLayersSortedByLayer.remove(j);
        }
        if (layer >= 0) {
            int i = 0;
            int size = this.fLayersSortedByLayer.size();
            while (i < size && layer >= this.fLayersSortedByLayer.get(i)) {
                ++i;
            }
            Integer layerObj = layer;
            this.fLayersSortedByLayer.add(i, layerObj);
            this.fAnnotationsSortedByLayer.add(i, annotationType);
        }
    }

    public void setAnnotationTypeColor(Object annotationType, Color color) {
        if (color != null) {
            this.fAnnotationTypes2Colors.put(annotationType, color);
        } else {
            this.fAnnotationTypes2Colors.remove(annotationType);
        }
    }

    private boolean skip(Object annotationType) {
        return !this.contains(annotationType, this.fAllowedAnnotationTypes, this.fConfiguredAnnotationTypes);
    }

    private boolean skipInHeader(Object annotationType) {
        return !this.contains(annotationType, this.fAllowedHeaderAnnotationTypes, this.fConfiguredHeaderAnnotationTypes);
    }

    private boolean contains(Object annotationType, Map<Object, Object> allowed, Set<Object> configured) {
        Boolean cached = (Boolean)allowed.get(annotationType);
        if (cached != null) {
            return cached;
        }
        boolean covered = this.isCovered(annotationType, configured);
        allowed.put(annotationType, covered ? Boolean.TRUE : Boolean.FALSE);
        return covered;
    }

    private boolean isCovered(Object annotationType, Set<Object> configured) {
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension extension = (IAnnotationAccessExtension)this.fAnnotationAccess;
            Iterator<Object> e = configured.iterator();
            while (e.hasNext()) {
                if (!extension.isSubtype(annotationType, e.next())) continue;
                return true;
            }
            return false;
        }
        return configured.contains(annotationType);
    }

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
    }

    private static double greyLevel(RGB rgb) {
        if (rgb.red == rgb.green && rgb.green == rgb.blue) {
            return rgb.red;
        }
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue + 0.5;
    }

    private static boolean isDark(RGB rgb) {
        return LpexOverviewRuler.greyLevel(rgb) > 128.0;
    }

    private Color getColor(Object annotationType, double scale) {
        Color base = this.findColor(annotationType);
        if (base == null) {
            return null;
        }
        RGB baseRGB = base.getRGB();
        RGB background = this.fCanvas.getBackground().getRGB();
        boolean darkBase = LpexOverviewRuler.isDark(baseRGB);
        boolean darkBackground = LpexOverviewRuler.isDark(background);
        if (darkBase && darkBackground) {
            background = new RGB(255, 255, 255);
        } else if (!darkBase && !darkBackground) {
            background = new RGB(0, 0, 0);
        }
        return this.fSharedTextColors.getColor(LpexOverviewRuler.interpolate(baseRGB, background, scale));
    }

    private Color findColor(Object annotationType) {
        IAnnotationAccessExtension extension;
        Object[] superTypes;
        Color color = this.fAnnotationTypes2Colors.get(annotationType);
        if (color != null) {
            return color;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && (superTypes = (extension = (IAnnotationAccessExtension)this.fAnnotationAccess).getSupertypes(annotationType)) != null) {
            int i = 0;
            while (i < superTypes.length) {
                color = this.fAnnotationTypes2Colors.get(superTypes[i]);
                if (color != null) {
                    return color;
                }
                ++i;
            }
        }
        return null;
    }

    private Color getStrokeColor(Object annotationType, boolean temporary) {
        return this.getColor(annotationType, temporary && this.fIsTemporaryAnnotationDiscolored ? 0.5 : 0.2);
    }

    private Color getFillColor(Object annotationType, boolean temporary) {
        return this.getColor(annotationType, temporary && this.fIsTemporaryAnnotationDiscolored ? 0.9 : 0.75);
    }

    public int getLineOfLastMouseButtonActivity() {
        if (this.fLastMouseButtonActivityLine >= this.fTextViewer.getDocument().getNumberOfLines()) {
            this.fLastMouseButtonActivityLine = -1;
        }
        return this.fLastMouseButtonActivityLine;
    }

    public int toDocumentLineNumber(int y_coordinate) {
        int bestLine;
        if (this.fTextViewer == null || y_coordinate == -1) {
            return -1;
        }
        int[] lineNumbers = this.toLineNumbers(y_coordinate, true);
        if (lineNumbers[0] == -1) {
            lineNumbers = this.toLineNumbers(y_coordinate, false);
        }
        if ((bestLine = this.findBestMatchingLineNumber(lineNumbers)) == -1 && lineNumbers.length > 0) {
            return lineNumbers[0];
        }
        return bestLine;
    }

    public IAnnotationModel getModel() {
        return this.fModel;
    }

    public int getAnnotationHeight() {
        return this.fAnnotationHeight;
    }

    public boolean hasAnnotation(int y) {
        return this.findBestMatchingLineNumber(this.toLineNumbers(y, true)) != -1;
    }

    public Control getHeaderControl() {
        return this.fHeader;
    }

    public void addHeaderAnnotationType(Object annotationType) {
        this.fConfiguredHeaderAnnotationTypes.add(annotationType);
        this.fAllowedHeaderAnnotationTypes.clear();
    }

    public void removeHeaderAnnotationType(Object annotationType) {
        this.fConfiguredHeaderAnnotationTypes.remove(annotationType);
        this.fAllowedHeaderAnnotationTypes.clear();
    }

    private void updateHeader() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        this.fHeader.setToolTipText(null);
        Object colorType = null;
        int i = this.fAnnotationsSortedByLayer.size() - 1;
        block0: while (i >= 0) {
            Object annotationType = this.fAnnotationsSortedByLayer.get(i);
            if (!this.skipInHeader(annotationType) && !this.skip(annotationType)) {
                FilterIterator e = new FilterIterator(annotationType, 14, this.fCachedAnnotations.iterator());
                while (e.hasNext()) {
                    if (e.next() == null) continue;
                    colorType = annotationType;
                    break block0;
                }
            }
            --i;
        }
        Color color = null;
        if (colorType != null) {
            color = this.findColor(colorType);
        }
        if (color == null) {
            if (this.fHeaderPainter != null) {
                this.fHeaderPainter.setColor(null);
            }
        } else {
            if (this.fHeaderPainter == null) {
                this.fHeaderPainter = new HeaderPainter();
                this.fHeader.addPaintListener((PaintListener)this.fHeaderPainter);
            }
            this.fHeaderPainter.setColor(color);
        }
        this.fHeader.redraw();
    }

    private void updateHeaderToolTipText() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        if (this.fHeader.getToolTipText() != null) {
            return;
        }
        StringBuilder overview = new StringBuilder();
        int i = this.fAnnotationsSortedByLayer.size() - 1;
        while (i >= 0) {
            Object annotationType = this.fAnnotationsSortedByLayer.get(i);
            if (!this.skipInHeader(annotationType) && !this.skip(annotationType)) {
                int count = 0;
                String annotationTypeLabel = null;
                FilterIterator e = new FilterIterator(annotationType, 14, this.fCachedAnnotations.iterator());
                while (e.hasNext()) {
                    Annotation annotation = (Annotation)e.next();
                    if (annotation == null) continue;
                    if (annotationTypeLabel == null) {
                        annotationTypeLabel = ((IAnnotationAccessExtension)this.fAnnotationAccess).getTypeLabel(annotation);
                    }
                    ++count;
                }
                if (annotationTypeLabel != null) {
                    if (overview.length() > 0) {
                        overview.append("\n");
                    }
                    overview.append(JFaceTextMessages.getFormattedString("OverviewRulerHeader.toolTipTextEntry", new Object[]{annotationTypeLabel, count}));
                }
            }
            --i;
        }
        if (overview.length() > 0) {
            this.fHeader.setToolTipText(overview.toString());
        }
    }

    public void setUseSaturatedColors(boolean useSaturatedColor) {
        this.fUseSaturatedColors = useSaturatedColor;
    }

    class FilterIterator
    implements Iterator<Object> {
        static final int TEMPORARY = 2;
        static final int PERSISTENT = 4;
        static final int IGNORE_BAGS = 8;
        private Iterator<?> fIterator;
        private Object fType;
        private Annotation fNext;
        private int fStyle;

        public FilterIterator(Object annotationType, int style) {
            this.fType = annotationType;
            this.fStyle = style;
            if (LpexOverviewRuler.this.fModel != null) {
                this.fIterator = LpexOverviewRuler.this.fModel.getAnnotationIterator();
                this.skip();
            }
        }

        public FilterIterator(Object annotationType, int style, Iterator<?> iterator) {
            this.fType = annotationType;
            this.fStyle = style;
            this.fIterator = iterator;
            this.skip();
        }

        private void skip() {
            boolean temp = (this.fStyle & 2) != 0;
            boolean pers = (this.fStyle & 4) != 0;
            boolean ignr = (this.fStyle & 8) != 0;
            while (this.fIterator.hasNext()) {
                Annotation next = (Annotation)this.fIterator.next();
                if (next.isMarkedDeleted() || ignr && next instanceof AnnotationBag) continue;
                this.fNext = next;
                String annotationType = next.getType();
                if (this.fType != null && !this.fType.equals(annotationType) && (LpexOverviewRuler.this.fConfiguredAnnotationTypes.contains(annotationType) || !this.isSubtype(annotationType))) continue;
                if (temp && pers) {
                    return;
                }
                if (pers && next.isPersistent()) {
                    return;
                }
                if (!temp || next.isPersistent()) continue;
                return;
            }
            this.fNext = null;
        }

        private boolean isSubtype(Object annotationType) {
            if (LpexOverviewRuler.this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
                IAnnotationAccessExtension extension = (IAnnotationAccessExtension)LpexOverviewRuler.this.fAnnotationAccess;
                return extension.isSubtype(annotationType, this.fType);
            }
            return this.fType.equals(annotationType);
        }

        @Override
        public boolean hasNext() {
            return this.fNext != null;
        }

        @Override
        public Object next() {
            try {
                Annotation annotation = this.fNext;
                return annotation;
            }
            finally {
                if (this.fIterator != null) {
                    this.skip();
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeaderPainter
    implements PaintListener {
        private Color fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = LpexOverviewRuler.this.fHeader.getDisplay().getSystemColor(18);
        }

        public void setColor(Color color) {
            this.fIndicatorColor = color;
        }

        private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topLeft, Color bottomRight) {
            gc.setForeground(topLeft == null ? this.fSeparatorColor : topLeft);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h - 1);
            gc.setForeground(bottomRight == null ? this.fSeparatorColor : bottomRight);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x, y + h, x + w, y + h);
        }

        public void paintControl(PaintEvent e) {
            if (this.fIndicatorColor == null) {
                return;
            }
            Point s = LpexOverviewRuler.this.fHeader.getSize();
            e.gc.setBackground(this.fIndicatorColor);
            Rectangle r = new Rectangle(2, 2, s.x - 4, 8);
            e.gc.fillRectangle(r);
            Display d = LpexOverviewRuler.this.fHeader.getDisplay();
            if (d != null) {
                this.drawBevelRect(e.gc, r.x, r.y, r.width - 1, r.height - 1, null, null);
            }
            e.gc.setForeground(this.fSeparatorColor);
            e.gc.setLineWidth(0);
            e.gc.drawLine(0, s.y - 1, s.x - 1, s.y - 1);
        }
    }

    class InternalListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension,
    LpexDocumentListener {
        private boolean _listeningToText;

        InternalListener() {
        }

        void listenToText() {
            if (LpexOverviewRuler.this.fTextViewer != null && LpexOverviewRuler.this.fModel != null && !this._listeningToText) {
                LpexOverviewRuler.this.fTextViewer.getFirstLpexView().addLpexDocumentListener(this);
                this._listeningToText = true;
            }
        }

        void dontListenToText() {
            LpexView lpexView;
            if (LpexOverviewRuler.this.fTextViewer != null && (lpexView = LpexOverviewRuler.this.fTextViewer.getFirstLpexView()) != null) {
                lpexView.removeLpexDocumentListener(this);
            }
            this._listeningToText = false;
        }

        @Override
        public void documentChanged(LpexView lpexView, int type, int line, int position, int count) {
            LpexOverviewRuler.this.update();
        }

        public void modelChanged(IAnnotationModel model) {
            LpexOverviewRuler.this.update();
        }

        public void modelChanged(AnnotationModelEvent event) {
            if (!event.isValid()) {
                return;
            }
            if (event.isWorldChange()) {
                LpexOverviewRuler.this.update();
                return;
            }
            Annotation[] annotations = event.getAddedAnnotations();
            int length = annotations.length;
            int i = 0;
            while (i < length) {
                if (!LpexOverviewRuler.this.skip(annotations[i].getType())) {
                    LpexOverviewRuler.this.update();
                    return;
                }
                ++i;
            }
            annotations = event.getRemovedAnnotations();
            length = annotations.length;
            i = 0;
            while (i < length) {
                if (!LpexOverviewRuler.this.skip(annotations[i].getType())) {
                    LpexOverviewRuler.this.update();
                    return;
                }
                ++i;
            }
            annotations = event.getChangedAnnotations();
            length = annotations.length;
            i = 0;
            while (i < length) {
                if (!LpexOverviewRuler.this.skip(annotations[i].getType())) {
                    LpexOverviewRuler.this.update();
                    return;
                }
                ++i;
            }
        }
    }

    private static final class JFaceTextMessages {
        private static ResourceBundle _bundle;

        private JFaceTextMessages() {
        }

        public static String getFormattedString(String key, Object[] args) {
            try {
                if (_bundle == null) {
                    _bundle = ResourceBundle.getBundle("org.eclipse.jface.text.JFaceTextMessages");
                }
                if (_bundle != null) {
                    return MessageFormat.format(_bundle.getString(key), args);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "!" + key + "!";
        }
    }

    static class WidgetInfos {
        Rectangle bounds;

        public WidgetInfos(LpexTextViewer textWidget, Canvas canvas) {
            this.bounds = canvas.getBounds();
        }
    }
}

