/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexRevisionPainter;
import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexViewListener;
import com.ibm.lpex.core.LpexWindow;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.revisions.IRevisionListener;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.ILineDifferExtension2;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class LpexLineNumberChangeRulerColumn
implements IVerticalRulerColumn,
IVerticalRulerInfo,
IVerticalRulerInfoExtension,
IChangeRulerColumn,
IRevisionRulerColumn,
IRevisionRulerColumnExtension {
    private LpexViewListener _lpexViewListener;
    private IAnnotationModel fAnnotationModel;
    private ILineDiffer fLineDiffer;
    private boolean fCharacterDisplay;
    private final LpexRevisionPainter fRevisionPainter;
    private CompositeRuler fParentRuler;
    private LpexTextViewer fCachedTextViewer;
    private LpexMultiWindow fCachedTextWidget;
    private Canvas fCanvas;
    private Font fFont;
    private Image fBuffer;
    private Color fBackground;
    private Color fAddedColor;
    private Color fChangedColor;
    private Color fDeletedColor;
    private IAnnotationHover fHover;
    private AnnotationListener fAnnotationListener = new AnnotationListener();
    private int fWidth;
    private final ISharedTextColors fSharedColors;
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LpexLineNumberChangeRulerColumn.this.fRunnableLock;
            synchronized (object) {
                LpexLineNumberChangeRulerColumn.this.fIsRunnablePosted = false;
            }
            LpexLineNumberChangeRulerColumn.this.redraw();
        }
    };

    public LpexLineNumberChangeRulerColumn(ISharedTextColors sharedColors) {
        Assert.isNotNull((Object)sharedColors);
        this.fRevisionPainter = new LpexRevisionPainter(this, sharedColors);
        this.fSharedColors = sharedColors;
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        LpexView lpexView;
        this.fParentRuler = parentRuler;
        this.fCachedTextViewer = (LpexTextViewer)parentRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getLpexMultiWindow();
        this.fRevisionPainter.setParentRuler(parentRuler);
        this.fCanvas = new Canvas(parentControl, 0);
        this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (LpexLineNumberChangeRulerColumn.this.fCachedTextViewer != null) {
                    LpexLineNumberChangeRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LpexLineNumberChangeRulerColumn.this.handleDispose();
                LpexLineNumberChangeRulerColumn.this.fCachedTextViewer = null;
                LpexLineNumberChangeRulerColumn.this.fCachedTextWidget = null;
            }
        });
        MouseHandler mouseHandler = new MouseHandler();
        this.fCanvas.addMouseListener((MouseListener)mouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)mouseHandler);
        if (this.fCachedTextViewer != null && (lpexView = this.fCachedTextViewer.getFirstLpexView()) != null) {
            if (this.fFont == null) {
                this.fFont = lpexView.getFont();
            }
            if (this._lpexViewListener == null) {
                this._lpexViewListener = new LpexViewAdapter(){

                    @Override
                    public void shown(LpexView view) {
                        LpexLineNumberChangeRulerColumn.this.handleLpexViewShown(view);
                    }
                };
            }
            lpexView.addLpexViewListener(this._lpexViewListener);
        }
        if (this.fFont != null) {
            this.fCanvas.setFont(this.fFont);
        }
        this.updateWidth();
        return this.fCanvas;
    }

    private void handleLpexViewShown(LpexView lpexView) {
        this.redraw();
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int y_coordinate) {
        return this.getParentRuler().toDocumentLineNumber(y_coordinate);
    }

    public void setModel(IAnnotationModel model) {
        this.fAnnotationModel = model;
        this.fRevisionPainter.setModel(model);
        IAnnotationModel newModel = model instanceof IAnnotationModelExtension ? ((IAnnotationModelExtension)model).getAnnotationModel((Object)"diff") : model;
        if (newModel instanceof ILineDiffer && this.fLineDiffer != (ILineDiffer)newModel) {
            if (this.fLineDiffer != null) {
                ((IAnnotationModel)this.fLineDiffer).removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.fLineDiffer = (ILineDiffer)newModel;
            ((IAnnotationModel)this.fLineDiffer).addAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
        }
        this.updateWidth();
        this.layout();
        this.postRedraw();
    }

    public void setDisplayMode(boolean characterMode) {
        if (characterMode != this.fCharacterDisplay) {
            this.fCharacterDisplay = characterMode;
            this.updateWidth();
            this.layout();
        }
    }

    public IAnnotationModel getModel() {
        return this.fAnnotationModel;
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = null;
        try {
            gc = new GC((Drawable)this.fBuffer);
            if (!this.fCanvas.getFont().isDisposed()) {
                gc.setFont(this.fCanvas.getFont());
            }
            gc.setBackground(this.getBackground(this.fCanvas.getDisplay()));
            gc.fillRectangle(0, 0, size.x, size.y);
            this.doPaint(gc);
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        dest.drawImage(this.fBuffer, 0, 0);
    }

    private void doPaint(GC gc) {
        Color foreground = gc.getForeground();
        if (this.fRevisionPainter.hasInformation()) {
            this.fRevisionPainter.paint(gc);
        } else if (this.isShowingChangeInformation()) {
            this.paintQuickDiff(gc);
        }
        gc.setForeground(foreground);
    }

    public IAnnotationHover getHover() {
        int activeLine = this.getLineOfLastMouseButtonActivity();
        if (this.fRevisionPainter.hasHover(activeLine)) {
            return this.fRevisionPainter.getHover();
        }
        if (this.hasHover(activeLine)) {
            return this.fHover;
        }
        return null;
    }

    public boolean hasHover(int activeLine) {
        return true;
    }

    public void setHover(IAnnotationHover hover) {
        this.fRevisionPainter.setHover(hover);
        this.fHover = hover;
    }

    public void setBackground(Color background) {
        this.fRevisionPainter.setBackground(background);
        this.fBackground = background;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        }
    }

    public void setAddedColor(Color addedColor) {
        this.fAddedColor = addedColor;
    }

    public void setChangedColor(Color changedColor) {
        this.fChangedColor = changedColor;
    }

    public void setDeletedColor(Color deletedColor) {
        this.fDeletedColor = deletedColor;
    }

    public void setRevisionInformation(RevisionInformation info) {
        this.fRevisionPainter.setRevisionInformation(info);
        this.updateWidth();
        this.layout();
        this.postRedraw();
    }

    public ISelectionProvider getRevisionSelectionProvider() {
        return this.fRevisionPainter.getRevisionSelectionProvider();
    }

    public void setRevisionRenderingMode(IRevisionRulerColumnExtension.RenderingMode renderingMode) {
        this.fRevisionPainter.setRenderingMode(renderingMode);
    }

    protected int computeNumberOfDigits() {
        int digits;
        int n = digits = this.fCharacterDisplay && this.getModel() != null ? 1 : 0;
        if (this.fRevisionPainter.hasInformation()) {
            digits += this.fRevisionPainter.getRequiredWidth();
        }
        return digits;
    }

    void updateWidth() {
        if (this.fCanvas == null || this.fCanvas.isDisposed()) {
            return;
        }
        int digits = this.computeNumberOfDigits();
        if (digits == 0) {
            this.fWidth = 0;
            return;
        }
        GC gc = new GC((Drawable)this.fCanvas);
        try {
            gc.setFont(this.fCanvas.getFont());
            char[] nines = new char[digits];
            Arrays.fill(nines, '9');
            this.fWidth = gc.stringExtent((String)new String((char[])nines)).x;
        }
        finally {
            gc.dispose();
        }
    }

    public int getWidth() {
        return this.fWidth > 0 ? this.fWidth : 8;
    }

    protected void layout() {
        Control control;
        if (this.fCachedTextViewer != null && (control = this.fCachedTextViewer.getControl()) instanceof Composite && !control.isDisposed()) {
            ((Composite)control).layout(true);
        }
    }

    public boolean isShowingRevisionInformation() {
        return this.fRevisionPainter.hasInformation();
    }

    public boolean isShowingChangeInformation() {
        return this.fLineDiffer instanceof ILineDifferExtension2 ? !((ILineDifferExtension2)this.fLineDiffer).isSuspended() : this.fLineDiffer != null;
    }

    public void showRevisionAuthor(boolean show) {
        this.fRevisionPainter.showRevisionAuthor(show);
        this.updateWidth();
        this.layout();
        this.postRedraw();
    }

    public void showRevisionId(boolean show) {
        this.fRevisionPainter.showRevisionId(show);
        this.updateWidth();
        this.layout();
        this.postRedraw();
    }

    public void addRevisionListener(IRevisionListener listener) {
        this.fRevisionPainter.addRevisionListener(listener);
    }

    public void removeRevisionListener(IRevisionListener listener) {
        this.fRevisionPainter.removeRevisionListener(listener);
    }

    protected String getDisplayCharacter(int line) {
        ILineDiffInfo info = this.getDiffInfo(line);
        if (info != null) {
            switch (info.getChangeType()) {
                case 2: {
                    return "~";
                }
                case 1: {
                    return "+";
                }
            }
        }
        return " ";
    }

    protected void handleDispose() {
        LpexView lpexView;
        this.fRevisionPainter.setParentRuler(null);
        this.fRevisionPainter.setModel(null);
        if (this.fLineDiffer != null) {
            ((IAnnotationModel)this.fLineDiffer).removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            this.fLineDiffer = null;
        }
        if (this.fCachedTextViewer != null && (lpexView = this.fCachedTextViewer.getFirstLpexView()) != null) {
            lpexView.removeLpexViewListener(this._lpexViewListener);
            this._lpexViewListener = null;
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    public void redraw() {
        if (this.fCachedTextViewer != null && this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setFont(Font font) {
        this.fFont = font;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setFont(this.fFont);
            this.updateWidth();
        }
    }

    private CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    private void paintQuickDiff(GC gc) {
        if (this.fCachedTextViewer == null) {
            return;
        }
        LpexWindow lpexWindow = this.fCachedTextViewer.getFirstLpexWindow();
        if (lpexWindow == null || lpexWindow.isDisposed()) {
            return;
        }
        LpexView lpexView = this.fCachedTextViewer.getFirstLpexView();
        int lineheight = lpexView.queryInt("rowHeight");
        int rows = lpexView.queryInt("rows");
        int shift = this.fCachedTextViewer.getTopInset() + lpexWindow.textWindow().getLocation().y;
        Color deletionColor = this.getDeletionColor();
        int width = this.getWidth();
        int i = 1;
        while (i <= rows) {
            int element = lpexView.elementOfRow(i);
            if (element != 0 && !lpexView.show(element)) {
                this.paintLine(lpexView.lineOfElement(element) - 1, shift + lineheight * (i - 1), lineheight, width, gc, deletionColor);
            }
            ++i;
        }
    }

    protected void paintLine(int line, int y, int lineheight, int width, GC gc, Color deletionColor) {
        ILineDiffInfo info = this.getDiffInfo(line);
        if (info != null) {
            if (this.hasSpecialColor(info)) {
                gc.setBackground(this.getColor(info));
                gc.fillRectangle(0, y, width, lineheight);
            }
            int delBefore = info.getRemovedLinesAbove();
            int delBelow = info.getRemovedLinesBelow();
            if (delBefore > 0 || delBelow > 0) {
                gc.setForeground(deletionColor);
                if (delBefore > 0) {
                    gc.drawLine(0, y, width, y);
                }
                if (delBelow > 0) {
                    gc.drawLine(0, y + lineheight - 1, width, y + lineheight - 1);
                }
            }
        }
    }

    private boolean hasSpecialColor(ILineDiffInfo info) {
        return info.getChangeType() == 1 || info.getChangeType() == 2;
    }

    private ILineDiffInfo getDiffInfo(int line) {
        return this.fLineDiffer != null ? this.fLineDiffer.getLineInfo(line) : null;
    }

    private Color getDeletionColor() {
        return this.fDeletedColor == null ? this.getBackground() : this.fDeletedColor;
    }

    private Color getColor(ILineDiffInfo info) {
        Assert.isTrue((info != null && info.getChangeType() != 0 ? 1 : 0) != 0);
        Color ret = null;
        switch (info.getChangeType()) {
            case 2: {
                ret = this.getShadedColor(this.fChangedColor);
                break;
            }
            case 1: {
                ret = this.getShadedColor(this.fAddedColor);
                break;
            }
        }
        return ret == null ? this.getBackground() : ret;
    }

    private Color getShadedColor(Color color) {
        if (color == null) {
            return null;
        }
        if (this.fSharedColors == null) {
            return color;
        }
        RGB baseRGB = color.getRGB();
        RGB background = this.getBackground().getRGB();
        boolean darkBase = LpexLineNumberChangeRulerColumn.isDark(baseRGB);
        boolean darkBackground = LpexLineNumberChangeRulerColumn.isDark(background);
        if (darkBase && darkBackground) {
            background = new RGB(255, 255, 255);
        } else if (!darkBase && !darkBackground) {
            background = new RGB(0, 0, 0);
        }
        return this.fSharedColors.getColor(LpexLineNumberChangeRulerColumn.interpolate(baseRGB, background, 0.6));
    }

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
    }

    private static double greyLevel(RGB rgb) {
        if (rgb.red == rgb.green && rgb.green == rgb.blue) {
            return rgb.red;
        }
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue + 0.5;
    }

    private static boolean isDark(RGB rgb) {
        return LpexLineNumberChangeRulerColumn.greyLevel(rgb) > 128.0;
    }

    protected Color getBackground(Display display) {
        return this.fBackground == null ? display.getSystemColor(25) : this.fBackground;
    }

    private Color getBackground() {
        return this.fBackground == null ? this.fCachedTextWidget.getDisplay().getSystemColor(25) : this.fBackground;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postRedraw() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            d.asyncExec(this.fRunnable);
        }
    }

    class AnnotationListener
    implements IAnnotationModelListener {
        AnnotationListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            LpexLineNumberChangeRulerColumn.this.postRedraw();
        }
    }

    private class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
        }

        public void mouseDown(MouseEvent event) {
            LpexLineNumberChangeRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        public void mouseDoubleClick(MouseEvent event) {
            LpexLineNumberChangeRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        public void mouseMove(MouseEvent event) {
            LpexLineNumberChangeRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }
    }
}

