/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexView;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.swt.widgets.Display;

public class LpexCompositeRuler
extends CompositeRuler
implements IViewportListener {
    private ViewportSynch viewportSynch = null;
    private int verticalOffset;

    public LpexCompositeRuler() {
    }

    public LpexCompositeRuler(int gap) {
        super(gap);
    }

    public int toDocumentLineNumber(int y_coordinate) {
        LpexTextViewer textViewer = (LpexTextViewer)this.getTextViewer();
        if (textViewer == null || y_coordinate == -1) {
            return -1;
        }
        int top = textViewer.getTopInset() + textViewer.getFirstLpexWindow().textWindow().getLocation().y;
        if (y_coordinate < top) {
            return -1;
        }
        LpexView lpexView = textViewer.getFirstLpexView();
        int row = (y_coordinate - top) / lpexView.queryInt("rowHeight") + 1;
        return LpexCompositeRuler._widgetLine2ModelLine(textViewer, row);
    }

    private static int _widgetLine2ModelLine(LpexTextViewer viewer, int widgetRow) {
        if (viewer != null) {
            LpexView lpexView = viewer.getFirstLpexView();
            if (widgetRow > lpexView.queryInt("rows")) {
                return -1;
            }
            int element = lpexView.elementOfRow(widgetRow);
            if (element == 0) {
                return -1;
            }
            if (lpexView.show(element)) {
                return -1;
            }
            return lpexView.lineOfElement(element) - 1;
        }
        return widgetRow;
    }

    public void postRedraw() {
        Display d;
        if (this.getControl() != null && !this.getControl().isDisposed() && (d = this.getControl().getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                @Override
                public void run() {
                    LpexCompositeRuler.this.getControl().redraw();
                }
            });
        }
    }

    public void viewportChanged(int verticalOffset) {
        this.verticalOffset = verticalOffset;
        if (this.viewportSynch == null) {
            this.viewportSynch = new ViewportSynch(verticalOffset);
            this.viewportSynch.start();
        }
    }

    private class ViewportSynch
    implements Runnable {
        private int startingOffset;

        public ViewportSynch(int verticalOffset) {
            this.startingOffset = verticalOffset;
        }

        @Override
        public void run() {
            if (LpexCompositeRuler.this.getControl() != null && !LpexCompositeRuler.this.getControl().isDisposed()) {
                LpexCompositeRuler.this.getControl().redraw();
                if (LpexCompositeRuler.this.verticalOffset != this.startingOffset) {
                    LpexCompositeRuler.this.viewportSynch = new ViewportSynch(LpexCompositeRuler.this.verticalOffset);
                    LpexCompositeRuler.this.viewportSynch.start();
                } else {
                    LpexCompositeRuler.this.viewportSynch = null;
                }
            } else {
                LpexCompositeRuler.this.viewportSynch = null;
            }
        }

        public void start() {
            Display d;
            if (LpexCompositeRuler.this.getControl() != null && !LpexCompositeRuler.this.getControl().isDisposed() && (d = LpexCompositeRuler.this.getControl().getDisplay()) != null) {
                d.asyncExec((Runnable)this);
            }
        }
    }
}

