/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexSourceViewer;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexWindow;
import java.util.Iterator;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public class LpexAnnotationBarHoverManager
extends AnnotationBarHoverManager {
    public LpexAnnotationBarHoverManager(IVerticalRulerInfo rulerInfo, ISourceViewer sourceViewer, IAnnotationHover annotationHover, IInformationControlCreator creator) {
        super(rulerInfo, sourceViewer, annotationHover, creator);
        this.setMargins(3, 0);
    }

    protected void computeInformation() {
        this.fAllowMouseExit = false;
        MouseEvent event = this.getHoverEvent();
        if ((event.stateMask & SWT.BUTTON_MASK) != 0) {
            this.setInformation(null, null);
            return;
        }
        IAnnotationHover hover = this._getHover(event);
        if (hover == null) {
            this.setInformation(null, null);
            return;
        }
        int yLocation = this.getHoverEventLocation().y;
        int line = this.getVerticalRulerInfo().toDocumentLineNumber(yLocation);
        if (hover instanceof IAnnotationHoverExtension) {
            IAnnotationHoverExtension extension = (IAnnotationHoverExtension)hover;
            ILineRange range = extension.getHoverLineRange(this.getSourceViewer(), line);
            this.setCustomInformationControlCreator(extension.getHoverControlCreator());
            range = this._adaptLineRange(range, line);
            if (range != null) {
                this.setInformation(extension.getHoverInfo(this.getSourceViewer(), range, ((LpexSourceViewer)this.getSourceViewer()).getFirstLpexView().queryInt("rows")), this.computeArea(range));
            } else {
                this.setInformation(null, null);
            }
        } else {
            this.setCustomInformationControlCreator(null);
            String info = null;
            info = hover.getHoverInfo(this.getSourceViewer(), line);
            if (info == null || info.length() == 0) {
                info = this.getAnnotationHover().getHoverInfo(this.getSourceViewer(), line);
            }
            this.setInformation(info, this.computeArea(line, yLocation));
        }
    }

    private Rectangle computeArea(int line, int y) {
        Point rulerSize = this.getVerticalRulerInfo().getControl().getSize();
        if (line < 0) {
            return new Rectangle(0, y, rulerSize.x, 2);
        }
        LpexSourceViewer lpexSourceViewer = (LpexSourceViewer)this.getSourceViewer();
        LpexView lpexView = lpexSourceViewer.getFirstLpexView();
        if (lpexView == null) {
            return null;
        }
        int topPixel = lpexSourceViewer.getTopInset() + lpexSourceViewer.getFirstLpexWindow().textWindow().getLocation().y;
        int lineHeight = lpexView.queryInt("rowHeight");
        int row = (y - topPixel) / lineHeight;
        return new Rectangle(0, topPixel + 1 + row * lineHeight, rulerSize.x, lineHeight);
    }

    private Rectangle computeArea(ILineRange lineRange) {
        LpexSourceViewer lpexSourceViewer = (LpexSourceViewer)this.getSourceViewer();
        LpexView lpexView = lpexSourceViewer.getFirstLpexView();
        int startLine = lineRange.getStartLine() + 1;
        int startRow = -1;
        int rows = lpexView.queryInt("rows");
        int i = 1;
        while (i <= rows) {
            int element = lpexView.elementOfRow(i);
            if (element != 0 && !lpexView.show(element) && lpexView.lineOfElement(element) == startLine) {
                startRow = --i;
                break;
            }
            ++i;
        }
        if (startRow < 0) {
            return null;
        }
        int topPixel = lpexSourceViewer.getTopInset() + lpexSourceViewer.getFirstLpexWindow().textWindow().getLocation().y;
        int lineHeight = lpexView.queryInt("rowHeight");
        return new Rectangle(0, topPixel + 1 + startRow * lineHeight, this.getVerticalRulerInfo().getControl().getSize().x, lineHeight * lineRange.getNumberOfLines());
    }

    private IAnnotationHover _getHover(MouseEvent event) {
        if (event == null || event.getSource() == null) {
            return this.getAnnotationHover();
        }
        IVerticalRulerInfo _verticalRulerInfo = this.getVerticalRulerInfo();
        if (_verticalRulerInfo instanceof CompositeRuler) {
            CompositeRuler comp = (CompositeRuler)_verticalRulerInfo;
            Iterator it = comp.getDecoratorIterator();
            while (it.hasNext()) {
                IAnnotationHover hover;
                Object o = it.next();
                if (!(o instanceof IVerticalRulerInfoExtension) || !(o instanceof IVerticalRulerInfo) || ((IVerticalRulerInfo)o).getControl() != event.getSource() || (hover = ((IVerticalRulerInfoExtension)o).getHover()) == null) continue;
                return hover;
            }
        }
        return this.getAnnotationHover();
    }

    private ILineRange _adaptLineRange(ILineRange lineRange, int line) {
        if (lineRange == null) {
            return null;
        }
        int orgStart = lineRange.getStartLine();
        int orgLast = orgStart + lineRange.getNumberOfLines() - 1;
        int newStart = -1;
        int newNumberOfLines = 0;
        LpexView lpexView = ((LpexSourceViewer)this.getSourceViewer()).getFirstLpexView();
        int rows = lpexView.queryInt("rows");
        int lastLine = -1;
        int i = 1;
        while (i <= rows) {
            int element = lpexView.elementOfRow(i);
            if (element != 0) {
                if (lpexView.show(element)) {
                    if (newStart != -1) {
                        if (lastLine >= line) break;
                        newStart = -1;
                    }
                } else {
                    int currentLine = lpexView.lineOfElement(element) - 1;
                    if (currentLine > orgLast) break;
                    if (currentLine >= orgStart) {
                        if (newStart == -1) {
                            newStart = currentLine;
                            lastLine = currentLine;
                            newNumberOfLines = 1;
                        } else {
                            if (currentLine != ++lastLine) break;
                            ++newNumberOfLines;
                        }
                    }
                }
            }
            ++i;
        }
        return newStart != -1 ? new LineRange(newStart, newNumberOfLines) : null;
    }

    protected Point computeSizeConstraints(Control subjectControl, Rectangle subjectArea, IInformationControl informationControl) {
        Rectangle r;
        LpexWindow window;
        Point constraints = super.computeSizeConstraints(subjectControl, subjectArea, informationControl);
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer instanceof LpexSourceViewer && (window = ((LpexSourceViewer)viewer).getFirstLpexWindow()) != null && (r = window.textWindow().getClientArea()) != null) {
            constraints.x = r.width;
            constraints.y = r.height;
        }
        return constraints;
    }
}

