/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.DocumentAdapter;
import com.ibm.lpex.alef.EditorStatusLine;
import com.ibm.lpex.alef.KeyBindings;
import com.ibm.lpex.alef.LPEXView;
import com.ibm.lpex.alef.LpexAbstractDecoratedTextEditor;
import com.ibm.lpex.alef.LpexCompositeRuler;
import com.ibm.lpex.alef.LpexContextContributor;
import com.ibm.lpex.alef.LpexFocusedInformationPresenter;
import com.ibm.lpex.alef.LpexKeyBindingAction;
import com.ibm.lpex.alef.LpexLanguageHelp;
import com.ibm.lpex.alef.LpexPlugin;
import com.ibm.lpex.alef.LpexRulerColumnWrapper;
import com.ibm.lpex.alef.LpexSourceViewer;
import com.ibm.lpex.alef.LpexSourceViewerConfiguration;
import com.ibm.lpex.alef.LpexTextSelection;
import com.ibm.lpex.alef.LpexTextSelectionNavigationLocation;
import com.ibm.lpex.alef.LpexTextViewer;
import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexBaseAction;
import com.ibm.lpex.core.LpexCommand;
import com.ibm.lpex.core.LpexDocumentListener;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexDocumentSectionListener;
import com.ibm.lpex.core.LpexKeyListener;
import com.ibm.lpex.core.LpexLog;
import com.ibm.lpex.core.LpexMultiWindow;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexUtilities;
import com.ibm.lpex.core.LpexView;
import com.ibm.lpex.core.LpexViewAdapter;
import com.ibm.lpex.core.LpexViewListener;
import com.ibm.lpex.core.LpexWindow;
import com.ibm.lpex.core.StatusLineListener;
import com.ibm.lpex.core.Utilities;
import com.ibm.lpex.samples.Lpex;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.CommandNotMappedException;
import org.eclipse.ui.actions.ContributedAction;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.texteditor.EditPosition;
import org.eclipse.ui.internal.texteditor.FocusedInformationPresenter;
import org.eclipse.ui.internal.texteditor.HistoryTracker;
import org.eclipse.ui.internal.texteditor.NLSUtility;
import org.eclipse.ui.internal.texteditor.TextEditorPlugin;
import org.eclipse.ui.internal.texteditor.rulers.StringSetSerializer;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.operations.OperationHistoryActionHandler;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProviderExtension;
import org.eclipse.ui.texteditor.IDocumentProviderExtension2;
import org.eclipse.ui.texteditor.IDocumentProviderExtension3;
import org.eclipse.ui.texteditor.IDocumentProviderExtension5;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.IElementStateListenerExtension;
import org.eclipse.ui.texteditor.IReadOnlyDependent;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension4;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.RevertToSavedAction;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.TextSelectionNavigationLocation;
import org.eclipse.ui.texteditor.rulers.IColumnSupport;
import org.eclipse.ui.texteditor.rulers.IContributedRulerColumn;
import org.eclipse.ui.texteditor.rulers.RulerColumnDescriptor;
import org.eclipse.ui.texteditor.rulers.RulerColumnPreferenceAdapter;
import org.eclipse.ui.texteditor.rulers.RulerColumnRegistry;
import org.osgi.framework.Bundle;

public abstract class LpexAbstractTextEditor
extends EditorPart
implements ITextEditor,
IReusableEditor,
ITextEditorExtension,
ITextEditorExtension4,
INavigationLocationProvider,
ISaveablesSource {
    private LpexFocusedInformationPresenter fInformationPresenter;
    private static final String TAG_CONTRIBUTION_TYPE = "editorContribution";
    public static final String PREFERENCE_COLOR_BACKGROUND = "AbstractTextEditor.Color.Background";
    public static final String PREFERENCE_COLOR_BACKGROUND_SYSTEM_DEFAULT = "AbstractTextEditor.Color.Background.SystemDefault";
    public static final String PREFERENCE_HYPERLINKS_ENABLED = "hyperlinksEnabled";
    public static final String PREFERENCE_HYPERLINK_KEY_MODIFIER = "hyperlinkKeyModifier";
    public static final String PREFERENCE_HYPERLINK_KEY_MODIFIER_MASK = "hyperlinkKeyModifierMask";
    public static final String PREFERENCE_RULER_CONTRIBUTIONS = "rulerContributions";
    public static final String DEFAULT_EDITOR_CONTEXT_MENU_ID = "#LpexEditorContext";
    public static final String DEFAULT_RULER_CONTEXT_MENU_ID = "#LpexRulerContext";
    protected static final int VERTICAL_RULER_WIDTH = 12;
    static final IdMapEntry[] ACTION_MAP = new IdMapEntry[]{new IdMapEntry("org.eclipse.ui.edit.text.goto.lineUp", 206), new IdMapEntry("org.eclipse.ui.edit.text.goto.lineDown", 94), new IdMapEntry("org.eclipse.ui.edit.text.goto.lineStart", 119), new IdMapEntry("org.eclipse.ui.edit.text.goto.lineEnd", 96), new IdMapEntry("org.eclipse.ui.edit.text.goto.columnPrevious", 136), new IdMapEntry("org.eclipse.ui.edit.text.goto.columnNext", 175), new IdMapEntry("org.eclipse.ui.edit.text.goto.pageUp", 152), new IdMapEntry("org.eclipse.ui.edit.text.goto.pageDown", 149), new IdMapEntry("org.eclipse.ui.edit.text.goto.wordPrevious", 167), new IdMapEntry("org.eclipse.ui.edit.text.goto.wordNext", 145), new IdMapEntry("org.eclipse.ui.edit.text.goto.textStart", 200), new IdMapEntry("org.eclipse.ui.edit.text.goto.textEnd", 66), new IdMapEntry("org.eclipse.ui.edit.text.goto.windowStart", 211), new IdMapEntry("org.eclipse.ui.edit.text.goto.windowEnd", 210), new IdMapEntry("org.eclipse.ui.edit.text.scroll.lineDown", 181), new IdMapEntry("org.eclipse.ui.edit.text.scroll.lineUp", 185), new IdMapEntry("org.eclipse.ui.edit.text.select.lineUp", 57), new IdMapEntry("org.eclipse.ui.edit.text.select.lineDown", 40), new IdMapEntry("org.eclipse.ui.edit.text.select.lineStart", 44), new IdMapEntry("org.eclipse.ui.edit.text.select.lineEnd", 43), new IdMapEntry("org.eclipse.ui.edit.text.select.columnPrevious", 45), new IdMapEntry("org.eclipse.ui.edit.text.select.columnNext", 54), new IdMapEntry("org.eclipse.ui.edit.text.select.pageUp", 50), new IdMapEntry("org.eclipse.ui.edit.text.select.pageDown", 47), new IdMapEntry("org.eclipse.ui.edit.text.select.wordPrevious", 51), new IdMapEntry("org.eclipse.ui.edit.text.select.wordNext", 46), new IdMapEntry("org.eclipse.ui.edit.text.select.textStart", 56), new IdMapEntry("org.eclipse.ui.edit.text.select.textEnd", 38), new IdMapEntry("org.eclipse.ui.edit.cut", 85), new IdMapEntry("org.eclipse.ui.edit.copy", 83), new IdMapEntry("org.eclipse.ui.edit.paste", 153), new IdMapEntry("org.eclipse.ui.edit.text.deletePrevious", 31), new IdMapEntry("org.eclipse.ui.edit.text.deleteNext", 86), new IdMapEntry("org.eclipse.ui.edit.text.deletePreviousWord", 91), new IdMapEntry("org.eclipse.ui.edit.text.deleteNextWord", 90), new IdMapEntry("org.eclipse.ui.edit.text.delete.line", 89), new IdMapEntry("org.eclipse.ui.edit.text.delete.line.to.beginning", 92), new IdMapEntry("org.eclipse.ui.edit.text.delete.line.to.end", 204), new IdMapEntry("org.eclipse.ui.edit.text.shiftLeft", 62), new IdMapEntry("org.eclipse.ui.edit.text.shiftRight", 63), new IdMapEntry("org.eclipse.ui.edit.text.lowerCase", 36), new IdMapEntry("org.eclipse.ui.edit.text.upperCase", 65), new IdMapEntry("org.eclipse.ui.edit.text.toggleOverwrite", 197), new IdMapEntry("org.eclipse.ui.edit.findIncremental", 103), new IdMapEntry("org.eclipse.ui.edit.findNext", 112), new IdMapEntry("org.eclipse.ui.edit.findPrevious", 115), new IdMapEntry("org.eclipse.ui.edit.text.toggleInsertMode", 197), new IdMapEntry("org.eclipse.ui.edit.text.gotoLastEditPosition", 109), new IdMapEntry("org.eclipse.ui.edit.text.folding.expand_all", 191)};
    private static final ISelectionProvider emptySelectionProvider = new ISelectionProvider(){

        public void addSelectionChangedListener(ISelectionChangedListener arg0) {
        }

        public ISelection getSelection() {
            return TextSelection.emptySelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener arg0) {
        }

        public void setSelection(ISelection arg0) {
        }
    };
    protected final String fErrorLabel = EditorMessages.getString("Editor_statusline_error_label");
    private final String fPositionLabelPattern = EditorMessages.getString("Editor_statusline_position_pattern");
    private final PositionLabelValue fLineLabel = new PositionLabelValue();
    private final PositionLabelValue fColumnLabel = new PositionLabelValue();
    private final Object[] fPositionLabelPatternArguments = new Object[]{this.fLineLabel, this.fColumnLabel};
    private IColumnSupport fColumnSupport;
    private String _statusLineInputMode;
    private int _statusLineChanges;
    private String _statusLineBrowseMode;
    private IDocumentProvider fExplicitDocumentProvider;
    private IPreferenceStore fPreferenceStore;
    private Annotation fRangeIndicator;
    private SourceViewerConfiguration fConfiguration;
    private LpexSourceViewer fSourceViewer;
    private IEditorStatusLine fEditorStatusLine;
    private IVerticalRuler fVerticalRuler;
    private String fEditorContextMenuId = null;
    private String fRulerContextMenuId = null;
    private String fHelpContextId;
    private boolean fShowHighlightRangeOnly;
    private Map<String, IAction> fActions = new HashMap<String, IAction>(10);
    private Map<String, IAction> fKeybindingActions = new HashMap<String, IAction>(80);
    private List<String> fPropertyActions = new ArrayList<String>(5);
    private List<ActionActivationCode> fActivationCodes = new ArrayList<ActionActivationCode>(2);
    private ActivationCodeTrigger fActivationCodeTrigger = new ActivationCodeTrigger();
    private IMenuListener fMenuListener;
    private MouseListener fMouseListener;
    private Image fTitleImage;
    private boolean fTitleImageEditable;
    private Menu fTextContextMenu;
    private Menu fRulerContextMenu;
    private IElementStateListener fElementStateListener = new ElementStateListener();
    private TextInputListener fTextInputListener = new TextInputListener();
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private ActivationListener fActivationListener;
    private Map<String, IStatusField> fStatusFields;
    private ITextSelection fRememberedSelection;
    private boolean fCompatibilityMode = true;
    private int fErrorCorrectionOnSave;
    private long fModificationStamp = -1L;
    private List<IMenuListener> fRulerContextMenuListeners = new ArrayList<IMenuListener>();
    private boolean fIsSanityCheckEnabled = true;
    private boolean fIsStateValidationEnabled = true;
    private TextEditorSavable fSavable;
    private boolean fHasBeenActivated;
    private boolean _modified;
    private LpexViewListener _lpexViewListener;
    private FocusListener _commandLineFocusListener;
    private StatusLineListener _statusLineListener;
    private boolean _activeWindowLpexStatusLine;
    private LpexEditorAction _firstAction;
    private IResource _inputResource;
    boolean _traceCommands;
    boolean _partBeingForcedClose;
    private boolean _reverting;
    private ICursorListener fCursorListener;
    private ActionFactory.IWorkbenchAction _saveAction;
    private LpexAction _eclipseUndoAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            lpexView.doAction(205);
        }

        @Override
        public boolean available(LpexView lpexView) {
            return lpexView.actionAvailable(205);
        }
    };
    private LpexAction _eclipseRedoAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            lpexView.doAction(171);
        }

        @Override
        public boolean available(LpexView lpexView) {
            return lpexView.actionAvailable(171);
        }
    };
    private LpexAction _eclipseDeleteAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            lpexView.doAction(lpexView.queryOn("inPrefix") ? LpexAbstractTextEditor.this._originalDeleteIdP : LpexAbstractTextEditor.this._originalDeleteIdT);
        }

        @Override
        public boolean available(LpexView lpexView) {
            return lpexView.actionAvailable(lpexView.queryOn("inPrefix") ? LpexAbstractTextEditor.this._originalDeleteIdP : LpexAbstractTextEditor.this._originalDeleteIdT);
        }
    };
    private LpexAction _helpAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            LpexAbstractTextEditor.this.performHelpAction(lpexView);
        }

        @Override
        public boolean available(LpexView lpexView) {
            return true;
        }
    };
    private LpexCommand _helpCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            return LpexAbstractTextEditor.performHelpCommand(parameters);
        }
    };
    private LpexCommand _loadCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            LpexAbstractTextEditor.this.doRevertToSaved();
            return true;
        }
    };
    private LpexAction _renameAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            lpexView.doCommand("set messageText " + LpexResources.message("action.notAvailable", "rename"));
        }

        @Override
        public boolean available(LpexView lpexView) {
            return true;
        }
    };
    private LpexCommand _saveCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            return LpexAbstractTextEditor.this.performSaveCommand(lpexView, parameters);
        }
    };
    private LpexAction _originalFindAction;
    private int _originalDeleteIdT;
    private int _originalDeleteIdP;
    private int _originalCslIdT;
    private int _originalCslIdP;
    private int _originalCslIdC;
    private LpexCommand _openNewViewCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            LpexAbstractTextEditor.this.openNewView(lpexView);
            return true;
        }
    };
    private LpexAction _openNewViewAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            if (this.available(lpexView)) {
                LpexAbstractTextEditor.this.openNewView(lpexView);
            }
        }

        @Override
        public boolean available(LpexView lpexView) {
            return LpexAbstractTextEditor.this.availableOpenNewView(lpexView);
        }
    };
    private LpexAction _closeViewAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            if (lpexView == LpexAbstractTextEditor.this.getFirstLpexView()) {
                if (lpexView.getLpexViews().length == 1) {
                    LpexAbstractTextEditor.this.close(true);
                }
            } else {
                LpexAbstractTextEditor.this.fSourceViewer.getLpexMultiWindow().closeWindow(lpexView.window());
            }
        }

        @Override
        public boolean available(LpexView lpexView) {
            return lpexView != LpexAbstractTextEditor.this.getFirstLpexView() || lpexView.getLpexViews().length == 1;
        }
    };
    private LpexAction _horizontalSplitAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            lpexView.doCommand("set splitWindow.orientation horizontal");
        }

        @Override
        public boolean available(LpexView lpexView) {
            return "vertical".equalsIgnoreCase(lpexView.query("current.splitWindow.orientation")) && LpexAbstractTextEditor.this.getWindows().length > 1;
        }
    };
    private LpexAction _verticalSplitAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            lpexView.doCommand("set splitWindow.orientation vertical");
        }

        @Override
        public boolean available(LpexView lpexView) {
            return "horizontal".equalsIgnoreCase(lpexView.query("current.splitWindow.orientation")) && LpexAbstractTextEditor.this.getWindows().length > 1;
        }
    };
    private LpexAction _nextViewAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            LpexWindow window = lpexView == null || lpexView.isDisposed() ? null : lpexView.window();
            LpexWindow[] windows = LpexAbstractTextEditor.this.getWindows();
            int i = 0;
            while (i < windows.length) {
                if (windows[i] == window || window == null || window.isDisposed()) {
                    LpexWindow nextwindow;
                    LpexWindow lpexWindow = window == null || window.isDisposed() ? windows[0] : (nextwindow = i < windows.length - 1 ? windows[i + 1] : windows[0]);
                    if (nextwindow != null && !nextwindow.isDisposed()) {
                        nextwindow.setFocus();
                        return;
                    }
                }
                ++i;
            }
        }

        @Override
        public boolean available(LpexView lpexView) {
            return LpexAbstractTextEditor.this.getWindows().length > 1;
        }
    };
    private LpexAction _prevViewAction = new LpexAction(){

        @Override
        public void doAction(LpexView lpexView) {
            LpexWindow window = lpexView == null || lpexView.isDisposed() ? null : lpexView.window();
            LpexWindow[] windows = LpexAbstractTextEditor.this.getWindows();
            int i = 0;
            while (i < windows.length) {
                if (windows[i] == window || window == null || window.isDisposed()) {
                    LpexWindow prevwindow;
                    LpexWindow lpexWindow = window == null || window.isDisposed() ? windows[windows.length - 1] : (prevwindow = i == 0 ? windows[windows.length - 1] : windows[i - 1]);
                    if (prevwindow != null && !prevwindow.isDisposed()) {
                        prevwindow.setFocus();
                        return;
                    }
                }
                ++i;
            }
        }

        @Override
        public boolean available(LpexView lpexView) {
            return LpexAbstractTextEditor.this.getWindows().length > 1;
        }
    };
    private LpexCommand _LpexCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            return LpexAbstractTextEditor.this.performLpexCommand(parameters, false);
        }
    };
    private LpexCommand _viewCommand = new LpexCommand(){

        @Override
        public boolean doCommand(LpexView lpexView, String parameters) {
            if ("log".equalsIgnoreCase(parameters)) {
                LpexView view;
                String logName = LpexView.globalQuery("editorLog");
                if (lpexView != null && (view = lpexView.lpexView(logName)) != null && view.window() != null) {
                    view.doAction(172);
                    view.doCommand("set readonly on");
                    view.window().setFocus();
                    return true;
                }
                return LpexAbstractTextEditor.this.performLpexCommand("\"" + logName + "\"", true);
            }
            if ("profile".equalsIgnoreCase(parameters)) {
                LpexView view;
                LpexView.doGlobalCommand("profile flush");
                String profileName = LpexView.globalQuery("defaultProfile");
                if (lpexView != null && (view = lpexView.lpexView(profileName)) != null && view.window() != null) {
                    view.doAction(172);
                    view.doCommand("set readonly on");
                    view.window().setFocus();
                    return true;
                }
                return LpexAbstractTextEditor.this.performLpexCommand("\"" + profileName + "\"", true);
            }
            return lpexView != null ? lpexView.doCommand("set messageText Syntax: view { log | profile }") : true;
        }
    };
    private LpexDocumentSectionListener _lpexDocumentSectionListener;
    private LpexWindow _activeWindow;
    private String _lastKeybindingBaseProfile;
    private String[] _scopeCommands1;
    private String[] _scopeCommands2;

    private int getYAtPrimaryWindowCursor() {
        int topPixel = this.fSourceViewer.getTopInset() + this.fSourceViewer.getFirstLpexWindow().textWindow().getLocation().y;
        LpexView lpexView = this.fSourceViewer.getFirstLpexView();
        if (lpexView.currentElement() == 0) {
            return topPixel;
        }
        return topPixel + (lpexView.queryInt("cursorRow") - 1) * lpexView.queryInt("rowHeight");
    }

    protected LpexAbstractTextEditor() {
    }

    public IDocumentProvider getDocumentProvider() {
        return this.fExplicitDocumentProvider;
    }

    protected final IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    protected final Annotation getRangeIndicator() {
        return this.fRangeIndicator;
    }

    protected final SourceViewerConfiguration getSourceViewerConfiguration() {
        return this.fConfiguration;
    }

    protected final ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    public final IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    protected final String getEditorContextMenuId() {
        return this.fEditorContextMenuId;
    }

    protected final String getRulerContextMenuId() {
        return this.fRulerContextMenuId;
    }

    protected void setDocumentProvider(IDocumentProvider provider) {
        this.fExplicitDocumentProvider = provider;
    }

    protected void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fConfiguration = configuration;
    }

    protected void setRangeIndicator(Annotation rangeIndicator) {
        Assert.isNotNull((Object)rangeIndicator);
        this.fRangeIndicator = rangeIndicator;
    }

    protected void setEditorContextMenuId(String contextMenuId) {
        Assert.isNotNull((Object)contextMenuId);
        this.fEditorContextMenuId = contextMenuId;
    }

    protected void setRulerContextMenuId(String contextMenuId) {
        Assert.isNotNull((Object)contextMenuId);
        this.fRulerContextMenuId = contextMenuId;
    }

    protected final void setCompatibilityMode(boolean compatible) {
        this.fCompatibilityMode = compatible;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.fSourceViewer == null ? emptySelectionProvider : this.fSourceViewer.getSelectionProvider();
    }

    protected void rememberSelection() {
        ISelectionProvider sp = this.getSelectionProvider();
        ISelection is = sp == null ? null : sp.getSelection();
        this.fRememberedSelection = is instanceof ITextSelection ? (ITextSelection)is : null;
    }

    protected void restoreSelection() {
        if (this.getSourceViewer() != null && this.fRememberedSelection != null && !this._reverting && this.isValidSelection(this.fRememberedSelection.getOffset(), this.fRememberedSelection.getLength())) {
            this.selectAndReveal(this.fRememberedSelection.getOffset(), this.fRememberedSelection.getLength());
        }
        this.fRememberedSelection = null;
    }

    private boolean isValidSelection(int offset, int len) {
        IDocument document;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null && (document = provider.getDocument((Object)this.getEditorInput())) != null) {
            int end = offset + len;
            int documentLength = document.getLength();
            return offset >= 0 && offset <= documentLength && end >= 0 && end <= documentLength && len >= 0;
        }
        return false;
    }

    protected IMenuListener createContextMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                String id = menu.getId();
                if (LpexAbstractTextEditor.this.getRulerContextMenuId().equals(id)) {
                    LpexAbstractTextEditor.this.setFocus();
                    LpexAbstractTextEditor.this.rulerContextMenuAboutToShow(menu);
                } else if (LpexAbstractTextEditor.this.getEditorContextMenuId().equals(id)) {
                    LpexAbstractTextEditor.this.setFocus();
                    LpexAbstractTextEditor.this.editorContextMenuAboutToShow(menu);
                }
            }
        };
    }

    protected final IMenuListener getContextMenuListener() {
        if (this.fMenuListener == null) {
            this.fMenuListener = this.createContextMenuListener();
        }
        return this.fMenuListener;
    }

    protected final MouseListener getRulerMouseListener() {
        if (this.fMouseListener == null) {
            this.fMouseListener = new MouseListener(){
                private boolean fDoubleClicked = false;
                private final int fDoubleClickTime = Display.getDefault().getDoubleClickTime();
                private long fMouseUpDelta = 0L;

                private void triggerAction(String actionID, MouseEvent e) {
                    IAction action = LpexAbstractTextEditor.this.getAction(actionID);
                    if (action != null) {
                        if (action instanceof IUpdate) {
                            ((IUpdate)action).update();
                        }
                        if (action.isEnabled()) {
                            Event event = new Event();
                            event.type = this.fDoubleClicked ? 8 : 4;
                            event.display = e.display;
                            event.widget = e.widget;
                            event.time = e.time;
                            event.data = e.data;
                            event.x = e.x;
                            event.y = e.y;
                            event.button = e.button;
                            event.stateMask = e.stateMask;
                            event.count = e.count;
                            action.runWithEvent(event);
                        }
                    }
                }

                public void mouseUp(final MouseEvent e) {
                    int delay;
                    LpexAbstractTextEditor.this.setFocus();
                    int n = delay = this.fMouseUpDelta == 0L ? 0 : this.fDoubleClickTime - (int)(System.currentTimeMillis() - this.fMouseUpDelta);
                    if (1 != e.button) {
                        return;
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!fDoubleClicked) {
                                this.triggerAction("RulerClick", e);
                            }
                        }
                    };
                    if (delay <= 0) {
                        runnable.run();
                    } else {
                        e.widget.getDisplay().timerExec(delay, runnable);
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                    if (1 == e.button) {
                        this.fDoubleClicked = true;
                        this.triggerAction("RulerDoubleClick", e);
                    }
                }

                public void mouseDown(MouseEvent e) {
                    this.fMouseUpDelta = System.currentTimeMillis();
                    this.fDoubleClicked = false;
                    if (LpexAbstractTextEditor.this.fRulerContextMenu != null && !LpexAbstractTextEditor.this.fRulerContextMenu.isDisposed()) {
                        Display display = LpexAbstractTextEditor.this.fRulerContextMenu.getDisplay();
                        Point location = display.getCursorLocation();
                        LpexAbstractTextEditor.this.fRulerContextMenu.setLocation(location.x, location.y);
                    }
                }
            };
        }
        return this.fMouseListener;
    }

    protected boolean affectsTextPresentation(PropertyChangeEvent event) {
        return false;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        String property;
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.affectsTextPresentation(event)) {
            this.fSourceViewer.invalidateTextPresentation();
        }
        if (PREFERENCE_HYPERLINKS_ENABLED.equals(property = event.getProperty())) {
            IHyperlinkDetector[] detectors = this.getSourceViewerConfiguration().getHyperlinkDetectors((ISourceViewer)this.fSourceViewer);
            int stateMask = this.getSourceViewerConfiguration().getHyperlinkStateMask((ISourceViewer)this.fSourceViewer);
            this.fSourceViewer.setHyperlinkDetectors(detectors, stateMask);
            return;
        }
        if (PREFERENCE_HYPERLINK_KEY_MODIFIER.equals(property)) {
            IHyperlinkDetector[] detectors = this.getSourceViewerConfiguration().getHyperlinkDetectors((ISourceViewer)this.fSourceViewer);
            int stateMask = this.getSourceViewerConfiguration().getHyperlinkStateMask((ISourceViewer)this.fSourceViewer);
            this.fSourceViewer.setHyperlinkDetectors(detectors, stateMask);
            return;
        }
        if (PREFERENCE_RULER_CONTRIBUTIONS.equals(property)) {
            IColumnSupport support = (IColumnSupport)this.getAdapter(IColumnSupport.class);
            if (support != null) {
                String[] difference = StringSetSerializer.getDifference((String)((String)event.getOldValue()), (String)((String)event.getNewValue()));
                int i = 0;
                while (i < difference.length) {
                    RulerColumnDescriptor desc = RulerColumnRegistry.getDefault().getColumnDescriptor(difference[i]);
                    if (desc != null && support.isColumnSupported(desc)) {
                        boolean newState = !support.isColumnVisible(desc);
                        support.setColumnVisible(desc, newState);
                    }
                    ++i;
                }
            }
            return;
        }
        if ("hoverReplaceMode".equals(property)) {
            IPreferenceStore store;
            if (this.fSourceViewer != null && (store = this.getPreferenceStore()) != null) {
                this.fSourceViewer.setHoverEnrichMode(this.convertEnrichModePreference(store.getInt("hoverReplaceMode")));
            }
            return;
        }
    }

    private static final IEditorPart findEditor(IEditorInput input) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int w = 0;
        while (w < windows.length) {
            IWorkbenchPage[] pages = windows[w].getPages();
            int p = 0;
            while (p < pages.length) {
                IEditorReference[] editors = pages[p].getEditorReferences();
                int e = 0;
                while (e < editors.length) {
                    IEditorInput editorInput;
                    IEditorPart editorPart = editors[e].getEditor(false);
                    if (editorPart != null && editors[e] instanceof EditorReference && ((EditorReference)editors[e]).getModel() != null && ((EditorReference)editors[e]).getModel().getContext() != null && ((EditorReference)editors[e]).getModel().getContext().get(IEditorPart.class) != null && (editorInput = editorPart.getEditorInput()).equals(input)) {
                        return editorPart;
                    }
                    ++e;
                }
                ++p;
            }
            ++w;
        }
        return null;
    }

    private void editorPartSetInput(IEditorInput input) {
        super.setInput(input);
    }

    protected final void internalInit(IWorkbenchWindow window, IEditorSite site, final IEditorInput input) throws PartInitException {
        LpexAbstractTextEditor selfEditorPart = this;
        final IWorkbenchWindow paramWindow = window;
        final IEditorSite paramSite = site;
        IRunnableWithProgress runnable = new IRunnableWithProgress((IEditorPart)selfEditorPart){
            private final /* synthetic */ IEditorPart val$selfEditorPart;
            {
                this.val$selfEditorPart = iEditorPart;
            }

            /*
             * Unable to fully structure code
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    if (LpexAbstractTextEditor.this.getDocumentProvider() instanceof IDocumentProviderExtension2) {
                        extension = (IDocumentProviderExtension2)LpexAbstractTextEditor.this.getDocumentProvider();
                        extension.setProgressMonitor(monitor);
                    }
                    if ((openEditorPart = LpexAbstractTextEditor.findEditor(input)) == null) ** GOTO lbl28
                    thisWorkbenchWindow = openEditorPart.getEditorSite().getWorkbenchWindow().equals(paramWindow);
                    lpexOpenEditorPart = openEditorPart instanceof LpexAbstractTextEditor;
                    v0 = multiPageOpenEditorPart = paramSite instanceof MultiPageEditorSite != false && ((MultiPageEditorSite)paramSite).getMultiPageEditor() == openEditorPart;
                    if (thisWorkbenchWindow && lpexOpenEditorPart) {
                        LpexAbstractTextEditor.this._partBeingForcedClose = true;
                        LpexAbstractTextEditor.this.editorPartSetInput(input);
                        LpexAbstractTextEditor.this.enableSanityChecking(false);
                        site = LpexAbstractTextEditor.this.getSite();
                        shell = site == null ? null : site.getShell();
                        v1 = display = shell == null || shell.isDisposed() != false ? null : shell.getDisplay();
                        if (display != null && !display.isDisposed()) {
                            display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IWorkbenchPartSite site = LpexAbstractTextEditor.this.getSite();
                                    if (site == null) {
                                        return;
                                    }
                                    IWorkbenchPage page = site.getPage();
                                    if (page == null) {
                                        return;
                                    }
                                    if ((this).LpexAbstractTextEditor.this.fSourceViewer != null) {
                                        if (openEditorPart != null) {
                                            try {
                                                page.bringToTop((IWorkbenchPart)openEditorPart);
                                            }
                                            catch (Throwable t) {
                                                LpexLog.log(t);
                                            }
                                        }
                                        if (val$selfEditorPart != null) {
                                            try {
                                                page.closeEditor(val$selfEditorPart, false);
                                            }
                                            catch (Throwable t) {
                                                LpexLog.log(t);
                                            }
                                        }
                                    } else {
                                        if (val$selfEditorPart != null) {
                                            try {
                                                page.closeEditor(val$selfEditorPart, false);
                                            }
                                            catch (Throwable t) {
                                                LpexLog.log(t);
                                            }
                                        }
                                        if (openEditorPart != null) {
                                            try {
                                                page.bringToTop((IWorkbenchPart)openEditorPart);
                                            }
                                            catch (Throwable t) {
                                                LpexLog.log(t);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                        if ((lpex = (LpexAbstractTextEditor)openEditorPart).openNewView(lpex.getActiveLpexView())) {
                            LpexView.doGlobalCommand("screenShow");
                        }
                        return;
                    }
                    if (thisWorkbenchWindow && multiPageOpenEditorPart) {
                        LpexAbstractTextEditor.this.doSetInput(input);
                        return;
                    }
                    try {
                        LpexAbstractTextEditor.this.doSetInput(input);
                        throw new PartInitException((IStatus)new Status(4, "com.ibm.lpex", 0, LpexResources.message("document.open"), null));
lbl28:
                        // 1 sources

                        LpexAbstractTextEditor.this.doSetInput(input);
                    }
                    catch (CoreException x) {
                        throw new InvocationTargetException(x);
                    }
                }
                finally {
                    if (LpexAbstractTextEditor.this.getDocumentProvider() instanceof IDocumentProviderExtension2) {
                        extension = (IDocumentProviderExtension2)LpexAbstractTextEditor.this.getDocumentProvider();
                        extension.setProgressMonitor(null);
                    }
                }
            }
        };
        try {
            this.getSite().getWorkbenchWindow().run(false, true, runnable);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof CoreException) {
                CoreException e = (CoreException)t;
                IStatus status = e.getStatus();
                if (status.getException() != null) {
                    throw new PartInitException(status);
                }
                throw new PartInitException((IStatus)new Status(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), t));
            }
            throw new PartInitException((IStatus)new Status(4, "com.ibm.lpex", 0, EditorMessages.getString("Editor_error_init"), t));
        }
        catch (Throwable t) {
            throw new PartInitException((IStatus)new Status(4, "com.ibm.lpex", 0, EditorMessages.getString("Editor_error_init"), t));
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.internalInit(site.getWorkbenchWindow(), site, input);
        this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
    }

    protected IVerticalRuler createVerticalRuler() {
        return null;
    }

    protected void updateContributedRulerColumns(LpexCompositeRuler ruler) {
        IColumnSupport support = (IColumnSupport)this.getAdapter(IColumnSupport.class);
        if (support == null) {
            return;
        }
        RulerColumnPreferenceAdapter adapter = null;
        if (this.fPreferenceStore != null) {
            adapter = new RulerColumnPreferenceAdapter(this.getPreferenceStore(), PREFERENCE_RULER_CONTRIBUTIONS);
        }
        RulerColumnRegistry registry = RulerColumnRegistry.getDefault();
        List descriptors = registry.getColumnDescriptors();
        for (RulerColumnDescriptor descriptor : descriptors) {
            support.setColumnVisible(descriptor, adapter == null || adapter.isEnabled(descriptor));
        }
    }

    protected IColumnSupport createColumnSupport() {
        return null;
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        return new LpexSourceViewer(parent, this, ruler, styles);
    }

    protected void initializeDragAndDrop(ISourceViewer viewer) {
    }

    public void createPartControl(Composite parent) {
        String partId;
        String partId2;
        if (this._partBeingForcedClose) {
            return;
        }
        this.fVerticalRuler = this.createVerticalRuler();
        int styles = 2048;
        this.fSourceViewer = (LpexSourceViewer)this.createSourceViewer(parent, this.fVerticalRuler, styles);
        if (this.fConfiguration == null) {
            this.fConfiguration = new LpexSourceViewerConfiguration();
        }
        this.fSourceViewer.configure(this.fConfiguration);
        if (this.fRangeIndicator != null) {
            this.fSourceViewer.setRangeIndicator(this.fRangeIndicator);
        }
        LpexWindow lpexWindow = this.fSourceViewer.getFirstLpexWindow();
        lpexWindow.textWindow().addMouseListener((MouseListener)this.getCursorListener());
        lpexWindow.textWindow().addKeyListener((KeyListener)this.getCursorListener());
        this.initializeDragAndDrop(this.fSourceViewer);
        String id = this.fEditorContextMenuId != null ? this.fEditorContextMenuId : DEFAULT_EDITOR_CONTEXT_MENU_ID;
        MenuManager manager = this.createContextMenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        this.fTextContextMenu = manager.createContextMenu((Control)lpexWindow.textWindow());
        lpexWindow.textWindow().setMenu(this.fTextContextMenu);
        if (this.fEditorContextMenuId != null) {
            this.getEditorSite().registerContextMenu(this.fEditorContextMenuId, manager, this.getSelectionProvider(), this.isEditorInputIncludedInContextMenu());
        } else if (this.fCompatibilityMode) {
            this.getEditorSite().registerContextMenu(DEFAULT_EDITOR_CONTEXT_MENU_ID, manager, this.getSelectionProvider(), this.isEditorInputIncludedInContextMenu());
        }
        if ((this.fEditorContextMenuId != null && this.fCompatibilityMode || this.fEditorContextMenuId == null) && (partId2 = this.getEditorSite().getId()) != null) {
            this.getEditorSite().registerContextMenu(partId2 + ".EditorContext", manager, this.getSelectionProvider(), this.isEditorInputIncludedInContextMenu());
        }
        if (this.fEditorContextMenuId == null) {
            this.fEditorContextMenuId = DEFAULT_EDITOR_CONTEXT_MENU_ID;
        }
        id = this.fRulerContextMenuId != null ? this.fRulerContextMenuId : DEFAULT_RULER_CONTEXT_MENU_ID;
        manager = new MenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        Control rulerControl = this.fVerticalRuler.getControl();
        this.fRulerContextMenu = manager.createContextMenu(rulerControl);
        rulerControl.setMenu(this.fRulerContextMenu);
        rulerControl.addMouseListener(this.getRulerMouseListener());
        if (this.fRulerContextMenuId != null) {
            this.getEditorSite().registerContextMenu(this.fRulerContextMenuId, manager, this.getSelectionProvider(), false);
        } else if (this.fCompatibilityMode) {
            this.getEditorSite().registerContextMenu(DEFAULT_RULER_CONTEXT_MENU_ID, manager, this.getSelectionProvider(), false);
        }
        if ((this.fRulerContextMenuId != null && this.fCompatibilityMode || this.fRulerContextMenuId == null) && (partId = this.getSite().getId()) != null) {
            this.getEditorSite().registerContextMenu(partId + ".RulerContext", manager, this.getSelectionProvider(), false);
        }
        this.getEditorSite().registerContextMenu("#AbstractTextEditorRulerContext", manager, this.getSelectionProvider(), false);
        if (this.fRulerContextMenuId == null) {
            this.fRulerContextMenuId = DEFAULT_RULER_CONTEXT_MENU_ID;
        }
        this.getSite().setSelectionProvider(this.getSelectionProvider());
        this.initializeSourceViewer(this.getEditorInput());
        this.createNavigationActions();
        this.createAccessibilityActions();
        this.createActions();
        IVerticalRuler ruler = this.getVerticalRuler();
        if (ruler instanceof LpexCompositeRuler) {
            this.updateContributedRulerColumns((LpexCompositeRuler)ruler);
        }
        lpexWindow.getLpexView().appendLpexDocumentListener(new LpexDocumentListener(){
            boolean fIsRunnablePosted = false;
            boolean fProcessingChanges = false;
            boolean fUpdateLastEditPosition = false;
            boolean fIsDirty = false;
            ISelection sel = null;
            private Position fLocalLastEditPosition = null;
            private Runnable fRunnable = new Runnable(){

                @Override
                public void run() {
                    fIsRunnablePosted = false;
                    if ((this).LpexAbstractTextEditor.this.fSourceViewer != null && fIsDirty && fUpdateLastEditPosition) {
                        TextEditorPlugin tep;
                        HistoryTracker history;
                        fUpdateLastEditPosition = false;
                        IEditorInput input = LpexAbstractTextEditor.this.getEditorInput();
                        IDocument document = LpexAbstractTextEditor.this.getDocumentProvider().getDocument((Object)input);
                        if (fLocalLastEditPosition != null) {
                            document.removePosition(fLocalLastEditPosition);
                            fLocalLastEditPosition = null;
                        }
                        if (sel instanceof ITextSelection && !sel.isEmpty()) {
                            ITextSelection s = (ITextSelection)sel;
                            fLocalLastEditPosition = new Position(s.getOffset(), s.getLength());
                            try {
                                document.addPosition(fLocalLastEditPosition);
                            }
                            catch (BadLocationException ex) {
                                fLocalLastEditPosition = null;
                            }
                        }
                        if (fLocalLastEditPosition != null && (history = (tep = TextEditorPlugin.getDefault()).getEditPositionHistory()) != null) {
                            IEditorSite site = LpexAbstractTextEditor.this.getEditorSite();
                            String siteId = site == null ? null : site.getId();
                            EditPosition ep = new EditPosition(input, siteId, fLocalLastEditPosition);
                            history.addOrReplace((Object)ep);
                            tep.setEditPositionHistory(history);
                        }
                    }
                }
            };

            @Override
            public void documentChanged(LpexView lpexView, int type, int line, int position, int count) {
                if (!this.fIsRunnablePosted) {
                    if (type == 6) {
                        this.fProcessingChanges = true;
                    } else if (!this.fProcessingChanges || type == 7) {
                        this.fProcessingChanges = false;
                        this.fIsRunnablePosted = true;
                        this.fUpdateLastEditPosition = true;
                        this.fIsDirty = LpexAbstractTextEditor.this.isDirty();
                        if (line < lpexView.queryInt("lines")) {
                            if (LpexAbstractTextEditor.this.getSelectionProvider() instanceof LpexTextViewer) {
                                LpexTextViewer lpextextviewer = (LpexTextViewer)LpexAbstractTextEditor.this.getSelectionProvider();
                                try {
                                    Point range = lpextextviewer.getSelectedRange();
                                    this.sel = range.x == -1 || range.y == -1 ? TextSelection.emptySelection() : new LpexTextSelection(LpexAbstractTextEditor.this.getActiveLpexView(), lpextextviewer.getDocument(), range.x, range.y);
                                }
                                catch (Exception e) {
                                    this.sel = TextSelection.emptySelection();
                                }
                            } else {
                                this.sel = LpexAbstractTextEditor.this.getSelectionProvider().getSelection();
                            }
                        } else {
                            Display.getDefault().asyncExec(this.fRunnable);
                        }
                    }
                }
            }
        });
    }

    private ICursorListener getCursorListener() {
        if (this.fCursorListener == null) {
            this.fCursorListener = new ICursorListener(){

                public void keyPressed(KeyEvent e) {
                    LpexAbstractTextEditor.this.handleCursorPositionChanged();
                }

                public void keyReleased(KeyEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    LpexAbstractTextEditor.this.handleCursorPositionChanged();
                }
            };
        }
        return this.fCursorListener;
    }

    protected MenuManager createContextMenuManager(String text, String id) {
        return new MenuManager(text, id);
    }

    protected boolean isEditorInputIncludedInContextMenu() {
        return true;
    }

    private void initializeActivationCodeTrigger() {
        this.fActivationCodeTrigger.install();
        LpexView lpexView = this._activeWindow != null && !this._activeWindow.isDisposed() ? this._activeWindow.getLpexView() : this.getLpexView();
        this.fActivationCodeTrigger.setLpexView(lpexView);
        this.fActivationCodeTrigger.setScopes(((LPEXView)lpexView).getKeyBindingScopes());
    }

    private void initializeSourceViewer(IEditorInput input) {
        IPreferenceStore store;
        IDocumentProvider documentProvider = this.getDocumentProvider();
        IAnnotationModel model = documentProvider.getAnnotationModel((Object)input);
        this.fSourceViewer.setEditorInput(input);
        IDocument document = documentProvider.getDocument((Object)input);
        if (document != null) {
            if (input instanceof IFileEditorInput) {
                try {
                    LpexView view = this.getActiveLpexView();
                    view.setBaseEncoding(((IFileEditorInput)input).getFile().getCharset());
                }
                catch (CoreException e) {
                    LpexLog.log(e);
                }
            }
            this.fSourceViewer.setDocument(document, model);
            this.setEditable(this.isEditable());
            this.fSourceViewer.showAnnotations(model != null);
        }
        if (this.fElementStateListener != null) {
            boolean isStateValidated = false;
            if (documentProvider instanceof IDocumentProviderExtension) {
                isStateValidated = ((IDocumentProviderExtension)documentProvider).isStateValidated((Object)input);
            }
            IElementStateListenerExtension extension = (IElementStateListenerExtension)this.fElementStateListener;
            extension.elementStateValidationChanged((Object)input, isStateValidated);
        }
        ITextViewerExtension8.EnrichMode mode = (store = this.getPreferenceStore()) != null ? this.convertEnrichModePreference(store.getInt("hoverReplaceMode")) : ITextViewerExtension8.EnrichMode.AFTER_DELAY;
        this.fSourceViewer.setHoverEnrichMode(mode);
        this._modified = false;
        this.fSourceViewer.updatePreferencePage();
    }

    private ITextViewerExtension8.EnrichMode convertEnrichModePreference(int mode) {
        switch (mode) {
            case -1: {
                return null;
            }
            case 0: {
                return ITextViewerExtension8.EnrichMode.AFTER_DELAY;
            }
            case 1: {
                return ITextViewerExtension8.EnrichMode.IMMEDIATELY;
            }
            case 2: {
                return ITextViewerExtension8.EnrichMode.ON_CLICK;
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    private void initializeTitle(IEditorInput input) {
        Image oldImage = this.fTitleImage;
        this.fTitleImage = null;
        this.fTitleImageEditable = true;
        String title = "";
        if (input != null) {
            this.fTitleImage = this.getDefaultTitleImage();
            title = input.getName();
        }
        this.setTitleImage(this.fTitleImage);
        this.setPartName(title);
        this.firePropertyChange(257);
        if (oldImage != null && !oldImage.isDisposed()) {
            oldImage.dispose();
        }
    }

    private Image getDefaultTitleImage() {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
        ImageDescriptor imageDesc = editorDesc != null ? editorDesc.getImageDescriptor() : null;
        return imageDesc != null ? imageDesc.createImage() : null;
    }

    protected Image getReadonlyTitleImage() {
        return this.getDefaultTitleImage();
    }

    protected void setDocumentProvider(IEditorInput input) {
    }

    private void updateDocumentProvider(IEditorInput input) {
        IDocumentProviderExtension2 extension;
        IProgressMonitor rememberedProgressMonitor = null;
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            provider.removeElementStateListener(this.fElementStateListener);
            if (provider instanceof IDocumentProviderExtension2) {
                extension = (IDocumentProviderExtension2)provider;
                rememberedProgressMonitor = extension.getProgressMonitor();
                extension.setProgressMonitor(null);
            }
        }
        this.setDocumentProvider(input);
        provider = this.getDocumentProvider();
        if (provider != null) {
            provider.addElementStateListener(this.fElementStateListener);
            if (provider instanceof IDocumentProviderExtension2) {
                extension = (IDocumentProviderExtension2)provider;
                extension.setProgressMonitor(rememberedProgressMonitor);
            }
        }
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        IVerticalRuler ruler;
        IEditorInput oldInput;
        ISaveablesLifecycleListener listener = (ISaveablesLifecycleListener)this.getSite().getService(ISaveablesLifecycleListener.class);
        if (listener == null) {
            this.fSavable = null;
        }
        if (input == null) {
            this.close(this.isSaveOnCloseNeeded());
            if (this.fSavable != null) {
                if (listener != null) {
                    listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 3, this.getSaveables(), false));
                }
                this.fSavable.disconnectEditor();
                this.fSavable = null;
            }
            return;
        }
        boolean mustSendLifeCycleEvent = false;
        if (this.fSavable != null) {
            if (listener != null) {
                listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 3, this.getSaveables(), false));
            }
            this.fSavable.disconnectEditor();
            this.fSavable = null;
            mustSendLifeCycleEvent = true;
        }
        if ((oldInput = this.getEditorInput()) != null) {
            this.getDocumentProvider().disconnect((Object)oldInput);
        }
        super.setInput(input);
        this.updateDocumentProvider(input);
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            Status s = new Status(4, "org.eclipse.ui", 0, EditorMessages.getString("Editor_error_no_provider"), null);
            throw new CoreException((IStatus)s);
        }
        provider.connect((Object)input);
        this.initializeTitle(input);
        if (this.fSourceViewer != null) {
            this.initializeSourceViewer(input);
        }
        this.updateStatusField("ElementState");
        this._inputResource = (IResource)input.getAdapter(IFile.class);
        if (this._inputResource == null) {
            this._inputResource = (IResource)input.getAdapter(IResource.class);
        }
        if ((ruler = this.getVerticalRuler()) instanceof LpexCompositeRuler) {
            this.updateContributedRulerColumns((LpexCompositeRuler)ruler);
        }
        if (mustSendLifeCycleEvent && listener != null) {
            listener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this, 1, this.getSaveables(), false));
        }
    }

    protected final void setInputWithNotify(IEditorInput input) {
        try {
            this.doSetInput(input);
            this.firePropertyChange(258);
        }
        catch (CoreException x) {
            String title = EditorMessages.getString("Editor_error_setinput_title");
            String msg = EditorMessages.getString("Editor_error_setinput_message");
            Shell shell = this.getSite().getShell();
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    public final void setInput(IEditorInput input) {
        this.setInputWithNotify(input);
    }

    protected void setPreferenceStore(IPreferenceStore store) {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fPreferenceStore = store;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public void close(final boolean save) {
        this.enableSanityChecking(false);
        Display display = this.getSite().getShell().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (LpexAbstractTextEditor.this.fSourceViewer != null) {
                    LpexAbstractTextEditor.this.getSite().getPage().closeEditor((IEditorPart)LpexAbstractTextEditor.this, save);
                }
            }
        });
    }

    public void dispose() {
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        if (this.fTitleImage != null) {
            this.fTitleImage.dispose();
            this.fTitleImage = null;
        }
        if (this.fPropertyChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
                this.fPreferenceStore = null;
            }
            this.fPropertyChangeListener = null;
        }
        if (this.fActivationCodeTrigger != null) {
            this.fActivationCodeTrigger.uninstall();
            this.fActivationCodeTrigger = null;
        }
        if (this.fSavable != null) {
            this.fSavable.disconnectEditor();
            this.fSavable = null;
        }
        this.disposeDocumentProvider();
        LpexView lpexView = this.getLpexView();
        if (lpexView != null) {
            lpexView.removeLpexViewListener(this._lpexViewListener);
            lpexView.removeLpexDocumentSectionListener(this._lpexDocumentSectionListener);
            lpexView.window().commandLine().removeFocusListener(this._commandLineFocusListener);
            this._lpexViewListener = null;
            this._lpexDocumentSectionListener = null;
            this._commandLineFocusListener = null;
        }
        if (this.fSourceViewer != null) {
            this.fSourceViewer = null;
        }
        if (this.fTextContextMenu != null) {
            this.fTextContextMenu.dispose();
            this.fTextContextMenu = null;
        }
        if (this.fRulerContextMenu != null) {
            this.fRulerContextMenu.dispose();
            this.fRulerContextMenu = null;
        }
        this.registerUndoRedoAction(ITextEditorActionConstants.UNDO, null);
        this.registerUndoRedoAction(ITextEditorActionConstants.REDO, null);
        if (this.fActions != null) {
            this.fActions.clear();
            this.fActions = null;
        }
        if (this.fKeybindingActions != null) {
            this.fKeybindingActions.clear();
            this.fKeybindingActions = null;
        }
        if (this.fPropertyActions != null) {
            this.fPropertyActions.clear();
            this.fPropertyActions = null;
        }
        if (this.fActivationCodes != null) {
            this.fActivationCodes.clear();
            this.fActivationCodes = null;
        }
        if (this.fEditorStatusLine != null) {
            this.fEditorStatusLine = null;
        }
        if (this.fConfiguration != null) {
            this.fConfiguration = null;
        }
        if (this.fColumnSupport != null) {
            this.fColumnSupport.dispose();
            this.fColumnSupport = null;
        }
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.uninstall();
            this.fInformationPresenter = null;
        }
        if (this.fVerticalRuler != null) {
            this.fVerticalRuler = null;
        }
        int i = 0;
        while (i < ACTION_MAP.length) {
            IdMapEntry entry = ACTION_MAP[i];
            IAction action = this.getAction(entry.getActionId());
            if (action instanceof LpexTextNavigationAction) {
                ((LpexTextNavigationAction)action)._editor = null;
            }
            ++i;
        }
        LpexEditorAction action = this._firstAction;
        while (action != null) {
            action.setEditor(null);
            LpexEditorAction old = action;
            action = action._next;
            old._next = null;
        }
        this._firstAction = null;
        if (this._saveAction != null) {
            this._saveAction.dispose();
            this._saveAction = null;
        }
        super.dispose();
    }

    protected void disposeDocumentProvider() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider != null) {
            IEditorInput input = this.getEditorInput();
            if (input != null) {
                provider.disconnect((Object)input);
            }
            if (this.fElementStateListener != null) {
                provider.removeElementStateListener(this.fElementStateListener);
                this.fElementStateListener = null;
            }
        }
        this.fExplicitDocumentProvider = null;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                String title = EditorMessages.getString("Editor_error_save_deleted_title");
                String msg = EditorMessages.getString("Editor_error_save_deleted_message");
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        } else {
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            this.performSave(false, progressMonitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableSanityChecking(boolean enable) {
        LpexAbstractTextEditor lpexAbstractTextEditor = this;
        synchronized (lpexAbstractTextEditor) {
            this.fIsSanityCheckEnabled = enable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safelySanityCheckState(IEditorInput input) {
        boolean enabled = false;
        LpexAbstractTextEditor lpexAbstractTextEditor = this;
        synchronized (lpexAbstractTextEditor) {
            enabled = this.fIsSanityCheckEnabled;
        }
        if (enabled) {
            this.sanityCheckState(input);
        }
    }

    protected void sanityCheckState(IEditorInput input) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p instanceof IDocumentProviderExtension3) {
            IDocumentProviderExtension3 p3 = (IDocumentProviderExtension3)p;
            long stamp = p.getModificationStamp((Object)input);
            if (stamp != this.fModificationStamp) {
                this.fModificationStamp = stamp;
                if (!p3.isSynchronized((Object)input)) {
                    this.handleEditorInputChanged();
                }
            }
        } else {
            long stamp;
            if (this.fModificationStamp == -1L) {
                this.fModificationStamp = p.getSynchronizationStamp((Object)input);
            }
            if ((stamp = p.getModificationStamp((Object)input)) != this.fModificationStamp) {
                this.fModificationStamp = stamp;
                if (stamp != p.getSynchronizationStamp((Object)input)) {
                    this.handleEditorInputChanged();
                }
            }
        }
        this.updateState(this.getEditorInput());
        this.updateStatusField("ElementState");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableStateValidation(boolean enable) {
        LpexAbstractTextEditor lpexAbstractTextEditor = this;
        synchronized (lpexAbstractTextEditor) {
            this.fIsStateValidationEnabled = enable;
        }
    }

    protected void validateState(IEditorInput input) {
        IFile file;
        IWorkspace workspace;
        IStatus status;
        IDocumentProvider provider = this.getDocumentProvider();
        if (!(provider instanceof IDocumentProviderExtension)) {
            return;
        }
        IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
        Shell shell = this.getSite().getShell();
        try {
            extension.validateState((Object)input, (Object)shell);
        }
        catch (CoreException x) {
            IStatus status2 = x.getStatus();
            if (status2 == null || status2.getSeverity() != 8) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
                ILog log = Platform.getLog((Bundle)bundle);
                log.log(x.getStatus());
                String title = EditorMessages.getString("Editor_error_validateEdit_title");
                String msg = EditorMessages.getString("Editor_error_validateEdit_message");
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
            }
            return;
        }
        IEditorInput editorInput = this.getEditorInput();
        if (extension.isReadOnly((Object)editorInput) && editorInput instanceof IFileEditorInput && !(status = (workspace = (file = ((IFileEditorInput)editorInput).getFile()).getWorkspace()).validateEdit(new IFile[]{file}, (Object)shell)).isOK()) {
            String title = EditorMessages.getString("Editor_error_validateEdit_title");
            String msg = EditorMessages.getString("Editor_error_validateEdit_message");
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)status);
        }
        if (this.fSourceViewer != null) {
            this.setEditable(this.isEditable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateEditorInputState() {
        boolean enabled = false;
        LpexAbstractTextEditor lpexAbstractTextEditor = this;
        synchronized (lpexAbstractTextEditor) {
            enabled = this.fIsStateValidationEnabled;
        }
        if (enabled) {
            LpexSourceViewer viewer = this.fSourceViewer;
            if (viewer == null) {
                return false;
            }
            this.fTextInputListener.inputChanged = false;
            viewer.addTextInputListener(this.fTextInputListener);
            try {
                final IEditorInput input = this.getEditorInput();
                BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LpexAbstractTextEditor.this.validateState(input);
                    }
                });
                this.sanityCheckState(input);
                boolean bl = !this.isEditorInputReadOnly() && !this.fTextInputListener.inputChanged;
                return bl;
            }
            finally {
                viewer.removeTextInputListener(this.fTextInputListener);
            }
        }
        return !this.isEditorInputReadOnly();
    }

    protected void updateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
            try {
                extension.updateStateCache((Object)input);
                if (this.fSourceViewer != null) {
                    this.setEditable(this.isEditable());
                }
            }
            catch (CoreException x) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
                ILog log = Platform.getLog((Bundle)bundle);
                log.log(x.getStatus());
            }
        }
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        LpexView lpexView = this.getLpexView();
        int textLimit = lpexView.queryInt("current.save.textLimit");
        int firstTruncatedElement = 0;
        DocumentAdapter documentAdapter = this.fSourceViewer.getDocumentAdapter();
        boolean errorSaving = false;
        try {
            try {
                provider.aboutToChange((Object)this.getEditorInput());
                lpexView.doDefaultCommand("undo check");
                lpexView.doDefaultCommand("undo save");
                lpexView.doCommand("parse");
                if (lpexView.queryOn("current.save.trim")) {
                    lpexView.doCommand("trim");
                }
                firstTruncatedElement = Utilities.notifyTruncateDocument(lpexView, documentAdapter, textLimit);
                IEditorInput input = this.getEditorInput();
                provider.saveDocument(progressMonitor, (Object)input, this.getDocumentProvider().getDocument((Object)input), overwrite);
                this.editorSaved();
            }
            catch (CoreException x) {
                errorSaving = true;
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    this.handleExceptionOnSave(x, progressMonitor);
                }
                if (firstTruncatedElement != 0) {
                    Utilities.notifyTruncateDocumentRestore(lpexView, documentAdapter, textLimit, firstTruncatedElement);
                    lpexView.doDefaultCommand("set messageText " + LpexResources.message("file.saveTruncation"));
                    String text = lpexView.elementText(firstTruncatedElement);
                    this.ensureVisible(lpexView, firstTruncatedElement);
                    lpexView.jump(firstTruncatedElement, lpexView.nls().sourceTruncate(text, textLimit) + 1);
                    lpexView.doDefaultCommand("set emphasisPosition 1");
                    lpexView.doDefaultCommand("set emphasisLength " + text.length());
                    lpexView.doDefaultCommand("set beep on");
                }
                if (!errorSaving) {
                    lpexView.doDefaultCommand("undo resetChanges");
                }
                lpexView.doDefaultCommand("screenShow document");
                provider.changed((Object)this.getEditorInput());
            }
        }
        finally {
            if (firstTruncatedElement != 0) {
                Utilities.notifyTruncateDocumentRestore(lpexView, documentAdapter, textLimit, firstTruncatedElement);
                lpexView.doDefaultCommand("set messageText " + LpexResources.message("file.saveTruncation"));
                String text = lpexView.elementText(firstTruncatedElement);
                this.ensureVisible(lpexView, firstTruncatedElement);
                lpexView.jump(firstTruncatedElement, lpexView.nls().sourceTruncate(text, textLimit) + 1);
                lpexView.doDefaultCommand("set emphasisPosition 1");
                lpexView.doDefaultCommand("set emphasisLength " + text.length());
                lpexView.doDefaultCommand("set beep on");
            }
            if (!errorSaving) {
                lpexView.doDefaultCommand("undo resetChanges");
            }
            lpexView.doDefaultCommand("screenShow document");
            provider.changed((Object)this.getEditorInput());
        }
    }

    void ensureVisible(LpexView lpexView, int element) {
        LpexDocumentLocation loc = new LpexDocumentLocation(element, 1);
        if (!lpexView.queryOn("visible", loc)) {
            while (--loc.element >= 1) {
                if (!lpexView.queryOn("visible", loc)) continue;
                lpexView.doCommand(loc, "set expanded on");
                return;
            }
            lpexView.doCommand("set topExpanded on");
        }
    }

    protected void handleExceptionOnSave(CoreException exception, IProgressMonitor progressMonitor) {
        try {
            ++this.fErrorCorrectionOnSave;
            boolean isSynchronized = false;
            IDocumentProvider p = this.getDocumentProvider();
            long modifiedStamp = p.getModificationStamp((Object)this.getEditorInput());
            long synchStamp = p.getSynchronizationStamp((Object)this.getEditorInput());
            boolean bl = isSynchronized = modifiedStamp == synchStamp;
            if (isSynchronized && p instanceof IDocumentProviderExtension3) {
                IDocumentProviderExtension3 p3 = (IDocumentProviderExtension3)p;
                isSynchronized &= p3.isSynchronized((Object)this.getEditorInput());
            }
            if (this.isNotSynchronizedException(exception) && this.fErrorCorrectionOnSave == 1 && !isSynchronized) {
                title = EditorMessages.getString("Editor_error_save_outofsync_title");
                String msg = MessageFormat.format(EditorMessages.getString("Editor_error_save_outofsync_message"), this.getEditorInput().getToolTipText());
                if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)title, (String)msg)) {
                    this.performSave(true, progressMonitor);
                } else if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
            } else {
                title = EditorMessages.getString("Editor_error_save_title");
                String msg = EditorMessages.getString("Editor_error_save_message");
                this.openSaveErrorDialog(title, msg, exception);
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
            }
        }
        finally {
            --this.fErrorCorrectionOnSave;
        }
    }

    protected void openSaveErrorDialog(String title, String message, CoreException exception) {
        ErrorDialog.openError((Shell)this.getSite().getShell(), (String)title, (String)message, (IStatus)exception.getStatus());
    }

    private boolean isNotSynchronizedException(CoreException ex) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension5) {
            return ((IDocumentProviderExtension5)provider).isNotSynchronizedException((Object)this.getEditorInput(), ex);
        }
        return false;
    }

    public void doSaveAs() {
        this.performSaveAs(this.getProgressMonitor());
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
    }

    protected void performSaveAs(IProgressMonitor progressMonitor, String fileName) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        boolean dirty = false;
        LpexView lpexView = this.getLpexView();
        if (lpexView != null) {
            dirty = lpexView.queryOn("dirty") || lpexView.queryInt("changes") != 0;
        }
        return dirty;
    }

    public void doRevertToSaved() {
        IDocumentProvider p = this.getDocumentProvider();
        if (p != null) {
            this.performRevert();
        }
    }

    protected void performRevert() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        try {
            try {
                this._reverting = true;
                provider.aboutToChange((Object)this.getEditorInput());
                provider.resetDocument((Object)this.getEditorInput());
                this.editorSaved();
            }
            catch (CoreException x) {
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    Shell shell = this.getSite().getShell();
                    String title = EditorMessages.getString("Editor_error_revert_title");
                    String msg = EditorMessages.getString("Editor_error_revert_message");
                    ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
                }
                provider.changed((Object)this.getEditorInput());
                this._reverting = false;
            }
        }
        finally {
            provider.changed((Object)this.getEditorInput());
            this._reverting = false;
        }
    }

    protected void handleElementContentReplaced() {
    }

    public void setAction(String actionName, IAction action) {
        if (this.fActions == null) {
            return;
        }
        Assert.isNotNull((Object)actionName);
        if (action == null) {
            action = this.fActions.remove(actionName);
            if (action != null) {
                this.fActivationCodeTrigger.unregisterActionFromKeyActivation(action);
            }
        } else {
            if (action.getId() == null) {
                action.setId(actionName);
            }
            this.fActions.put(actionName, action);
            this.fActivationCodeTrigger.registerActionForKeyActivation(action);
        }
    }

    public IAction getAction(String actionName) {
        if (this.fActions == null) {
            return null;
        }
        Assert.isNotNull((Object)actionName);
        IAction action = this.fActions.get(actionName);
        if (action == null && (action = this.findContributedAction(actionName)) != null) {
            this.setAction(actionName, action);
        }
        return action;
    }

    private IAction findContributedAction(String actionID) {
        Object element;
        ArrayList<IConfigurationElement> actions = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui", "editorActions");
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (TAG_CONTRIBUTION_TYPE.equals(element.getName()) && (this.getSite() == null || this.getSite().getId().equals(element.getAttribute("targetID")))) {
                IConfigurationElement[] children = element.getChildren("action");
                int j = 0;
                while (j < children.length) {
                    IConfigurationElement child = children[j];
                    if (actionID.equals(child.getAttribute("actionID"))) {
                        actions.add(child);
                    }
                    ++j;
                }
            }
            ++i;
        }
        int actionSize = actions.size();
        if (actionSize > 0) {
            if (actionSize > 1) {
                Object[] actionArray = actions.toArray(new IConfigurationElement[actionSize]);
                ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                    public IConfigurationElement getConfigurationElement(Object object) {
                        return (IConfigurationElement)object;
                    }
                };
                sorter.sort(actionArray);
                element = actionArray[0];
            } else {
                element = (IConfigurationElement)actions.get(0);
            }
            try {
                return new ContributedAction((IServiceLocator)this.getSite(), element);
            }
            catch (CommandNotMappedException commandNotMappedException) {
                // empty catch block
            }
        }
        return null;
    }

    private void updateAction(String actionName) {
        IAction action;
        Assert.isNotNull((Object)actionName);
        if (this.fActions != null && (action = this.fActions.get(actionName)) instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    public void markAsPropertyDependentAction(String actionId, boolean mark) {
        Assert.isNotNull((Object)actionId);
        if (mark) {
            if (!this.fPropertyActions.contains(actionId)) {
                this.fPropertyActions.add(actionId);
            }
        } else {
            this.fPropertyActions.remove(actionId);
        }
    }

    protected void updatePropertyDependentActions() {
        if (this.fPropertyActions != null) {
            Iterator<String> e = this.fPropertyActions.iterator();
            while (e.hasNext()) {
                this.updateAction(e.next());
            }
        }
    }

    protected void createNavigationActions() {
        int i = 0;
        while (i < ACTION_MAP.length) {
            IdMapEntry entry = ACTION_MAP[i];
            LpexTextNavigationAction action = new LpexTextNavigationAction(this, entry.getAction());
            action.setActionDefinitionId(entry.getActionId());
            this.setAction(entry.getActionId(), (IAction)action);
            ++i;
        }
    }

    private void createAccessibilityActions() {
        ShowRulerContextMenuAction action = new ShowRulerContextMenuAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.showRulerContextMenu");
        this.setAction("org.eclipse.ui.edit.text.showRulerContextMenu", (IAction)action);
    }

    protected void createActions() {
        LpexEditorAction action = new LpexEditorAction(LpexPlugin.getResourceBundle(), "undo.", this, 1);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.UNDO_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.undo");
        this.setAction(ITextEditorActionConstants.UNDO, (IAction)action);
        action = new LpexEditorAction(LpexPlugin.getResourceBundle(), "redo.", this, 2);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.REDO_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.redo");
        this.setAction(ITextEditorActionConstants.REDO, (IAction)action);
        action = new LpexEditorAction(LpexPlugin.getResourceBundle(), "cut.", this, 3);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
        action = new LpexEditorAction(LpexPlugin.getResourceBundle(), "copy.", this, 4);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setAction(ITextEditorActionConstants.COPY, (IAction)action);
        action = new LpexEditorAction(LpexPlugin.getResourceBundle(), "paste.", this, 5);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        action = new LpexEditorAction(LpexPlugin.getResourceBundle(), "Delete.", this, 6);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.DELETE_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setAction(ITextEditorActionConstants.DELETE, (IAction)action);
        action = new LpexEditorAction(LpexPlugin.getResourceBundle(), "SelectAll.", this, 7);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.setAction(ITextEditorActionConstants.SELECT_ALL, (IAction)action);
        action = new LpexEditorAction(LpexPlugin.getResourceBundle(), "Print.", this, 10);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.PRINT_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.file.print");
        this.setAction(ITextEditorActionConstants.PRINT, (IAction)action);
        action = new LpexFindReplaceAction(LpexPlugin.getResourceBundle(), "FindReplace.", this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.FIND_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.setAction(ITextEditorActionConstants.FIND, (IAction)action);
        this._saveAction = ActionFactory.SAVE.create(this.getSite().getWorkbenchWindow());
        this._saveAction.setId(ActionFactory.SAVE.getId());
        this.setAction(ITextEditorActionConstants.SAVE, (IAction)this._saveAction);
        action = new RevertToSavedAction(LpexPlugin.getResourceBundle(), "Revert.", (ITextEditor)this);
        action.setHelpContextId(IAbstractTextEditorHelpContextIds.REVERT_TO_SAVED_ACTION);
        action.setActionDefinitionId("org.eclipse.ui.file.revert");
        this.setAction(ITextEditorActionConstants.REVERT_TO_SAVED, (IAction)action);
        action = new LpexEditorAction(EditorMessages.getResourceBundle(), "Editor.GotoLine.", this, 137);
        action.setHelpContextId("org.eclipse.ui.GotoLine_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.goto.line");
        this.setAction("GotoLine", (IAction)action);
        Object resAction = new TextOperationAction(EditorMessages.getResourceBundle(), "Editor.ShowInformation.", (ITextEditor)this, 16, true);
        resAction = new InformationDispatchAction(EditorMessages.getResourceBundle(), "Editor.ShowInformation.", (TextOperationAction)resAction);
        action.setHelpContextId("org.eclipse.ui.show_information_action_context");
        resAction.setActionDefinitionId("org.eclipse.ui.edit.text.showInformation");
        this.setAction("ShowInformation", (IAction)resAction);
        PropertyDialogAction openProperties = new PropertyDialogAction(new IShellProvider(){

            public Shell getShell() {
                return LpexAbstractTextEditor.this.getSite().getShell();
            }
        }, new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return new StructuredSelection((Object)LpexAbstractTextEditor.this.getEditorInput());
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
            }
        });
        openProperties.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.setAction(ITextEditorActionConstants.PROPERTIES, (IAction)openProperties);
        LpexAbstractDecoratedTextEditor.createRulerMarkerActions(this, (IVerticalRulerInfo)this.fVerticalRuler);
        this.markAsPropertyDependentAction(ITextEditorActionConstants.REVERT_TO_SAVED, true);
    }

    protected final void addAction(IMenuManager menu, String actionName) {
        IAction action = this.getAction(actionName);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            menu.add(action);
        }
    }

    protected final void addAction(IMenuManager menu, String group, String actionName) {
        IAction action = this.getAction(actionName);
        if (action != null) {
            IMenuManager subMenu;
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if ((subMenu = menu.findMenuUsingPath(group)) != null) {
                subMenu.add(action);
            } else {
                menu.appendToGroup(group, action);
            }
        }
    }

    private void addLpexPopupAction(IMenuManager menu, String actionName, String labelKey) {
        IAction action = this.getAction(actionName);
        if (action == null) {
            action = this.createLpexPopupAction(actionName, labelKey);
        }
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            menu.add(action);
        }
    }

    protected final void addGroup(IMenuManager menu, String existingGroup, String newGroup) {
        IMenuManager subMenu = menu.findMenuUsingPath(existingGroup);
        if (subMenu != null) {
            subMenu.add((IContributionItem)new Separator(newGroup));
        } else {
            menu.appendToGroup(existingGroup, (IContributionItem)new Separator(newGroup));
        }
    }

    protected void rulerContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
        Iterator<IMenuListener> i = this.fRulerContextMenuListeners.iterator();
        while (i.hasNext()) {
            i.next().menuAboutToShow(menu);
        }
        if (this.getVerticalRuler().getLineOfLastMouseButtonActivity() >= 0) {
            this.addAction(menu, "ManageBookmarks");
            this.addAction(menu, "ManageTasks");
        }
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.undo"));
        menu.add((IContributionItem)new GroupMarker("group.save"));
        menu.add((IContributionItem)new Separator("group.copy"));
        this.populateSubmenu(menu, new LpexStringTokenizer(Utilities.currentPopupMenu(this.getLpexView())));
        menu.add((IContributionItem)new Separator("group.print"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.find"));
        menu.add((IContributionItem)new Separator("group.add"));
        menu.add((IContributionItem)new Separator("group.rest"));
        menu.add((IContributionItem)new Separator("additions"));
        if (this.isEditable()) {
            this.addAction(menu, "group.save", ITextEditorActionConstants.SAVE);
        }
    }

    protected IStatusLineManager getStatusLineManager() {
        return this.getEditorSite().getActionBars().getStatusLineManager();
    }

    public Object getAdapter(Class required) {
        if (IEditorStatusLine.class.equals((Object)required)) {
            if (this.fEditorStatusLine == null) {
                IStatusLineManager statusLineManager = this.getStatusLineManager();
                ISelectionProvider selectionProvider = this.getSelectionProvider();
                if (statusLineManager != null && selectionProvider != null) {
                    this.fEditorStatusLine = new EditorStatusLine(statusLineManager, selectionProvider);
                }
            }
            return this.fEditorStatusLine;
        }
        if (IVerticalRulerInfo.class.equals((Object)required) && this.fVerticalRuler != null) {
            return this.fVerticalRuler;
        }
        if (ITextOperationTarget.class.equals((Object)required)) {
            return this.fSourceViewer != null ? this.fSourceViewer.getTextOperationTarget() : null;
        }
        if (IRewriteTarget.class.equals((Object)required)) {
            if (this.fSourceViewer != null) {
                LpexSourceViewer extension = this.fSourceViewer;
                return extension.getRewriteTarget();
            }
            return null;
        }
        if (Control.class.equals((Object)required)) {
            return this.fSourceViewer != null ? this.fSourceViewer.getLpexMultiWindow() : null;
        }
        if (IColumnSupport.class.equals((Object)required)) {
            if (this.fColumnSupport == null) {
                this.fColumnSupport = this.createColumnSupport();
            }
            return this.fColumnSupport;
        }
        return super.getAdapter(required);
    }

    public void setFocus() {
        LpexMultiWindow lpexMultiWindow;
        if (this.fSourceViewer != null && LpexUtilities.okToUse((Widget)(lpexMultiWindow = this.fSourceViewer.getLpexMultiWindow()))) {
            lpexMultiWindow.setFocus();
        }
    }

    protected void setHelpContextId(String helpContextId) {
        Assert.isNotNull((Object)helpContextId);
        this.fHelpContextId = helpContextId;
    }

    protected final String getHelpContextId() {
        return this.fHelpContextId;
    }

    protected void setLanguageHelp(LpexLanguageHelp lsh) {
        this.fSourceViewer.setLanguageHelp(lsh);
    }

    protected void setKeyBindingScopes(String[] scopes) {
        this.setKeyBindingScopes(this.getLpexView(), scopes);
    }

    protected void setKeyBindingScopes(LpexView lpexView, String[] scopes) {
        if (lpexView != null) {
            ((LPEXView)lpexView).setKeyBindingScopes(scopes);
        }
    }

    protected String[] getKeyBindingScopes(LpexView lpexView) {
        return lpexView != null ? ((LPEXView)lpexView).getKeyBindingScopes() : null;
    }

    protected IProgressMonitor getProgressMonitor() {
        IProgressMonitor pm = null;
        IStatusLineManager manager = this.getStatusLineManager();
        if (manager != null) {
            pm = manager.getProgressMonitor();
        }
        return pm != null ? pm : new NullProgressMonitor();
    }

    protected void handleEditorInputChanged() {
        block18: {
            Shell shell = this.getSite().getShell();
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                this.close(false);
                return;
            }
            IEditorInput input = this.getEditorInput();
            String inputName = input.getToolTipText();
            if (provider.isDeleted((Object)input)) {
                if (this.isSaveAsAllowed()) {
                    String[] buttons;
                    String msg;
                    String title = EditorMessages.getString("Editor_error_activated_deleted_save_title");
                    MessageDialog dialog = new MessageDialog(shell, title, null, msg = NLSUtility.format((String)EditorMessages.getString("Editor_error_activated_deleted_save_message"), (Object)inputName), 3, buttons = new String[]{EditorMessages.getString("Editor_error_activated_deleted_save_button_save"), EditorMessages.getString("Editor_error_activated_deleted_save_button_close")}, 0);
                    if (dialog.open() == 0) {
                        IProgressMonitor pm = this.getProgressMonitor();
                        this.performSaveAs(pm);
                        if (pm.isCanceled()) {
                            this.handleEditorInputChanged();
                        }
                    } else {
                        this.close(false);
                    }
                } else {
                    String msg;
                    String title = EditorMessages.getString("Editor_error_activated_deleted_close_title");
                    if (MessageDialog.openConfirm((Shell)shell, (String)title, (String)(msg = NLSUtility.format((String)EditorMessages.getString("Editor_error_activated_deleted_close_message"), (Object)inputName)))) {
                        this.close(false);
                    }
                }
            } else {
                String title = EditorMessages.getString("Editor_error_activated_outofsync_title");
                String msg = NLSUtility.format((String)EditorMessages.getString("Editor_error_activated_outofsync_message"), (Object)inputName);
                if (this.fHasBeenActivated && MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg)) {
                    try {
                        if (provider instanceof IDocumentProviderExtension) {
                            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
                            extension.synchronize((Object)input);
                            break block18;
                        }
                        this.doSetInput(input);
                    }
                    catch (CoreException x) {
                        IStatus status = x.getStatus();
                        if (status == null || status.getSeverity() != 8) {
                            title = EditorMessages.getString("Editor_error_refresh_outofsync_title");
                            msg = NLSUtility.format((String)EditorMessages.getString("Editor_error_refresh_outofsync_message"), (Object)inputName);
                            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
                        }
                        break block18;
                    }
                }
                if (this.fHasBeenActivated && !this.isDirty()) {
                    try {
                        IDocument document = provider.getDocument((Object)input);
                        if (document != null) {
                            document.replace(0, 0, "");
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public boolean showsHighlightRangeOnly() {
        return this.fShowHighlightRangeOnly;
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        this.fShowHighlightRangeOnly = showHighlightRangeOnly;
    }

    public void setHighlightRange(int offset, int len, boolean moveCursor) {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.fShowHighlightRangeOnly) {
            if (moveCursor) {
                this.fSourceViewer.setVisibleRegion(offset, len);
            }
        } else {
            IRegion rangeIndication = this.fSourceViewer.getRangeIndication();
            if (rangeIndication == null || offset != rangeIndication.getOffset() || len != rangeIndication.getLength()) {
                this.fSourceViewer.setRangeIndication(offset, len, moveCursor);
            }
        }
    }

    public IRegion getHighlightRange() {
        if (this.fSourceViewer == null) {
            return null;
        }
        if (this.fShowHighlightRangeOnly) {
            return this.fSourceViewer.getVisibleRegion();
        }
        return this.fSourceViewer.getRangeIndication();
    }

    public void setActionActivationCode(String actionName, char activationCharacter, int activationKeyCode, int activationStateMask) {
        Assert.isNotNull((Object)actionName);
        ActionActivationCode found = this.findActionActivationCode(actionName);
        if (found == null) {
            found = new ActionActivationCode(actionName);
            this.fActivationCodes.add(found);
        }
        found.fCharacter = activationCharacter;
        found.fKeyCode = activationKeyCode;
        found.fStateMask = activationStateMask;
    }

    private ActionActivationCode findActionActivationCode(String actionName) {
        int size = this.fActivationCodes.size();
        int i = 0;
        while (i < size) {
            ActionActivationCode code = this.fActivationCodes.get(i);
            if (actionName.equals(code.fActionId)) {
                return code;
            }
            ++i;
        }
        return null;
    }

    public void removeActionActivationCode(String actionName) {
        Assert.isNotNull((Object)actionName);
        ActionActivationCode code = this.findActionActivationCode(actionName);
        if (code != null) {
            this.fActivationCodes.remove(code);
        }
    }

    public void resetHighlightRange() {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.fShowHighlightRangeOnly) {
            this.fSourceViewer.resetVisibleRegion();
        } else {
            this.fSourceViewer.removeRangeIndication();
        }
    }

    protected void adjustHighlightRange(int offset, int len) {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)this.fSourceViewer;
            extension.exposeModelRange((IRegion)new Region(offset, len));
        } else if (!LpexAbstractTextEditor.isVisible(this.fSourceViewer, offset, len)) {
            this.fSourceViewer.resetVisibleRegion();
        }
    }

    public void selectAndReveal(int start, int len) {
        this.selectAndReveal(start, len, start, len);
    }

    protected void selectAndReveal(String selectionType, LpexTextSelectionNavigationLocation.Block block) {
        ITextSelection textSelection;
        if (this.fSourceViewer == null) {
            return;
        }
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && ((textSelection = (ITextSelection)selection).getOffset() != 0 || textSelection.getLength() != 0)) {
            this.markInNavigationHistory();
        }
        this.restoreNavigationLocation(selectionType, block);
        this.markInNavigationHistory();
    }

    protected void selectAndReveal(int selectionStart, int selectionLength, int revealStart, int revealLength) {
        ITextSelection textSelection;
        if (this.fSourceViewer == null) {
            return;
        }
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && ((textSelection = (ITextSelection)selection).getOffset() != 0 || textSelection.getLength() != 0)) {
            this.markInNavigationHistory();
        }
        if (selectionLength == 0) {
            LpexDocumentLocation startLocation = this.fSourceViewer.getLpexDocumentLocation(selectionStart);
            this.getLpexView().doCommand("block clear");
            this.getLpexView().jump(startLocation);
            this.getLpexView().doCommand("screenShow view");
        } else {
            this.getLpexView().doCommand("screenShow view");
            this.getFirstLpexView().doCommand("block clear");
            this.adjustHighlightRange(revealStart, revealLength);
            this.fSourceViewer.revealRange(revealStart, revealLength);
            this.fSourceViewer.setSelectedRange(selectionStart, selectionLength);
            this.getFirstLpexView().doCommand("screenShow view");
        }
        this.markInNavigationHistory();
    }

    protected void restoreNavigationLocation(String selectionType, LpexTextSelectionNavigationLocation.Block block) {
        LpexView lpexView = this.getActiveLpexView();
        if (selectionType.equals("none")) {
            return;
        }
        lpexView.jump(block.getTopElement(), block.getTopPosition());
        lpexView.doCommand("screenShow view");
        lpexView.doCommand("block clear");
        lpexView.doCommand("screenShow view");
        if (!(selectionType.equals("none") || selectionType.isEmpty() || selectionType.equals("UNINITIALIZED"))) {
            lpexView.doCommand("block set " + selectionType);
        }
        this.ensureVisible(lpexView, block.getBottomElement());
        lpexView.jump(block.getBottomElement(), block.getBottomPosition());
        lpexView.doCommand("block set");
        lpexView.doCommand("screenShow view");
    }

    public INavigationLocation createEmptyNavigationLocation() {
        return new TextSelectionNavigationLocation((ITextEditor)this, false);
    }

    public INavigationLocation createNavigationLocation() {
        LpexView view = this.getFirstLpexView();
        if (view == null) {
            view = this.getLpexView();
        }
        if (view == null) {
            view = this.getActiveLpexView();
        }
        if (view == null) {
            return this.createEmptyNavigationLocation();
        }
        String selectionType = view.query("block.type");
        return new LpexTextSelectionNavigationLocation(this, selectionType, true);
    }

    protected void markInNavigationHistory() {
        this.getSite().getPage().getNavigationHistory().markLocation((IEditorPart)this);
    }

    protected void editorSaved() {
        INavigationLocation[] locations = this.getSite().getPage().getNavigationHistory().getLocations();
        IEditorInput input = this.getEditorInput();
        int i = 0;
        while (i < locations.length) {
            if (locations[i] instanceof TextSelectionNavigationLocation && input.equals(locations[i].getInput())) {
                TextSelectionNavigationLocation location = (TextSelectionNavigationLocation)locations[i];
                location.partSaved((IEditorPart)this);
            }
            ++i;
        }
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updatePropertyDependentActions();
    }

    public void setStatusField(IStatusField field, String category) {
        IStatusField f;
        Assert.isNotNull((Object)category);
        if (field != null) {
            if (this.fStatusFields == null) {
                this.fStatusFields = new HashMap<String, IStatusField>(3);
            }
            this.fStatusFields.put(category, field);
            this.updateStatusField(category);
        } else if (this.fStatusFields != null && (f = this.fStatusFields.remove(category)) instanceof StatusLineContributionItem) {
            ((StatusLineContributionItem)f).setActionHandler(null);
        }
    }

    protected IStatusField getStatusField(String category) {
        return category != null && this.fStatusFields != null ? this.fStatusFields.get(category) : null;
    }

    protected void handleCursorPositionChanged() {
        this.updateStatusField("InputPosition");
    }

    protected void updateStatusField(String category) {
        IStatusField field;
        IStatusField iStatusField = field = category == null ? null : this.getStatusField(category);
        if (field != null) {
            String text = null;
            if ("InputPosition".equals(category)) {
                text = this.getCursorPosition();
            } else if ("ElementState".equals(category)) {
                text = this._statusLineBrowseMode != null ? this._statusLineBrowseMode : (this._statusLineChanges == 0 ? "" : (this._statusLineChanges == 1 ? LpexResources.message("status.1change") : LpexResources.message("status.nchanges", this._statusLineChanges)));
            } else if ("InputMode".equals(category)) {
                text = this._statusLineInputMode;
            }
            field.setText(text == null ? "" : text);
        }
    }

    protected void updateStatusFields() {
        if (this.fStatusFields != null) {
            Iterator<String> e = this.fStatusFields.keySet().iterator();
            while (e.hasNext()) {
                this.updateStatusField(e.next());
            }
        }
    }

    private void clearStatusFields() {
        this._statusLineInputMode = null;
        this._statusLineChanges = 0;
        this._statusLineBrowseMode = null;
        this.updateStatusFields();
    }

    protected String getCursorPosition() {
        if (this.fSourceViewer == null) {
            return this.fErrorLabel;
        }
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return this.fErrorLabel;
        }
        LpexView view = this.fSourceViewer.getActiveLpexView();
        LpexDocumentLocation location = view.documentLocation();
        this.fLineLabel.fValue = view.queryInt("line");
        this.fColumnLabel.fValue = location.position;
        return NLSUtility.format((String)this.fPositionLabelPattern, (Object[])this.fPositionLabelPatternArguments);
    }

    public boolean isEditable() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
            return extension.isModifiable((Object)this.getEditorInput());
        }
        return false;
    }

    private void setEditable(boolean editable) {
        this.fSourceViewer.setEditable(editable);
        if (editable != this.fTitleImageEditable) {
            Image oldImage = this.fTitleImage;
            this.fTitleImage = editable ? this.getDefaultTitleImage() : this.getReadonlyTitleImage();
            this.fTitleImageEditable = editable;
            this.setTitleImage(this.fTitleImage);
            this.firePropertyChange(257);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
    }

    public boolean isEditorInputReadOnly() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
            return extension.isReadOnly((Object)this.getEditorInput());
        }
        return true;
    }

    public boolean isEditorInputModifiable() {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider instanceof IDocumentProviderExtension) {
            IDocumentProviderExtension extension = (IDocumentProviderExtension)provider;
            return extension.isModifiable((Object)this.getEditorInput());
        }
        return true;
    }

    public void addRulerContextMenuListener(IMenuListener listener) {
        this.fRulerContextMenuListeners.add(listener);
    }

    public void removeRulerContextMenuListener(IMenuListener listener) {
        this.fRulerContextMenuListeners.remove(listener);
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        return true;
    }

    protected static final int widgetOffset2ModelOffset(ISourceViewer viewer, int widgetOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        return widgetOffset + viewer.getVisibleRegion().getOffset();
    }

    protected static final int modelOffset2WidgetOffset(ISourceViewer viewer, int modelOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.modelOffset2WidgetOffset(modelOffset);
        }
        return modelOffset - viewer.getVisibleRegion().getOffset();
    }

    protected static final IRegion getCoverage(ISourceViewer viewer) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.getModelCoverage();
        }
        return viewer.getVisibleRegion();
    }

    protected static final boolean isVisible(ISourceViewer viewer, int offset, int len) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion overlap = extension.modelRange2WidgetRange((IRegion)new Region(offset, len));
            return overlap != null;
        }
        return viewer.overlapsWithVisibleRegion(offset, len);
    }

    public void showChangeInformation(boolean show) {
    }

    public boolean isChangeInformationShowing() {
        return false;
    }

    protected void setStatusLineErrorMessage(String message) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(true, message, null);
        }
    }

    protected void setStatusLineMessage(String message) {
        IEditorStatusLine statusLine = (IEditorStatusLine)this.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            statusLine.setMessage(false, message, null);
        }
    }

    public Annotation gotoAnnotation(boolean forward) {
        ITextSelection selection = (ITextSelection)this.getSelectionProvider().getSelection();
        Position position = new Position(0, 0);
        Annotation annotation = this.findAnnotation(selection.getOffset(), selection.getLength(), forward, position);
        this.setStatusLineErrorMessage(null);
        this.setStatusLineMessage(null);
        if (annotation != null) {
            this.selectAndReveal(position.getOffset(), position.getLength());
            this.setStatusLineMessage(annotation.getText());
        }
        return annotation;
    }

    protected Annotation findAnnotation(int offset, int length, boolean forward, Position annotationPosition) {
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        IAnnotationModel model = this.getDocumentProvider().getAnnotationModel((Object)this.getEditorInput());
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Position p;
            Annotation a = (Annotation)e.next();
            if (!this.isNavigationTarget(a) || (p = model.getPosition(a)) == null) continue;
            if (forward && p.offset == offset || !forward && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && containingAnnotationPosition != null && (!forward || p.length < containingAnnotationPosition.length) && (forward || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (forward) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || nextAnnotationPosition == null || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || nextAnnotationPosition == null || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    protected boolean isNavigationTarget(Annotation annotation) {
        String key;
        AnnotationPreference preference = EditorsPlugin.getDefault().getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
        String string = key = preference == null ? null : preference.getIsGoToNextNavigationTargetKey();
        return key != null && this.getPreferenceStore() != null && this.getPreferenceStore().getBoolean(key);
    }

    public void showRevisionInformation(RevisionInformation info, String quickDiffProviderId) {
    }

    public Saveable[] getSaveables() {
        if (this.fSavable == null) {
            this.fSavable = new TextEditorSavable(this);
        }
        return new Saveable[]{this.fSavable};
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public int getOrientation() {
        return 0x2000000;
    }

    public LpexView getLpexView() {
        return this.fSourceViewer != null ? this.fSourceViewer.getLpexView() : null;
    }

    public LpexView getFirstLpexView() {
        return this.fSourceViewer != null ? this.fSourceViewer.getFirstLpexView() : null;
    }

    public LpexView getActiveLpexView() {
        return this.fSourceViewer != null ? this.fSourceViewer.getActiveLpexView() : null;
    }

    public LpexWindow getLpexWindow() {
        return this.fSourceViewer != null ? this.fSourceViewer.getLpexWindow() : null;
    }

    public LpexWindow getFirstLpexWindow() {
        return this.fSourceViewer != null ? this.fSourceViewer.getFirstLpexWindow() : null;
    }

    public LpexWindow getActiveLpexWindow() {
        return this.fSourceViewer != null ? this.fSourceViewer.getActiveLpexWindow() : null;
    }

    private LpexViewListener getLpexViewListener() {
        if (this._lpexViewListener == null) {
            this._lpexViewListener = new LpexViewAdapter(){

                @Override
                public void shown(LpexView view) {
                    LpexAbstractTextEditor.this.lpexViewShown(view);
                }
            };
        }
        return this._lpexViewListener;
    }

    private void lpexViewShown(LpexView lpexView) {
        if (lpexView == this.getFirstLpexView()) {
            boolean modified;
            boolean bl = modified = lpexView.queryInt("changes") != 0 || lpexView.queryOn("dirty");
            if (this._modified != modified) {
                this._modified = modified;
                this.firePropertyChange(257);
            }
        }
        if (this._activeWindow == null || this._activeWindow.getLpexView() == lpexView) {
            Utilities.addStatusLineListener(this._activeWindow, this.getStatusLineListener());
            this.updateWorkbenchActions(lpexView);
        }
    }

    private StatusLineListener getStatusLineListener() {
        if (this._statusLineListener == null) {
            this._statusLineListener = new StatusLineListener(){

                @Override
                public void line(int line) {
                    LpexAbstractTextEditor.this.updateStatusField("InputPosition");
                }

                @Override
                public void column(int column) {
                    LpexAbstractTextEditor.this.updateStatusField("InputPosition");
                }

                @Override
                public void inputMode(String inputMode) {
                    LpexAbstractTextEditor.this._statusLineInputMode = inputMode;
                    LpexAbstractTextEditor.this.updateStatusField("InputMode");
                }

                @Override
                public void changes(int changes) {
                    LpexAbstractTextEditor.this._statusLineChanges = changes;
                    LpexAbstractTextEditor.this.updateStatusField("ElementState");
                }

                @Override
                public void browseMode(String browseMode) {
                    LpexAbstractTextEditor.this._statusLineBrowseMode = browseMode;
                    LpexAbstractTextEditor.this.updateStatusField("ElementState");
                }

                @Override
                public void info(String info) {
                }
            };
        }
        return this._statusLineListener;
    }

    private FocusListener getCommandLineFocusListener() {
        if (this._commandLineFocusListener == null) {
            this._commandLineFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    LpexAbstractTextEditor.this.commandLineFocusGained();
                }

                public void focusLost(FocusEvent e) {
                    LpexAbstractTextEditor.this.commandLineFocusLost();
                }
            };
        }
        return this._commandLineFocusListener;
    }

    private void commandLineFocusGained() {
        this.updateClipboardActions();
        IBindingService keyBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (keyBindingService != null) {
            keyBindingService.setKeyFilterEnabled(false);
        }
    }

    private void commandLineFocusLost() {
        this.updateClipboardActions();
        IBindingService keyBindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (keyBindingService != null) {
            keyBindingService.setKeyFilterEnabled(true);
        }
    }

    void initPrimaryLpexWindow(LpexWindow lpexWindow) {
        lpexWindow.commandLine().addFocusListener(this.getCommandLineFocusListener());
    }

    void initSecondaryLpexWindow(LpexWindow lpexWindow) {
        String partId;
        String id = this.fEditorContextMenuId != null ? this.fEditorContextMenuId : DEFAULT_EDITOR_CONTEXT_MENU_ID;
        MenuManager manager = this.createContextMenuManager(id, id);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(this.getContextMenuListener());
        Menu contextMenu = manager.createContextMenu((Control)lpexWindow.textWindow());
        lpexWindow.textWindow().setMenu(contextMenu);
        this.getEditorSite().registerContextMenu(this.fEditorContextMenuId, manager, this.getSelectionProvider(), this.isEditorInputIncludedInContextMenu());
        if (this.fCompatibilityMode && (partId = this.getEditorSite().getId()) != null) {
            this.getEditorSite().registerContextMenu(partId + ".EditorContext", manager, this.getSelectionProvider(), this.isEditorInputIncludedInContextMenu());
        }
        this.initPrimaryLpexWindow(lpexWindow);
    }

    void initLpexView(LpexView lpexView) {
        this.addLpexViewListener(lpexView);
        try {
            this.initializeLpexView(lpexView);
        }
        catch (Throwable e) {
            LpexLog.log(e);
        }
    }

    void activeWindowChanged(LpexWindow lpexWindow) {
        if (this._activeWindow != null) {
            Utilities.removeStatusLineListener(this._activeWindow, this._statusLineListener);
        }
        if (lpexWindow != null) {
            this._activeWindowLpexStatusLine = lpexWindow.getLpexView().queryOn("current.statusLine");
            if (this._activeWindowLpexStatusLine) {
                this.clearStatusFields();
            } else {
                Utilities.addStatusLineListener(lpexWindow, this.getStatusLineListener());
            }
        }
        this._activeWindow = lpexWindow;
        this.initializeActivationCodeTrigger();
        this.createLpexKeyBindings();
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof LpexContextContributor) {
            ((LpexContextContributor)contributor).activeWindowChanged();
        }
    }

    public void initializeLpexView(LpexView lpexView) {
    }

    public void updateProfile(LpexView lpexView) {
    }

    protected void widgetContentsSet(LpexView lpexView) {
    }

    void doUpdateProfile(LpexView lpexView) {
        if (lpexView == null) {
            return;
        }
        this.doOurUpdateProfile(lpexView);
        this.initializeKeyBindingsScope(lpexView);
        try {
            this.updateProfile(lpexView);
        }
        catch (Exception e) {
            LpexLog.log(e);
        }
        this.updateSplitViewActions(lpexView);
        this.initializeActivationCodeTrigger();
        this.createLpexKeyBindings();
    }

    private void updateWorkbenchActions(LpexView lpexView) {
        LpexEditorAction action = this._firstAction;
        while (action != null) {
            action.update();
            action = action.next();
        }
    }

    private void updateClipboardActions() {
        IAction action = this.getAction(ITextEditorActionConstants.CUT);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if ((action = this.getAction(ITextEditorActionConstants.COPY)) instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if ((action = this.getAction(ITextEditorActionConstants.PASTE)) instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private IAction createLpexPopupAction(String actionName, String labelKey) {
        String label;
        LpexPopupAction action = null;
        String description = null;
        if (LpexStringTokenizer.isValidQuotedString(labelKey)) {
            label = LpexStringTokenizer.removeQuotes(labelKey);
        } else {
            label = LpexResources.message(labelKey);
            if (label == null) {
                label = labelKey;
            } else {
                description = LpexResources.message(labelKey + ".description");
            }
        }
        LpexView lpexView = this.getLpexView();
        int id = lpexView.actionId(actionName);
        if (id != 0) {
            action = new LpexPopupAction(this, id, label, description);
            LpexAction lpexAction = lpexView.action(actionName);
            Object contextHelpId = null;
            if (lpexAction != null && lpexAction instanceof LpexBaseAction) {
                contextHelpId = ((LpexBaseAction)lpexAction).getHelpId(lpexView);
            }
            if (contextHelpId == null) {
                contextHelpId = "com.ibm.lpex." + labelKey.replace('.', '_') + "_context";
            }
            action.setHelpContextId((String)contextHelpId);
        }
        return action;
    }

    private boolean populateSubmenu(IMenuManager menu, LpexStringTokenizer st) {
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("MARK-")) continue;
            if (token.equalsIgnoreCase("endSubmenu")) {
                return true;
            }
            if (token.equalsIgnoreCase("beginSubmenu")) {
                String label;
                if (!st.hasMoreTokens()) continue;
                boolean sourceSubmenu = false;
                token = st.nextToken();
                if (LpexStringTokenizer.isValidQuotedString(token)) {
                    label = LpexStringTokenizer.removeQuotes(token);
                } else {
                    if (token.equals("popup.sourceMenu")) {
                        sourceSubmenu = true;
                    }
                    if ((label = LpexResources.message(token)) == null) {
                        label = token;
                    }
                }
                MenuManager submenu = new MenuManager(label, sourceSubmenu ? "popup.sourceMenu" : null);
                menu.add((IContributionItem)submenu);
                if (this.populateSubmenu((IMenuManager)submenu, st)) continue;
                return false;
            }
            if (token.equalsIgnoreCase("separator")) {
                menu.add((IContributionItem)new Separator());
                continue;
            }
            if (!st.hasMoreTokens()) continue;
            String actionName = st.nextToken();
            this.addLpexPopupAction(menu, actionName, token);
        }
        return true;
    }

    private void addLpexViewListener(LpexView lpexView) {
        if (lpexView != null) {
            lpexView.addLpexViewListener(this.getLpexViewListener());
        }
    }

    private void doOurUpdateProfile(LpexView lpexView) {
        this._originalDeleteIdT = lpexView.actionId(lpexView.query("keyAction.delete.t"));
        this._originalDeleteIdP = lpexView.actionId(lpexView.query("keyAction.delete.p"));
        lpexView.doCommand("set keyAction.delete.t.p nullAction");
        lpexView.defineAction("eclipseUndo", this._eclipseUndoAction);
        lpexView.defineAction("eclipseRedo", this._eclipseRedoAction);
        lpexView.defineAction("eclipseDelete", this._eclipseDeleteAction);
        lpexView.defineAction("help", this._helpAction);
        lpexView.defineCommand("help", this._helpCommand);
        String osName = System.getProperty("os.name");
        if (osName != null && osName.startsWith("Mac")) {
            lpexView.doDefaultCommand("set keyAction.f1.t.p.c help");
        } else {
            lpexView.doDefaultCommand("set keyAction.f1.t.p.c");
        }
        lpexView.defineAction("rename", this._renameAction);
        lpexView.defineAction("save", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexAbstractTextEditor.this.getSite().getPage().saveEditor((IEditorPart)LpexAbstractTextEditor.this, false);
            }

            @Override
            public boolean available(LpexView view) {
                return LpexAbstractTextEditor.this.isDirty();
            }
        });
        lpexView.defineAction("saveAs", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexAbstractTextEditor.this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        lpexView.defineCommand("load", this._loadCommand);
        lpexView.defineCommand("save", this._saveCommand);
        lpexView.defineCommand("quit", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                LpexAbstractTextEditor.this.close(false);
                return true;
            }
        });
        lpexView.defineCommand("editorId", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                return view != null ? view.doCommand("set messageText " + LpexAbstractTextEditor.this.getSite().getId()) : true;
            }
        });
        lpexView.defineCommand("editorInput", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                if (view == null) {
                    return true;
                }
                if (LpexAbstractTextEditor.this.getEditorInput() == null) {
                    return view.doCommand("set messageText none.");
                }
                Class<?> editorInputClass = LpexAbstractTextEditor.this.getEditorInput().getClass();
                StringBuilder msg = new StringBuilder(64);
                msg.append(editorInputClass.getName());
                Class<?>[] interfaces = editorInputClass.getInterfaces();
                if (interfaces.length != 0) {
                    msg.append(" [implements ");
                    int i = 0;
                    while (i < interfaces.length) {
                        if (i != 0) {
                            msg.append(", ");
                        }
                        msg.append(interfaces[i].getName());
                        ++i;
                    }
                    msg.append("]");
                }
                while (!editorInputClass.getSuperclass().getName().equalsIgnoreCase("java.lang.Object")) {
                    editorInputClass = editorInputClass.getSuperclass();
                    msg.append(" <- ").append(editorInputClass.getName());
                }
                return view.doCommand("set messageText " + msg.toString());
            }
        });
        lpexView.defineCommand("traceCommands", new LpexCommand(){

            @Override
            public boolean doCommand(LpexView view, String parameters) {
                LpexAbstractTextEditor.this._traceCommands = "on".equalsIgnoreCase(parameters);
                return true;
            }
        });
        this._originalFindAction = lpexView.defineAction("find", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexAbstractTextEditor.runActionFind(LpexAbstractTextEditor.this);
            }

            @Override
            public boolean available(LpexView view) {
                return LpexAbstractTextEditor.actionAvailableFind(LpexAbstractTextEditor.this);
            }
        });
        lpexView.defineCommand("Lpex", this._LpexCommand);
        lpexView.defineCommand("view", this._viewCommand);
        lpexView.defineCommand("openNewView", this._openNewViewCommand);
        lpexView.defineAction("openNewView", this._openNewViewAction);
        lpexView.defineAction("cslAction", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                int actionId;
                int n = view.window().textWindow().isFocusControl() ? (view.queryOn("inPrefix") ? LpexAbstractTextEditor.this._originalCslIdP : LpexAbstractTextEditor.this._originalCslIdT) : (actionId = LpexAbstractTextEditor.this._originalCslIdC);
                if (actionId != 0) {
                    view.triggerAction(actionId);
                } else {
                    ((IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class)).openKeyAssistDialog();
                }
            }

            @Override
            public boolean available(LpexView view) {
                return true;
            }
        });
        this._originalCslIdT = lpexView.actionId(lpexView.query("keyAction.c-s-l.t"));
        this._originalCslIdP = lpexView.actionId(lpexView.query("keyAction.c-s-l.p"));
        this._originalCslIdC = lpexView.actionId(lpexView.query("keyAction.c-s-l.c"));
        lpexView.doCommand("set keyAction.c-s-l.t.p.c cslAction");
    }

    private static void runActionFind(LpexAbstractTextEditor editor) {
        LpexView lpexView = editor.getLpexView();
        if (lpexView != null) {
            if (lpexView.queryOn("readonly")) {
                if (editor._originalFindAction == null) {
                    lpexView.doDefaultAction(103);
                } else {
                    editor._originalFindAction.doAction(lpexView);
                }
                lpexView.doCommand("screenShow view");
            } else {
                lpexView.triggerAction(104);
            }
        }
    }

    private static boolean actionAvailableFind(LpexAbstractTextEditor editor) {
        LpexView lpexView = editor.getLpexView();
        if (lpexView == null) {
            return false;
        }
        if (lpexView.queryOn("readonly")) {
            return editor._originalFindAction == null ? lpexView.defaultActionAvailable(103) : editor._originalFindAction.available(lpexView);
        }
        return lpexView.actionAvailable(104);
    }

    private void performHelpAction(LpexView lpexView) {
        this.fSourceViewer.performHelp(lpexView);
    }

    private static boolean performHelpCommand(String parameters) {
        Object helpPage = LpexView.getLpexHelpPage(parameters);
        if (helpPage != null) {
            if (((String)helpPage).startsWith("api/")) {
                helpPage = "/com.ibm.lpex.doc.isv/" + (String)helpPage;
            } else if (((String)helpPage).startsWith("ref/") || ((String)helpPage).startsWith("concepts/") || ((String)helpPage).startsWith("tasks/") || ((String)helpPage).startsWith("ui/")) {
                helpPage = "/com.ibm.lpex.doc.user/" + (String)helpPage;
            }
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource((String)helpPage);
        }
        return true;
    }

    private boolean performSaveCommand(LpexView lpexView, String parameters) {
        LpexStringTokenizer st = new LpexStringTokenizer(parameters);
        if (!st.hasMoreTokens()) {
            this.getSite().getPage().saveEditor((IEditorPart)this, false);
            return true;
        }
        return lpexView != null ? lpexView.doDefaultCommand("save " + parameters) : true;
    }

    protected boolean availableOpenNewView(LpexView lpexView) {
        if (lpexView.queryOn("current.splitWindow")) {
            return lpexView.queryInt("documentViews") < this.fSourceViewer.getLpexMultiWindow().getMaxWindows();
        }
        return true;
    }

    private LpexWindow[] getWindows() {
        LpexMultiWindow lpexMultiWindow;
        if (this.fSourceViewer != null && (lpexMultiWindow = this.fSourceViewer.getLpexMultiWindow()) != null) {
            return lpexMultiWindow.getWindows();
        }
        return new LpexWindow[0];
    }

    private boolean openNewView(LpexView lpexView) {
        if (lpexView.queryOn("current.multipleViews")) {
            if (!lpexView.queryOn("current.splitWindow")) {
                return this.performLpexCommand(lpexView);
            }
            if (this.fSourceViewer != null) {
                LpexView view = this.fSourceViewer.splitView(lpexView);
                if (view != null) {
                    view.window().textWindow().addMouseListener((MouseListener)this.getCursorListener());
                    view.window().textWindow().addKeyListener((KeyListener)this.getCursorListener());
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    private void updateSplitViewActions(LpexView lpexView) {
        if (lpexView.queryOn("current.multipleViews")) {
            this.assignKey(lpexView, "c-2", "openNewView");
            if (lpexView.queryOn("current.splitWindow") || this.getWindows().length > 1) {
                lpexView.defineAction("nextView", this._nextViewAction);
                this.assignKey(lpexView, "a-s-right", "nextView");
                lpexView.defineAction("prevView", this._prevViewAction);
                this.assignKey(lpexView, "a-s-left", "prevView");
                lpexView.defineAction("verticalSplit", this._verticalSplitAction);
                lpexView.defineAction("horizontalSplit", this._horizontalSplitAction);
                lpexView.defineAction("closeView", this._closeViewAction);
                this.assignKey(lpexView, "c-0", "closeView");
            }
        }
    }

    private void assignKey(LpexView lpexView, String key, String actionName) {
        if (!lpexView.keyAssigned(key + ".t")) {
            lpexView.doCommand("set keyAction." + key + ".t " + actionName);
        }
        if (!lpexView.keyAssigned(key + ".p")) {
            lpexView.doCommand("set keyAction." + key + ".p " + actionName);
        }
        if (!lpexView.keyAssigned(key + ".c")) {
            lpexView.doCommand("set keyAction." + key + ".c " + actionName);
        }
    }

    private boolean performLpexCommand(final String parameters, final boolean browse) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> cl = Class.forName("com.ibm.lpex.samples.Lpex");
                    Constructor<?> lpexConstructor = cl.getConstructor(String[].class, Rectangle.class, Boolean.TYPE, Shell.class);
                    lpexConstructor.newInstance(LpexStringTokenizer.split(parameters), new Rectangle(10, 10, 648, 711), browse, LpexAbstractTextEditor.this.getSite().getShell());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        return true;
    }

    protected boolean performLpexCommand(LpexView lpexView) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Class<?> cl = Class.forName("com.ibm.lpex.samples.Lpex");
                    Constructor<?> lpexConstructor = cl.getConstructor(LpexView.class, Lpex.Delegate.class, Rectangle.class, Boolean.TYPE);
                    lpexConstructor.newInstance(LpexAbstractTextEditor.this.getFirstLpexView(), LpexAbstractTextEditor.this.getDelegate(), new Rectangle(10, 10, 648, 711), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        return true;
    }

    private Lpex.Delegate getDelegate() {
        return new Lpex.Delegate(){

            @Override
            public void delegate(LpexView lpexView) {
                LpexAbstractTextEditor.this.handleDelegate(lpexView);
            }
        };
    }

    protected void handleDelegate(LpexView lpexView) {
        lpexView.defineAction("help", this._helpAction);
        lpexView.defineCommand("help", this._helpCommand);
        lpexView.defineAction("rename", this._renameAction);
        lpexView.defineAction("save", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexView v = LpexAbstractTextEditor.this.getLpexView();
                if (v != null) {
                    v.doAction(v.actionId("save"));
                }
            }

            @Override
            public boolean available(LpexView view) {
                LpexView v = LpexAbstractTextEditor.this.getLpexView();
                return v != null && v.actionAvailable(v.actionId("save"));
            }
        });
        lpexView.defineAction("saveAs", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexView v = LpexAbstractTextEditor.this.getLpexView();
                if (v != null) {
                    v.doAction(v.actionId("saveAs"));
                }
            }

            @Override
            public boolean available(LpexView view) {
                LpexView v = LpexAbstractTextEditor.this.getLpexView();
                return v != null && v.actionAvailable(v.actionId("saveAs"));
            }
        });
        lpexView.defineAction("get", new LpexAction(){

            @Override
            public void doAction(LpexView view) {
                LpexView v = LpexAbstractTextEditor.this.getLpexView();
                if (v != null) {
                    v.doAction(v.actionId("get"));
                }
            }

            @Override
            public boolean available(LpexView view) {
                LpexView v = LpexAbstractTextEditor.this.getLpexView();
                return v != null && v.actionAvailable(v.actionId("get"));
            }
        });
        lpexView.defineCommand("load", this._loadCommand);
        lpexView.defineCommand("save", this._saveCommand);
    }

    protected boolean setDocumentSection(int linesBeforeStart, int linesAfterEnd) {
        LpexView lpexView = this.getFirstLpexView();
        if (lpexView == null) {
            return false;
        }
        boolean success = lpexView.setLinesOutsideDocumentSection(linesBeforeStart, linesAfterEnd);
        if (success) {
            if (linesBeforeStart == 0 && linesAfterEnd == 0) {
                if (this._lpexDocumentSectionListener != null) {
                    lpexView.removeLpexDocumentSectionListener(this._lpexDocumentSectionListener);
                    this._lpexDocumentSectionListener = null;
                }
            } else if (this._lpexDocumentSectionListener == null) {
                this._lpexDocumentSectionListener = new LpexDocumentSectionListener(){

                    @Override
                    public boolean addLines(LpexView v, int neededLine) {
                        return LpexAbstractTextEditor.this.manageDocumentSection(v, neededLine);
                    }
                };
                lpexView.addLpexDocumentSectionListener(this._lpexDocumentSectionListener);
            }
        }
        return success;
    }

    private boolean manageDocumentSection(LpexView lpexView, int neededLine) {
        DocumentAdapter documentAdapter = this.fSourceViewer.getDocumentAdapter();
        documentAdapter.listenToLpexDocument(false);
        documentAdapter.listenToEclipseDocument(false);
        this.addLines(lpexView, neededLine);
        documentAdapter.listenToEclipseDocument(true);
        documentAdapter.listenToLpexDocument(true);
        if (lpexView.queryInt("lines.beforeStart") == 0 && lpexView.queryInt("lines.afterEnd") == 0 && this._lpexDocumentSectionListener != null) {
            lpexView.removeLpexDocumentSectionListener(this._lpexDocumentSectionListener);
            this._lpexDocumentSectionListener = null;
        }
        return true;
    }

    protected boolean addLines(LpexView lpexView, int lineNeeded) {
        return false;
    }

    protected IResource getInputResource() {
        return this._inputResource;
    }

    String getActionAccelerator(int actionId) {
        String commandId;
        int indexOfDot;
        String actionKey;
        LpexView lpexView = this.getLpexView();
        if (lpexView != null && (actionKey = lpexView.actionKey(actionId)) != null && (indexOfDot = actionKey.indexOf(46)) > 0 && this.scopeCommandSet(commandId = actionKey.substring(0, indexOfDot))) {
            return commandId;
        }
        return null;
    }

    private void initializeKeyBindingsScope(LpexView lpexView) {
        if (lpexView != null) {
            String baseProfile = lpexView.query("baseProfile");
            if ("none".equalsIgnoreCase(baseProfile)) {
                this.setKeyBindingScopes(lpexView, new String[0]);
                return;
            }
            if (baseProfile == null) {
                this.setKeyBindingScopes(lpexView, new String[]{"com.ibm.lpex.lpexScope"});
            } else {
                this.setKeyBindingScopes(lpexView, new String[]{"com.ibm.lpex." + baseProfile + "Scope"});
            }
        }
    }

    private void createLpexKeyBindings() {
        LpexView lpexView;
        LpexView lpexView2 = lpexView = this._activeWindow != null && !this._activeWindow.isDisposed() ? this._activeWindow.getLpexView() : this.getLpexView();
        if (lpexView != null) {
            String baseProfile = lpexView.query("baseProfile");
            if (baseProfile == null) {
                baseProfile = "lpex";
            }
            if (baseProfile.equals(this._lastKeybindingBaseProfile)) {
                return;
            }
            this.unregisterScopeActions();
            this._lastKeybindingBaseProfile = baseProfile;
            this._scopeCommands2 = null;
            this._scopeCommands1 = null;
            if ("none".equalsIgnoreCase(baseProfile)) {
                return;
            }
            if ("emacs".equalsIgnoreCase(baseProfile)) {
                this._scopeCommands1 = KeyBindings.emacsScopeCommands;
            } else if ("vi".equalsIgnoreCase(baseProfile)) {
                this._scopeCommands1 = KeyBindings.viScopeCommands;
            } else if ("eclipse".equalsIgnoreCase(baseProfile)) {
                this._scopeCommands1 = KeyBindings.eclipseScopeCommands;
            } else {
                this._scopeCommands1 = KeyBindings.lpexScopeCommands;
                if ("seu".equalsIgnoreCase(baseProfile)) {
                    this._scopeCommands2 = KeyBindings.seuScopeCommands;
                } else if ("ispf".equalsIgnoreCase(baseProfile)) {
                    this._scopeCommands2 = KeyBindings.ispfScopeCommands;
                } else if ("xedit".equalsIgnoreCase(baseProfile)) {
                    this._scopeCommands2 = KeyBindings.xeditScopeCommands;
                } else if ("brief".equalsIgnoreCase(baseProfile)) {
                    this._scopeCommands2 = KeyBindings.briefScopeCommands;
                } else if ("epm".equalsIgnoreCase(baseProfile)) {
                    this._scopeCommands2 = KeyBindings.epmScopeCommands;
                }
            }
            this.registerScopeActions();
        }
    }

    private void registerScopeActions() {
        String keyString;
        int i;
        if (this.fKeybindingActions == null) {
            return;
        }
        if (this._scopeCommands1 != null) {
            i = 0;
            while (i < this._scopeCommands1.length) {
                keyString = this._scopeCommands1[i];
                this.fKeybindingActions.put(keyString, (IAction)new LpexKeyBindingAction(this, keyString));
                ++i;
            }
        }
        if (this._scopeCommands2 != null) {
            i = 0;
            while (i < this._scopeCommands2.length) {
                keyString = this._scopeCommands2[i];
                this.fKeybindingActions.put(keyString, (IAction)new LpexKeyBindingAction(this, keyString));
                ++i;
            }
        }
        this.fActivationCodeTrigger.registerKeybindingActionsForKeyActivation();
    }

    private void unregisterScopeActions() {
        if (this.fKeybindingActions == null) {
            return;
        }
        this.fActivationCodeTrigger.unregisterKeybindingActionsForKeyActivation();
        this.fKeybindingActions.clear();
    }

    boolean scopeCommandSet(String scopeCommand) {
        int i;
        if (this._scopeCommands1 != null) {
            i = 0;
            while (i < this._scopeCommands1.length) {
                if (this._scopeCommands1[i].equals(scopeCommand)) {
                    return true;
                }
                ++i;
            }
        }
        if (this._scopeCommands2 != null) {
            i = 0;
            while (i < this._scopeCommands2.length) {
                if (this._scopeCommands2[i].equals(scopeCommand)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void createViewPreferenceNodes(LpexSourceViewer lpexSourceViewer) {
    }

    protected IPreferencePage createViewPreferencePage(LpexView lpexView, int nodeType) {
        return null;
    }

    private void registerUndoRedoAction(String actionId, OperationHistoryActionHandler action) {
        IAction oldAction = this.getAction(actionId);
        if (oldAction instanceof OperationHistoryActionHandler) {
            ((OperationHistoryActionHandler)oldAction).dispose();
        }
        if (action == null) {
            return;
        }
        this.setAction(actionId, (IAction)action);
        IActionBars actionBars = this.getEditorSite().getActionBars();
        if (actionBars != null) {
            actionBars.setGlobalActionHandler(actionId, (IAction)action);
        }
    }

    static class ActionActivationCode {
        public String fActionId;
        public char fCharacter;
        public int fKeyCode = -1;
        public int fStateMask = -1;

        public ActionActivationCode(String actionId) {
            this.fActionId = actionId;
        }

        public boolean matches(Event event) {
            return !(event.character != this.fCharacter || this.fKeyCode != -1 && event.keyCode != this.fKeyCode || this.fStateMask != -1 && event.stateMask != this.fStateMask);
        }
    }

    class ActivationCodeTrigger
    implements LpexKeyListener {
        private boolean fIsInstalled;
        private IKeyBindingService fKeyBindingService;
        private LpexView _lpexView;
        private String[] _keyBindingScopes;

        ActivationCodeTrigger() {
        }

        @Override
        public void keyPressed(Event event) {
            ActionActivationCode code = null;
            int size = LpexAbstractTextEditor.this.fActivationCodes.size();
            int i = 0;
            while (i < size) {
                IAction action;
                code = LpexAbstractTextEditor.this.fActivationCodes.get(i);
                if (code.matches(event) && (action = LpexAbstractTextEditor.this.getAction(code.fActionId)) != null) {
                    if (action instanceof IUpdate) {
                        ((IUpdate)action).update();
                    }
                    if (!action.isEnabled() && action instanceof IReadOnlyDependent) {
                        IReadOnlyDependent dependent = (IReadOnlyDependent)action;
                        boolean writable = dependent.isEnabled(true);
                        if (writable) {
                            event.doit = false;
                            return;
                        }
                    } else if (action.isEnabled()) {
                        event.doit = false;
                        action.run();
                        return;
                    }
                }
                ++i;
            }
        }

        public void install() {
            if (!this.fIsInstalled) {
                this.fKeyBindingService = LpexAbstractTextEditor.this.getEditorSite().getKeyBindingService();
                this.fIsInstalled = true;
                this._keyBindingScopes = null;
            }
        }

        public void setLpexView(LpexView lpexView) {
            if (this.fIsInstalled && this._lpexView != lpexView) {
                if (this._lpexView != null) {
                    this._lpexView.removeLpexKeyListener(this);
                }
                this._lpexView = lpexView;
                if (this._lpexView != null) {
                    this._lpexView.addLpexKeyListener(this);
                }
            }
        }

        public void uninstall() {
            if (this.fIsInstalled) {
                this.setLpexView(null);
                this.fIsInstalled = false;
                this.fKeyBindingService = null;
            }
        }

        public void registerActionForKeyActivation(IAction action) {
            if (this.fIsInstalled && action.getActionDefinitionId() != null) {
                this.fKeyBindingService.registerAction(action);
            }
        }

        public void unregisterActionFromKeyActivation(IAction action) {
            if (this.fIsInstalled && action.getActionDefinitionId() != null) {
                this.fKeyBindingService.unregisterAction(action);
            }
        }

        void registerKeybindingActionsForKeyActivation() {
            Iterator<IAction> it = LpexAbstractTextEditor.this.fKeybindingActions.values().iterator();
            while (it.hasNext()) {
                this.fKeyBindingService.registerAction(it.next());
            }
        }

        void unregisterKeybindingActionsForKeyActivation() {
            Iterator<IAction> it = LpexAbstractTextEditor.this.fKeybindingActions.values().iterator();
            while (it.hasNext()) {
                this.fKeyBindingService.unregisterAction(it.next());
            }
        }

        public void setScopes(String[] keyBindingScopes) {
            if (keyBindingScopes != null) {
                boolean sameScopes;
                boolean bl = sameScopes = this._keyBindingScopes != null && this._keyBindingScopes.length == keyBindingScopes.length;
                if (sameScopes) {
                    int i = 0;
                    while (i < keyBindingScopes.length) {
                        if (!keyBindingScopes[i].equals(this._keyBindingScopes[i])) {
                            sameScopes = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (!sameScopes) {
                    this._keyBindingScopes = keyBindingScopes;
                    this.fKeyBindingService.setScopes(keyBindingScopes);
                }
            }
        }
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        private void handleActivation() {
            if (this.fIsHandlingActivation) {
                return;
            }
            if (this.fActivePart == LpexAbstractTextEditor.this) {
                this.fIsHandlingActivation = true;
                try {
                    LpexAbstractTextEditor.this.safelySanityCheckState(LpexAbstractTextEditor.this.getEditorInput());
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
            LpexAbstractTextEditor.this.fHasBeenActivated = true;
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == LpexAbstractTextEditor.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ActivationListener.this.handleActivation();
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    protected static class ColumnSupport
    implements IColumnSupport {
        private final LpexAbstractTextEditor fEditor;
        private final RulerColumnRegistry fRegistry;
        private final List<IContributedRulerColumn> fColumns;

        public ColumnSupport(LpexAbstractTextEditor editor, RulerColumnRegistry registry) {
            Assert.isLegal((editor != null ? 1 : 0) != 0);
            Assert.isLegal((registry != null ? 1 : 0) != 0);
            this.fEditor = editor;
            this.fRegistry = registry;
            this.fColumns = new ArrayList<IContributedRulerColumn>();
        }

        public final void setColumnVisible(RulerColumnDescriptor descriptor, boolean visible) {
            Assert.isLegal((descriptor != null ? 1 : 0) != 0);
            LpexCompositeRuler ruler = this.getRuler();
            if (ruler == null) {
                return;
            }
            if (!this.isColumnSupported(descriptor)) {
                visible = false;
            }
            if (this.isColumnVisible(descriptor)) {
                if (!visible) {
                    this.removeColumn(ruler, descriptor);
                }
            } else if (visible) {
                this.addColumn(ruler, descriptor);
            }
        }

        private void addColumn(final LpexCompositeRuler ruler, final RulerColumnDescriptor descriptor) {
            final int idx = this.computeIndex(ruler, descriptor);
            SafeRunnable runnable = new SafeRunnable(){

                public void run() throws Exception {
                    IContributedRulerColumn column = descriptor.createColumn((ITextEditor)fEditor);
                    if (column instanceof AbstractRulerColumn) {
                        column = new LpexRulerColumnWrapper((AbstractRulerColumn)column, (LpexSourceViewer)fEditor.getSourceViewer());
                    }
                    fColumns.add(column);
                    this.initializeColumn(column);
                    ruler.addDecorator(idx, (IVerticalRulerColumn)column);
                }
            };
            SafeRunner.run((ISafeRunnable)runnable);
        }

        protected void initializeColumn(IContributedRulerColumn column) {
        }

        private void removeColumn(LpexCompositeRuler ruler, RulerColumnDescriptor descriptor) {
            this.removeColumn(ruler, this.getVisibleColumn(ruler, descriptor));
        }

        private void removeColumn(final LpexCompositeRuler ruler, final IContributedRulerColumn rulerColumn) {
            if (rulerColumn != null) {
                SafeRunnable runnable = new SafeRunnable(){

                    public void run() throws Exception {
                        if (ruler != null) {
                            ruler.removeDecorator((IVerticalRulerColumn)rulerColumn);
                        }
                        rulerColumn.columnRemoved();
                    }
                };
                SafeRunner.run((ISafeRunnable)runnable);
            }
        }

        private IContributedRulerColumn getVisibleColumn(LpexCompositeRuler ruler, RulerColumnDescriptor descriptor) {
            Iterator it = ruler.getDecoratorIterator();
            while (it.hasNext()) {
                IContributedRulerColumn rulerColumn;
                RulerColumnDescriptor rcd;
                IVerticalRulerColumn column = (IVerticalRulerColumn)it.next();
                if (!(column instanceof IContributedRulerColumn) || !descriptor.equals((Object)(rcd = (rulerColumn = (IContributedRulerColumn)column).getDescriptor()))) continue;
                return rulerColumn;
            }
            return null;
        }

        private int computeIndex(LpexCompositeRuler ruler, RulerColumnDescriptor descriptor) {
            int index = 0;
            List all = this.fRegistry.getColumnDescriptors();
            int newPos = all.indexOf(descriptor);
            Iterator it = ruler.getDecoratorIterator();
            while (it.hasNext()) {
                RulerColumnDescriptor rcd;
                IVerticalRulerColumn column = (IVerticalRulerColumn)it.next();
                if (column instanceof IContributedRulerColumn ? (rcd = ((IContributedRulerColumn)column).getDescriptor()) != null && all.indexOf(rcd) > newPos : "org.eclipse.jface.text.source.projection.ProjectionRulerColumn".equalsIgnoreCase(column.getClass().getName())) break;
                ++index;
            }
            return index;
        }

        public final boolean isColumnVisible(RulerColumnDescriptor descriptor) {
            Assert.isLegal((descriptor != null ? 1 : 0) != 0);
            LpexCompositeRuler ruler = this.getRuler();
            return ruler != null && this.getVisibleColumn(ruler, descriptor) != null;
        }

        public final boolean isColumnSupported(RulerColumnDescriptor descriptor) {
            if (descriptor == null || this.getRuler() == null) {
                return false;
            }
            return descriptor.matchesEditor((ITextEditor)this.fEditor);
        }

        private LpexCompositeRuler getRuler() {
            Object ruler = this.fEditor.getAdapter(IVerticalRulerInfo.class);
            return ruler instanceof LpexCompositeRuler ? (LpexCompositeRuler)((Object)ruler) : null;
        }

        public void dispose() {
            Iterator<IContributedRulerColumn> iter = new ArrayList<IContributedRulerColumn>(this.fColumns).iterator();
            while (iter.hasNext()) {
                this.removeColumn(this.getRuler(), iter.next());
            }
            this.fColumns.clear();
        }
    }

    private static final class EditorMessages {
        private static ResourceBundle _bundle;

        private EditorMessages() {
        }

        public static String getString(String key) {
            try {
                if (EditorMessages.getResourceBundle() != null) {
                    return _bundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return "!" + key + "!";
        }

        public static ResourceBundle getResourceBundle() {
            if (_bundle == null) {
                _bundle = ResourceBundle.getBundle("org.eclipse.ui.texteditor.EditorMessages");
            }
            return _bundle;
        }
    }

    class ElementStateListener
    implements IElementStateListener,
    IElementStateListenerExtension {
        private Display fDisplay;

        ElementStateListener() {
        }

        public void elementStateValidationChanged(Object element, boolean isStateValidated) {
            if (element != null && element.equals(LpexAbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        LpexAbstractTextEditor.this.enableSanityChecking(true);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementDirtyStateChanged(Object element, boolean isDirty) {
            if (element != null && element.equals(LpexAbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        LpexAbstractTextEditor.this.enableSanityChecking(true);
                        LpexAbstractTextEditor.this.firePropertyChange(257);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementContentAboutToBeReplaced(Object element) {
            if (element != null && element.equals(LpexAbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        LpexAbstractTextEditor.this.enableSanityChecking(true);
                        LpexAbstractTextEditor.this.rememberSelection();
                        LpexAbstractTextEditor.this.resetHighlightRange();
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementContentReplaced(Object element) {
            if (element != null && element.equals(LpexAbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        LpexAbstractTextEditor.this.enableSanityChecking(true);
                        LpexAbstractTextEditor.this.firePropertyChange(257);
                        LpexAbstractTextEditor.this.restoreSelection();
                        LpexAbstractTextEditor.this.handleElementContentReplaced();
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementDeleted(Object deletedElement) {
            if (deletedElement != null && deletedElement.equals(LpexAbstractTextEditor.this.getEditorInput())) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        LpexAbstractTextEditor.this.enableSanityChecking(true);
                        LpexAbstractTextEditor.this.close(false);
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementMoved(final Object originalElement, final Object movedElement) {
            if (originalElement != null && originalElement.equals(LpexAbstractTextEditor.this.getEditorInput())) {
                final boolean doValidationAsync = Display.getCurrent() != null;
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        LpexAbstractTextEditor.this.enableSanityChecking(true);
                        if (((ElementStateListener)ElementStateListener.this).LpexAbstractTextEditor.this.fSourceViewer == null) {
                            return;
                        }
                        if (!LpexAbstractTextEditor.this.canHandleMove((IEditorInput)originalElement, (IEditorInput)movedElement)) {
                            LpexAbstractTextEditor.this.close(true);
                            return;
                        }
                        if (movedElement == null || movedElement instanceof IEditorInput) {
                            LpexAbstractTextEditor.this.rememberSelection();
                            final IDocumentProvider d = LpexAbstractTextEditor.this.getDocumentProvider();
                            IDocument changed = null;
                            boolean wasDirty = LpexAbstractTextEditor.this.isDirty();
                            changed = d.getDocument((Object)LpexAbstractTextEditor.this.getEditorInput());
                            final String previousContent = changed != null ? (wasDirty ? changed.get() : null) : null;
                            LpexAbstractTextEditor.this.setInput((IEditorInput)movedElement);
                            if (wasDirty && changed != null) {
                                Runnable r2 = new Runnable(){

                                    @Override
                                    public void run() {
                                        LpexAbstractTextEditor.this.validateState(LpexAbstractTextEditor.this.getEditorInput());
                                        d.getDocument((Object)LpexAbstractTextEditor.this.getEditorInput()).set(previousContent);
                                        LpexView lpexView = LpexAbstractTextEditor.this.getLpexView();
                                        if (lpexView != null) {
                                            lpexView.doCommand("set dirty on");
                                            lpexView.doCommand("screenShow document");
                                        }
                                        LpexAbstractTextEditor.this.updateStatusField("ElementState");
                                        LpexAbstractTextEditor.this.restoreSelection();
                                    }
                                };
                                ElementStateListener.this.execute(r2, doValidationAsync);
                            } else {
                                LpexAbstractTextEditor.this.restoreSelection();
                            }
                        }
                    }
                };
                this.execute(r, false);
            }
        }

        public void elementStateChanging(Object element) {
            if (element != null && element.equals(LpexAbstractTextEditor.this.getEditorInput())) {
                LpexAbstractTextEditor.this.enableSanityChecking(false);
            }
        }

        public void elementStateChangeFailed(Object element) {
            if (element != null && element.equals(LpexAbstractTextEditor.this.getEditorInput())) {
                LpexAbstractTextEditor.this.enableSanityChecking(true);
            }
        }

        private void execute(Runnable runnable, boolean postAsync) {
            if (postAsync || Display.getCurrent() == null) {
                if (this.fDisplay == null) {
                    this.fDisplay = LpexAbstractTextEditor.this.getSite().getShell().getDisplay();
                }
                this.fDisplay.asyncExec(runnable);
            } else {
                runnable.run();
            }
        }

        class Validator
        implements VerifyListener {
            Validator() {
            }

            public void verifyText(VerifyEvent e) {
                IDocument document = LpexAbstractTextEditor.this.getDocumentProvider().getDocument((Object)LpexAbstractTextEditor.this.getEditorInput());
                final boolean[] documentChanged = new boolean[1];
                IDocumentListener listener = new IDocumentListener(){

                    public void documentAboutToBeChanged(DocumentEvent event) {
                    }

                    public void documentChanged(DocumentEvent event) {
                        documentChanged[0] = true;
                    }
                };
                try {
                    if (document != null) {
                        document.addDocumentListener(listener);
                    }
                    if (!LpexAbstractTextEditor.this.validateEditorInputState() || documentChanged[0]) {
                        e.doit = false;
                    }
                }
                finally {
                    if (document != null) {
                        document.removeDocumentListener(listener);
                    }
                }
            }
        }
    }

    static interface ICursorListener
    extends MouseListener,
    KeyListener {
    }

    protected static final class IdMapEntry {
        private String fActionId;
        private int fAction;

        public IdMapEntry(String actionName, int actionId) {
            this.fActionId = actionName;
            this.fAction = actionId;
        }

        public String getActionId() {
            return this.fActionId;
        }

        public int getAction() {
            return this.fAction;
        }
    }

    private final class InformationDispatchAction
    extends TextEditorAction {
        private final TextOperationAction fTextOperationAction;

        public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction) {
            super(resourceBundle, prefix, (ITextEditor)LpexAbstractTextEditor.this);
            if (textOperationAction == null) {
                throw new IllegalArgumentException();
            }
            this.fTextOperationAction = textOperationAction;
        }

        public void run() {
            IAnnotationHover annotationHover;
            ITextHover textHover;
            ITextViewerExtension4 extension4;
            ISourceViewer sourceViewer = LpexAbstractTextEditor.this.getSourceViewer();
            if (sourceViewer == null) {
                if (this.fTextOperationAction.isEnabled()) {
                    this.fTextOperationAction.run();
                }
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
                return;
            }
            if (sourceViewer instanceof ITextViewerExtension2 && (textHover = ((ITextViewerExtension2)sourceViewer).getCurrentTextHover()) != null && this.makeTextHoverFocusable(sourceViewer, textHover)) {
                return;
            }
            if (sourceViewer instanceof ISourceViewerExtension3 && (annotationHover = ((ISourceViewerExtension3)sourceViewer).getCurrentAnnotationHover()) != null && this.makeAnnotationHoverFocusable(annotationHover)) {
                return;
            }
            if (this.fTextOperationAction.isEnabled()) {
                this.fTextOperationAction.run();
            }
        }

        private boolean makeTextHoverFocusable(ISourceViewer sourceViewer, ITextHover textHover) {
            IRegion hoverRegion;
            int offset;
            block5: {
                Point hoverEventLocation = ((ITextViewerExtension2)sourceViewer).getHoverEventLocation();
                offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
                if (offset == -1) {
                    return false;
                }
                try {
                    hoverRegion = textHover.getHoverRegion((ITextViewer)sourceViewer, offset);
                    if (hoverRegion != null) break block5;
                    return false;
                }
                catch (BadLocationException e) {
                    return false;
                }
            }
            String hoverInfo = textHover.getHoverInfo((ITextViewer)sourceViewer, hoverRegion);
            IInformationControlCreator controlCreator = null;
            if (textHover instanceof IInformationProviderExtension2) {
                controlCreator = ((IInformationProviderExtension2)textHover).getInformationPresenterControlCreator();
            }
            FocusedInformationPresenter.InformationProvider informationProvider = new FocusedInformationPresenter.InformationProvider(hoverRegion, (Object)hoverInfo, controlCreator);
            FocusedInformationPresenter informationPresenter = this.getInformationPresenter();
            informationPresenter.setOffset(offset);
            informationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            informationPresenter.setMargins(6, 6);
            String contentType = TextUtilities.getContentType((IDocument)sourceViewer.getDocument(), (String)LpexAbstractTextEditor.this.getSourceViewerConfiguration().getConfiguredDocumentPartitioning(LpexAbstractTextEditor.this.getSourceViewer()), (int)offset, (boolean)true);
            informationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            informationPresenter.showInformation();
            return true;
        }

        private boolean makeAnnotationHoverFocusable(IAnnotationHover annotationHover) {
            IVerticalRuler info = LpexAbstractTextEditor.this.getVerticalRuler();
            int line = info.getLineOfLastMouseButtonActivity();
            if (line == -1) {
                return false;
            }
            return this.getInformationPresenter().openFocusedAnnotationHover(annotationHover, line);
        }

        private FocusedInformationPresenter getInformationPresenter() {
            if (LpexAbstractTextEditor.this.fInformationPresenter == null) {
                LpexAbstractTextEditor.this.fInformationPresenter = new LpexFocusedInformationPresenter(LpexAbstractTextEditor.this.getSourceViewer(), LpexAbstractTextEditor.this.getSourceViewerConfiguration());
            }
            return LpexAbstractTextEditor.this.fInformationPresenter;
        }

        private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
            LpexDocumentLocation loc;
            IDocument document = textViewer.getDocument();
            if (document == null) {
                return -1;
            }
            int top = 0;
            if (y < top) {
                return -1;
            }
            LpexView lpexView = ((LpexTextViewer)textViewer).getFirstLpexView();
            int row = (y - top) / lpexView.queryInt("rowHeight") + 1;
            if (row > lpexView.queryInt("rows")) {
                return -1;
            }
            int element = lpexView.elementOfRow(row);
            if (element == 0 || lpexView.show(element)) {
                return -1;
            }
            int prefixWidth = lpexView.queryInt("prefixAreaWidth") + lpexView.queryInt("expandHideAreaWidth");
            if (x < prefixWidth) {
                return -1;
            }
            if ((x += lpexView.queryInt("scroll") - prefixWidth) >= lpexView.queryInt("textWidth", loc = new LpexDocumentLocation(element, 1))) {
                return -1;
            }
            int lookup = lpexView.queryInt("pixelPosition", loc);
            String text = lpexView.elementText(element);
            if (text == null) {
                return -1;
            }
            int high = text.length();
            int guessPosition = 1;
            int guessPixelDelta = Math.abs(lookup - x);
            int i = 2;
            while (i <= high) {
                loc.position = i;
                lookup = lpexView.queryInt("pixelPosition", loc);
                int pixelDelta = Math.abs(lookup - x);
                if (pixelDelta < guessPixelDelta) {
                    guessPosition = i;
                    guessPixelDelta = pixelDelta;
                }
                ++i;
            }
            loc.position = guessPosition;
            return ((LpexTextViewer)textViewer).getDocumentAdapter().getDocOffset(loc);
        }
    }

    private class LpexEditorAction
    extends TextEditorAction {
        private LpexEditorAction _next;
        private int _actionId;

        public LpexEditorAction(ResourceBundle bundle, String key, LpexAbstractTextEditor editor, int actionId) {
            super(bundle, key, (ITextEditor)editor);
            this._actionId = -1;
            this._actionId = actionId;
            this._next = LpexAbstractTextEditor.this._firstAction;
            LpexAbstractTextEditor.this._firstAction = this;
        }

        LpexEditorAction next() {
            return this._next;
        }

        public void update() {
            LpexView lpexView = ((LpexAbstractTextEditor)this.getTextEditor()).getLpexView();
            this.update(lpexView);
        }

        private void update(LpexView lpexView) {
            this.setEnabled(lpexView != null && lpexView.actionAvailable(this._actionId));
        }

        public void run() {
            LpexView lpexView = ((LpexAbstractTextEditor)this.getTextEditor()).getLpexView();
            if (lpexView != null) {
                if (this._actionId == 7) {
                    IBindingService service = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
                    TriggerSequence[] seq = service.getActiveBindingsFor("org.eclipse.ui.edit.selectAll");
                    int i = 0;
                    while (i < seq.length) {
                        Trigger[] triggers = seq[i].getTriggers();
                        int j = 0;
                        while (j < triggers.length) {
                            String action;
                            char key;
                            int modifiers;
                            String keyBinding;
                            if (triggers[j] instanceof KeyStroke && (keyBinding = this.getLpexKeyBinding(modifiers = ((KeyStroke)triggers[j]).getModifierKeys(), key = (char)((KeyStroke)triggers[j]).getNaturalKey())).length() > 0 && (action = lpexView.query("keyAction." + keyBinding)) != null && action.length() > 0) {
                                lpexView.triggerAction(lpexView.actionId(action), true);
                                return;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (lpexView.query("updateProfile.baseProfile").equalsIgnoreCase("eclipse")) {
                        lpexView.triggerAction(216, true);
                    } else {
                        lpexView.triggerAction(this._actionId, true);
                    }
                    return;
                }
                lpexView.triggerAction(this._actionId, true);
            }
        }

        private String getLpexKeyBinding(int modifiers, char key) {
            IKeyLookup lookup = KeyLookupFactory.getDefault();
            StringBuilder lpexKey = new StringBuilder();
            if ((modifiers & lookup.getCtrl()) > 0) {
                lpexKey.append('c');
            }
            if ((modifiers & lookup.getAlt()) > 0) {
                lpexKey.append('c');
            }
            if ((modifiers & lookup.getShift()) > 0) {
                lpexKey.append('s');
            }
            lpexKey.append(key);
            int l = lpexKey.length() - 1;
            while (l > 0) {
                lpexKey.insert(l, '-');
                l -= 2;
            }
            return lpexKey.toString().toLowerCase();
        }
    }

    private class LpexFindReplaceAction
    extends LpexEditorAction {
        public LpexFindReplaceAction(ResourceBundle bundle, String key, LpexAbstractTextEditor editor) {
            super(bundle, key, editor, -1);
        }

        @Override
        public void update() {
            this.setEnabled(LpexAbstractTextEditor.actionAvailableFind((LpexAbstractTextEditor)this.getTextEditor()));
        }

        @Override
        public void run() {
            LpexAbstractTextEditor.runActionFind((LpexAbstractTextEditor)this.getTextEditor());
        }
    }

    private static class LpexPopupAction
    extends TextEditorAction {
        private int _actionId = -1;

        public LpexPopupAction(LpexAbstractTextEditor editor, int actionId, String menuItemText, String description) {
            super(LpexPlugin.getResourceBundle(), "", (ITextEditor)editor);
            this._actionId = actionId;
            this.setText(menuItemText);
            this.showAccelerator();
            this.setToolTipText(description);
            this.setDescription(description);
        }

        private void showAccelerator() {
            LpexAbstractTextEditor editor = (LpexAbstractTextEditor)this.getTextEditor();
            this.setActionDefinitionId(editor.getActionAccelerator(this._actionId));
            this.firePropertyChange("text", "", this.getText());
        }

        public void update() {
            LpexView lpexView = ((LpexAbstractTextEditor)this.getTextEditor()).getLpexView();
            this.update(lpexView);
        }

        private void update(LpexView lpexView) {
            if (lpexView != null) {
                this.setEnabled(lpexView.actionAvailable(this._actionId));
                this.setChecked(lpexView.actionChecked(this._actionId));
            } else {
                this.setEnabled(false);
                this.setChecked(false);
            }
        }

        public void run() {
            LpexView lpexView = ((LpexAbstractTextEditor)this.getTextEditor()).getLpexView();
            if (lpexView != null) {
                lpexView.triggerAction(this._actionId);
            }
        }
    }

    private static class LpexTextNavigationAction
    extends TextNavigationAction {
        private LpexAbstractTextEditor _editor;
        private int _lpexActionId;

        public LpexTextNavigationAction(LpexAbstractTextEditor editor, int action) {
            super(null, action);
            this._editor = editor;
            this._lpexActionId = action;
        }

        public void run() {
            LpexView lpexView = this._editor.getLpexView();
            if (lpexView != null) {
                lpexView.triggerAction(this._lpexActionId, true);
                if (this._editor._traceCommands) {
                    lpexView.doDefaultCommand("set messageText * command IdMapEntry => LPEX action " + this._lpexActionId);
                    lpexView.doDefaultCommand("screenShow view");
                }
            }
        }
    }

    private static class PositionLabelValue {
        public int fValue;

        private PositionLabelValue() {
        }

        public String toString() {
            return this.fValue <= 0 ? "" : String.valueOf(this.fValue);
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            LpexAbstractTextEditor.this.handlePreferenceStoreChanged(event);
        }
    }

    class ShowRulerContextMenuAction
    extends Action {
        ShowRulerContextMenuAction() {
        }

        public void run() {
            if (LpexAbstractTextEditor.this.fSourceViewer == null) {
                return;
            }
            LpexWindow text = LpexAbstractTextEditor.this.fSourceViewer.getFirstLpexWindow();
            if (text == null || text.isDisposed()) {
                return;
            }
            Point location = new Point(0, LpexAbstractTextEditor.this.getYAtPrimaryWindowCursor());
            if (LpexAbstractTextEditor.this.fVerticalRuler instanceof IVerticalRulerExtension) {
                ((IVerticalRulerExtension)LpexAbstractTextEditor.this.fVerticalRuler).setLocationOfLastMouseButtonActivity(location.x, location.y);
            }
            location = text.toDisplay(location);
            LpexAbstractTextEditor.this.fRulerContextMenu.setLocation(location.x, location.y);
            LpexAbstractTextEditor.this.fRulerContextMenu.setVisible(true);
        }
    }

    protected static class TextEditorSavable
    extends Saveable {
        private ITextEditor fTextEditor;
        private IEditorInput fEditorInput;
        private IDocument fDocument;

        public TextEditorSavable(ITextEditor textEditor) {
            Assert.isLegal((textEditor != null ? 1 : 0) != 0);
            this.fTextEditor = textEditor;
            this.fEditorInput = this.fTextEditor.getEditorInput();
            Assert.isLegal((this.fEditorInput != null ? 1 : 0) != 0);
        }

        public void disconnectEditor() {
            this.getAdapter(IDocument.class);
            this.fTextEditor = null;
        }

        public String getName() {
            String title;
            if (this.fTextEditor != null && (title = this.fTextEditor.getTitle()) != null && title.length() > 0) {
                return title;
            }
            return this.fEditorInput.getName();
        }

        public String getToolTipText() {
            return this.fEditorInput.getToolTipText();
        }

        public ImageDescriptor getImageDescriptor() {
            return this.fEditorInput.getImageDescriptor();
        }

        public void doSave(IProgressMonitor monitor) throws CoreException {
            this.fTextEditor.doSave(monitor);
        }

        public boolean isDirty() {
            return this.fTextEditor.isDirty();
        }

        public boolean supportsBackgroundSave() {
            return false;
        }

        public int hashCode() {
            Object document = this.getAdapter(IDocument.class);
            return document == null ? 0 : document.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Saveable)) {
                return false;
            }
            Object thisDocument = this.getAdapter(IDocument.class);
            Object otherDocument = ((Saveable)obj).getAdapter(IDocument.class);
            if (thisDocument == null && otherDocument == null) {
                return true;
            }
            return thisDocument != null && thisDocument.equals(otherDocument);
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IDocument.class) {
                IDocumentProvider documentProvider;
                if (this.fDocument == null && (documentProvider = this.fTextEditor.getDocumentProvider()) != null) {
                    this.fDocument = documentProvider.getDocument((Object)this.fEditorInput);
                }
                return this.fDocument;
            }
            return super.getAdapter(adapter);
        }
    }

    private static class TextInputListener
    implements ITextInputListener {
        public boolean inputChanged;

        private TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            this.inputChanged = true;
        }
    }
}

