/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.alef;

import com.ibm.lpex.alef.LpexStatusTextEditor;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.TextEditorAction;

class DefaultEncodingSupport
implements IEncodingSupport {
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceChangeListener;
    private LpexStatusTextEditor fTextEditor;

    public void initialize(LpexStatusTextEditor textEditor) {
        this.fTextEditor = textEditor;
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        this.fPreferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if ("encoding".equals(event.getKey())) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            DefaultEncodingSupport.this.setEncoding(null, false);
                        }
                    };
                    if (Display.getCurrent() != null) {
                        runnable.run();
                    } else {
                        Shell shell = DefaultEncodingSupport.this.fTextEditor != null ? DefaultEncodingSupport.this.fTextEditor.getSite().getShell() : DefaultEncodingSupport.getActiveWorkbenchShell();
                        Display display = shell != null ? shell.getDisplay() : Display.getDefault();
                        display.asyncExec(runnable);
                    }
                }
            }
        };
        prefs.addPreferenceChangeListener(this.fPreferenceChangeListener);
    }

    public void dispose() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        prefs.removePreferenceChangeListener(this.fPreferenceChangeListener);
        this.fTextEditor = null;
    }

    public void reset() {
    }

    protected void setEncoding(String encoding, boolean overwrite) {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IEditorInput input = this.fTextEditor.getEditorInput();
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            String current = provider.getEncoding((Object)input);
            if (!this.fTextEditor.isDirty()) {
                boolean apply;
                String internal = encoding == null ? "" : encoding;
                boolean bl = apply = (overwrite || current == null) && !internal.equals(current);
                if (apply) {
                    provider.setEncoding((Object)input, encoding);
                    Runnable encodingSetter = new Runnable(){

                        @Override
                        public void run() {
                            DefaultEncodingSupport.this.fTextEditor.doRevertToSaved();
                        }
                    };
                    Display display = this.fTextEditor.getSite().getShell().getDisplay();
                    if (display != null && !display.isDisposed()) {
                        BusyIndicator.showWhile((Display)display, (Runnable)encodingSetter);
                    } else {
                        encodingSetter.run();
                    }
                }
            }
        }
    }

    public void setEncoding(String encoding) {
        this.setEncoding(encoding, true);
    }

    public String getEncoding() {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            return provider.getEncoding((Object)this.fTextEditor.getEditorInput());
        }
        return null;
    }

    public String getDefaultEncoding() {
        IDocumentProvider p = this.fTextEditor.getDocumentProvider();
        if (p instanceof IStorageDocumentProvider) {
            IStorageDocumentProvider provider = (IStorageDocumentProvider)p;
            return provider.getDefaultEncoding();
        }
        return null;
    }

    public String getStatusHeader(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException) {
            return TextEditorMessages.getString("Editor_error_unreadable_encoding_header");
        }
        if (t instanceof UnsupportedEncodingException) {
            return TextEditorMessages.getString("Editor_error_unsupported_encoding_header");
        }
        return null;
    }

    public String getStatusBanner(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException) {
            return TextEditorMessages.getString("Editor_error_unreadable_encoding_banner");
        }
        if (t instanceof UnsupportedEncodingException) {
            return TextEditorMessages.getString("Editor_error_unsupported_encoding_banner");
        }
        return null;
    }

    public String getStatusMessage(IStatus status) {
        Throwable t = status.getException();
        if (t instanceof CharConversionException || t instanceof UnsupportedEncodingException) {
            String encoding = this.getEncoding();
            if (encoding == null) {
                encoding = this.getDefaultEncoding();
            }
            if (t instanceof CharConversionException) {
                if (encoding != null) {
                    return MessageFormat.format(TextEditorMessages.getString("Editor_error_unreadable_encoding_message_arg"), encoding);
                }
                return TextEditorMessages.getString("Editor_error_unreadable_encoding_message");
            }
            if (t instanceof UnsupportedEncodingException) {
                if (encoding != null) {
                    return TextEditorMessages.getFormattedString("Editor_error_unsupported_encoding_message_arg", encoding);
                }
                return TextEditorMessages.getString("Editor_error_unsupported_encoding_message");
            }
        }
        return null;
    }

    public boolean isEncodingError(IStatus status) {
        if (status == null || status.getSeverity() != 4) {
            return false;
        }
        Throwable t = status.getException();
        return t instanceof CharConversionException || t instanceof UnsupportedEncodingException;
    }

    public void createStatusEncodingChangeControl(Composite parent, IStatus status) {
        final IAction action = this.fTextEditor.getAction("ChangeEncoding");
        if (action instanceof TextEditorAction) {
            ((TextEditorAction)action).update();
        }
        if (action == null || !action.isEnabled()) {
            return;
        }
        Shell shell = parent.getShell();
        Display display = shell.getDisplay();
        Color bgColor = display.getSystemColor(25);
        Button button = new Button(parent, 0x800008);
        button.setText(action.getText());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
            }
        });
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData(1808));
        filler.setBackground(bgColor);
    }

    private static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    private static final class TextEditorMessages {
        private static ResourceBundle _bundle;

        private TextEditorMessages() {
        }

        public static String getString(String key) {
            try {
                if (TextEditorMessages.getResourceBundle() != null) {
                    return _bundle.getString(key);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return "!" + key + "!";
        }

        public static String getFormattedString(String key, Object arg) {
            String format = null;
            try {
                if (TextEditorMessages.getResourceBundle() != null) {
                    format = _bundle.getString(key);
                }
            }
            catch (MissingResourceException e) {
                return "!" + key + "!";
            }
            if (arg == null) {
                arg = "";
            }
            if (format == null) {
                return key;
            }
            return MessageFormat.format(format, arg);
        }

        public static ResourceBundle getResourceBundle() {
            if (_bundle == null) {
                _bundle = ResourceBundle.getBundle("org.eclipse.ui.editors.text.TextEditorMessages");
            }
            return _bundle;
        }
    }
}

