/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.idz.system.util;

import com.ibm.ftt.common.logging.LogUtil;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class PLICommentFinder {
    private IDocument document;
    private boolean debug = false;
    private int marginR = 72;

    public PLICommentFinder(IDocument document, int marginR) {
        this.document = document;
        this.marginR = marginR - 1;
    }

    public String getComments(int codeStartLine) {
        String comments = "";
        if (this.document != null) {
            try {
                int commentStartLine = 1;
                int commentEndLine = 1;
                boolean foundBottomOfComment = false;
                int i = codeStartLine;
                while (i >= 1) {
                    int length;
                    int offset = this.document.getLineOffset(i - 1);
                    String line = this.document.get(offset, length = this.document.getLineOffset(i - 1) + this.document.getLineLength(i - 1) - offset);
                    if (line.length() > this.marginR) {
                        line = line.substring(0, this.marginR);
                    }
                    if (line.trim().endsWith("*/")) {
                        if (!foundBottomOfComment) {
                            commentEndLine = i;
                            foundBottomOfComment = true;
                        }
                        while (!line.trim().startsWith("/*")) {
                            offset = this.document.getLineOffset(--i - 1);
                            length = this.document.getLineOffset(i - 1) + this.document.getLineLength(i - 1) - offset;
                            line = this.document.get(offset, length);
                        }
                        commentStartLine = i;
                    } else if (line.trim().length() > 0) {
                        if (!this.debug) break;
                        System.out.println(line);
                        break;
                    }
                    --i;
                }
                if (foundBottomOfComment) {
                    int offset = this.document.getLineOffset(commentStartLine - 1);
                    int length = this.document.getLineOffset(commentEndLine - 1) + this.document.getLineLength(commentEndLine - 1) - offset;
                    comments = this.document.get(offset, length);
                    if (this.debug) {
                        System.out.println(comments);
                    }
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
                LogUtil.log((int)4, (String)"Caught exception during PLICommentFinder::getComments()", (int)0, (String)"com.ibm.idz.system.util", (Throwable)e);
            }
        }
        return comments;
    }
}

