/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.codecoverage.internal;

import com.ibm.cdz.remote.debug.UniversalPDTLaunchBaseDelegate;
import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.CCData;
import com.ibm.debug.pdt.codecoverage.internal.core.CCDebugTarget;
import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.utilities.CCCoreUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.utilities.CCStartupKeyGenerator;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CCUIData;
import com.ibm.debug.pdt.core.IPDTDebugTarget;
import com.ibm.debug.pdt.profile.internal.model.DebugProfile;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.ICCInfoProvider;
import com.ibm.ftt.debug.ui.codecoverage.internal.CodeCoverageCompositeForDebugProfile;
import com.ibm.ftt.debug.ui.codecoverage.internal.CodeCoveragePage;
import com.ibm.ftt.debug.ui.codecoverage.internal.CodeCoverageTab;
import com.ibm.ftt.debug.ui.tabs.DebugOptionsTab;
import com.ibm.ftt.debug.ui.tabs.IPropertyGroupProvider;
import com.ibm.ftt.ui.properties.formpages.core.FormPageContent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.osgi.framework.Bundle;

public class IDzLauchCodeCoverageInfoProvider
implements ICCInfoProvider,
ApplicationLaunchConstants {
    private static final String PLUGIN_ID = "com.ibm.ftt.debug.ui.codecoverage";
    private static ILog fLog = Platform.getLog((Bundle)Platform.getBundle((String)"com.ibm.ftt.debug.ui.codecoverage"));
    private static final String EMPTY = "";

    public static final void log(Throwable e) {
        fLog.log((IStatus)new Status(4, PLUGIN_ID, e.getMessage(), e));
    }

    public Object getCCProperties(ILaunchConfiguration configuration) {
        CCParams result = new CCParams();
        try {
            CCCoreUtilities.processStartupkey((String)configuration.getAttribute("com.ibm.ftt.debug.codecoveragekey", EMPTY), (CCParams)result);
        }
        catch (CoreException e) {
            IDzLauchCodeCoverageInfoProvider.log(e);
        }
        return result;
    }

    public IPDTDebugTarget getTarget(ILaunch launch, Object ccProperties, int key) {
        CCParams parms = ccProperties instanceof CCParams ? (CCParams)ccProperties : new CCParams();
        return new CCDebugTarget(null, launch, (CCData)new CCUIData(parms), key);
    }

    public FormPageContent getCodeCoveragePage() {
        return new CodeCoveragePage();
    }

    public ILaunchConfigurationTab getCodeCoverageLaunchTab() {
        return new CodeCoverageTab();
    }

    public ILaunchConfigurationTab getCodeCoverageLaunchTab(boolean showOverride, IPropertyGroupProvider propertyGroupProvider, DebugOptionsTab debugOptions) {
        return new CodeCoverageTab(showOverride, propertyGroupProvider, debugOptions);
    }

    public Object getCCProperties(String ccStartupKey, ILaunchConfiguration config) throws CoreException {
        CCParams result = new CCParams();
        String ccOptions = ccStartupKey != null ? ccStartupKey : this.generateCCStartupKey(config);
        boolean forceSource = config.getAttribute("forcesource", false);
        if (forceSource) {
            boolean isDTCompat;
            String connectionString = config.getAttribute("com.ibm.ftt.debug.connection", EMPTY);
            boolean bl = isDTCompat = connectionString.isEmpty() || connectionString.contains("TCPIP") || connectionString.contains("DBMDT");
            if (isDTCompat) {
                CCCoreUtilities.processStartupkey((String)("CC,,view=SOURCE_ONLY," + ccOptions), (CCParams)result);
            } else {
                CCCoreUtilities.processStartupkey((String)("CC,,view=SOURCE_LISTING," + ccOptions), (CCParams)result);
            }
        } else {
            CCCoreUtilities.processStartupkey((String)("CC,," + ccOptions), (CCParams)result);
        }
        return result;
    }

    private String generateCCStartupKey(ILaunchConfiguration config) throws CoreException {
        CCStartupKeyGenerator generator = new CCStartupKeyGenerator();
        String level = config.getAttribute("CODE_COVERAGE_LEVEL", ICCConstants.COVERAGE_LEVEL.LINE.toString());
        if (level.equals(ICCConstants.COVERAGE_LEVEL.MODULE.toString())) {
            generator.setCCLevel(ICCConstants.COVERAGE_LEVEL.MODULE);
        }
        if (level.equals(ICCConstants.COVERAGE_LEVEL.FUNCTION.toString())) {
            generator.setCCLevel(ICCConstants.COVERAGE_LEVEL.FUNCTION);
        } else {
            generator.setCCLevel(ICCConstants.COVERAGE_LEVEL.LINE);
        }
        generator.setGenHtml(config.getAttribute("ccGenerateHtml", false));
        generator.setGenPDF(config.getAttribute("ccGeneratePDF", false));
        generator.setRoot(config.getAttribute("root", EMPTY));
        generator.setIgnoreError(config.getAttribute("ignoreerrors", false));
        if (config.getAttribute("ccFilterList", false)) {
            generator.setFilter(config.getAttribute("ccFilterListPathV2", EMPTY));
        }
        generator.setTestId(config.getAttribute("testid", EMPTY));
        generator.setTestTags(config.getAttribute("tag", EMPTY));
        boolean forceSource = config.getAttribute("forcesource", false);
        if (forceSource) {
            String connectionString = config.getAttribute("com.ibm.ftt.debug.connection", EMPTY);
            boolean isDTCompat = connectionString.isEmpty() || connectionString.contains("TCPIP") || connectionString.contains("DBMDT");
            generator.setViewPreference(isDTCompat ? ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY : ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING);
        }
        return generator.generateStartupKey();
    }

    public String getCoverageLevel() {
        return "CODE_COVERAGE_LEVEL";
    }

    public String getCoverageMode() {
        return "compiled_coverage";
    }

    public DebugProfile.CodeCoverageOptions getCodeCoverageOptions(ILaunchConfiguration candidate) throws CoreException {
        DebugProfile.CodeCoverageOptions result = null;
        if (candidate.hasAttribute("ccGeneratePDF") || candidate.hasAttribute("ignoreerrors") || candidate.hasAttribute("ccFilterList") && candidate.getAttribute("ccFilterList", false) || candidate.hasAttribute("testid") || candidate.hasAttribute("tag")) {
            boolean isGeneratePDFReport = candidate.getAttribute("ccGeneratePDF", false);
            boolean isIgnoreErrors = candidate.getAttribute("ignoreerrors", false);
            String fileFilter = CodeCoverageCompositeForDebugProfile.retrieveFilterListPath(candidate);
            String testID = candidate.getAttribute("testid", EMPTY);
            String tags = candidate.getAttribute("tag", EMPTY);
            result = new DebugProfile.CodeCoverageOptions(isGeneratePDFReport, isIgnoreErrors, fileFilter, testID, tags);
        }
        return result;
    }

    public void updateCCOptions(IPDTDebugTarget debugTarget, ILaunchConfiguration configuration, boolean useDebugTool) {
        if (debugTarget instanceof CCDebugTarget) {
            CCData data = ((CCDebugTarget)debugTarget).getCCData();
            try {
                boolean forceSource = configuration.getAttribute("forcesource", false);
                if (forceSource) {
                    boolean isDTCompat = UniversalPDTLaunchBaseDelegate.isUseDebugTool((ILaunchConfiguration)configuration);
                    ICCCoreConstants.DESIRED_COVERAGE_VIEW source = isDTCompat ? ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY : ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING;
                    data.setDesiredCoverageView(source);
                }
            }
            catch (CoreException e) {
                IDzLauchCodeCoverageInfoProvider.log(e);
            }
        }
    }
}

