/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.codecoverage.internal;

import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageCompositeListener;
import com.ibm.ftt.common.logging.LogUtil;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.Activator;
import com.ibm.ftt.debug.ui.DebugMessages;
import com.ibm.ftt.debug.ui.Messages;
import com.ibm.ftt.debug.ui.codecoverage.internal.CodeCoverageCompositeForDebugProfile;
import com.ibm.ftt.debug.ui.composites.IProfileProvider;
import com.ibm.ftt.debug.ui.tabs.AbstractPropertyGroupMessageTab;
import com.ibm.ftt.debug.ui.tabs.DebugOptionsTab;
import com.ibm.ftt.debug.ui.tabs.IPropertyGroupProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CodeCoverageTab
extends AbstractPropertyGroupMessageTab
implements ApplicationLaunchConstants,
CodeCoverageCompositeListener {
    protected CodeCoverageCompositeForDebugProfile fCodeCoverageComposite;
    Button fEnableCodeCoverage;
    private boolean fShowOverride;
    private IProfileProvider fProfileProvider = null;
    private boolean fProfileSelection = false;
    private boolean fSupportsProfiles = false;
    private DebugOptionsTab fDebugOptions;

    public CodeCoverageTab() {
        this(false, null, null);
    }

    public CodeCoverageTab(boolean showOverride, IPropertyGroupProvider provider, DebugOptionsTab debugOptions) {
        super(provider, DebugMessages.CRRDG8018);
        this.fShowOverride = showOverride;
        if (provider instanceof IProfileProvider) {
            this.fProfileProvider = (IProfileProvider)provider;
            this.fSupportsProfiles = true;
        }
        this.fDebugOptions = debugOptions;
    }

    protected void doCreateControl(Composite parent) {
        this.setDirty(false);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)parent);
        if (this.fShowOverride) {
            this.fEnableCodeCoverage = new Button(parent, 32);
            this.fEnableCodeCoverage.addSelectionListener((SelectionListener)this);
            this.fEnableCodeCoverage.setText(Messages.CodeCoverageTab_1);
        }
        this.fCodeCoverageComposite = new CodeCoverageCompositeForDebugProfile(parent, 0, this, false);
        if (this.fProfileProvider != null) {
            this.fProfileProvider.addProfileListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    CodeCoverageTab.this.fProfileSelection = ((Button)event.widget).getSelection();
                    CodeCoverageTab.this.updateFields();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }
            });
        }
        GridDataFactory.fillDefaults().grab(true, false).indent(this.fShowOverride ? 15 : 0, -1).applyTo((Control)this.fCodeCoverageComposite);
    }

    public String getName() {
        return Messages.CodeCoverageTab_0;
    }

    protected void doInitializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean isCodeCoverage = configuration.getAttribute("com.ibm.ftt.debug.codecoverage", false);
            if (this.fShowOverride) {
                this.fEnableCodeCoverage.setSelection(isCodeCoverage);
            }
            this.fCodeCoverageComposite.initialize(configuration);
            this.updateFields();
        }
        catch (CoreException e) {
            LogUtil.log((int)4, (String)e.getMessage(), (String)"com.ibm.debug.pdt.idz.launches.common", (Throwable)e);
        }
    }

    private void updateFields() {
        this.fCodeCoverageComposite.enableCodeCoverage(this.fShowOverride && this.fEnableCodeCoverage.getSelection() || !this.fShowOverride && (!this.fSupportsProfiles || !this.fProfileSelection));
        this.doValidation();
    }

    private void doValidation() {
        this.setDirty(true);
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        if (!this.fShowOverride || this.fEnableCodeCoverage.getSelection()) {
            this.fCodeCoverageComposite.validateFields();
            this.setErrorMessage(this.fCodeCoverageComposite.getErrorMessage());
            this.setWarningMessage(this.fCodeCoverageComposite.getWarningMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fShowOverride) {
            configuration.setAttribute("com.ibm.ftt.debug.codecoverage", this.fEnableCodeCoverage.getSelection());
        }
        if (!this.fShowOverride || this.fEnableCodeCoverage.getSelection()) {
            ICCCoreConstants.DESIRED_COVERAGE_VIEW sourceOption = this.fDebugOptions == null || this.fDebugOptions.isDTCompatMode() ? ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY : ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING;
            configuration.setAttribute("com.ibm.ftt.debug.codecoveragekey", this.fCodeCoverageComposite.generateCCKey(sourceOption));
        }
        this.fCodeCoverageComposite.applyToConfiguration(configuration);
    }

    public boolean canSave() {
        if (this.fShowOverride && this.fEnableCodeCoverage.getSelection()) {
            return this.fCodeCoverageComposite.canSave();
        }
        return this.getErrorMessage() == null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getWarningMessage() == null && this.getErrorMessage() == null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        this.widgetSelected(event);
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.fShowOverride && this.fEnableCodeCoverage == event.getSource()) {
            this.updateFields();
        }
        this.fCodeCoverageComposite.setModuleList(false);
        this.doValidation();
        this.updateLaunchConfigurationDialog();
    }

    public void modifyText(ModifyEvent event) {
        this.fCodeCoverageComposite.setModuleList(false);
        this.doValidation();
        this.updateLaunchConfigurationDialog();
    }

    public Image getImage() {
        return Activator.getDefault().getImageRegistry().get("icons/coverage.png");
    }
}

