/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.codecoverage.internal;

import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageComposite;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageCompositeListener;
import com.ibm.ftt.debug.ui.DebugLaunchUtils;
import com.ibm.ftt.debug.ui.codecoverage.internal.CodeCoverageCompositeForDebugProfile;
import com.ibm.ftt.ui.properties.formpages.core.FormPageContent;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CodeCoveragePage
extends FormPageContent {
    public static final String COPY_RIGHT = "  Licensed Materials - Property of IBM, 5724-T07, Copyright IBM Corporation 2015. All Rights Reserved.  US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private CodeCoverageComposite fCCComposite;
    private boolean fInitializing;
    private ICCCoreConstants.DESIRED_COVERAGE_VIEW fSourceView = ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY;

    public void createContent(Composite parent) {
        GridLayoutFactory.fillDefaults().applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        this.fCCComposite = new CodeCoverageCompositeForDebugProfile(parent, 0, new CCCompositeListener(), false, this.hasModuleListOption());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fCCComposite);
        this.initializeValues();
    }

    private boolean hasModuleListOption() {
        String coverageOptions = this.instanceHelper.getValue("CODE_COVERAGE_OPTIONS");
        return coverageOptions != null && coverageOptions.contains("moduleexcludelist");
    }

    protected void initializeValues() {
        this.fInitializing = true;
        String coverageOptions = this.instanceHelper.getValue("CODE_COVERAGE_OPTIONS");
        boolean isIntegratedDebugger = this.instanceHelper.getBooleanValue("DEBUG_USE_INTEGRATED_DEBUGGER");
        this.fSourceView = isIntegratedDebugger ? ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_LISTING : ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY;
        ((CodeCoverageCompositeForDebugProfile)this.fCCComposite).setSourceViewOption(this.fSourceView);
        if (coverageOptions != null) {
            ((CodeCoverageCompositeForDebugProfile)this.fCCComposite).initializeFromStartupKey(coverageOptions, this.fSourceView);
        }
        if (!DebugLaunchUtils.isStandaloneDebug()) {
            DebugLaunchUtils.isCodeCoverageLicense((boolean)false);
        }
        this.fInitializing = false;
    }

    protected void handleFieldsUpdated() {
        if (!this.fInitializing) {
            this.instanceHelper.setValue("CODE_COVERAGE_OPTIONS", this.fCCComposite.getStartupKey());
        }
        this.messageHelper.clearMessages(this.fCCComposite.getWarningControl());
        if (this.fCCComposite.getWarningMessage() != null) {
            this.messageHelper.displayWarningMessage(this.fCCComposite.getWarningMessage(), this.fCCComposite.getWarningControl());
        }
    }

    class CCCompositeListener
    implements CodeCoverageCompositeListener {
        CCCompositeListener() {
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            CodeCoveragePage.this.handleFieldsUpdated();
        }

        public void widgetSelected(SelectionEvent arg0) {
            CodeCoveragePage.this.handleFieldsUpdated();
        }

        public void modifyText(ModifyEvent arg0) {
            CodeCoveragePage.this.handleFieldsUpdated();
        }
    }
}

