/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.debug.ui.codecoverage.internal;

import com.ibm.debug.pdt.codecoverage.core.results.ICCConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.CCParams;
import com.ibm.debug.pdt.codecoverage.internal.core.ICCCoreConstants;
import com.ibm.debug.pdt.codecoverage.internal.core.Messages;
import com.ibm.debug.pdt.codecoverage.internal.core.utilities.CCCoreUtilities;
import com.ibm.debug.pdt.codecoverage.internal.core.utilities.CCStartupKeyGenerator;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageComposite;
import com.ibm.debug.pdt.codecoverage.ui.internal.launch.CodeCoverageCompositeListener;
import com.ibm.ftt.debug.launcher.ApplicationLaunchConstants;
import com.ibm.ftt.debug.ui.Labels;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CodeCoverageCompositeForDebugProfile
extends CodeCoverageComposite
implements ApplicationLaunchConstants {
    public static final String USE_PREVIOUS_RESULT = "UsePreviousResult";
    public static final String USE_SPECIFIC_RESULT = "UseLastPreviousResult";
    public static final String RUN_FULL_COVERAGE = "RunFullCoverage";
    public static final String RESULT_FILE_NAME_ATTR = "ResultFileName";
    public static final String PARAM_IGNORE_ERRORS = "ignoreerrors";
    public static final String GENERATE_HTML = "ccGenerateHtml";
    public static final String GENERATE_PDF = "ccGeneratePDF";
    public static final String PARAM_TEST_CASE = "testid";
    public static final String MODULE_LIST_ENABLED = "ccModuleList";
    public static final String MODULE_LIST_PATH = "ccModuleListPath";
    public static final String FILTER_LIST_ENABLED = "ccFilterList";
    public static final String FILTER_LIST_PATH = "ccFilterListPath";
    public static final String FILTER_LIST_PATH_V2 = "ccFilterListPathV2";
    public static final String PARAM_TAG = "tag";
    public static final String PARAM_FORCE_SOURCE = "forcesource";
    public static final String CODE_COVERAGE_LEVEL_ATTR = "CODE_COVERAGE_LEVEL";
    public static final String CODE_COVERAGE_LEVEL_MODULE = "CODE_COVERAGE_LEVEL_MODULE";
    public static final String CODE_COVERAGE_LEVEL_FUNCTION = "CODE_COVERAGE_LEVEL_FUNCTION";
    public static final String CODE_COVERAGE_LEVEL_LINE = "CODE_COVERAGE_LEVEL_LINE";
    private Button fUseSource;
    private ICCCoreConstants.DESIRED_COVERAGE_VIEW fSourceView = ICCCoreConstants.DESIRED_COVERAGE_VIEW.SOURCE_ONLY;
    private boolean fIsModuleList = false;

    public CodeCoverageCompositeForDebugProfile(Composite parent, int style, CodeCoverageCompositeListener listener) {
        super(parent, style, listener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.ibm.ftt.debug.ui.codeCoverage");
    }

    public CodeCoverageCompositeForDebugProfile(Composite parent, int style, CodeCoverageCompositeListener listener, boolean overrideHiddenOptions) {
        super(parent, style, listener, overrideHiddenOptions);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.ibm.ftt.debug.ui.codeCoverage");
    }

    public CodeCoverageCompositeForDebugProfile(Composite parent, int style, CodeCoverageCompositeListener listener, boolean editFilter, boolean isNewPropertyGroup) {
        super(parent, style, listener, editFilter, isNewPropertyGroup);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.ibm.ftt.debug.ui.codeCoverage_property_group");
    }

    public void applyToConfiguration(ILaunchConfigurationWorkingCopy configuration) {
        if (configuration != null) {
            configuration.setAttribute(PARAM_IGNORE_ERRORS, this.fIgnoreErrors.getSelection());
            configuration.setAttribute(GENERATE_PDF, this.fGenPDF.getSelection());
            configuration.setAttribute(PARAM_TEST_CASE, this.fTestCaseText.getText().trim());
            configuration.setAttribute(PARAM_TAG, this.fTagText.getText().trim());
            configuration.setAttribute("root", this.fRootText == null ? "" : this.fRootText.getText().trim());
            configuration.setAttribute(CODE_COVERAGE_LEVEL_ATTR, this.getCodeCoverageLevel().toString());
            configuration.removeAttribute(FILTER_LIST_PATH);
            configuration.setAttribute(FILTER_LIST_PATH_V2, this.fFilterListField.getText());
            configuration.setAttribute(FILTER_LIST_ENABLED, this.fFilterListCheckBox.getSelection());
            configuration.setAttribute(PARAM_FORCE_SOURCE, this.fUseSource.getSelection());
        }
    }

    public void initialize(ILaunchConfiguration configuration) throws CoreException {
        String value;
        this.fIgnoreErrors.setSelection(configuration.getAttribute(PARAM_IGNORE_ERRORS, false));
        this.fGenPDF.setSelection(configuration.getAttribute(GENERATE_PDF, false));
        this.fTestCaseText.setText(configuration.getAttribute(PARAM_TEST_CASE, ""));
        this.fTagText.setText(configuration.getAttribute(PARAM_TAG, ""));
        this.initializeLevel(configuration.getAttribute(CODE_COVERAGE_LEVEL_ATTR, ICCConstants.COVERAGE_LEVEL.LINE.toString()));
        this.fFilterListField.setText(CodeCoverageCompositeForDebugProfile.retrieveFilterListPath(configuration));
        this.fFilterListCheckBox.setSelection(configuration.getAttribute(FILTER_LIST_ENABLED, false));
        this.fUseSource.setSelection(configuration.getAttribute(PARAM_FORCE_SOURCE, false));
        if (configuration.hasAttribute("com.ibm.ftt.debug.codecoveragekey") && (value = configuration.getAttribute("com.ibm.ftt.debug.codecoveragekey", "")).contains("moduleexcludelist")) {
            this.setWarningMessage(Messages.CRRDG7152);
            this.setModuleList(true);
        }
        if (this.fRootText != null) {
            this.fRootText.setText(configuration.getAttribute("root", ""));
        }
    }

    public static String retrieveFilterListPath(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.hasAttribute(FILTER_LIST_PATH) && !configuration.getAttribute(FILTER_LIST_PATH, "").isEmpty()) {
            return configuration.getAttribute(FILTER_LIST_PATH, "");
        }
        if (configuration.hasAttribute(FILTER_LIST_PATH_V2)) {
            return configuration.getAttribute(FILTER_LIST_PATH_V2, "");
        }
        return "";
    }

    public void setModuleList(boolean isModuleList) {
        this.fIsModuleList = isModuleList;
    }

    public String generateCCKey(ICCCoreConstants.DESIRED_COVERAGE_VIEW sourceviewOption) {
        CCStartupKeyGenerator generator = new CCStartupKeyGenerator(this.fIsModuleList);
        if (this.fFunctionFilterButton.getSelection()) {
            generator.setCCLevel(ICCConstants.COVERAGE_LEVEL.FUNCTION);
        } else {
            generator.setCCLevel(ICCConstants.COVERAGE_LEVEL.LINE);
        }
        generator.setGenPDF(this.fGenPDF.getSelection());
        if (this.fRootText != null) {
            generator.setRoot(this.fRootText.getText());
        }
        generator.setIgnoreError(this.fIgnoreErrors.getSelection());
        generator.setFilter(this.fFilterListCheckBox.getSelection() ? this.fFilterListField.getText() : null);
        generator.setTestId(this.fTestCaseText.getText());
        generator.setTestTags(this.fTagText.getText());
        if (this.fUseSource.getSelection()) {
            generator.setViewPreference(sourceviewOption);
        }
        return generator.generateStartupKey();
    }

    public void enableCodeCoverage(boolean enabled) {
        this.fIgnoreErrors.setEnabled(enabled);
        this.fGenPDF.setEnabled(enabled);
        this.fTestCaseText.setEnabled(enabled);
        this.fTestLabel.setEnabled(enabled);
        this.fTagText.setEnabled(enabled);
        this.fTagLabel.setEnabled(enabled);
        this.fFunctionFilterButton.setEnabled(enabled);
        this.fLineFilterButton.setEnabled(enabled);
        this.fFilterListField.setEnabled(enabled);
        this.fFilterListCheckBox.setEnabled(enabled);
        this.fUseSource.setEnabled(enabled);
        if (enabled) {
            this.enableFields();
            this.validateFields();
        }
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    protected void createAdditionalOptions(Composite codeCoverageLaunchPageComposite) {
        super.createAdditionalOptions(codeCoverageLaunchPageComposite);
        this.fUseSource = new Button((Composite)this.fAdditionalGroup, 32);
        this.fUseSource.setText(Labels.USE_SOURCE_COBOL);
        this.fUseSource.setToolTipText(Labels.USE_SOURCE_COBOL_TOOLTIP);
        this.fUseSource.moveAbove((Control)this.fIgnoreErrors);
        this.fUseSource.addSelectionListener((SelectionListener)this);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)this.fUseSource);
    }

    protected void updateGenerator(Widget widget) {
        if (widget == this.fUseSource) {
            if (this.fUseSource.getSelection()) {
                this.fGenerator.setViewPreference(this.fSourceView);
            } else {
                this.fGenerator.setViewPreference(ICCCoreConstants.DESIRED_COVERAGE_VIEW.DEFAULT);
            }
        } else {
            super.updateGenerator(widget);
        }
    }

    public void setSourceViewOption(ICCCoreConstants.DESIRED_COVERAGE_VIEW sourceView) {
        this.fSourceView = sourceView;
    }

    public void initializeFromStartupKey(String startupKey, ICCCoreConstants.DESIRED_COVERAGE_VIEW dView) {
        super.initializeFromStartupKey(startupKey);
        startupKey = CCStartupKeyGenerator.stripStartupKeyPrefix((String)startupKey);
        CCParams properties = new CCParams();
        CCCoreUtilities.processStartupkey((String)startupKey, (CCParams)properties);
        ICCCoreConstants.DESIRED_COVERAGE_VIEW view = properties.getDesiredView();
        this.fUseSource.setSelection(view == dView);
    }
}

