/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.ui;

import com.ibm.debug.xmlui.api.IXUIElement;
import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.api.XUIModel;
import com.ibm.debug.xmlui.internal.parser.XUICheckedButton;
import com.ibm.debug.xmlui.internal.parser.XUICombo;
import com.ibm.debug.xmlui.internal.parser.XUIRadioButton;
import com.ibm.debug.xmlui.internal.parser.XUIRadioGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class XUIReconciler {
    private XUIModel fElementRoot;
    private HashMap<Control, IXUIElement> fWidgetToElements = new HashMap();
    private HashMap<IXUIElement, Control> fElementToWidgets = new HashMap();

    public XUIReconciler(XUIModel root) {
        this.fElementRoot = root;
    }

    public void registerElement(IXUIElement element, Control widget) {
        this.fWidgetToElements.put(widget, element);
        this.fElementToWidgets.put(element, widget);
    }

    public Control getWidgetFromElement(IXUIElement element) {
        return this.fElementToWidgets.get(element);
    }

    public IXUIElement getElementFromWidget(Control widget) {
        return this.fWidgetToElements.get(widget);
    }

    public void dispose() {
        this.fWidgetToElements.clear();
        this.fElementToWidgets.clear();
    }

    public void updateSelection() {
        for (Map.Entry<Control, IXUIElement> entry : this.fWidgetToElements.entrySet()) {
            if (!(entry.getKey() instanceof Button)) continue;
            IXUIElement element = entry.getValue();
            element.setSelected(((Button)entry.getKey()).getSelection());
        }
    }

    public void initializeDefaults() {
        this.initializeDefaults(this.fElementRoot);
    }

    private void initializeDefaults(IXUIElement element) {
        this.setWidgetDefaultValue(element);
        ArrayList<IXUIElement> children = element.getChildElements();
        int i = 0;
        while (i < children.size()) {
            IXUIElement child = children.get(i);
            this.initializeDefaults(child);
            ++i;
        }
    }

    private void setWidgetDefaultValue(IXUIElement element) {
        Control widget = this.fElementToWidgets.get(element);
        if (element instanceof XUIRadioButton && widget instanceof Button) {
            XUIRadioButton radioElement = (XUIRadioButton)element;
            ((Button)widget).setSelection(radioElement.isDefault());
            radioElement.setSelected(radioElement.isDefault());
        } else if (element instanceof XUICheckedButton && widget instanceof Button) {
            ((Button)widget).setSelection(false);
            element.setSelected(false);
        }
        Object data = element.getData();
        if (data instanceof Text) {
            ((Text)data).setText("");
        }
    }

    public void reconcileAttributes(XUIAttributeList attributes) {
        int i = 0;
        while (i < attributes.size()) {
            XUIAttribute attr = attributes.getAttribute(i);
            this.reconcileAttribute(attr);
            ++i;
        }
    }

    public void reconcileAttribute(XUIAttribute attr) {
        String name = attr.getName();
        String value = attr.getValue();
        IXUIElement element = this.fElementRoot.findElementById(name);
        if (element != null) {
            if (element.getData() != null) {
                this.selectElementWidget(element, true);
                this.reconcileValueText(element, value);
            } else {
                this.selectElementWidget(element, Boolean.parseBoolean(value));
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(name, ".");
            IXUIElement parent = this.fElementRoot;
            String token = null;
            while (tokenizer.hasMoreTokens() && parent != null) {
                token = tokenizer.nextToken();
                IXUIElement nextElement = this.reconcileAttributeToken(parent, token);
                parent = nextElement;
            }
            if (parent != null && value != null) {
                this.reconcileValueText(parent, value);
            }
        }
    }

    private void selectElementWidget(IXUIElement element, boolean isSelected) {
        Control widget = this.fElementToWidgets.get(element);
        if (widget instanceof Button) {
            ((Button)widget).setSelection(isSelected);
        }
    }

    private boolean reconcileValueText(IXUIElement element, String value) {
        Object data = element.getData();
        if (element instanceof XUICombo) {
            int index;
            XUICombo comboElement = (XUICombo)element;
            Combo combo = (Combo)this.getWidgetFromElement(element);
            if (combo != null && (index = combo.indexOf(value)) >= 0) {
                combo.select(index);
                comboElement.selectItem(index);
                return true;
            }
        } else if (data instanceof Text) {
            ((Text)data).setText(value);
            return true;
        }
        return false;
    }

    private IXUIElement reconcileAttributeToken(IXUIElement parent, String token) {
        IXUIElement matchingElement = this.findMatchingChildElement(parent, token);
        if (matchingElement != null) {
            this.selectButton(matchingElement);
            return matchingElement;
        }
        return null;
    }

    private void selectButton(IXUIElement element) {
        if (element.getType() == 2) {
            Control widget = this.fElementToWidgets.get(element);
            if (widget instanceof Button) {
                ((Button)widget).setSelection(true);
            }
        } else if (element.getType() == 3) {
            this.selectRadioButton(element);
        }
    }

    private void selectRadioButton(IXUIElement element) {
        IXUIElement parent = element.getParent();
        ArrayList<IXUIElement> siblings = parent.getChildElements();
        int i = 0;
        while (i < siblings.size()) {
            IXUIElement sibling = siblings.get(i);
            Control widget = this.fElementToWidgets.get(sibling);
            if (widget instanceof Button) {
                if (sibling == element) {
                    ((Button)widget).setSelection(true);
                } else {
                    ((Button)widget).setSelection(false);
                }
            }
            ++i;
        }
    }

    private IXUIElement findMatchingChildElement(IXUIElement parent, String elementId) {
        ArrayList<IXUIElement> children = parent.getChildElements();
        children = this.expandRadioGroups(children);
        int i = 0;
        while (i < children.size()) {
            IXUIElement child = children.get(i);
            String id = child.getId();
            if (id == null) {
                id = child.getNameKey();
            }
            if (id == null) {
                id = child.getName();
            }
            if (this.postfixID(id).equals(elementId)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    private ArrayList<IXUIElement> expandRadioGroups(ArrayList<IXUIElement> children) {
        ArrayList<IXUIElement> newList = new ArrayList<IXUIElement>();
        int i = 0;
        while (i < children.size()) {
            IXUIElement child = children.get(i);
            if (child.getType() == 4) {
                XUIRadioGroup radioGroup = (XUIRadioGroup)child;
                ArrayList<IXUIElement> radioElements = radioGroup.getChildElements();
                newList.addAll(radioElements);
            } else {
                newList.add(child);
            }
            ++i;
        }
        return newList;
    }

    private String postfixID(String id) {
        if (id.endsWith(":")) {
            id = id.substring(0, id.length() - 1);
        }
        if (id.indexOf(32) > 0) {
            id = id.replace(' ', '_');
        }
        return id;
    }

    public void setEnabledAllControls(boolean enabled) {
        for (Control widget : this.fElementToWidgets.values()) {
            IXUIElement element = this.fWidgetToElements.get(widget);
            if (widget instanceof Button) {
                Object data;
                ((Button)widget).setEnabled(enabled);
                if (element == null || !((data = element.getData()) instanceof Text)) continue;
                ((Text)data).setEnabled(enabled);
                continue;
            }
            if (widget instanceof Combo) {
                ((Combo)widget).setEnabled(enabled);
                continue;
            }
            if (!(widget instanceof Label)) continue;
            ((Label)widget).setEnabled(enabled);
        }
    }
}

