/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.internal.parser;

import com.ibm.debug.xmlui.api.XUIAttribute;
import com.ibm.debug.xmlui.api.XUIAttributeList;
import com.ibm.debug.xmlui.api.XUIParseException;
import com.ibm.debug.xmlui.internal.parser.XUIAbstractParser;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XUIAttributesParser
extends XUIAbstractParser {
    public XUIAttributeList parse(InputStream stream) throws XUIParseException {
        Document dom = this.getDocument(stream);
        Element rootElement = dom.getDocumentElement();
        if (!this.nodeNameEquals(rootElement, "attributes")) {
            throw new XUIParseException("Invalid attribute list file: The root element must be a <attributes> node.");
        }
        XUIAttributeList attributes = new XUIAttributeList();
        NodeList childNodes = rootElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            short nodeType = node.getNodeType();
            if (nodeType == 1 && this.nodeNameEquals(node, "attribute")) {
                XUIAttribute attr = this.createAttribute((Element)node);
                attributes.addAttribute(attr);
            }
            ++i;
        }
        return attributes;
    }

    private XUIAttribute createAttribute(Element node) {
        String name = node.getAttribute("name");
        String value = node.getAttribute("value");
        XUIAttribute attribute = new XUIAttribute(name, value);
        return attribute;
    }
}

