/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.xmlui.api;

import com.ibm.debug.xmlui.api.XUIAttribute;
import java.util.ArrayList;
import java.util.Iterator;

public class XUIAttributeList {
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private ArrayList<XUIAttribute> fAttributes = new ArrayList();

    public void addAttribute(XUIAttribute attr) {
        this.fAttributes.add(attr);
    }

    public void addAttributeList(XUIAttributeList attrList) {
        int i = 0;
        while (i < attrList.size()) {
            this.fAttributes.add(attrList.getAttribute(i));
            ++i;
        }
    }

    public int size() {
        return this.fAttributes.size();
    }

    public XUIAttribute getAttribute(int index) {
        if (index >= 0 && index < this.size()) {
            return this.fAttributes.get(index);
        }
        return null;
    }

    public Iterator<XUIAttribute> iterator() {
        return this.fAttributes.iterator();
    }

    public boolean containsAttribute(String attributeName) {
        Iterator<XUIAttribute> it = this.iterator();
        while (it.hasNext()) {
            XUIAttribute attr = it.next();
            if (!attr.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public String getAttributeValue(String attributeName) {
        Iterator<XUIAttribute> it = this.iterator();
        while (it.hasNext()) {
            XUIAttribute attr = it.next();
            if (!attr.getName().equals(attributeName)) continue;
            return attr.getValue();
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(XML_HEADER);
        sb.append('<');
        sb.append("attributes");
        sb.append(">\n");
        int i = 0;
        while (i < this.size()) {
            XUIAttribute attr = this.getAttribute(i);
            String attrString = attr.toString();
            sb.append(attrString);
            sb.append('\n');
            ++i;
        }
        sb.append("</");
        sb.append("attributes");
        sb.append('>');
        return sb.toString();
    }
}

