/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.launchconfig;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.daemon.IDaemonDebugTarget2;
import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.OldEngineParameters;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.core.launch.PICLLoadInfo;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import com.ibm.debug.pdt.ui.launchconfig.IConfigurationConstants;
import java.io.File;
import java.net.Socket;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;

public class PICLLoadLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate,
IConfigurationConstants {
    private PICLLoadInfo createLoadInfo(ILaunchConfiguration config) {
        PICLLoadInfo loadInfo = new PICLLoadInfo();
        try {
            loadInfo.setLaunchConfig(config);
            loadInfo.setProgramName(config.getAttribute("ProgramName", ""));
            loadInfo.setProgramParms(config.getAttribute("Parameters", ""));
            loadInfo.setProject(this.getProjectResource(config.getAttribute("Project", "")));
            if (config.getAttribute("DebugInitialization", false)) {
                loadInfo.setStartupBehaviour(0);
            } else {
                loadInfo.setStartupBehaviour(1);
            }
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        return loadInfo;
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IProject getProjectResource(String projectName) {
        IProject[] projects = this.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getName().equals(projectName)) {
                return projects[i];
            }
            ++i;
        }
        return null;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString(this, "Got to the PICL Load launch config delegate");
        }
        if (!config.getType().supportsMode(mode) || !config.exists()) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(this, "Unsupported request made - fatal error", 4);
            }
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(this, "Mode: " + mode);
            }
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(this, "Configuration exists: " + config.exists());
            }
            StatusInfo status = new StatusInfo();
            status.setError(PICLMessages.picl_thread_error_not_supported);
            throw new CoreException((IStatus)status);
        }
        if (mode.equals("run")) {
            String fullyQualifiedProgramName = config.getAttribute("ProgramName", "");
            String parameters = config.getAttribute("Parameters", "");
            Process p = null;
            Path fullPathName = new Path(fullyQualifiedProgramName);
            String programName = fullPathName.lastSegment();
            File workingDir = new File(fullPathName.removeLastSegments(1).toOSString());
            try {
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                String[] envArray = null;
                if (launchManager != null) {
                    envArray = launchManager.getEnvironment(config);
                }
                p = workingDir.isDirectory() && workingDir.exists() ? Runtime.getRuntime().exec("cmd /C start " + programName + " " + parameters, envArray, workingDir) : Runtime.getRuntime().exec("cmd /C start " + fullyQualifiedProgramName + " " + parameters, envArray);
            }
            catch (Exception e) {
                PICLUtils.logError(e);
                return;
            }
            if (p != null) {
                launch.addProcess(DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)fullyQualifiedProgramName));
            }
            return;
        }
        if (config.getAttribute("Daemon", false)) {
            int key = config.getAttribute("Key", -99999);
            if (key == -99999) {
                return;
            }
            CoreDaemon.OldDaemonInput input = CoreDaemon.retrieveOldDaemonInput((int)key);
            if (input == null) {
                return;
            }
            OldEngineParameters engineParameters = new OldEngineParameters();
            engineParameters.setInfo(input.getInputArray(), input.getSocket().getSocket());
            PICLLoadInfo loadInfo = new PICLLoadInfo((EngineParameters)engineParameters);
            loadInfo.setLaunchConfig(config);
            if (engineParameters.getConnection() != null) {
                loadInfo.setEngineConnection(engineParameters.getConnection());
                loadInfo.setEngineWaiting(true);
            } else {
                loadInfo.setEngineWaiting(false);
            }
            loadInfo.setStartupBehaviour(engineParameters.getLoadStartupBehaviour());
            PICLDebugTarget target = new PICLDebugTarget(launch, (PICLAbstractStartupInfo)loadInfo, loadInfo.getEngineConnection());
            launch.addDebugTarget((IDebugTarget)target);
            Socket socket = loadInfo.getEngineConnection();
            ((IDaemonDebugTarget2)target).engineIsWaiting(socket, socket.getPort() == 0);
        } else {
            if (!CoreDaemon.startListening()) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString(this, "Debug Daemon failed to start!", 4);
                }
                PICLDebugPlugin.showMessageDialog(null, PICLMessages.PICLLoadLaunchConfigTab1_daemonFailedToStartError, false);
                return;
            }
            PICLLoadInfo loadInfo = this.createLoadInfo(config);
            PICLDebugTarget target = new PICLDebugTarget(launch, (PICLAbstractStartupInfo)loadInfo, loadInfo.getEngineConnection());
            int key = CoreDaemon.generateKey();
            CoreDaemon.storeDebugTarget((IDebugTarget)target, (int)key);
            launch.addDebugTarget((IDebugTarget)target);
            boolean rc = target.launchEngine(key);
            if (!rc) {
                launch.removeDebugTarget((IDebugTarget)target);
                PICLDebugPlugin.showMessageDialog(null, 1, PICLLabels.picl_debug_target_label_engine_message_title, PICLMessages.PICLLoadLaunchConfigTab1_daemonFailedToStartError, false);
            }
        }
    }
}

