/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui.launchconfig;

import com.ibm.debug.daemon.CoreDaemon;
import com.ibm.debug.pdt.internal.core.EngineParameters;
import com.ibm.debug.pdt.internal.core.OldEngineParameters;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.launch.PICLAbstractStartupInfo;
import com.ibm.debug.pdt.internal.core.launch.PICLAttachInfo;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.ProcessSelectionDialog;
import com.ibm.debug.pdt.internal.ui.util.StatusInfo;
import com.ibm.debug.pdt.ui.launchconfig.IConfigurationConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class PICLAttachLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate,
IConfigurationConstants {
    private PICLAttachInfo createAttachInfo(ILaunchConfiguration config) {
        PICLAttachInfo attachInfo = new PICLAttachInfo();
        attachInfo.setLaunchConfig(config);
        attachInfo.setProject(this.getProjectResource(config.getAttribute("Project", "")));
        String processIDText = config.getAttribute("PID", null);
        if (processIDText == null || processIDText.equals("")) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            class ProcessSelectionRunnable
            implements Runnable {
                public String selectedPID = null;
                private final /* synthetic */ Display val$display;

                ProcessSelectionRunnable(Display display) {
                    this.val$display = display;
                }

                @Override
                public void run() {
                    ProcessSelectionDialog dialog = new ProcessSelectionDialog(this.val$display.getActiveShell());
                    if (dialog.open() == 0) {
                        this.selectedPID = dialog.getSelectedProcess();
                    }
                }
            }
            ProcessSelectionRunnable runnable = new ProcessSelectionRunnable(display);
            display.syncExec((Runnable)runnable);
            processIDText = runnable.selectedPID;
        }
        try {
            Integer.parseInt(processIDText);
        }
        catch (NumberFormatException e) {
            return null;
        }
        try {
            attachInfo.setProcessID(processIDText);
            attachInfo.setProcessPath(config.getAttribute("ProcessPath", ""));
        }
        catch (CoreException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        attachInfo.setStartupBehaviour(-1);
        return attachInfo;
    }

    public IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IProject getProjectResource(String projectName) {
        IProject[] projects = this.getWorkspaceRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getName().equals(projectName)) {
                return projects[i];
            }
            ++i;
        }
        return null;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString(this, "Got to the PICL attach launch configuration delegate");
        }
        if (!config.getType().supportsMode(mode) || !config.exists()) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(this, "Unsupported request made - fatal error", 4);
            }
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(this, "Mode: " + mode);
            }
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(this, "Configuration exists: " + config.exists());
            }
            StatusInfo status = new StatusInfo();
            status.setError(PICLMessages.picl_thread_error_not_supported);
            throw new CoreException((IStatus)status);
        }
        if (config.getAttribute("Daemon", false)) {
            int key = config.getAttribute("Key", -99999);
            if (key == -99999) {
                return;
            }
            CoreDaemon.OldDaemonInput input = CoreDaemon.retrieveOldDaemonInput((int)key);
            if (input == null) {
                return;
            }
            OldEngineParameters engineParameters = new OldEngineParameters();
            engineParameters.setInfo(input.getInputArray(), input.getSocket().getSocket());
            PICLAttachInfo attachInfo = null;
            attachInfo = new PICLAttachInfo((EngineParameters)engineParameters);
            attachInfo.setLaunchConfig(config);
            if (engineParameters.getConnection() != null) {
                attachInfo.setEngineConnection(engineParameters.getConnection());
                attachInfo.setEngineWaiting(true);
            } else {
                attachInfo.setEngineWaiting(false);
            }
            PICLDebugTarget target = new PICLDebugTarget(launch, (PICLAbstractStartupInfo)attachInfo, attachInfo.getEngineConnection());
            launch.addDebugTarget((IDebugTarget)target);
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(this, "calling debug target.engineIsWaiting()");
            }
            target.engineIsWaiting(attachInfo.getEngineConnection());
        } else {
            if (!CoreDaemon.startListening()) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString(this, "Debug Daemon failed to start!", 4);
                }
                PICLDebugPlugin.showMessageDialog(null, PICLMessages.PICLLoadLaunchConfigTab1_daemonFailedToStartError, false);
                return;
            }
            PICLAttachInfo attachInfo = this.createAttachInfo(config);
            if (attachInfo == null) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString(this, "Attach info is null - error occurred. Check process ID.", 4);
                }
                PICLDebugPlugin.showMessageDialog(null, 1, PICLLabels.Attach_errorTitle, PICLMessages.PICLAttachLaunchConfigTab1_badPIDError, false);
                launch.terminate();
                return;
            }
            try {
                ILaunchConfigurationWorkingCopy configCopy = config.getWorkingCopy();
                configCopy.setAttribute("PID", null);
                configCopy.doSave();
            }
            catch (CoreException configCopy) {
                // empty catch block
            }
            PICLDebugTarget target = new PICLDebugTarget(launch, (PICLAbstractStartupInfo)attachInfo, attachInfo.getEngineConnection());
            int key = CoreDaemon.generateKey();
            CoreDaemon.storeDebugTarget((IDebugTarget)target, (int)key);
            launch.addDebugTarget((IDebugTarget)target);
            boolean rc = target.launchEngine(key);
            if (!rc) {
                launch.removeDebugTarget((IDebugTarget)target);
                PICLDebugPlugin.showMessageDialog(null, 1, PICLLabels.picl_debug_target_label_engine_message_title, PICLMessages.picl_debug_target_error_engineNotLaunched, false);
            }
        }
    }
}

