/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui;

import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class DebuggerMarkerAnnotation
extends MarkerAnnotation
implements IAnnotationPresentation {
    private IDebugModelPresentation fPresentation = null;

    public DebuggerMarkerAnnotation(IMarker marker, String name) {
        super(marker);
    }

    public int getLayer() {
        try {
            IBreakpoint iBP = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(this.getMarker());
            if (iBP instanceof PICLBreakpoint && !((PICLBreakpoint)iBP).isEnabled()) {
                return 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 2;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        if (this.fPresentation == null) {
            this.fPresentation = DebugUITools.newDebugModelPresentation();
        }
        try {
            Image image = this.fPresentation.getImage((Object)this.getMarker());
            ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DebuggerMarkerAnnotation) {
            return super.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.getMarker().hashCode();
    }
}

