/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.ui;

import com.ibm.debug.pdt.core.breakpoints.PICLBreakpoint;
import com.ibm.debug.pdt.core.breakpoints.PICLWatchBreakpoint;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.Part;
import com.ibm.debug.pdt.internal.core.model.StackFrame;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.sourcelocator.PDTLookupResult;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.properties.BreakpointPropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.DebuggeeThreadPropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.ExprNodeBasePropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.FunctionPropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.ModulePropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.PartPropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.ProcessPropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.StackFramePropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.ViewFilePropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.properties.WatchpointPropertySourceAdapter;
import com.ibm.debug.pdt.internal.ui.sourcelocator.DebuggeeThreadSourceDisplayAdapter;
import com.ibm.debug.pdt.internal.ui.sourcelocator.PDTLookupResultAdapter;
import com.ibm.debug.pdt.internal.ui.views.PDTVariableLabelProvider;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementEditor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;

public class AdapterFactory
implements IAdapterFactory {
    private Class<?>[] ADAPTER_LIST = new Class[]{IPropertySource.class, IElementEditor.class, IElementLabelProvider.class, IWorkbenchAdapter.class, ISourceDisplay.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType == IPropertySource.class) {
            if (adaptableObject instanceof StackFrame) {
                return new StackFramePropertySourceAdapter((StackFrame)adaptableObject);
            }
            if (adaptableObject instanceof DebuggeeThread) {
                return new DebuggeeThreadPropertySourceAdapter((DebuggeeThread)adaptableObject);
            }
            if (adaptableObject instanceof PICLDebugTarget) {
                IProcess process = ((PDTDebugTarget)adaptableObject).getProcess();
                return new ProcessPropertySourceAdapter((DebuggeeProcess)process);
            }
            if (adaptableObject instanceof DebuggeeProcess) {
                return new ProcessPropertySourceAdapter((DebuggeeProcess)adaptableObject);
            }
            if (adaptableObject instanceof PICLModule) {
                return new ModulePropertySourceAdapter((PICLModule)adaptableObject);
            }
            if (adaptableObject instanceof Part) {
                return new PartPropertySourceAdapter((Part)adaptableObject);
            }
            if (adaptableObject instanceof ExprNodeBase) {
                return new ExprNodeBasePropertySourceAdapter((ExprNodeBase)adaptableObject);
            }
            if (adaptableObject instanceof PICLWatchBreakpoint) {
                return new WatchpointPropertySourceAdapter((PICLWatchBreakpoint)adaptableObject);
            }
            if (adaptableObject instanceof PICLBreakpoint) {
                return new BreakpointPropertySourceAdapter((PICLBreakpoint)adaptableObject);
            }
            if (adaptableObject instanceof Function) {
                return new FunctionPropertySourceAdapter((Function)adaptableObject);
            }
            if (adaptableObject instanceof ViewFile) {
                return new ViewFilePropertySourceAdapter((ViewFile)adaptableObject);
            }
        } else {
            if (adapterType == IElementEditor.class) {
                return PICLDebugPlugin.getEditWidgetFactory().getColumnEditorFactoryAdapter();
            }
            if (adapterType == IElementLabelProvider.class) {
                return new PDTVariableLabelProvider();
            }
            if (adapterType == IWorkbenchAdapter.class) {
                if (adaptableObject instanceof PDTLookupResult) {
                    return new PDTLookupResultAdapter((PDTLookupResult)adaptableObject);
                }
            } else if (adapterType == ISourceDisplay.class && adaptableObject instanceof DebuggeeThread) {
                return DebuggeeThreadSourceDisplayAdapter.getInstance();
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return this.ADAPTER_LIST;
    }
}

