/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.core.IValueDetail;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegister;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;

public class PDTVariableLabelProvider
extends VariableLabelProvider
implements IDebugModelPresentation,
IColorProvider {
    private static final Color CHANGED_COLOR = DebugUITools.getPreferenceColor((String)"org.eclipse.debug.ui.changedDebugElement");
    private boolean fShowTypes = false;

    public void setAttribute(String attribute, Object value) {
        if (attribute.equals("org.eclipse.debug.ui.displayVariableTypeNames")) {
            this.fShowTypes = (Boolean)value;
        }
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        String varValue = null;
        try {
            varValue = value instanceof IValueDetail ? ((IValueDetail)value).getDetailsValue() : value.getValueString();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        listener.detailComputed(value, varValue);
    }

    public IEditorInput getEditorInput(Object element) {
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IVariable) {
            try {
                if (((IVariable)element).hasValueChanged()) {
                    return CHANGED_COLOR;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IRegister) {
            try {
                if (((IRegister)element).hasValueChanged()) {
                    return PICLUtils.getImage("PICL_ICON_REGISTER_CHANGED");
                }
                return PICLUtils.getImage("PICL_ICON_REGISTER");
            }
            catch (DebugException e) {
                return PICLUtils.getImage("PICL_ICON_REGISTER");
            }
        }
        if (element instanceof IVariable) {
            if (element instanceof ExprNodeBase) {
                ExprNodeBase node = (ExprNodeBase)element;
                if (!node.getExpression().isEnabled()) {
                    return PICLUtils.getImage("PICL_ICON_VARIABLE_DISABLED");
                }
                if (node.isChanged()) {
                    return PICLUtils.getImage("PICL_ICON_VARIABLE_CHANGED");
                }
            }
            return PICLUtils.getImage("PICL_ICON_VARIABLE");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IVariable) {
            try {
                boolean hasValueString;
                IVariable var = (IVariable)element;
                IValue val = var.getValue();
                String typeName = val.getReferenceTypeName();
                if (val.hasVariables() && !PreferenceUI.isDisplayValues()) {
                    hasValueString = false;
                } else {
                    boolean bl = hasValueString = val.getValueString().length() != 0;
                }
                if (hasValueString) {
                    String valueString = val.getValueString();
                    if (this.fShowTypes && typeName.length() != 0) {
                        return NLS.bind((String)PICLLabels.picl_variable_label_type_name_value, (Object[])new String[]{typeName, var.getName(), valueString});
                    }
                    return NLS.bind((String)PICLLabels.picl_variable_label_name_value, (Object[])new String[]{var.getName(), valueString});
                }
                if (this.fShowTypes && typeName.length() != 0) {
                    return NLS.bind((String)PICLLabels.picl_variable_label_type_name, (Object[])new String[]{typeName, var.getName()});
                }
                if (var.getName().length() == 0) {
                    return PICLLabels.picl_value_error_no_value_available;
                }
                return var.getName();
            }
            catch (DebugException e) {
                return PICLLabels.debug_element_unknown;
            }
        }
        return element.toString();
    }

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        String valueString = value.getValueString();
        return valueString;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

