/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.core.PDTDebugUtils;
import com.ibm.debug.pdt.internal.core.IDebugLocationProvider;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLModule;
import com.ibm.debug.pdt.internal.core.PICLModuleParent;
import com.ibm.debug.pdt.internal.core.model.Function;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.PDTModelPresentation;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.AddProgramAction;
import com.ibm.debug.pdt.internal.ui.actions.CopyTreeViewToClipboardAction;
import com.ibm.debug.pdt.internal.ui.actions.ModulesFilterAction;
import com.ibm.debug.pdt.internal.ui.actions.PrintTreeViewAction;
import com.ibm.debug.pdt.internal.ui.actions.RemoveProgramAction;
import com.ibm.debug.pdt.internal.ui.actions.SetFunctionBreakpointAction;
import com.ibm.debug.pdt.internal.ui.actions.SetModuleSideFileLocationAction;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import com.ibm.debug.pdt.internal.ui.views.ModulesContentProvider;
import com.ibm.debug.pdt.internal.ui.views.ModulesFilterDebuggable;
import java.text.Collator;
import java.util.Comparator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ModulesView
extends AbstractDebugView
implements IDoubleClickListener,
IDebugContextListener {
    TreeViewer fTreeViewer = null;
    private PDTDebugTarget fCurrentDebugTarget = null;
    protected static final String MODULES_NOT_AVAILABLE = PICLLabels.ModulesView_modules_not_available;
    private ModulesFilterAction fModulesFilterAction;
    private CopyTreeViewToClipboardAction fCopyTreeViewToClipboardAction;
    private PrintTreeViewAction fPrintTreeViewAction;
    private SetFunctionBreakpointAction fSetFunctionBreakpointAction;
    private AddProgramAction fAddProgramAction = null;
    private boolean fAddProgramAdded = false;
    private RemoveProgramAction fRemoveProgramAction = null;
    private SetModuleSideFileLocationAction fSetModuleSideFileLocationAction = null;
    private IToolBarManager ftbm = null;
    private PDTModelPresentation fModelPresentation = null;
    boolean showMsg = true;
    private Composite fControl;

    protected Viewer createViewer(Composite parent) {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".createViewer()");
        }
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        this.fTreeViewer = new TreeViewer(parent, 4);
        this.fTreeViewer.setContentProvider((IContentProvider)new ModulesContentProvider(this));
        this.fModelPresentation = new PDTModelPresentation();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new ModuleLabelProvider(this.fModelPresentation));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fTreeViewer);
        this.setTitleToolTip(PICLLabels.ModulesView_tooltip);
        this.fTreeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        this.fTreeViewer.setComparator(new ViewerComparator((Comparator)Collator.getInstance()));
        this.fTreeViewer.addFilter((ViewerFilter)new ModulesFilterDebuggable());
        return this.fTreeViewer;
    }

    protected void createActions() {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".createActions()");
        }
        this.fModulesFilterAction = new ModulesFilterAction(this.fTreeViewer);
        this.fModulesFilterAction.setEnabled(false);
        this.fSetFunctionBreakpointAction = new SetFunctionBreakpointAction(this.fTreeViewer);
        this.fRemoveProgramAction = new RemoveProgramAction(this.fTreeViewer);
        this.fSetModuleSideFileLocationAction = new SetModuleSideFileLocationAction(this.fTreeViewer);
        this.fCopyTreeViewToClipboardAction = new CopyTreeViewToClipboardAction((StructuredViewer)this.fTreeViewer);
        this.fCopyTreeViewToClipboardAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_COPY_VIEW_TO_CLIPBOARD"));
        this.fCopyTreeViewToClipboardAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_COPY_VIEW_TO_CLIPBOARD"));
        this.fCopyTreeViewToClipboardAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_COPY_VIEW_TO_CLIPBOARD"));
        this.fPrintTreeViewAction = new PrintTreeViewAction((StructuredViewer)this.fTreeViewer, PICLLabels.ModulesView_printjobtitle);
        this.fPrintTreeViewAction.setHoverImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_CLCL_PRINT_VIEW"));
        this.fPrintTreeViewAction.setDisabledImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_DLCL_PRINT_VIEW"));
        this.fPrintTreeViewAction.setImageDescriptor(PICLUtils.getImageDescriptor("PICL_ICON_ELCL_PRINT_VIEW"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".configureToolBar()");
        }
        this.ftbm = tbm;
        tbm.add((IAction)this.fModulesFilterAction);
        Separator invisibleSeparator = new Separator(((Object)((Object)this)).getClass().getName());
        invisibleSeparator.setVisible(false);
        tbm.add((IContributionItem)invisibleSeparator);
        tbm.add((IContributionItem)new Separator(((Object)((Object)this)).getClass().getName() + ".additions"));
        tbm.add((IAction)this.fCopyTreeViewToClipboardAction);
        tbm.add((IAction)this.fPrintTreeViewAction);
        this.setInitialContent();
    }

    protected String getHelpContextId() {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".getHelpContextId()");
        }
        return PICLUtils.getHelpResourceString("modules_view");
    }

    protected void fillContextMenu(IMenuManager mm) {
        StructuredSelection sel;
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".fillContextMenu()");
        }
        if ((sel = (StructuredSelection)this.fTreeViewer.getSelection()) != StructuredSelection.EMPTY && sel.size() == 1) {
            if (sel.getFirstElement() instanceof Function && this.fCurrentDebugTarget.supportsBrkptType("com.ibm.debug.pdt.core.PICLEntryBreakpoint")) {
                this.fSetFunctionBreakpointAction.updateHelp();
                mm.add((IAction)this.fSetFunctionBreakpointAction);
            }
            if (sel.getFirstElement() instanceof PICLModule) {
                if (this.fCurrentDebugTarget.supportsModuleRemove()) {
                    mm.add((IAction)this.fRemoveProgramAction);
                }
                if (this.fCurrentDebugTarget.supportsModuleSideFileUpdate()) {
                    mm.add((IAction)this.fSetModuleSideFileLocationAction);
                }
            }
        }
        mm.add((IContributionItem)new GroupMarker("additions"));
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
        if (structuredSelection.size() != 1) {
            return;
        }
        Object selection = structuredSelection.getFirstElement();
        if (!(selection instanceof ViewFile) && !(selection instanceof Function)) {
            if (this.fTreeViewer.getExpandedState(selection)) {
                this.fTreeViewer.collapseToLevel(selection, 1);
            } else {
                this.fTreeViewer.expandToLevel(selection, 1);
            }
            return;
        }
        if (selection instanceof IDebugLocationProvider) {
            IWorkbenchPage page = this.getViewSite().getPage();
            int lineNumber = 0;
            if (selection instanceof Function) {
                lineNumber = ((Function)selection).getLineNumber();
            }
            PICLUtils.resetEditor(selection, page, lineNumber);
        }
    }

    protected void setInitialContent() {
        IAdaptable selectedItem = DebugUITools.getDebugContext();
        if (selectedItem != null) {
            this.processSelection((ISelection)new StructuredSelection((Object)selectedItem));
        }
    }

    public void createPartControl(Composite parent) {
        this.fControl = parent;
        super.createPartControl(parent);
    }

    public void setFocus() {
        if (this.showMsg) {
            this.getMessagePage().getControl().setFocus();
        } else {
            super.setFocus();
        }
    }

    protected void initActionState(IAction action) {
        if (action instanceof ModulesFilterAction) {
            this.fModulesFilterAction.setChecked(PreferenceUI.isDebugInfoFilter());
            this.fModulesFilterAction.run();
        } else {
            super.initActionState(action);
        }
    }

    public void dispose() {
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        super.dispose();
        PreferenceUI.setDebugInfoFilter(this.fModulesFilterAction.isChecked());
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.processSelection(event.getContext());
    }

    private void processSelection(ISelection selection) {
        PDTDebugTarget newDebugTarget = PICLDebugPlugin.getPDTDebugTarget(selection);
        if (this.fCurrentDebugTarget == newDebugTarget) {
            return;
        }
        PICLModuleParent currentModuleParent = null;
        if (this.fCurrentDebugTarget != null) {
            currentModuleParent = this.fCurrentDebugTarget.getModuleParent();
            this.fCurrentDebugTarget = null;
            if (currentModuleParent != null) {
                currentModuleParent.saveExpandedElements(this.fTreeViewer.getExpandedElements());
            }
        }
        this.fModulesFilterAction.setEnabled(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fControl, PICLUtils.getHelpResourceString("modules_view"));
        if (this.fTreeViewer == null || this.fTreeViewer.getContentProvider() == null) {
            this.showMessage(MODULES_NOT_AVAILABLE);
            this.showMsg = true;
            return;
        }
        if (newDebugTarget == null || newDebugTarget.isTerminated() || !newDebugTarget.supportsModules()) {
            this.fTreeViewer.setInput(null);
            this.showMessage(MODULES_NOT_AVAILABLE);
            this.showMsg = true;
        } else {
            this.showMsg = false;
            this.showViewer();
            this.fCurrentDebugTarget = newDebugTarget;
            this.fModulesFilterAction.setEnabled(true);
            if (newDebugTarget.supportsModuleAdd() && !this.fAddProgramAdded) {
                if (this.fAddProgramAction == null) {
                    this.fAddProgramAction = new AddProgramAction(newDebugTarget);
                }
                this.ftbm.insertBefore(this.fModulesFilterAction.getId(), (IAction)this.fAddProgramAction);
                this.ftbm.update(false);
                this.fAddProgramAdded = true;
            } else if (!newDebugTarget.supportsModuleAdd() && this.fAddProgramAdded) {
                this.ftbm.remove(this.fAddProgramAction.getId());
                this.ftbm.update(false);
                this.fAddProgramAdded = false;
            }
            if (PDTDebugUtils.isiSeriesEngine((IDebugTarget)newDebugTarget)) {
                this.setPartName(PICLLabels.ModulesView_printjobtitle_400);
                this.setTitleToolTip(PICLLabels.ModulesView_tooltip_400);
                this.fModulesFilterAction.setToolTipText(PICLLabels.ModulesFilterAction_tooltip_400);
            } else {
                this.setPartName(PICLLabels.ModulesView_printjobtitle);
                this.setTitleToolTip(PICLLabels.ModulesView_tooltip);
                this.fModulesFilterAction.setToolTipText(PICLLabels.ModulesFilterAction_tooltip);
            }
            if (this.fAddProgramAction != null) {
                this.fAddProgramAction.setDebugTarget(newDebugTarget);
            }
            this.fTreeViewer.setInput((Object)newDebugTarget.getModuleParent());
            final Object[] expandState = newDebugTarget.getModuleParent().getExpandedElements();
            final TreeViewer treeViewer = this.fTreeViewer;
            if (expandState.length > 0) {
                new UIJob("Refresh expanded state"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        treeViewer.setExpandedElements(expandState);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }
    }

    public PDTDebugTarget getCurrentDebugTarget() {
        return this.fCurrentDebugTarget;
    }

    private static class ModuleLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        private PDTModelPresentation fModelPresentation = null;

        ModuleLabelProvider(PDTModelPresentation presentation) {
            this.fModelPresentation = presentation;
        }

        public String getToolTipText(Object element) {
            if (element instanceof ViewFile) {
                String label = ((ViewFile)element).getFileName();
                if (!((ViewFile)element).getLabel().equals(label)) {
                    return label;
                }
            }
            return null;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.fModelPresentation.getText(cell.getElement()));
        }

        public Image getImage(Object element) {
            return this.fModelPresentation.getImage(element);
        }

        public String getText(Object element) {
            return this.fModelPresentation.getText(element);
        }
    }
}

