/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.DebugEngineCommandLogResponseEvent;
import com.ibm.debug.pdt.internal.core.model.DebugEngineTerminatedEvent;
import com.ibm.debug.pdt.internal.core.model.DebuggeeProcess;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ErrorOccurredEvent;
import com.ibm.debug.pdt.internal.core.model.IDebugEngineEventListener;
import com.ibm.debug.pdt.internal.core.model.IModelEventListener;
import com.ibm.debug.pdt.internal.core.model.MessageReceivedEvent;
import com.ibm.debug.pdt.internal.core.model.ModelStateReadyEvent;
import com.ibm.debug.pdt.internal.core.model.ProcessAddedEvent;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.epdc.EPDC_EngineSession;
import com.ibm.debug.pdt.internal.epdc.ERepCommandLog;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewClearAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewClearCommandsAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewCopyAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewDeleteCommandAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewEditCommandAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewExportCommandHistoryAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewExportCommandLogAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewImportCommandLogAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewInsertCommandAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewNextCommandLogAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewPlayAllCommandLogAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewPrintAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewSelectAllAction;
import com.ibm.debug.pdt.internal.ui.actions.DebugConsoleViewStopCommandAction;
import com.ibm.debug.pdt.internal.ui.contentassist.ContentAssistProvider;
import com.ibm.debug.pdt.internal.ui.dialogs.AddDebugConsoleDialog;
import com.ibm.debug.pdt.internal.ui.dialogs.ChangeCommandStringDialog;
import com.ibm.debug.pdt.internal.ui.util.DebugConsoleColorProvider;
import com.ibm.debug.pdt.internal.ui.util.DebugConsoleUtils;
import com.ibm.debug.pdt.internal.ui.util.LogLine;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleJob;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleLogManager;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleSession;
import com.ibm.debug.pdt.internal.ui.views.SemaphoreConsole;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;

public class DebugConsoleView
extends AbstractDebugView
implements IDebugEventSetListener,
IDebugEngineEventListener,
IDebugContextListener {
    private static final String EMPTY = "";
    private static final String[] EMPTYPROPOSALS = new String[0];
    private Thread fPlayAllThread = null;
    private boolean fStopPlayAllThread = true;
    protected SemaphoreConsole playbackSemaphore = new SemaphoreConsole();
    private Map<ILaunchConfiguration, ILaunchConfigurationWorkingCopy> fConfigMap = new HashMap<ILaunchConfiguration, ILaunchConfigurationWorkingCopy>();
    private boolean fDisposed = false;
    private TextViewer fTextViewer;
    private StyledText fDebugConsoleOutput;
    private List fCommandLogViewer;
    private DebugConsoleLogManager fCommandLogManager;
    Combo fCommandField;
    private Button fButton = null;
    private AddDebugConsoleDialog fAddDebugConsoleDialog;
    private SashForm fSashForm;
    private Label fCommandEntryLabel;
    private FontChangeListener fFontChangeListener;
    private DebugConsoleSession fCurrentDebugConsoleSession = null;
    private DebugConsoleViewCopyAction fCopyAction;
    private DebugConsoleViewClearAction fClearAction;
    private DebugConsoleViewSelectAllAction fSelectAllAction;
    private DebugConsoleViewPrintAction fPrintAction;
    private DebugConsoleViewExportCommandHistoryAction fExportHistoryAction;
    private DebugConsoleViewExportCommandLogAction fExportLogAction;
    private DebugConsoleViewImportCommandLogAction fImportAction;
    private DebugConsoleViewNextCommandLogAction fNextCommandLogAction;
    private DebugConsoleViewPlayAllCommandLogAction fPlayAllCommandLogAction;
    private DebugConsoleViewStopCommandAction fStopCommandLogAction;
    private DebugConsoleViewEditCommandAction fEditCommandAction;
    private DebugConsoleViewInsertCommandAction fInsertCommandAction;
    private DebugConsoleViewDeleteCommandAction fDeleteCommandAction;
    private DebugConsoleViewClearCommandsAction fClearCommandsAction;
    private DebugConsoleColorProvider fDebugConsoleColorProvider;
    private ContentAssistProvider fCommandFieldAssist;
    private boolean fCheckEditor = false;
    private boolean fHold = false;
    private boolean fWaitForCommand = false;
    Job waitForEditorJob = null;

    DebugConsoleSession getCurrentSession() {
        return this.fCurrentDebugConsoleSession;
    }

    boolean isCurrentDebugSession(DebugConsoleSession session) {
        return session == this.fCurrentDebugConsoleSession;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (source instanceof PICLDebugTarget || source instanceof DebuggeeThread || source instanceof DebuggeeProcess) {
                boolean currentSession = false;
                if (this.fCurrentDebugConsoleSession != null) {
                    currentSession = ((PDTDebugElement)source).getDebugTarget().equals(this.fCurrentDebugConsoleSession.getTarget());
                }
                switch (event.getKind()) {
                    case 4: {
                        break;
                    }
                    case 8: {
                        if (!(source instanceof DebuggeeProcess) || !currentSession) break;
                        ILaunchConfiguration launchConfig = ((DebuggeeProcess)source).getLaunch().getLaunchConfiguration();
                        ILaunchConfigurationWorkingCopy workingLaunchConfig = this.fConfigMap.get(launchConfig);
                        if (workingLaunchConfig != null) {
                            try {
                                ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
                                wc.setAttribute("CommandHistoryList", workingLaunchConfig.getAttribute("CommandHistoryList", EMPTY));
                                wc.doSave();
                            }
                            catch (CoreException e) {
                                PICLUtils.logError((Exception)((Object)e));
                            }
                            this.fConfigMap.remove(launchConfig);
                        }
                        this.disableInput();
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (!currentSession) break;
                        this.enableInput(false);
                        break;
                    }
                }
            }
            ++i;
        }
    }

    private void disableInput() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DebugConsoleView.this.fDisposed) {
                    return;
                }
                if (DebugConsoleView.this.fCommandField != null) {
                    DebugConsoleView.this.fCommandField.setEnabled(false);
                }
                if (DebugConsoleView.this.fNextCommandLogAction != null) {
                    DebugConsoleView.this.fNextCommandLogAction.setEnabled(false);
                }
                if (DebugConsoleView.this.fPlayAllCommandLogAction != null) {
                    DebugConsoleView.this.fPlayAllCommandLogAction.setEnabled(false);
                }
                if (DebugConsoleView.this.fButton != null) {
                    DebugConsoleView.this.fButton.setEnabled(false);
                }
            }
        });
    }

    private void enableInput(final boolean setFocus) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DebugConsoleView.this.fDisposed) {
                    return;
                }
                boolean sessionOk = DebugConsoleView.this.fCurrentDebugConsoleSession != null && DebugConsoleView.this.fCurrentDebugConsoleSession.getTarget().isAcceptingRequests() && Job.getJobManager().find((Object)DebugConsoleView.this.fCurrentDebugConsoleSession).length == 0;
                DebugConsoleView.this.fCommandField.setEnabled(sessionOk);
                DebugConsoleView.this.fButton.setEnabled(sessionOk);
                if (DebugConsoleView.this.fCurrentDebugConsoleSession != null && DebugConsoleView.this.getCommandLogManager().getSize() > 0) {
                    DebugConsoleView.this.fNextCommandLogAction.setEnabled(sessionOk);
                    DebugConsoleView.this.fPlayAllCommandLogAction.setEnabled(sessionOk);
                }
                if (setFocus && sessionOk) {
                    DebugConsoleView.this.fCommandField.setFocus();
                }
            }
        });
    }

    protected Viewer createViewer(Composite parent) {
        parent = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        this.fSashForm = new SashForm(parent, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        this.fSashForm.setLayoutData((Object)gd);
        this.fSashForm.setOrientation(256);
        this.fTextViewer = new TextViewer((Composite)this.fSashForm, 776);
        this.fTextViewer.setDocument((IDocument)new Document());
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.grabExcessHorizontalSpace = true;
        this.fTextViewer.getControl().setLayoutData((Object)gd);
        this.fDebugConsoleOutput = this.fTextViewer.getTextWidget();
        this.fDebugConsoleOutput.setText(PICLLabels.DebugConsoleView_consoleNotAvailable);
        this.fDebugConsoleOutput.setDoubleClickEnabled(true);
        this.fCommandLogViewer = new List((Composite)this.fSashForm, 780);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.horizontalIndent = 5;
        this.fCommandLogViewer.setLayoutData((Object)gd);
        this.fSashForm.setWeights(new int[]{80, 20});
        this.fCommandEntryLabel = new Label(parent, 0);
        this.fCommandEntryLabel.setText(PICLLabels.DebugConsoleView_piclCommand);
        gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalIndent = 5;
        this.fCommandEntryLabel.setLayoutData((Object)gd);
        this.fCommandField = new Combo(parent, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 1;
        this.fCommandField.setLayoutData((Object)gd);
        this.fCommandField.setEnabled(false);
        this.fCommandFieldAssist = new ContentAssistProvider((Control)this.fCommandField);
        this.fCommandField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                String command = DebugConsoleView.this.fCommandField.getText();
                if (e.character == '\r') {
                    DebugConsoleView.this.addCommandToLog(command);
                    int idx = DebugConsoleView.this.fCommandField.indexOf(command);
                    if (idx != -1) {
                        DebugConsoleView.this.fCommandField.remove(idx);
                    }
                    DebugConsoleView.this.fCommandField.add(command, 0);
                    DebugConsoleView.this.checkAndPlayCommand(command);
                    DebugConsoleView.this.fCommandField.setText(DebugConsoleView.EMPTY);
                    DebugConsoleView.this.addToCommandHistory(command);
                }
            }
        });
        this.fButton = new Button(parent, 8);
        gd = new GridData(4);
        gd.horizontalSpan = 1;
        this.fButton.setLayoutData((Object)gd);
        this.fButton.setText(PICLLabels.DebugConsoleView_EnterCommands);
        this.fButton.setEnabled(false);
        this.fButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DebugConsoleView.this.fAddDebugConsoleDialog = new AddDebugConsoleDialog(DebugConsoleView.this.fButton.getShell(), DebugConsoleView.this.fCurrentDebugConsoleSession, DebugConsoleView.this.fCommandField.getText());
                if (DebugConsoleView.this.fAddDebugConsoleDialog.open() == 0 && DebugConsoleView.this.fAddDebugConsoleDialog.getValue().length() > 0) {
                    String debugConsoleDialogText = DebugConsoleView.this.fAddDebugConsoleDialog.getValue();
                    String[] commandList = DebugConsoleUtils.toArray(debugConsoleDialogText, ";");
                    int i = 0;
                    while (i < commandList.length) {
                        DebugConsoleView.this.fCommandField.add(commandList[i]);
                        DebugConsoleView.this.addCommandToLog(commandList[i]);
                        DebugConsoleView.this.addToCommandHistory(commandList[i]);
                        DebugConsoleView.this.checkAndPlayCommand(commandList[i]);
                        ++i;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fFontChangeListener = new FontChangeListener();
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this.fFontChangeListener);
        Font debugConsoleFont = JFaceResources.getFont((String)"com.ibm.debug.pdt.ui.DebugConsoleFont");
        this.fTextViewer.getTextWidget().setFont(debugConsoleFont);
        this.fCommandLogViewer.setFont(debugConsoleFont);
        this.fCommandLogManager = new DebugConsoleLogManager(this.getCommandLogViewer(), this);
        this.fDebugConsoleColorProvider = new DebugConsoleColorProvider();
        return this.fTextViewer;
    }

    private void addCommandToLog(String command) {
        int logIndex = this.fCommandLogViewer.getItemCount() - 1;
        DebugConsoleLogManager logManager = this.getCommandLogManager();
        logManager.setSelected(logIndex);
        this.fCommandLogViewer.setItem(logIndex, DebugConsoleUtils.formatCommandLogViewerCommand(command, logIndex));
        logManager.editCommand(logIndex, command);
    }

    protected List getCommandLogViewer() {
        return this.fCommandLogViewer;
    }

    protected void createActions() {
        this.fCopyAction = new DebugConsoleViewCopyAction(this);
        this.fCopyAction.setEnabled(true);
        this.fSelectAllAction = new DebugConsoleViewSelectAllAction(this);
        this.fSelectAllAction.setEnabled(true);
        this.fClearAction = new DebugConsoleViewClearAction(this);
        this.fClearAction.setEnabled(true);
        this.fPrintAction = new DebugConsoleViewPrintAction(this);
        this.fExportHistoryAction = new DebugConsoleViewExportCommandHistoryAction(this);
        this.fExportHistoryAction.setEnabled(false);
        this.fExportLogAction = new DebugConsoleViewExportCommandLogAction(this);
        this.fExportLogAction.setEnabled(false);
        this.fImportAction = new DebugConsoleViewImportCommandLogAction(this);
        this.fImportAction.setEnabled(false);
        this.fNextCommandLogAction = new DebugConsoleViewNextCommandLogAction(this);
        this.fNextCommandLogAction.setEnabled(false);
        this.fPlayAllCommandLogAction = new DebugConsoleViewPlayAllCommandLogAction(this);
        this.fPlayAllCommandLogAction.setEnabled(false);
        this.fEditCommandAction = new DebugConsoleViewEditCommandAction(this);
        this.fEditCommandAction.setEnabled(false);
        this.fInsertCommandAction = new DebugConsoleViewInsertCommandAction(this);
        this.fInsertCommandAction.setEnabled(false);
        this.fDeleteCommandAction = new DebugConsoleViewDeleteCommandAction(this);
        this.fDeleteCommandAction.setEnabled(false);
        this.fClearCommandsAction = new DebugConsoleViewClearCommandsAction(this);
        this.fClearCommandsAction.setEnabled(false);
        this.fStopCommandLogAction = new DebugConsoleViewStopCommandAction(this);
        this.fStopCommandLogAction.setEnabled(false);
    }

    protected String getHelpContextId() {
        return PICLUtils.getHelpResourceString("debug_console");
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.fCopyAction);
        menu.add((IAction)this.fSelectAllAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fClearAction);
        menu.add((IAction)this.fPrintAction);
        menu.add((IAction)this.fExportHistoryAction);
        menu.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void createLogContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                mgr.add((IAction)DebugConsoleView.this.fEditCommandAction);
                mgr.add((IAction)DebugConsoleView.this.fImportAction);
                mgr.add((IAction)DebugConsoleView.this.fExportLogAction);
                mgr.add((IAction)DebugConsoleView.this.fNextCommandLogAction);
                mgr.add((IAction)DebugConsoleView.this.fPlayAllCommandLogAction);
                mgr.add((IAction)DebugConsoleView.this.fStopCommandLogAction);
                mgr.add((IAction)DebugConsoleView.this.fInsertCommandAction);
                mgr.add((IAction)DebugConsoleView.this.fDeleteCommandAction);
                mgr.add((IAction)DebugConsoleView.this.fClearCommandsAction);
                mgr.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.addContextMenuManager((IMenuManager)menuMgr);
    }

    public void copySelection() {
        this.fTextViewer.doOperation(4);
    }

    public void clear() {
        this.fDebugConsoleOutput.setText(EMPTY);
    }

    public void selectAll() {
        this.fTextViewer.doOperation(7);
    }

    public void printContents() {
        this.fPrintAction.print(this.fTextViewer);
    }

    public void exportCommandHistory() {
        if (this.fCurrentDebugConsoleSession == null) {
            return;
        }
        String exportText = this.fDebugConsoleOutput.getSelectionText();
        if (exportText == null || exportText.length() == 0) {
            exportText = this.fDebugConsoleOutput.getText();
        }
        this.fExportHistoryAction.doExport(this.fTextViewer.getTextWidget().getShell(), exportText);
    }

    public void exportCommandLog() {
        DebugConsoleLogManager logManager;
        if (this.fCurrentDebugConsoleSession != null && (logManager = this.getCommandLogManager()).getSize() > 0) {
            String exportFilePath = DebugConsoleUtils.getExportFilePath(this.fTextViewer.getTextWidget().getShell());
            logManager.exportCommandLog(exportFilePath);
        }
    }

    public void updateButtons() {
        if (this.fCurrentDebugConsoleSession != null) {
            DebugConsoleLogManager logManager = this.getCommandLogManager();
            this.fDeleteCommandAction.setEnabled(logManager.canDelete());
            this.fInsertCommandAction.setEnabled(logManager.canInsert());
            this.fEditCommandAction.setEnabled(logManager.canInsert());
            this.fClearCommandsAction.setEnabled(logManager.getSize() > 0);
            if (logManager.getSize() > 0 && this.fCommandField.getEnabled() && logManager.hasNextCommand()) {
                this.fNextCommandLogAction.setEnabled(true);
                this.fPlayAllCommandLogAction.setEnabled(true);
            } else {
                this.fNextCommandLogAction.setEnabled(false);
                this.fPlayAllCommandLogAction.setEnabled(false);
            }
            if (logManager.getSize() > 0) {
                this.fExportLogAction.setEnabled(true);
            } else {
                this.fExportLogAction.setEnabled(false);
            }
            this.fExportHistoryAction.setEnabled(true);
        } else {
            this.fInsertCommandAction.setEnabled(false);
            this.fDeleteCommandAction.setEnabled(false);
            this.fClearCommandsAction.setEnabled(false);
            this.fEditCommandAction.setEnabled(false);
            this.fNextCommandLogAction.setEnabled(false);
            this.fPlayAllCommandLogAction.setEnabled(false);
        }
    }

    public void importContents() {
        boolean hasImportedCommands;
        if (this.fCurrentDebugConsoleSession != null && (hasImportedCommands = this.getCommandLogManager().doImport())) {
            this.updateButtons();
        }
    }

    public boolean nextLogCommand() {
        return this.nextLogCommand(null, true);
    }

    public boolean nextLogCommand(String command, boolean gotoNextCommand) {
        DebugConsoleJob job = new DebugConsoleJob(command, gotoNextCommand, this, this.fCurrentDebugConsoleSession);
        job.schedule();
        return this.getCommandLogManager().hasNextCommand();
    }

    public void playAllCommandLog() {
        if (this.fPlayAllThread == null || !this.fPlayAllThread.isAlive()) {
            this.fPlayAllThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (!DebugConsoleView.this.fDisposed) {
                        DebugConsoleSession session = DebugConsoleView.this.fCurrentDebugConsoleSession;
                        if (session == null || DebugConsoleView.this.fStopPlayAllThread) {
                            return;
                        }
                        int j = 0;
                        while (j < 100 && !session.isIdle()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            ++j;
                        }
                        if (session.isIdle() && !DebugConsoleView.this.nextLogCommand()) {
                            DebugConsoleView.this.fStopCommandLogAction.setEnabled(false);
                            return;
                        }
                        try {
                            DebugConsoleView.this.fHold = true;
                            DebugConsoleView.this.playbackSemaphore.hold();
                            DebugConsoleView.this.fHold = false;
                        }
                        catch (InterruptedException e) {
                            DebugConsoleView.this.fHold = false;
                            return;
                        }
                    }
                    return;
                }
            }, "Play");
            this.fStopPlayAllThread = false;
            this.fPlayAllThread.start();
            this.fStopCommandLogAction.setEnabled(true);
        }
    }

    public void stopCommandLogPlayback() {
        this.fStopPlayAllThread = true;
        if (this.fPlayAllThread != null) {
            this.fPlayAllThread.interrupt();
        }
        this.fStopCommandLogAction.setEnabled(false);
    }

    public void editCommandString() {
        if (this.fCurrentDebugConsoleSession != null && this.fCommandLogViewer != null) {
            ChangeCommandStringDialog dlg;
            int rc;
            DebugConsoleLogManager logManager = this.getCommandLogManager();
            String string = logManager.getCommand();
            if (string == null) {
                string = EMPTY;
            }
            if ((rc = (dlg = new ChangeCommandStringDialog(this.fSashForm.getShell(), string, PICLLabels.EditCommandStringDialog_title)).open()) == 0) {
                logManager.setSelectedTo(dlg.getString());
                this.fCommandField.setText(dlg.getString());
                this.updateButtons();
            }
        }
    }

    public void insertCommand() {
        if (this.fCurrentDebugConsoleSession != null && this.fCommandLogViewer != null) {
            DebugConsoleLogManager logManager = this.getCommandLogManager();
            String commandAfter = logManager.getCommands().get(logManager.getCurCommandNum());
            String string = EMPTY;
            ChangeCommandStringDialog dlg = new ChangeCommandStringDialog(this.fSashForm.getShell(), string, PICLLabels.InsertCommandStringDialog_title);
            int rc = dlg.open();
            String newCommand = dlg.getString();
            if (rc == 0 && newCommand != null && newCommand.length() > 0) {
                logManager.insertCommand(newCommand);
                this.insertToCommandHistory(newCommand, commandAfter);
            }
        }
    }

    public void deleteCommand() {
        if (this.fCurrentDebugConsoleSession != null) {
            final DebugConsoleLogManager logManager = this.getCommandLogManager();
            int index = logManager.getCurCommandNum() - logManager.getStartupCommands().size();
            CommonUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    logManager.deleteCommand();
                }
            });
            this.removeFromCommandHistory(false, index);
        }
    }

    public void clearCommands() {
        if (this.fCurrentDebugConsoleSession != null) {
            this.getCommandLogManager().clearCommands();
            this.removeFromCommandHistory(true, 0);
        }
    }

    public void checkAndPlayCommand(String command) {
        this.nextLogCommand(command, true);
    }

    public void checkAndPlayCommand() {
        this.checkAndPlayCommand(true);
    }

    public void checkAndPlayCommand(boolean gotoNextCommand) {
        if (this.fCurrentDebugConsoleSession == null || this.fEditCommandAction == null) {
            return;
        }
        this.nextLogCommand(null, gotoNextCommand);
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IAction)this.fClearAction);
        tbm.add((IAction)this.fPrintAction);
        Separator separator = new Separator(((Object)((Object)this)).getClass().getName());
        tbm.add((IContributionItem)separator);
        tbm.add((IAction)this.fInsertCommandAction);
        tbm.add((IAction)this.fDeleteCommandAction);
        tbm.add((IAction)this.fClearCommandsAction);
        separator = new Separator(((Object)((Object)this)).getClass().getName() + "2");
        tbm.add((IContributionItem)separator);
        tbm.add((IAction)this.fImportAction);
        tbm.add((IAction)this.fExportLogAction);
        tbm.add((IAction)this.fExportHistoryAction);
        separator = new Separator(((Object)((Object)this)).getClass().getName() + "3");
        tbm.add((IContributionItem)separator);
        tbm.add((IAction)this.fNextCommandLogAction);
        tbm.add((IAction)this.fPlayAllCommandLogAction);
        tbm.add((IAction)this.fStopCommandLogAction);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createLogContextMenu((Control)this.fCommandLogViewer);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        DebugUITools.getDebugContextManager().addDebugContextListener((IDebugContextListener)this);
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof IDebugElement) {
            this.updateView(PICLDebugPlugin.getPICLDebugTarget((IDebugElement)context));
        }
    }

    void addCommandLine(final String newLine, final DebugConsoleSession consoleSession) throws EngineRequestException {
        CommonUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DebugConsoleView.this.fDisposed) {
                    return;
                }
                if (consoleSession == DebugConsoleView.this.fCurrentDebugConsoleSession) {
                    int prevCharCount = DebugConsoleView.this.fDebugConsoleOutput.getCharCount();
                    DebugConsoleView.this.fDebugConsoleOutput.append(newLine + DebugConsoleUtils.getLineDelimiter());
                    DebugConsoleView.this.fTextViewer.setTextColor(DebugConsoleView.this.fDebugConsoleColorProvider.getForeground(newLine), prevCharCount, newLine.length(), true);
                    DebugConsoleView.this.fDebugConsoleOutput.setSelection(prevCharCount);
                }
            }
        });
        consoleSession.addToCommandHistory(newLine);
        consoleSession.addToLogLines(newLine + DebugConsoleUtils.getLineDelimiter(), true);
        this.disableInput();
        if (consoleSession.getTarget() != null && consoleSession.getTarget().getDebugEngine() != null) {
            while (this.fPlayAllThread != null && this.fPlayAllThread.isAlive() && !this.fHold) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            this.fWaitForCommand = true;
            ERepCommandLog reply = consoleSession.getTarget().getDebugEngine().commandLog(newLine, false, false);
            this.fCheckEditor = reply.isThreadStateChgd() || reply.getStackChanges().length > 0;
            this.fWaitForCommand = false;
        }
        this.enableInput(true);
    }

    public void debugContextChanged(DebugContextEvent event) {
        PICLDebugTarget debugTarget = PICLDebugPlugin.getPICLDebugTarget(event.getContext());
        this.updateView(debugTarget);
    }

    private void updateView(PICLDebugTarget debugTarget) {
        if (debugTarget == null) {
            this.switchToNoTarget();
            return;
        }
        DebugConsoleSession newDebugConsoleSession = debugTarget.getDebugConsoleSession();
        if (this.isCurrentDebugSession(newDebugConsoleSession)) {
            return;
        }
        if (this.fCurrentDebugConsoleSession != null) {
            if (this.fCurrentDebugConsoleSession.getTarget().getDebugEngine() != null) {
                this.fCurrentDebugConsoleSession.getTarget().getDebugEngine().removeListener((IModelEventListener)this);
            }
            this.getCommandLogManager().removeEventListeners();
            this.fCurrentDebugConsoleSession.setCommandFieldHistory(this.fCommandField.getItems());
        }
        if (newDebugConsoleSession == null || !newDebugConsoleSession.supportsLog()) {
            this.switchToNoTarget();
        } else {
            this.updateViewInfo(newDebugConsoleSession);
        }
    }

    private void updateLogUI() {
        if (this.fCurrentDebugConsoleSession != null) {
            ILaunchConfiguration config;
            DebugConsoleLogManager logManager = this.getCommandLogManager();
            if (this.fCurrentDebugConsoleSession.getTarget() != null && this.fCurrentDebugConsoleSession.getTarget().getLaunch() != null && (config = this.fCurrentDebugConsoleSession.getTarget().getLaunch().getLaunchConfiguration()) != null) {
                String configStartupList = EMPTY;
                String configCurrentList = EMPTY;
                try {
                    configStartupList = config.getAttribute("StartupCommandList", EMPTY);
                    configCurrentList = config.getAttribute("CommandHistoryList", EMPTY);
                }
                catch (CoreException ce) {
                    PICLUtils.logError((Exception)((Object)ce));
                }
                logManager.getStartupCommands().clear();
                logManager.getCommands().clear();
                logManager.setStartupCommands(configStartupList);
                logManager.setCurrentCommands(configCurrentList);
            }
            logManager.updateLogViewer();
            if (this.fImportAction != null) {
                this.fImportAction.setEnabled(true);
            }
            this.updateButtons();
            logManager.resetEventListeners();
            this.fCommandLogViewer.redraw();
        }
    }

    private void switchToNoTarget() {
        this.stopCommandLogPlayback();
        if (this.fPlayAllThread != null) {
            try {
                this.fPlayAllThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.fCommandField.setEnabled(false);
        this.fButton.setEnabled(false);
        this.fImportAction.setEnabled(false);
        this.fNextCommandLogAction.setEnabled(false);
        this.fPlayAllCommandLogAction.setEnabled(false);
        this.fDebugConsoleOutput.setText(PICLLabels.DebugConsoleView_consoleNotAvailable);
        this.fCurrentDebugConsoleSession = null;
        this.fCommandLogViewer.removeAll();
        this.updateButtons();
    }

    private void updateViewInfo(DebugConsoleSession debugConsoleSession) {
        this.stopCommandLogPlayback();
        if (this.fPlayAllThread != null) {
            try {
                this.fPlayAllThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.fCurrentDebugConsoleSession = debugConsoleSession;
        if (this.fCurrentDebugConsoleSession.getTarget().getDebugEngine() != null) {
            this.fCurrentDebugConsoleSession.getTarget().getDebugEngine().addEventListener((IDebugEngineEventListener)this);
        }
        boolean sessionOk = !debugConsoleSession.getTarget().isTerminated() && debugConsoleSession.getTarget().isAcceptingRequests() && Job.getJobManager().find((Object)debugConsoleSession).length == 0;
        this.fCommandField.setEnabled(sessionOk);
        this.fButton.setEnabled(sessionOk);
        this.fDebugConsoleOutput.setText(EMPTY);
        LogLine[] logLines = debugConsoleSession.getLogLines();
        int i = 0;
        while (i < logLines.length) {
            int previousCharCount = this.fDebugConsoleOutput.getCharCount();
            this.fDebugConsoleOutput.append(logLines[i].getContent());
            if (logLines[i].isInput()) {
                this.fTextViewer.setTextColor(this.fDebugConsoleColorProvider.getForeground(logLines[i]), previousCharCount, logLines[i].getContent().length(), true);
            }
            ++i;
        }
        this.fDebugConsoleOutput.setSelection(this.fDebugConsoleOutput.getCharCount());
        this.updateLogUI();
        this.fStopCommandLogAction.setEnabled(false);
        this.fCommandField.setItems(debugConsoleSession.getCommandFieldHistory());
        EPDC_EngineSession engineSession = debugConsoleSession.getTarget().getEngineSession();
        if (engineSession.isDebugTool()) {
            this.fCommandFieldAssist.setProposals(this.fCommandFieldAssist.getProposals(engineSession.getEngineVersionString(), null));
        } else {
            this.fCommandFieldAssist.setProposals(EMPTYPROPOSALS);
        }
    }

    public void dispose() {
        this.fDisposed = true;
        DebugUITools.getDebugContextManager().removeDebugContextListener((IDebugContextListener)this);
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this.fFontChangeListener);
        this.fCommandEntryLabel.dispose();
        this.fCommandEntryLabel = null;
        this.fCommandField.dispose();
        this.fCommandField = null;
        this.fButton.dispose();
        this.fButton = null;
        this.fTextViewer = null;
        this.fCurrentDebugConsoleSession = null;
        for (Map.Entry<ILaunchConfiguration, ILaunchConfigurationWorkingCopy> entry : this.fConfigMap.entrySet()) {
            try {
                ILaunchConfigurationWorkingCopy wc = entry.getKey().getWorkingCopy();
                wc.setAttribute("CommandHistoryList", entry.getValue().getAttribute("CommandHistoryList", EMPTY));
                wc.doSave();
            }
            catch (CoreException ce) {
                PICLUtils.logError((Exception)((Object)ce));
            }
        }
        this.fConfigMap.clear();
        super.dispose();
    }

    public void setFocus() {
        if (this.fCommandField.isEnabled()) {
            this.fCommandField.setFocus();
        } else {
            super.setFocus();
        }
    }

    public void addToCommandHistory(String command) {
        ILaunchConfigurationWorkingCopy config = null;
        try {
            config = this.getWorkingLaunchConfiguration();
            if (config != null) {
                Object currentCommands = config.getAttribute("CommandHistoryList", EMPTY);
                currentCommands = currentCommands == null || ((String)currentCommands).length() == 0 ? command : (String)currentCommands + DebugConsoleUtils.getLineDelimiter() + command;
                config.setAttribute("CommandHistoryList", (String)currentCommands);
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
    }

    private ILaunchConfigurationWorkingCopy getWorkingLaunchConfiguration() {
        ILaunchConfigurationWorkingCopy config = null;
        try {
            ILaunchConfiguration launchConfig = this.fCurrentDebugConsoleSession.getTarget().getLaunch().getLaunchConfiguration();
            config = this.fConfigMap.get(launchConfig);
            if (config == null) {
                config = launchConfig.getWorkingCopy();
                this.fConfigMap.put(launchConfig, config);
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
        return config;
    }

    public void removeFromCommandHistory(boolean isAll, int index) {
        ILaunchConfigurationWorkingCopy config = null;
        try {
            config = this.getWorkingLaunchConfiguration();
            if (config != null) {
                if (isAll) {
                    config.setAttribute("CommandHistoryList", EMPTY);
                } else {
                    String currentCommands = config.getAttribute("CommandHistoryList", EMPTY);
                    if ((currentCommands = DebugConsoleUtils.removeCommand(currentCommands, index)) != null) {
                        config.setAttribute("CommandHistoryList", currentCommands);
                    }
                }
            }
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
    }

    public void insertToCommandHistory(String insertedCommand, String commandAfter) {
        try {
            ILaunchConfigurationWorkingCopy config = this.getWorkingLaunchConfiguration();
            String configCurrentCommands = config.getAttribute("CommandHistoryList", EMPTY);
            configCurrentCommands = DebugConsoleUtils.insertCommand(configCurrentCommands, insertedCommand, commandAfter);
            config.setAttribute("CommandHistoryList", configCurrentCommands);
        }
        catch (CoreException ce) {
            PICLUtils.logError((Exception)((Object)ce));
        }
    }

    public DebugConsoleLogManager getCommandLogManager() {
        return this.fCommandLogManager;
    }

    public void commandLogResponse(DebugEngineCommandLogResponseEvent event) {
        final String[] lines = event.getResponseLines();
        final boolean clearConsole = event.getDebugEngine().getProcess() != null && event.getDebugEngine().getProcess().getProcessStopInfo() != null && event.getDebugEngine().getProcess().getProcessStopInfo().getReason() == 24;
        CommonUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DebugConsoleView.this.fDisposed) {
                    return;
                }
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    DebugConsoleView.this.fDebugConsoleOutput.append(DebugConsoleUtils.cleanLine(line));
                    ++n2;
                }
                DebugConsoleView.this.fDebugConsoleOutput.setTopIndex(DebugConsoleView.this.fDebugConsoleOutput.getLineCount());
                if (clearConsole) {
                    DebugConsoleView.this.clear();
                }
            }
        });
    }

    public void debugEngineTerminated(DebugEngineTerminatedEvent event) {
        IDebugTarget target = event.getDebugEngine().getDebugTarget();
        if (target instanceof PICLDebugTarget) {
            Job[] jobs = Job.getJobManager().find((Object)((PICLDebugTarget)target).getDebugConsoleSession());
            int i = 0;
            while (i < jobs.length) {
                jobs[i].cancel();
                ++i;
            }
        }
        event.getDebugEngine().removeListener((IModelEventListener)this);
    }

    public void modelStateChanged(ModelStateReadyEvent event) {
        if (this.fHold) {
            if (this.fWaitForCommand || this.fCheckEditor) {
                this.checkEditor();
            } else {
                this.playbackSemaphore.release();
            }
        }
    }

    public void errorOccurred(ErrorOccurredEvent event) {
    }

    public void messageReceived(MessageReceivedEvent event) {
    }

    public void processAdded(ProcessAddedEvent event) {
    }

    public boolean isDisposed() {
        return this.fDisposed;
    }

    void updateCommandText(final String command, final DebugConsoleSession debugConsoleSession) {
        CommonUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DebugConsoleView.this.fDisposed) {
                    return;
                }
                if (debugConsoleSession == DebugConsoleView.this.fCurrentDebugConsoleSession) {
                    DebugConsoleView.this.fCommandField.setText(command);
                }
            }
        });
    }

    protected IPage createDefaultPage(PageBook book) {
        final IPage viewerPage = super.createDefaultPage(book);
        Page page = new Page(){

            public void createControl(Composite parent) {
                viewerPage.createControl(parent);
            }

            public Control getControl() {
                return DebugConsoleView.this.fSashForm.isDisposed() ? null : DebugConsoleView.this.fSashForm.getParent();
            }

            public void setFocus() {
                viewerPage.setFocus();
            }
        };
        page.createControl((Composite)book);
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    private void checkEditor() {
        if (this.waitForEditorJob == null || this.waitForEditorJob.getResult() != null) {
            this.waitForEditorJob = new Job("Debug Console: Wait for editor to load"){

                protected IStatus run(IProgressMonitor arg0) {
                    DebuggeeThread thread;
                    boolean sourceFound;
                    while (DebugConsoleView.this.fWaitForCommand) {
                        try {
                            Thread.sleep(100L);
                            if (!arg0.isCanceled()) continue;
                        }
                        catch (InterruptedException e) {}
                        break;
                    }
                    if (!arg0.isCanceled() && DebugConsoleView.this.fCheckEditor && DebugConsoleView.this.fCurrentDebugConsoleSession != null && (sourceFound = (thread = DebugConsoleView.this.fCurrentDebugConsoleSession.getTarget().getDebugEngine().getCurrentThread()).getLocation().getPart().isDebuggable())) {
                        ViewFile file = thread.getLocation().getViewFile();
                        while (file == null || !file.isVerified() || file.getEditorFile() == null || file.isEmpty() && file.getLastLineNumber() > 1) {
                            try {
                                Thread.sleep(100L);
                                if (arg0.isCanceled()) {
                                }
                            }
                            catch (InterruptedException e) {}
                            break;
                            if (DebugConsoleView.this.fCurrentDebugConsoleSession == null || DebugConsoleView.this.fCurrentDebugConsoleSession.getTarget().isTerminated()) {
                                return Status.OK_STATUS;
                            }
                            file = thread.getLocation().getViewFile();
                        }
                        while (DebugConsoleView.this.fCurrentDebugConsoleSession != null && !DebugConsoleView.this.fCurrentDebugConsoleSession.isIdle()) {
                            try {
                                Thread.sleep(100L);
                                if (!arg0.isCanceled()) continue;
                            }
                            catch (InterruptedException e) {}
                            break;
                        }
                    }
                    DebugConsoleView.this.playbackSemaphore.release();
                    return Status.OK_STATUS;
                }
            };
            this.waitForEditorJob.setSystem(true);
            this.waitForEditorJob.schedule();
        }
    }

    private class FontChangeListener
    implements IPropertyChangeListener {
        private FontChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("com.ibm.debug.pdt.ui.DebugConsoleFont") && DebugConsoleView.this.fTextViewer != null) {
                Font debugConsoleFont = JFaceResources.getFont((String)"com.ibm.debug.pdt.ui.DebugConsoleFont");
                DebugConsoleView.this.fTextViewer.getTextWidget().setFont(debugConsoleFont);
            }
        }
    }
}

