/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.util.DebugConsoleUtils;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleView;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class DebugConsoleLogManager {
    private static final int NOT_DRAGGING = -1;
    private static final int BUTTON_DOWN = 0;
    private static final int DRAGGING = 1;
    private boolean fStartupCommandsAreSet = false;
    private ArrayList<String> fStartupCommands;
    private ArrayList<String> fCurrentCommands;
    private int fCurrentCommandIndex;
    private int fDraggingState = -1;
    private int fDraggingOldIndex = -1;
    private int fPickedUpIndex = -1;
    MySelectionListener fSelectionListener;
    MyMouseAdapter fMouseListener;
    MyMouseMoveListener fMouseMoveListener;
    MyKeyListener fKeyListener;
    private List fCommandLogViewer;
    private Combo fCommandField;
    private DebugConsoleView fDebugConsoleView;
    private boolean fEventListenersAdded = false;

    public DebugConsoleLogManager(List commandLogViewer, DebugConsoleView debugConsoleView) {
        this.fCommandLogViewer = commandLogViewer;
        this.fCommandField = debugConsoleView.fCommandField;
        this.fDebugConsoleView = debugConsoleView;
        this.fStartupCommands = new ArrayList();
        this.fCurrentCommands = new ArrayList();
        this.fSelectionListener = new MySelectionListener();
        this.fMouseListener = new MyMouseAdapter();
        this.fMouseMoveListener = new MyMouseMoveListener();
        this.fKeyListener = new MyKeyListener();
    }

    public void removeEventListeners() {
        this.fCommandLogViewer.removeSelectionListener((SelectionListener)this.fSelectionListener);
        this.fCommandLogViewer.removeMouseListener((MouseListener)this.fMouseListener);
        this.fCommandLogViewer.removeMouseMoveListener((MouseMoveListener)this.fMouseMoveListener);
        this.fCommandLogViewer.removeKeyListener((KeyListener)this.fKeyListener);
        this.fEventListenersAdded = false;
    }

    public void resetEventListeners() {
        if (!this.fEventListenersAdded) {
            this.fEventListenersAdded = true;
            this.fCommandLogViewer.addSelectionListener((SelectionListener)this.fSelectionListener);
            this.fCommandLogViewer.addMouseListener((MouseListener)this.fMouseListener);
            this.fCommandLogViewer.addMouseMoveListener((MouseMoveListener)this.fMouseMoveListener);
            this.fCommandLogViewer.addKeyListener((KeyListener)this.fKeyListener);
        }
    }

    public boolean doImport() {
        StringBuffer importCommands = DebugConsoleUtils.getImportedCommandsFromFile(this.fCommandLogViewer.getShell());
        if (importCommands == null || importCommands.length() == 0) {
            return false;
        }
        String[] cmds = DebugConsoleUtils.toArray(importCommands.toString());
        int i = 0;
        while (i < cmds.length) {
            this.insertCommand(cmds[i]);
            ++i;
        }
        return true;
    }

    public void setStartupCommands(String startCommands) {
        String[] cmds = DebugConsoleUtils.toArray(startCommands);
        if (cmds == null || cmds.length == 0) {
            return;
        }
        int i = 0;
        while (i < cmds.length) {
            this.fStartupCommands.add(cmds[i]);
            ++i;
        }
        this.fStartupCommandsAreSet = true;
        this.fCurrentCommands.addAll(this.fStartupCommands);
    }

    public boolean startupCommandsAreSet() {
        return this.fStartupCommandsAreSet;
    }

    public ArrayList<String> getCommands() {
        return this.fCurrentCommands;
    }

    public ArrayList<String> getStartupCommands() {
        return this.fStartupCommands;
    }

    public void setCurrentCommands(String commands) {
        String[] cmds = DebugConsoleUtils.toArray(commands);
        if (cmds == null || cmds.length == 0) {
            return;
        }
        int i = 0;
        while (i < cmds.length) {
            this.fCurrentCommands.add(cmds[i]);
            ++i;
        }
    }

    public String getCommand() {
        if (this.hasNextCommand()) {
            return this.fCurrentCommands.get(this.fCurrentCommandIndex);
        }
        return null;
    }

    public int getCurCommandNum() {
        return this.fCurrentCommandIndex;
    }

    public void goToNextCommand() {
        if (this.hasNextCommand()) {
            ++this.fCurrentCommandIndex;
            this.fCommandLogViewer.setSelection(this.fCurrentCommandIndex);
            if (this.hasNextCommand()) {
                this.fCommandField.setText(this.fCurrentCommands.get(this.fCurrentCommandIndex));
            } else {
                this.fCommandField.setText("");
            }
        } else {
            this.fCommandField.setText("");
        }
    }

    public void insertCommand(String cmd) {
        this.fCurrentCommands.add(this.fCurrentCommandIndex, cmd);
        int top = this.fCommandLogViewer.getTopIndex();
        int cur = this.fCurrentCommandIndex;
        this.updateLogViewer();
        this.fCommandLogViewer.setTopIndex(top);
        this.setSelected(cur + 1);
    }

    public void appendCommand(String cmd) {
        this.fCurrentCommands.add(cmd);
        this.fCurrentCommandIndex = this.fCurrentCommands.size() - 1;
    }

    public void editCommand(int pos, String newCommand) {
        if (pos < this.fCurrentCommands.size()) {
            this.fCurrentCommands.set(pos, newCommand);
        } else {
            this.fCommandLogViewer.add("");
            this.fCurrentCommands.add(newCommand);
            this.fCurrentCommands.set(pos, newCommand);
        }
    }

    public void deleteCommand() {
        if (this.hasNextCommand()) {
            this.fCurrentCommands.remove(this.fCurrentCommandIndex);
            int top = this.fCommandLogViewer.getTopIndex();
            int cur = this.fCurrentCommandIndex;
            this.updateLogViewer();
            this.fCommandLogViewer.setTopIndex(top);
            this.fCurrentCommandIndex = cur < this.fCurrentCommands.size() ? cur : cur - 1;
            if (this.fCurrentCommandIndex < 0) {
                this.fCurrentCommandIndex = 0;
            }
            this.fCommandLogViewer.select(this.fCurrentCommandIndex);
        }
    }

    public void clearCommands() {
        this.fCurrentCommands.clear();
        this.updateLogViewer();
    }

    public boolean canDelete() {
        return this.fCurrentCommandIndex < this.fCurrentCommands.size();
    }

    public boolean canInsert() {
        return this.fCurrentCommandIndex <= this.fCurrentCommands.size();
    }

    public boolean canEdit() {
        return this.fCurrentCommandIndex <= this.fCurrentCommands.size();
    }

    public void setSelectedTo(String s) {
        if (this.fCurrentCommandIndex >= 0 && this.hasNextCommand()) {
            this.fCurrentCommands.set(this.fCurrentCommandIndex, s);
            this.fCommandLogViewer.setItem(this.fCurrentCommandIndex, DebugConsoleUtils.formatCommandLogViewerCommand(s, this.fCurrentCommandIndex));
        } else if (this.fCurrentCommandIndex == this.fCurrentCommands.size()) {
            this.fCurrentCommands.add(s);
            this.fCommandLogViewer.setItem(this.fCurrentCommandIndex, DebugConsoleUtils.formatCommandLogViewerCommand(s, this.fCurrentCommandIndex));
            this.fCommandLogViewer.add("");
        }
    }

    public void setSelected(int index) {
        if (index >= 0 && index <= this.fCurrentCommands.size()) {
            this.fCurrentCommandIndex = index;
            this.fCommandLogViewer.select(index);
        }
    }

    public boolean hasNextCommand() {
        return this.fCurrentCommandIndex < this.fCurrentCommands.size();
    }

    public int getSize() {
        return this.fCurrentCommands.size();
    }

    public void exportCommandLog(String exportFilePath) {
        if (exportFilePath == null) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter writer = new FileWriter(exportFilePath, false);){
                ListIterator<String> iter = this.fCurrentCommands.listIterator();
                while (iter.hasNext()) {
                    writer.write(iter.next() + PDTCoreUtils.LINE_SEPARATOR);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            PICLUtils.logError(e);
        }
    }

    public void updateLogViewer() {
        if (this.fCommandLogViewer != null) {
            this.fCommandLogViewer.removeAll();
            if (this.fCurrentCommands != null) {
                int n = 0;
                while (n < this.fCurrentCommands.size()) {
                    this.fCommandLogViewer.add(DebugConsoleUtils.formatCommandLogViewerCommand(this.fCurrentCommands.get(n), n));
                    ++n;
                }
                this.fCommandLogViewer.add("");
                if (this.fCurrentCommandIndex >= this.fCurrentCommands.size()) {
                    this.fCurrentCommandIndex = 0;
                }
                this.fCommandLogViewer.setSelection(this.fCurrentCommandIndex);
                this.fCommandLogViewer.redraw();
            }
            this.fDebugConsoleView.updateButtons();
        }
        this.fCommandField.setText("");
    }

    private class MyKeyListener
    extends KeyAdapter {
        private MyKeyListener() {
        }

        public void keyReleased(KeyEvent e) {
            if (e.character == '\r') {
                DebugConsoleLogManager.this.fDebugConsoleView.checkAndPlayCommand();
            } else if (e.character == '\u007f') {
                DebugConsoleLogManager.this.deleteCommand();
            }
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        public void mouseDown(MouseEvent e) {
            if ((e.button == 1 || e.button == 3) && DebugConsoleLogManager.this.fDraggingState == -1) {
                int index = (int)((float)e.y / (float)DebugConsoleLogManager.this.fCommandLogViewer.getItemHeight()) + DebugConsoleLogManager.this.fCommandLogViewer.getTopIndex();
                if (index < 0) {
                    index = 0;
                }
                if (e.button == 3) {
                    DebugConsoleLogManager.this.setSelected(index);
                }
                DebugConsoleLogManager.this.fCommandLogViewer.setItem(DebugConsoleLogManager.this.fCommandLogViewer.getSelectionIndex(), "  " + DebugConsoleLogManager.this.fCommandLogViewer.getItem(DebugConsoleLogManager.this.fCommandLogViewer.getSelectionIndex()));
                if (e.button == 1 && DebugConsoleLogManager.this.fCommandLogViewer.getSelectionIndex() < DebugConsoleLogManager.this.fCurrentCommands.size()) {
                    DebugConsoleLogManager.this.fDraggingState = 0;
                    DebugConsoleLogManager.this.fDraggingOldIndex = DebugConsoleLogManager.this.fCommandLogViewer.getSelectionIndex();
                    DebugConsoleLogManager.this.fPickedUpIndex = DebugConsoleLogManager.this.fCommandLogViewer.getSelectionIndex();
                }
            }
            DebugConsoleLogManager.this.fDebugConsoleView.stopCommandLogPlayback();
        }

        public void mouseUp(MouseEvent e) {
            if (DebugConsoleLogManager.this.fDraggingState == 1) {
                int index = (int)((float)e.y / (float)DebugConsoleLogManager.this.fCommandLogViewer.getItemHeight()) + DebugConsoleLogManager.this.fCommandLogViewer.getTopIndex();
                if (index < 0) {
                    index = 0;
                }
                if (index >= DebugConsoleLogManager.this.fCurrentCommands.size()) {
                    index = DebugConsoleLogManager.this.fCurrentCommands.size() - 1;
                }
                String val = DebugConsoleLogManager.this.fCurrentCommands.get(DebugConsoleLogManager.this.fPickedUpIndex);
                DebugConsoleLogManager.this.fCurrentCommands.remove(DebugConsoleLogManager.this.fPickedUpIndex);
                DebugConsoleLogManager.this.fCurrentCommands.add(index, val);
                int topIndex = DebugConsoleLogManager.this.fCommandLogViewer.getTopIndex();
                DebugConsoleLogManager.this.updateLogViewer();
                DebugConsoleLogManager.this.fCommandLogViewer.select(DebugConsoleLogManager.this.fDraggingOldIndex);
                DebugConsoleLogManager.this.fCommandLogViewer.setTopIndex(topIndex);
            }
            DebugConsoleLogManager.this.fCommandLogViewer.setItem(DebugConsoleLogManager.this.fCommandLogViewer.getSelectionIndex(), DebugConsoleLogManager.this.fCommandLogViewer.getSelection()[0].trim());
            DebugConsoleLogManager.this.fDraggingState = -1;
        }

        public void mouseDoubleClick(MouseEvent e) {
            DebugConsoleLogManager.this.fDraggingState = -1;
            DebugConsoleLogManager.this.fCommandLogViewer.setItem(DebugConsoleLogManager.this.fCommandLogViewer.getSelectionIndex(), DebugConsoleLogManager.this.fCommandLogViewer.getSelection()[0].trim());
            DebugConsoleLogManager.this.fDebugConsoleView.stopCommandLogPlayback();
        }
    }

    private class MyMouseMoveListener
    implements MouseMoveListener {
        Shell dragInfoShell = null;
        Label dragInfoLabel = null;

        private MyMouseMoveListener() {
        }

        public void mouseMove(MouseEvent e) {
            if (DebugConsoleLogManager.this.fDraggingState != -1) {
                int index = (int)((float)e.y / (float)DebugConsoleLogManager.this.fCommandLogViewer.getItemHeight()) + DebugConsoleLogManager.this.fCommandLogViewer.getTopIndex();
                if (index < 0) {
                    index = 0;
                }
                if (index >= DebugConsoleLogManager.this.fCurrentCommands.size()) {
                    index = DebugConsoleLogManager.this.fCurrentCommands.size() - 1;
                    DebugConsoleLogManager.this.fDraggingState = 1;
                }
                if (index != DebugConsoleLogManager.this.fDraggingOldIndex && index < DebugConsoleLogManager.this.fCurrentCommands.size()) {
                    String val = DebugConsoleLogManager.this.fCommandLogViewer.getItem(DebugConsoleLogManager.this.fDraggingOldIndex);
                    DebugConsoleLogManager.this.fCommandLogViewer.remove(DebugConsoleLogManager.this.fDraggingOldIndex);
                    DebugConsoleLogManager.this.fCommandLogViewer.add("  " + val.trim(), index);
                    DebugConsoleLogManager.this.fDraggingOldIndex = index;
                    DebugConsoleLogManager.this.fDraggingState = 1;
                }
                if (this.dragInfoShell == null) {
                    this.dragInfoShell = new Shell(DebugConsoleLogManager.this.fCommandLogViewer.getShell(), 16388);
                    this.dragInfoShell.setLayout((Layout)new FillLayout());
                    this.dragInfoLabel = new Label((Composite)this.dragInfoShell, 0);
                    this.dragInfoLabel.setForeground(this.dragInfoShell.getDisplay().getSystemColor(28));
                    this.dragInfoLabel.setBackground(this.dragInfoShell.getDisplay().getSystemColor(29));
                }
                this.dragInfoLabel.setText(" " + NLS.bind((String)PICLLabels.DebugConsoleView_draggingCommand, (Object)String.valueOf(DebugConsoleLogManager.this.fPickedUpIndex), (Object)String.valueOf(index)));
                this.dragInfoShell.setBounds(DebugConsoleLogManager.this.fCommandLogViewer.toDisplay((int)e.x, (int)e.y).x - 15, DebugConsoleLogManager.this.fCommandLogViewer.toDisplay((int)e.x, (int)e.y).y + 20, this.dragInfoLabel.computeSize((int)-1, (int)-1).x + 5, this.dragInfoLabel.computeSize((int)-1, (int)-1).y + 3);
                this.dragInfoShell.setVisible(true);
            } else if (this.dragInfoShell != null) {
                this.dragInfoShell.setVisible(false);
            }
        }
    }

    private class MySelectionListener
    implements SelectionListener {
        private MySelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (DebugConsoleLogManager.this.fDebugConsoleView.getCurrentSession() != null) {
                if (DebugConsoleLogManager.this.fCurrentCommandIndex >= 0 && DebugConsoleLogManager.this.hasNextCommand() && DebugConsoleLogManager.this.fCurrentCommands.get(DebugConsoleLogManager.this.fCurrentCommandIndex).equals("")) {
                    DebugConsoleLogManager.this.deleteCommand();
                }
                DebugConsoleLogManager.this.fCurrentCommandIndex = DebugConsoleLogManager.this.fCommandLogViewer.getSelectionIndex();
                if (DebugConsoleLogManager.this.fDebugConsoleView.getCommandLogManager().getCommand() == null) {
                    DebugConsoleLogManager.this.fCommandField.setText("");
                } else {
                    DebugConsoleLogManager.this.fCommandField.setText(DebugConsoleLogManager.this.fDebugConsoleView.getCommandLogManager().getCommand());
                }
                DebugConsoleLogManager.this.fDebugConsoleView.updateButtons();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            DebugConsoleLogManager.this.fDebugConsoleView.checkAndPlayCommand(false);
        }
    }
}

