/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.views;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleJobRule;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleLogManager;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleSession;
import com.ibm.debug.pdt.internal.ui.views.DebugConsoleView;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class DebugConsoleJob
extends Job {
    private String fCommand;
    private DebugConsoleView fView;
    private boolean fGoToNextCommand;
    private DebugConsoleSession fSession;

    public DebugConsoleJob(String command, boolean gotoNextCommand, DebugConsoleView debugConsoleView, DebugConsoleSession session) {
        super("Internal Command Log Job");
        this.setSystem(true);
        this.fCommand = command;
        this.fView = debugConsoleView;
        this.fGoToNextCommand = gotoNextCommand;
        this.fSession = session;
        this.setRule(new DebugConsoleJobRule(this.fSession));
    }

    protected IStatus run(IProgressMonitor monitor) {
        final DebugConsoleLogManager logManager = this.fView.getCommandLogManager();
        String nextCommand = this.fCommand;
        String currentlySelectedCommand = logManager.getCommand();
        if (!PDTCoreUtils.isEmpty((String)currentlySelectedCommand)) {
            nextCommand = currentlySelectedCommand;
        }
        if (nextCommand != null) {
            try {
                this.fView.addCommandLine(nextCommand, this.fSession);
            }
            catch (EngineRequestException engineRequestException) {
                // empty catch block
            }
            CommonUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (DebugConsoleJob.this.fGoToNextCommand) {
                        logManager.goToNextCommand();
                    }
                    DebugConsoleJob.this.fView.updateButtons();
                }
            });
        }
        int currentCommandIndex = logManager.getCurCommandNum();
        ArrayList<String> commands = logManager.getCommands();
        if (currentCommandIndex >= 0 && currentCommandIndex < commands.size() && commands.get(currentCommandIndex).equals("")) {
            this.fView.deleteCommand();
            if (currentlySelectedCommand != null && !this.fView.isDisposed()) {
                this.fView.updateCommandText(currentlySelectedCommand, this.fSession);
            }
        }
        return Status.OK_STATUS;
    }
}

