/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.MonitorExpressionDialog;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class MonitorUtils {
    private static final String PREFIX = "AddSnippetToMonitorAction.";

    public static void addMonitor(ITextEditor editor) {
        ITextSelection textSelection = (ITextSelection)editor.getSelectionProvider().getSelection();
        String snippet = textSelection.getText().trim();
        if (snippet.length() == 0) {
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_invalid_text, true);
            return;
        }
        int lineNum = PICLUtils.getLineNumber((IEditorPart)editor);
        if (lineNum < 0) {
            PICLDebugPlugin.showMessageDialog(null, NLS.bind((String)PICLMessages.AddSnippetToMonitorAction_error_invalid_line, (Object)Integer.toString(lineNum)), true);
            return;
        }
        IEditorInput editorInput = editor.getEditorInput();
        DebuggeeThread thread = null;
        ViewFile viewFile = null;
        if (editorInput instanceof IFileEditorInput || editorInput instanceof EngineSuppliedViewEditorInput) {
            PDTDebugTarget viewDbgTgt = PICLDebugPlugin.getCurrentPDTDebugTarget();
            PDTDebugTarget editorDbgTgt = null;
            IDebugTarget target = PICLUtils.getViewFile(editorInput).getDebugTarget();
            if (!(target instanceof PDTDebugTarget)) {
                if (PICLDebugPlugin.fPDT) {
                    PICLUtils.logString(editor, "AddSnippetToMonitorAction.: invalid debug target", 4);
                }
                PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_invalid_selection, true);
                return;
            }
            editorDbgTgt = (PDTDebugTarget)target;
            if (viewDbgTgt == editorDbgTgt) {
                thread = PICLDebugPlugin.getCurrentThread();
                if (thread == null) {
                    thread = editorDbgTgt.getStoppingThread();
                }
            } else {
                thread = editorDbgTgt.getStoppingThread();
                if (thread == null) {
                    thread = PICLDebugPlugin.getCurrentThread();
                }
            }
        } else {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(editor, "AddSnippetToMonitorAction.: unknown editorInput", 4);
            }
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_unknown_editorinput, true);
            return;
        }
        viewFile = PICLUtils.getViewFile(editorInput);
        if (thread == null || thread.isTerminated()) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(editor, "AddSnippetToMonitorAction.: invalid thread", 4);
            }
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_invalid_selection, true);
            return;
        }
        if (viewFile == null) {
            if (PICLDebugPlugin.fPDT) {
                PICLUtils.logString(editor, "AddSnippetToMonitorAction.: invalid viewfile", 4);
            }
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_invalid_selection, true);
            return;
        }
        IdentifierParser parser = null;
        try {
            parser = viewFile.getPart().getLanguage().getIdentifierParser();
        }
        catch (NullPointerException editorDbgTgt) {
            // empty catch block
        }
        String lineText = null;
        int lineOffset = -1;
        try {
            IDocumentProvider provider = editor.getDocumentProvider();
            IDocument document = provider.getDocument((Object)editorInput);
            int startLineOffset = document.getLineOffset(textSelection.getStartLine());
            int endLineOffset = document.getLineOffset(textSelection.getStartLine() + 1);
            lineText = document.get(startLineOffset, endLineOffset - startLineOffset);
            lineOffset = Math.min(endLineOffset, textSelection.getOffset()) - startLineOffset + 1;
        }
        catch (BadLocationException e) {
            PICLUtils.logError((Exception)((Object)e));
        }
        if (lineText == null || lineOffset < 0) {
            PICLUtils.logString(editor, "AddSnippetToMonitorAction.: invalid selection", 4);
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToMonitorAction_error_invalid_selection, true);
            return;
        }
        int prefixLength = viewFile.getPrefixLength();
        parser.setPrefixLength(prefixLength);
        parser.setViewInfoID(viewFile.getView().getViewInformation().getKind());
        snippet = parser.doLanguageSpecifics(snippet, lineText, lineOffset);
        Location location = new Location(viewFile, lineNum);
        try {
            thread.monitorExpression(location, snippet);
        }
        catch (EngineRequestException e) {
            PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
            return;
        }
        MonitorExpressionDialog.addExpressionHistory(snippet);
        CommonUtils.showView((String)"com.ibm.debug.pdt.ui.MonitorView");
    }
}

