/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.ui.util.DialogField;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class LayoutUtil {
    public static int getNumberOfColumns(DialogField[] editors) {
        int nCulumns = 0;
        int i = 0;
        while (i < editors.length) {
            nCulumns = Math.max(editors[i].getNumberOfControls(), nCulumns);
            ++i;
        }
        return nCulumns;
    }

    public static void doDefaultLayout(Composite parent, DialogField[] editors, boolean labelOnTop) {
        LayoutUtil.doDefaultLayout(parent, editors, labelOnTop, 0, 0);
    }

    public static void doDefaultLayout(Composite parent, DialogField[] editors, boolean labelOnTop, int minWidth, int minHeight) {
        int nCulumns = LayoutUtil.getNumberOfColumns(editors);
        Control[][] controls = new Control[editors.length][];
        int i = 0;
        while (i < editors.length) {
            controls[i] = editors[i].doFillIntoGrid(parent, nCulumns);
            ++i;
        }
        if (labelOnTop) {
            LayoutUtil.modifyLabelSpans(controls, --nCulumns);
        }
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = nCulumns;
        parent.setLayout((Layout)layout);
    }

    public static void modifyLabelSpans(Control[][] controls, int nCulumns) {
        int i = 0;
        while (i < controls.length) {
            LayoutUtil.setHorizontalSpan(controls[i][0], nCulumns);
            ++i;
        }
    }

    public static void setHorizontalSpan(Control control, int span) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalSpan = span;
        } else if (span != 1) {
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            control.setLayoutData((Object)gd);
        }
    }
}

