/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.FileListItem;
import com.ibm.debug.pdt.internal.ui.dialogs.FileFilterDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FileFilterList {
    private static final String EMPTYSTRING = "";
    List<FileListItem> fAllElements = Collections.emptyList();
    private ArrayList<FileListItem> fFilteredElements = new ArrayList();
    private boolean fIgnoreCase;
    private String fRememberedMatchText = "";
    private FileFilterDialog fParentPage;
    protected boolean fInitialPopulationDone = false;
    private Table fTable;
    private Text fText;
    private TableViewer fTableViewer;
    private FileListItem fSelectedItem;

    public FileFilterList(FileFilterDialog page, boolean ignoreCase) {
        this.fParentPage = page;
        this.fIgnoreCase = ignoreCase;
    }

    public void addWidgets(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createText(composite);
        this.createList(composite);
    }

    private void createList(Composite parent) {
        this.fTable = new Table(parent, 67588);
        GridData tgd = new GridData(4, 4, true, true);
        tgd.heightHint = 240;
        this.fTable.setLayoutData((Object)tgd);
        this.fTable.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, true));
        this.fTable.setLayout((Layout)tableLayout);
        TableColumn col = new TableColumn(this.fTable, 16384);
        col.setResizable(true);
        col.setText(PICLLabels.FileFilterDialog_filename);
        col = new TableColumn(this.fTable, 16384);
        col.setResizable(true);
        col.setText(PICLLabels.FileFilterDialog_path);
        this.fTableViewer = new TableViewer(this.fTable);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setInput(this.fFilteredElements);
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof TableItem) {
                    FileFilterList.this.fSelectedItem = (FileListItem)e.item.getData();
                }
            }
        });
        this.fTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                FileFilterList.this.fParentPage.processDialog();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createText(Composite parent) {
        this.fText = new Text(parent, 2048);
        this.fText.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                FileFilterList.this.filter(false);
            }
        });
    }

    public void initializeFiles() {
        FileListItem i = new FileListItem(PICLLabels.FileFilterDialog_wait_loading);
        FileListItem[] items = new FileListItem[]{i};
        this.setElements(items);
        this.setFilter(EMPTYSTRING, true);
    }

    public void filter(boolean forceUpdate) {
        String filterText = this.getFilter();
        if (!forceUpdate && filterText.equals(this.fRememberedMatchText)) {
            return;
        }
        this.fFilteredElements.clear();
        this.fRememberedMatchText = filterText;
        filterText = filterText.replaceAll("\\.", "\\\\.");
        filterText = filterText.replaceAll("\\*", ".*");
        filterText = filterText.replaceAll("\\?", ".");
        String regex = filterText + ".*";
        Pattern pattern = null;
        try {
            pattern = this.fIgnoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (pattern != null) {
            String label = null;
            Matcher matcher = null;
            Iterator<FileListItem> iter = this.fAllElements.iterator();
            boolean useBase = this.fParentPage.filterOnBaseName();
            while (iter.hasNext()) {
                FileListItem item = iter.next();
                label = useBase ? item.getBaseName() : item.getFullName();
                matcher = pattern.matcher(label);
                if (!matcher.matches()) continue;
                this.fFilteredElements.add(item);
            }
        }
        this.updateListWidget();
        this.fParentPage.updateListCount(this.fTable.getItemCount());
        if (this.fTable.getItemCount() > 0) {
            FileListItem fi;
            this.fSelectedItem = fi = (FileListItem)this.fTable.getItem(0).getData();
        }
    }

    public String getFilter() {
        return this.fText.getText();
    }

    public void setElements(FileListItem[] items) {
        this.fAllElements = Arrays.asList(items);
    }

    public void setFilter(String pattern, boolean refilter) {
        this.fText.setText(pattern);
        if (refilter) {
            this.filter(true);
        }
    }

    void updateListWidget() {
        if (this.fTable == null || this.fTable.isDisposed()) {
            return;
        }
        this.fTable.setRedraw(false);
        int tableCount = this.fTable.getItemCount();
        int itemsCount = this.fFilteredElements.size();
        if (itemsCount == 0) {
            this.fTable.removeAll();
        } else if (tableCount > itemsCount) {
            if (tableCount - itemsCount > 5000) {
                this.fTable.removeAll();
                numToAdd = itemsCount;
                i = 0;
                while (i < numToAdd) {
                    new TableItem(this.fTable, 0);
                    ++i;
                }
            } else {
                this.fTable.remove(itemsCount, tableCount - 1);
            }
        } else if (tableCount < itemsCount) {
            numToAdd = itemsCount - tableCount;
            i = 0;
            while (i < numToAdd) {
                new TableItem(this.fTable, 0);
                ++i;
            }
        }
        TableItem[] tableItems = this.fTable.getItems();
        Iterator<FileListItem> iter = this.fFilteredElements.iterator();
        int i = 0;
        while (i < tableItems.length) {
            FileListItem item = iter.next();
            TableItem tblItem = tableItems[i];
            tblItem.setData((Object)item);
            tblItem.setText(item.getBaseName());
            tblItem.setText(1, item.getPath());
            ++i;
        }
        if (this.fTable.getItemCount() > 0) {
            this.fTable.setSelection(0);
        }
        this.fTable.setRedraw(true);
    }

    public void setIgnoreCase(boolean ignore) {
        this.fIgnoreCase = ignore;
        this.filter(true);
    }

    public void setFilterEntryEnabled(boolean enable) {
        this.fText.setFocus();
        this.fText.setEnabled(enable);
    }

    public FileListItem getSelectedItem() {
        return this.fSelectedItem;
    }

    public boolean setFocus() {
        return this.fText.setFocus();
    }
}

