/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.util;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.util.EntryListItem;
import com.ibm.debug.pdt.internal.ui.dialogs.EntrySelectBPWizardPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EntryFilterList {
    List<EntryListItem> fAllElements = Collections.emptyList();
    private ArrayList<EntryListItem> fFilteredElements = new ArrayList();
    private boolean fIgnoreCase;
    private String fRememberedMatchText = "";
    private EntrySelectBPWizardPage fParentPage;
    protected boolean fInitialPopulationDone = false;
    private Table fTable;
    private Text fText;
    private TableViewer fTableViewer;

    public EntryFilterList(EntrySelectBPWizardPage page, boolean ignoreCase) {
        this.fParentPage = page;
        this.fIgnoreCase = ignoreCase;
    }

    public void addWidgets(Composite parent) {
        this.createText(parent);
        this.createList(parent);
    }

    private void createList(Composite parent) {
        this.fTable = new Table(parent, 67588);
        GridData tgd = new GridData(4, 4, true, true);
        tgd.heightHint = 240;
        this.fTable.setLayoutData((Object)tgd);
        this.fTable.setHeaderVisible(true);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
        this.fTable.setLayout((Layout)tableLayout);
        TableColumn col = new TableColumn(this.fTable, 16384);
        col.setResizable(true);
        col.setText(PICLLabels.EntrySelectBPWizard_page1_function);
        col = new TableColumn(this.fTable, 16384);
        col.setResizable(true);
        col.setText(PICLLabels.EntrySelectBPWizard_page1_class);
        this.fTableViewer = new TableViewer(this.fTable);
        this.fTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fTableViewer.setInput(this.fFilteredElements);
        this.fTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
            }
        });
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EntryListItem fi;
                if (e.item instanceof TableItem && !(fi = (EntryListItem)e.item.getData()).getOriginalName().equals(EntryFilterList.this.fParentPage.getFunctionName())) {
                    EntryFilterList.this.fParentPage.setFunctionItem(fi);
                }
            }
        });
        this.fTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                EntryFilterList.this.fParentPage.processDialog();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    private void createText(Composite parent) {
        this.fText = new Text(parent, 2048);
        this.fText.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                EntryFilterList.this.filter(false);
            }
        });
    }

    public void initializeFunctions() {
        EntryListItem i = new EntryListItem(PICLLabels.EntrySelectBPWizard_page1_wait_loading);
        EntryListItem[] items = new EntryListItem[]{i};
        this.setElements(items);
        this.setFilter("", true);
        this.forceSelection();
    }

    public void filter(boolean forceUpdate) {
        String filterText = this.getFilter();
        if (!forceUpdate && filterText.equals(this.fRememberedMatchText)) {
            return;
        }
        this.fFilteredElements.clear();
        this.fRememberedMatchText = filterText;
        filterText = filterText.replaceAll("\\*", ".*");
        filterText = filterText.replaceAll("\\?", ".");
        filterText = filterText.replaceAll("\\(", "\\\\(");
        filterText = filterText.replaceAll("\\)", "\\\\)");
        String regex = filterText + ".*";
        Pattern pattern = null;
        try {
            pattern = this.fIgnoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (pattern != null) {
            String label = null;
            Matcher matcher = null;
            for (EntryListItem item : this.fAllElements) {
                label = item.getFullName();
                matcher = pattern.matcher(label);
                if (!matcher.matches()) continue;
                this.fFilteredElements.add(item);
            }
        }
        this.updateListWidget();
        this.fParentPage.updateListCount(this.fTable.getItemCount());
        this.fTable.setSelection(0);
    }

    public String getFilter() {
        return this.fText.getText();
    }

    public void selectFilterText() {
        this.fText.selectAll();
    }

    public void setElements(EntryListItem[] items) {
        this.fAllElements = Arrays.asList(items);
    }

    public void setEnabled(boolean enable) {
        this.fText.setEnabled(enable);
        this.fTable.setEnabled(enable);
    }

    public void setFilter(String pattern, boolean refilter) {
        this.fText.setText(pattern);
        if (refilter) {
            this.filter(true);
        }
    }

    public boolean setFocus() {
        return this.fText.setFocus();
    }

    public void setFont(Font font) {
        this.fText.setFont(font);
        this.fTable.setFont(font);
    }

    void updateListWidget() {
        if (this.fTable == null || this.fTable.isDisposed()) {
            return;
        }
        this.fTable.setRedraw(false);
        int tableCount = this.fTable.getItemCount();
        int itemsCount = this.fFilteredElements.size();
        if (itemsCount == 0) {
            this.fTable.removeAll();
        } else if (tableCount > itemsCount) {
            if (tableCount - itemsCount > 5000) {
                this.fTable.removeAll();
                numToAdd = itemsCount;
                i = 0;
                while (i < numToAdd) {
                    new TableItem(this.fTable, 0);
                    ++i;
                }
            } else {
                this.fTable.remove(itemsCount, tableCount - 1);
            }
        } else if (tableCount < itemsCount) {
            numToAdd = itemsCount - tableCount;
            i = 0;
            while (i < numToAdd) {
                new TableItem(this.fTable, 0);
                ++i;
            }
        }
        TableItem[] tableItems = this.fTable.getItems();
        Iterator<EntryListItem> iter = this.fFilteredElements.iterator();
        int i = 0;
        while (i < tableItems.length) {
            EntryListItem item = iter.next();
            TableItem tblItem = tableItems[i];
            tblItem.setData((Object)item);
            tblItem.setText(item.getFunctionName());
            tblItem.setText(1, item.getClassName());
            ++i;
        }
        this.forceSelection();
        this.fTable.setRedraw(true);
    }

    public void restoreDefaults() {
        this.updateListWidget();
    }

    public void setIgnoreCase(boolean ignore) {
        this.fIgnoreCase = ignore;
        this.filter(true);
    }

    public void setFilterEntryEnabled(boolean enable) {
        this.fText.setFocus();
        this.fText.setEnabled(enable);
    }

    public void forceSelection() {
        if (this.fTable.getItemCount() > 0) {
            EntryListItem fi = (EntryListItem)this.fTable.getItem(0).getData();
            this.fParentPage.setFunctionItem(fi);
        }
    }

    public void cleanup() {
        if (this.fTable != null) {
            this.fTable.clearAll();
        }
        if (this.fAllElements != null) {
            this.fAllElements = null;
        }
        if (this.fFilteredElements != null) {
            this.fFilteredElements.clear();
        }
    }
}

