/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.properties;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.ExpressionBase;
import com.ibm.debug.pdt.internal.ui.properties.PropertySourceAdapter;
import org.eclipse.debug.core.DebugException;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ExprNodeBasePropertySourceAdapter
extends PropertySourceAdapter {
    private static final String PREFIX = "picl_variable.";
    private static final String VARIABLE_NAME = "picl_variable.variable_name";
    private static final String VARIABLE_EXPRESSION = "picl_variable.variable_expression";
    private static final String VARIABLE_TYPE = "picl_variable.variable_type";
    private static final String VARIABLE_THREAD = "picl_variable.variable_thread";
    private static final String VARIABLE_MODULE = "picl_variable.variable_module";
    private static final String VARIABLE_PART = "picl_variable.variable_part";
    private static final String VARIABLE_FILE = "picl_variable.variable_file";
    private static final String VARIABLE_LINE = "picl_variable.variable_line";
    private ExprNodeBase fSource;

    public ExprNodeBasePropertySourceAdapter(ExprNodeBase source) {
        this.fSource = source;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor[] pdlist = new PropertyDescriptor[8];
            pdlist[0] = new PropertyDescriptor((Object)VARIABLE_NAME, PICLLabels.debug_element_name);
            pdlist[0].setCategory("1 " + PICLLabels.debug_element_variable);
            pdlist[1] = new PropertyDescriptor((Object)VARIABLE_TYPE, PICLLabels.debug_element_type);
            pdlist[1].setCategory("2 " + PICLLabels.MonitorExpressionDialog_label_context);
            pdlist[2] = new PropertyDescriptor((Object)VARIABLE_THREAD, PICLLabels.debug_element_thread);
            pdlist[2].setCategory("2 " + PICLLabels.MonitorExpressionDialog_label_context);
            pdlist[3] = new PropertyDescriptor((Object)VARIABLE_MODULE, PICLLabels.debug_element_module);
            pdlist[3].setCategory("2 " + PICLLabels.MonitorExpressionDialog_label_context);
            pdlist[4] = new PropertyDescriptor((Object)VARIABLE_PART, PICLLabels.debug_element_object);
            pdlist[4].setCategory("2 " + PICLLabels.MonitorExpressionDialog_label_context);
            pdlist[5] = new PropertyDescriptor((Object)VARIABLE_FILE, PICLLabels.debug_element_file);
            pdlist[5].setCategory("2 " + PICLLabels.MonitorExpressionDialog_label_context);
            pdlist[6] = new PropertyDescriptor((Object)VARIABLE_LINE, PICLLabels.debug_element_line);
            pdlist[6].setCategory("2 " + PICLLabels.MonitorExpressionDialog_label_context);
            pdlist[7] = new PropertyDescriptor((Object)VARIABLE_EXPRESSION, PICLLabels.debug_element_value);
            pdlist[7].setCategory("1 " + PICLLabels.debug_element_variable);
            return pdlist;
        }
        catch (NullPointerException nullPointerException) {
            return new IPropertyDescriptor[0];
        }
    }

    public Object getPropertyValue(Object id) {
        try {
            ExpressionBase expr = this.fSource.getExpression();
            if (id.equals(VARIABLE_NAME)) {
                return this.fSource.getName();
            }
            if (id.equals(VARIABLE_EXPRESSION)) {
                try {
                    return this.fSource.getValue().getValueString();
                }
                catch (DebugException e) {
                    return PICLLabels.debug_element_unknown;
                }
            }
            if (id.equals(VARIABLE_TYPE)) {
                return this.fSource.getReferenceTypeName();
            }
            if (id.equals(VARIABLE_THREAD)) {
                return expr.getThread().getName();
            }
            if (id.equals(VARIABLE_MODULE)) {
                return expr.getLocation().getPart().getModule().getName();
            }
            if (id.equals(VARIABLE_PART)) {
                return expr.getLocation().getPart().getName();
            }
            if (id.equals(VARIABLE_FILE)) {
                return expr.getLocation().getViewFile().getBaseFileName();
            }
            if (id.equals(VARIABLE_LINE)) {
                int linenumber = expr.getLocation().getLineNumber();
                Integer linenum = linenumber;
                return linenum;
            }
            return PICLLabels.debug_element_unknown;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return null;
    }
}

