/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.preferences;

import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class MonitorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "com.ibm.debug.pdt.internal.ui.preferences.MonitorPreferencePage";
    public static final String EXPAND_DEPTH_DEFAULT_PREF = "monitor_view_expand_depth";
    private IntegerFieldEditor fExpandDepthSpinner;
    private static final int expansionDepthThreshold = 10;

    public MonitorPreferencePage() {
        this.setTitle(PICLLabels.MonitorView_label);
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), PICLUtils.getHelpResourceString("monitor_preference_page"));
        return composite;
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.fExpandDepthSpinner = new IntegerFieldEditor(EXPAND_DEPTH_DEFAULT_PREF, PICLLabels.MonitorView_expand_depth, parent){

            protected boolean checkState() {
                Text expandText = this.getTextControl();
                if (!MonitorPreferencePage.this.checkExpandField(expandText)) {
                    this.setErrorMessage(PICLMessages.CRRDG3260);
                    this.showErrorMessage();
                    return false;
                }
                this.clearErrorMessage();
                return true;
            }
        };
        this.addField((FieldEditor)this.fExpandDepthSpinner);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    private boolean checkExpandField(Text text) {
        block5: {
            block6: {
                if (text == null) {
                    return false;
                }
                String numberString = text.getText();
                try {
                    int number = Integer.parseInt(numberString);
                    if (number > 10) {
                        this.setMessage(PICLMessages.CRRDG3261, 2);
                        break block5;
                    }
                    if (number > 0) break block6;
                    return false;
                }
                catch (NumberFormatException e1) {
                    return false;
                }
            }
            this.setMessage(null);
        }
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return PreferenceUI.getPreferenceStore();
    }
}

