/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.PICLRegister;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.EngineRequestException;
import com.ibm.debug.pdt.internal.core.model.ExprNodeBase;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.memory.MapStorageAction;
import com.ibm.debug.pdt.internal.ui.memory.OrderedMemoryRenderingLister;
import com.ibm.debug.pdt.internal.ui.memory.OverrideRenderingManager;
import com.ibm.debug.pdt.internal.ui.memory.PICLMemoryBlock;
import com.ibm.debug.pdt.internal.ui.preferences.PreferenceUI;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.MonitorMemoryBlockDialog;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IAddMemoryBlocksTarget;
import org.eclipse.debug.ui.actions.IAddMemoryRenderingsTarget;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;

public class PICLExtendedMemoryBlockRetrieval
extends PlatformObject
implements IMemoryBlockRetrievalExtension,
IAddMemoryRenderingsTarget,
IAddMemoryBlocksTarget {
    private PDTDebugTarget fDebugTarget;
    private IMemoryRenderingSite fSite;
    private static final PICLMemoryBlock[] EMPTYMEMORYBLOCKS = new PICLMemoryBlock[0];
    private ArrayList<PICLMemoryBlock> fMemoryBlocks;

    public PICLExtendedMemoryBlockRetrieval(PDTDebugTarget debugTarget) {
        this.fDebugTarget = debugTarget;
    }

    private void assignSite() {
        IViewPart memView = null;
        try {
            memView = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0].findView("org.eclipse.debug.ui.MemoryView");
        }
        catch (Exception e) {
            PICLUtils.logError(e);
        }
        if (memView != null) {
            if (!(memView instanceof IMemoryRenderingSite)) {
                PDTCoreUtils.logEvent((String)"Could not find Memory view to display memory rendering", (Object)PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages()[0]);
            } else {
                this.fSite = (IMemoryRenderingSite)memView;
            }
        }
    }

    public final boolean supportsStorageRetrieval() {
        return this.fDebugTarget.supportsStorage();
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        DebuggeeThread thrd;
        String baseAddr = Long.toHexString(startAddress);
        PICLMemoryBlock memBlk = (PICLMemoryBlock)this.getExtendedMemoryBlock(baseAddr, thrd = PICLDebugPlugin.getCurrentThread());
        if (memBlk != null) {
            memBlk.setMemLength(length);
        }
        return memBlk;
    }

    public PICLMemoryBlock addMemoryBlock(PICLMemoryBlock memBlk) {
        if (memBlk == null) {
            return null;
        }
        if (this.fMemoryBlocks == null) {
            this.fMemoryBlocks = new ArrayList();
        }
        if (this.fMemoryBlocks.contains((Object)memBlk)) {
            return this.fMemoryBlocks.get(this.fMemoryBlocks.indexOf((Object)memBlk));
        }
        this.fMemoryBlocks.add(memBlk);
        return memBlk;
    }

    protected void removeMemoryBlock(PICLMemoryBlock memBlk) {
        if (this.fMemoryBlocks != null) {
            this.fMemoryBlocks.remove((Object)memBlk);
        }
    }

    public void markMemBlksChanged(boolean fireEvent) {
        if (PICLDebugPlugin.fPDT) {
            PICLUtils.logString((Object)this, ".markMemBlksChanged()");
        }
        if (this.fMemoryBlocks == null) {
            return;
        }
        for (PICLMemoryBlock element : this.fMemoryBlocks) {
            element.memoryChanged(fireEvent);
        }
    }

    public void cleanup() {
        if (this.fMemoryBlocks != null) {
            this.fMemoryBlocks.clear();
            this.fMemoryBlocks = null;
        }
    }

    public IMemoryBlock[] getMemoryBlocks() {
        if (this.fMemoryBlocks == null) {
            return EMPTYMEMORYBLOCKS;
        }
        return this.fMemoryBlocks.toArray(new IMemoryBlock[this.fMemoryBlocks.size()]);
    }

    public IMemoryBlockExtension getExtendedMemoryBlock(String expression, Object context) throws DebugException {
        if (this.fDebugTarget.isTerminated()) {
            return null;
        }
        DebuggeeThread thread = null;
        String expr = null;
        Location loc = null;
        if (context instanceof PICLRegister) {
            PICLRegister register = (PICLRegister)context;
            expr = register.getName();
            thread = (DebuggeeThread)register.getThread();
            loc = thread.getLocation();
        } else if (context instanceof ExprNodeBase) {
            ExprNodeBase var = (ExprNodeBase)context;
            try {
                expr = var.getNodeExpression(true);
                thread = var.getExpression().getThread();
                if (thread == null) {
                    thread = PICLDebugPlugin.getThread((ISelection)new StructuredSelection(context));
                }
                if ((loc = var.getExpression().getLocation()) == null && thread != null) {
                    loc = thread.getLocation();
                }
            }
            catch (EngineRequestException engineRequestException) {}
        } else {
            expr = expression;
            thread = PICLDebugPlugin.getThread((ISelection)new StructuredSelection(context));
            loc = PICLDebugPlugin.getLocationFromEditor(null);
            if (loc == null && thread != null) {
                loc = thread.getLocation();
            }
        }
        if (thread == null || loc == null) {
            Status status = new Status(4, PICLDebugPlugin.getPluginID(), 5012, PICLMessages.picl_memory_error_invalid_location, null);
            throw new DebugException((IStatus)status);
        }
        PICLMemoryBlock memoryBlk = new PICLMemoryBlock(expr, thread, loc);
        return this.addMemoryBlock(memoryBlk);
    }

    public void addMemoryRenderings(IWorkbenchPart part, ISelection selection, IMemoryRenderingType[] renderingTypes) throws CoreException {
        ITextEditor editor = PICLDebugPlugin.getTextEditor(part);
        if (editor != null) {
            ViewFile vf = PICLDebugPlugin.getViewFile(editor);
            PICLDebugTarget dbgTgt = PICLDebugPlugin.getPICLDebugTarget((IDebugElement)vf);
            if (vf != null && dbgTgt != null) {
                MapStorageAction action = new MapStorageAction(editor, renderingTypes[0], 0, dbgTgt);
                action.run();
            }
        }
    }

    public boolean canAddMemoryRenderings(IWorkbenchPart part, ISelection selection) {
        return selection != null && !selection.isEmpty();
    }

    public IMemoryRenderingType[] getMemoryRenderingTypes(IWorkbenchPart part, ISelection selection) {
        ITextEditor editor = PICLDebugPlugin.getTextEditor(part);
        if (editor != null) {
            ViewFile vf = PICLDebugPlugin.getViewFile(editor);
            PICLDebugTarget dbgTgt = PICLDebugPlugin.getPICLDebugTarget((IDebugElement)vf);
            if (vf != null && dbgTgt != null) {
                PICLMemoryBlock memBlk = new PICLMemoryBlock(dbgTgt);
                IMemoryRenderingType[] renderings = OrderedMemoryRenderingLister.getList((IMemoryBlock)memBlk);
                return renderings;
            }
        }
        return null;
    }

    public boolean canAddMemoryBlocks(IWorkbenchPart part, ISelection selection) throws CoreException {
        if (!this.supportsAddMemoryBlocks(part)) {
            return false;
        }
        return this.fDebugTarget.isAcceptingRequests();
    }

    public boolean supportsAddMemoryBlocks(IWorkbenchPart part) {
        return this.fDebugTarget.supportsStorageRetrieval();
    }

    public void addMemoryBlocks(IWorkbenchPart part, ISelection selection) throws CoreException {
        String expression;
        IMemoryBlockRetrieval retrieval;
        if (this.fSite == null) {
            this.assignSite();
        }
        if ((retrieval = MemoryViewUtil.getMemoryBlockRetrieval((Object)DebugUITools.getDebugContext())) == null) {
            return;
        }
        MonitorMemoryBlockDialog dialog = new MonitorMemoryBlockDialog(DebugUIPlugin.getShell(), retrieval, null, null);
        dialog.open();
        if (dialog.getReturnCode() == 1) {
            return;
        }
        final String expr = expression = dialog.getExpression().trim().length() > 0 ? dialog.getExpression().trim() : "";
        UIJob job = new UIJob("Add Memory Block"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    IMemoryBlockExtension newMemBlock = PICLExtendedMemoryBlockRetrieval.this.getExtendedMemoryBlock(expr, PICLExtendedMemoryBlockRetrieval.this.fDebugTarget);
                    if (newMemBlock != null) {
                        try {
                            IMemoryRenderingType[] defaultRenderingTypes = DebugUITools.getMemoryRenderingManager().getDefaultRenderingTypes((IMemoryBlock)newMemBlock);
                            IMemoryRenderingType primaryRenderingType = DebugUITools.getMemoryRenderingManager().getRenderingType(PreferenceUI.getDefaultRenderingId());
                            if (primaryRenderingType == null) {
                                primaryRenderingType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType((IMemoryBlock)newMemBlock);
                            }
                            ArrayList<IMemoryRenderingType> filteredDefaultRendingTypes = new ArrayList<IMemoryRenderingType>(defaultRenderingTypes.length);
                            int i = 0;
                            while (i < defaultRenderingTypes.length) {
                                String overrideRenderingID;
                                String thisRenderingID = defaultRenderingTypes[i].getId();
                                if (thisRenderingID.equals(overrideRenderingID = OverrideRenderingManager.instance().getRenderingId(thisRenderingID))) {
                                    filteredDefaultRendingTypes.add(defaultRenderingTypes[i]);
                                }
                                ++i;
                            }
                            IMemoryRenderingType[] filteredDefaultRenderingTypesArray = filteredDefaultRendingTypes.toArray(new IMemoryRenderingType[filteredDefaultRendingTypes.size()]);
                            PICLExtendedMemoryBlockRetrieval.this.addMemoryRenderings(newMemBlock, primaryRenderingType, filteredDefaultRenderingTypesArray);
                        }
                        catch (CoreException ce) {
                            PICLUtils.logError((Exception)((Object)ce));
                        }
                    }
                }
                catch (DebugException de) {
                    MemoryViewUtil.openError((String)DebugUIMessages.AddMemoryBlockAction_title, (String)DebugUIMessages.AddMemoryBlockAction_failed, (Exception)((Object)de));
                }
                catch (NumberFormatException nfe) {
                    StringBuilder message = new StringBuilder(DebugUIMessages.AddMemoryBlockAction_failed);
                    message.append(System.getProperty("line.separator"));
                    message.append(DebugUIMessages.AddMemoryBlockAction_input_invalid);
                    MemoryViewUtil.openError((String)DebugUIMessages.AddMemoryBlockAction_title, (String)message.toString(), null);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void addRendering(IMemoryBlockExtension newMemBlock, IMemoryRenderingType renderingType, String containerID) {
        if (renderingType != null) {
            try {
                IMemoryRendering rendering = renderingType.createRendering();
                IMemoryRenderingContainer targetContainer = this.fSite.getContainer(containerID);
                if (targetContainer instanceof IMemoryViewPane && ((IMemoryViewPane)targetContainer).getControl() != null && ((IMemoryViewPane)targetContainer).getControl().isDisposed()) {
                    this.fSite = null;
                    this.assignSite();
                    targetContainer = this.fSite.getContainer(containerID);
                }
                rendering.init(targetContainer, (IMemoryBlock)newMemBlock);
                targetContainer.addMemoryRendering(rendering);
            }
            catch (CoreException ce) {
                PICLUtils.logError((Exception)((Object)ce));
            }
        }
    }

    protected void addMemoryRenderings(IMemoryBlockExtension newMemBlock, IMemoryRenderingType primaryRenderingType, IMemoryRenderingType[] secondaryRenderingTypes) throws CoreException {
        if (primaryRenderingType == null) {
            primaryRenderingType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType((IMemoryBlock)newMemBlock);
        }
        if (secondaryRenderingTypes == null || secondaryRenderingTypes.length <= 0) {
            secondaryRenderingTypes = DebugUITools.getMemoryRenderingManager().getDefaultRenderingTypes((IMemoryBlock)newMemBlock);
        }
        int usedRenderingCount = 0;
        if (primaryRenderingType == null) {
            if (secondaryRenderingTypes == null || secondaryRenderingTypes.length <= 0) {
                return;
            }
            primaryRenderingType = secondaryRenderingTypes[usedRenderingCount];
            ++usedRenderingCount;
        }
        this.addRendering(newMemBlock, primaryRenderingType, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
        int i = usedRenderingCount;
        while (i < secondaryRenderingTypes.length) {
            boolean create = true;
            if (primaryRenderingType != null && primaryRenderingType.getId().equals(secondaryRenderingTypes[i].getId())) {
                create = false;
            }
            if (create) {
                this.addRendering(newMemBlock, secondaryRenderingTypes[i], "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2");
            }
            ++i;
        }
        MapStorageAction.monitorAndRenderMemory((IMemoryBlock)newMemBlock, null, null);
    }
}

