/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.ui.IOrderableMemoryRenderingType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;

public final class OrderedMemoryRenderingLister {
    private static HashMap<String, Integer> fgContributedOrdinals = null;

    public static IMemoryRenderingType[] getList(IMemoryBlock memblk) {
        IMemoryRenderingType[] pluginList = DebugUITools.getMemoryRenderingManager().getRenderingTypes(memblk);
        TreeMap<Integer, ArrayList<IMemoryRenderingType>> orderer = new TreeMap<Integer, ArrayList<IMemoryRenderingType>>();
        int added = 0;
        IMemoryRenderingType[] iMemoryRenderingTypeArray = pluginList;
        int n = pluginList.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryRenderingType type = iMemoryRenderingTypeArray[n2];
            Integer ordinal = OrderedMemoryRenderingLister.getOrdinal(type);
            if (ordinal != null) {
                ArrayList<IMemoryRenderingType> ordinalList = (ArrayList<IMemoryRenderingType>)orderer.get(ordinal);
                if (ordinalList == null) {
                    ordinalList = new ArrayList<IMemoryRenderingType>();
                    orderer.put(ordinal, ordinalList);
                }
                ordinalList.add(type);
                ++added;
            }
            ++n2;
        }
        IMemoryRenderingType[] orderedList = new IMemoryRenderingType[added];
        int next_pos = 0;
        for (List finalList : orderer.values()) {
            for (IMemoryRenderingType type : finalList) {
                orderedList[next_pos++] = type;
            }
        }
        return orderedList;
    }

    private static Integer getOrdinal(IMemoryRenderingType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof IOrderableMemoryRenderingType) {
            return ((IOrderableMemoryRenderingType)type).getOrdinal();
        }
        if (fgContributedOrdinals == null) {
            OrderedMemoryRenderingLister.initializeContributedOrdinals();
        }
        if (fgContributedOrdinals.containsKey(type.getId())) {
            return fgContributedOrdinals.get(type.getId());
        }
        return 0;
    }

    private static void initializeContributedOrdinals() {
        IConfigurationElement[] configurationElements;
        fgContributedOrdinals = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(PICLDebugPlugin.getPluginID(), "memoryrenderingordinal");
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionPoint.getConfigurationElements();
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                IConfigurationElement element = iConfigurationElementArray[n2];
                String id = element.getAttribute("id");
                if (!PDTCoreUtils.isEmpty((String)id)) {
                    Integer finalOrdinal;
                    String ordinal = element.getAttribute("ordinal");
                    try {
                        finalOrdinal = Integer.decode(ordinal);
                    }
                    catch (NumberFormatException e) {
                        if (!"HIDE".equalsIgnoreCase(ordinal)) break block4;
                        finalOrdinal = null;
                    }
                    fgContributedOrdinals.put(id, finalOrdinal);
                }
            }
            ++n2;
        }
    }
}

