/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.pdt.internal.ui.memory;

import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.core.IPDTDebugTracer;
import com.ibm.debug.pdt.internal.core.PDTDebugElement;
import com.ibm.debug.pdt.internal.core.PDTDebugTarget;
import com.ibm.debug.pdt.internal.core.PICLLabels;
import com.ibm.debug.pdt.internal.core.PICLMessages;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.model.IdentifierParser;
import com.ibm.debug.pdt.internal.core.model.Location;
import com.ibm.debug.pdt.internal.core.model.ViewFile;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.EngineSuppliedViewEditorInput;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.PICLUtils;
import com.ibm.debug.pdt.internal.ui.memory.PICLMemoryBlock;
import com.ibm.lpex.alef.LpexAbstractTextEditor;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexView;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IMemoryBlockManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingManager;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class MapStorageAction
extends Action {
    private PDTDebugElement fDebugElement;
    private PICLDebugTarget fDebugTarget;
    private ITextEditor fEditor = null;
    private IMemoryRenderingType fRenderingType = null;
    protected IMemoryRenderingType fRenderingType2 = null;
    private static String[] RENDERING_PANE_IDS = new String[]{"org.eclipse.debug.ui.MemoryView.RenderingViewPane.1", "org.eclipse.debug.ui.MemoryView.RenderingViewPane.2"};

    public MapStorageAction(PDTDebugElement element, IMemoryRenderingType renderingType, int numInMenu) {
        this.setText(renderingType, numInMenu);
        this.fRenderingType = renderingType;
        this.fDebugElement = element;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("map_storage_action"));
    }

    public MapStorageAction(ITextEditor editor, IMemoryRenderingType renderingType, int numInMenu, PICLDebugTarget debugTarget) {
        this.setText(renderingType, numInMenu);
        this.fRenderingType = renderingType;
        this.fEditor = editor;
        this.fDebugTarget = debugTarget;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, PICLUtils.getHelpResourceString("map_storage_action"));
    }

    private void setText(IMemoryRenderingType renderingType, int numInMenu) {
        if (renderingType == null) {
            this.setText("&" + numInMenu + " " + PICLLabels.AddSnippetToStorageMonitorAction_memorylabel);
        } else {
            this.setText("&" + numInMenu + " " + renderingType.getLabel());
        }
    }

    public void run() {
        IMemoryRendering rendering1;
        PICLMemoryBlock memBlk = null;
        boolean traceAddMemoryBlock = false;
        try {
            if (this.fEditor != null) {
                memBlk = this.getMemoryBlock(this.fEditor);
                if ((memBlk = this.fDebugTarget.addMemoryBlock(memBlk)) != null) {
                    traceAddMemoryBlock = true;
                }
            } else if (this.fDebugElement != null) {
                memBlk = this.getMemoryBlock(this.fDebugElement);
            }
        }
        catch (DebugException de) {
            PICLDebugPlugin.showMessageDialog(null, de.getMessage(), true);
            return;
        }
        if (memBlk == null) {
            return;
        }
        if (this.fRenderingType == null) {
            IMemoryRenderingManager renMgr = DebugUITools.getMemoryRenderingManager();
            IMemoryRenderingType[] defaultRenderings = renMgr.getDefaultRenderingTypes((IMemoryBlock)memBlk);
            if (defaultRenderings[0] == null) {
                return;
            }
            this.fRenderingType = defaultRenderings[0];
        }
        IMemoryRendering rendering2 = null;
        try {
            rendering1 = this.fRenderingType.createRendering();
            if (this.fRenderingType2 != null) {
                rendering2 = this.fRenderingType2.createRendering();
            }
        }
        catch (CoreException e) {
            PICLDebugPlugin.showMessageDialog(null, e.getMessage(), true);
            return;
        }
        MapStorageAction.monitorAndRenderMemory((IMemoryBlock)memBlk, rendering1, rendering2);
        if (traceAddMemoryBlock) {
            try {
                IPDTDebugTracer[] tracerClasses;
                IPDTDebugTracer[] iPDTDebugTracerArray = tracerClasses = this.fDebugTarget.getDebugTracers();
                int n = tracerClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    IPDTDebugTracer tracerClass = iPDTDebugTracerArray[n2];
                    tracerClass.traceUserAction((Object)memBlk, (short)4, null);
                    ++n2;
                }
            }
            catch (Exception e) {
                PICLUtils.logError(e);
            }
        }
    }

    public static void monitorAndRenderMemory(IMemoryBlock memblk, IMemoryRendering rendering1, IMemoryRendering rendering2) {
        IMemoryBlockManager memMgr = DebugPlugin.getDefault().getMemoryBlockManager();
        memMgr.addMemoryBlocks(new IMemoryBlock[]{memblk});
        IMemoryRenderingSite site = MapStorageAction.getMemoryRenderingSite();
        if (site == null) {
            return;
        }
        IMemoryRendering[] renderings = new IMemoryRendering[]{rendering1, rendering2};
        int i = 0;
        while (i < renderings.length) {
            IMemoryRenderingContainer container;
            if (renderings[i] != null && (container = site.getContainer(RENDERING_PANE_IDS[i])) != null) {
                renderings[i].init(container, memblk);
                container.addMemoryRendering(renderings[i]);
            }
            ++i;
        }
        if (rendering2 != null) {
            ((MemoryView)site).showViewPane(true, RENDERING_PANE_IDS[1]);
        }
    }

    private static IMemoryRenderingSite getMemoryRenderingSite() {
        IWorkbenchWindow window = CommonUtils.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart memView = null;
        try {
            memView = activePage.showView("org.eclipse.debug.ui.MemoryView");
        }
        catch (PartInitException e) {
            PDTCoreUtils.logString((Object)activePage, (String)": could not open Memory view", (int)1, (Exception)((Object)e));
            return null;
        }
        if (!(memView instanceof IMemoryRenderingSite)) {
            PDTCoreUtils.logEvent((String)"Could not find Memory view to display memory rendering", (Object)activePage);
            return null;
        }
        return (IMemoryRenderingSite)memView;
    }

    private PICLMemoryBlock getMemoryBlock(ITextEditor editor) throws DebugException {
        ViewFile vf = PICLDebugPlugin.getViewFile(editor);
        if (vf == null) {
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToStorageMonitorAction_error_editor_not_found, true);
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        DebuggeeThread threadContext = PICLDebugPlugin.getCurrentThread();
        if (editorInput instanceof EngineSuppliedViewEditorInput) {
            PICLDebugTarget tgt = ((EngineSuppliedViewEditorInput)editorInput).getPICLDebugTarget();
            if (tgt == null || tgt.isTerminated()) {
                threadContext = null;
            } else if (threadContext == null || threadContext.isTerminated() || !((PDTDebugTarget)threadContext.getDebugTarget()).equals((Object)tgt)) {
                threadContext = tgt.getStoppingThread();
            }
        }
        if (threadContext == null || threadContext.isTerminated()) {
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToStorageMonitorAction_error_invalid_selection, true);
        }
        ITextSelection textSelection = (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
        String snippet = null;
        if (textSelection != null) {
            snippet = textSelection.getText();
        }
        if (snippet == null || PDTCoreUtils.isEmpty((String)(snippet = snippet.trim()))) {
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToStorageMonitorAction_error_invalid_text, true);
            return null;
        }
        int lineNumber = PICLUtils.getRealLineNumber(editor.getEditorInput(), textSelection.getStartLine());
        IdentifierParser parser = null;
        try {
            parser = vf.getPart().getLanguage().getIdentifierParser();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (editor instanceof LpexAbstractTextEditor && parser != null) {
            int[] identifierInString;
            LpexView lpexView = ((LpexAbstractTextEditor)this.fEditor).getLpexView();
            LpexDocumentLocation cursorLoc = lpexView.documentLocation();
            String lineText = lpexView.elementText(cursorLoc.element);
            if (editor.getEditorInput() instanceof EngineSuppliedViewEditorInput) {
                int prefixLength = ((EngineSuppliedViewEditorInput)editor.getEditorInput()).getPrefixLength();
                parser.setPrefixLength(prefixLength);
                parser.setViewInfoID(((EngineSuppliedViewEditorInput)editor.getEditorInput()).getViewInformation().getKind());
            } else {
                parser.setViewInfoID((short)2);
            }
            if (snippet.length() == 0 && (identifierInString = parser.identifierInString(lineText, cursorLoc.position - 1)) != null && identifierInString[0] >= 0) {
                snippet = lineText.substring(identifierInString[0], identifierInString[1] + 1);
            }
            snippet = parser.doLanguageSpecifics(snippet, lineText, cursorLoc.position - 1);
        }
        if (snippet.length() == 0) {
            PICLDebugPlugin.showMessageDialog(null, PICLMessages.AddSnippetToStorageMonitorAction_error_invalid_text, true);
            return null;
        }
        Location location = new Location(vf, lineNumber);
        return new PICLMemoryBlock(snippet, threadContext, location);
    }

    private PICLMemoryBlock getMemoryBlock(PDTDebugElement element) throws DebugException {
        IMemoryBlockRetrieval retrieval;
        PDTDebugTarget tgt = PICLDebugPlugin.getPDTDebugTarget((IDebugElement)element);
        if (tgt != null && !tgt.isTerminated() && (retrieval = (IMemoryBlockRetrieval)tgt.getAdapter(IMemoryBlockRetrieval.class)) instanceof IMemoryBlockRetrievalExtension) {
            IMemoryBlockRetrievalExtension memSupport = (IMemoryBlockRetrievalExtension)retrieval;
            return (PICLMemoryBlock)memSupport.getExtendedMemoryBlock(null, (Object)element);
        }
        return null;
    }
}

